/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.mm.mysql;

import java.io.UnsupportedEncodingException;

class Buffer {
    byte[] buf;
    int buf_length = 0;
    int pos = 0;
    int send_length = 0;
    static final int NO_LENGTH_LIMIT = -1;
    int max_length = -1;
    static long NULL_LENGTH = -1L;

    Buffer(byte[] byArray) {
        this.buf = byArray;
        this.buf_length = byArray.length;
    }

    Buffer(int n, int n2) {
        this.buf = new byte[n];
        this.buf_length = this.buf.length;
        this.pos = 4;
        this.max_length = n2;
    }

    Buffer(int n) {
        this(n, -1);
    }

    final void setBytes(byte[] byArray) {
        this.send_length = this.buf_length;
        System.arraycopy(byArray, 0, this.buf, 0, this.buf_length);
    }

    final byte readByte() {
        return this.buf[this.pos++];
    }

    final int readInt() {
        byte[] byArray = this.buf;
        return byArray[this.pos++] & 0xFF | (byArray[this.pos++] & 0xFF) << 8;
    }

    final int readLongInt() {
        byte[] byArray = this.buf;
        return byArray[this.pos++] & 0xFF | (byArray[this.pos++] & 0xFF) << 8 | (byArray[this.pos++] & 0xFF) << 16;
    }

    final long readLong() {
        byte[] byArray = this.buf;
        return byArray[this.pos++] & 0xFF | (byArray[this.pos++] & 0xFF) << 8 | (byArray[this.pos++] & 0xFF) << 16 | (byArray[this.pos++] & 0xFF) << 24;
    }

    final long readLongLong() {
        byte[] byArray = this.buf;
        return (long)(byArray[this.pos++] & 0xFF) | (long)(byArray[this.pos++] & 0xFF) << 8 | (long)(byArray[this.pos++] & 0xFF) << 16 | (long)(byArray[this.pos++] & 0xFF) << 24 | (long)(byArray[this.pos++] & 0xFF) << 32 | (long)(byArray[this.pos++] & 0xFF) << 40 | (long)(byArray[this.pos++] & 0xFF) << 48 | (long)(byArray[this.pos++] & 0xFF) << 56;
    }

    final int readnBytes() {
        int n = this.buf[this.pos++] & 0xFF;
        switch (n) {
            case 1: {
                return this.buf[this.pos++] & 0xFF;
            }
            case 2: {
                return this.readInt();
            }
            case 3: {
                return this.readLongInt();
            }
            case 4: {
                return (int)this.readLong();
            }
        }
        return 255;
    }

    final long readLength() {
        int n = this.buf[this.pos++] & 0xFF;
        switch (n) {
            case 251: {
                return 0L;
            }
            case 252: {
                return this.readInt();
            }
            case 253: {
                return this.readLongInt();
            }
            case 254: {
                return this.readLong();
            }
        }
        return n;
    }

    final long newReadLength() {
        int n = this.buf[this.pos++] & 0xFF;
        switch (n) {
            case 251: {
                return 0L;
            }
            case 252: {
                return this.readInt();
            }
            case 253: {
                return this.readLongInt();
            }
            case 254: {
                return this.readLongLong();
            }
        }
        return n;
    }

    final long readFieldLength() {
        int n = this.buf[this.pos++] & 0xFF;
        switch (n) {
            case 251: {
                return NULL_LENGTH;
            }
            case 252: {
                return this.readInt();
            }
            case 253: {
                return this.readLongInt();
            }
            case 254: {
                return this.readLong();
            }
        }
        return n;
    }

    final byte[] readByteArray() {
        return this.getNullTerminatedBytes();
    }

    final byte[] readLenByteArray() {
        long l = this.readFieldLength();
        if (l == NULL_LENGTH) {
            return null;
        }
        if (l == 0L) {
            return new byte[0];
        }
        return this.getBytes((int)l);
    }

    final String readString() {
        int n = this.pos;
        int n2 = 0;
        while (this.buf[n] != 0 && n < this.buf_length) {
            ++n2;
            ++n;
        }
        String string = new String(this.buf, this.pos, n2);
        this.pos += n2 + 1;
        return string;
    }

    final String readLenString() {
        long l = this.readFieldLength();
        if (l == NULL_LENGTH) {
            return null;
        }
        if (l == 0L) {
            return "";
        }
        String string = new String(this.buf, this.pos, (int)l);
        this.pos = (int)((long)this.pos + l);
        return string;
    }

    final byte[] getBytes(int n) {
        byte[] byArray = new byte[n];
        System.arraycopy(this.buf, this.pos, byArray, 0, n);
        this.pos += n;
        return byArray;
    }

    final byte[] getNullTerminatedBytes() {
        int n = this.pos;
        int n2 = 0;
        while (this.buf[n] != 0 && n < this.buf_length) {
            ++n2;
            ++n;
        }
        byte[] byArray = new byte[n2];
        System.arraycopy(this.buf, this.pos, byArray, 0, n2);
        this.pos += n2 + 1;
        return byArray;
    }

    final boolean isLastDataPacket() {
        return this.buf_length <= 2 && (this.buf[0] & 0xFF) == 254;
    }

    final void clear() {
        this.pos = 4;
    }

    final void writeByte(byte by) {
        this.buf[this.pos++] = by;
    }

    final void writeInt(int n) {
        byte[] byArray = this.buf;
        byArray[this.pos++] = (byte)(n & 0xFF);
        byArray[this.pos++] = (byte)(n >>> 8);
    }

    final void writeLongInt(int n) {
        byte[] byArray = this.buf;
        byArray[this.pos++] = (byte)(n & 0xFF);
        byArray[this.pos++] = (byte)(n >>> 8);
        byArray[this.pos++] = (byte)(n >>> 16);
    }

    final void writeLong(long l) {
        byte[] byArray = this.buf;
        byArray[this.pos++] = (byte)(l & 0xFFL);
        byArray[this.pos++] = (byte)(l >>> 8);
        byArray[this.pos++] = (byte)(l >>> 16);
        byArray[this.pos++] = (byte)(l >>> 24);
    }

    final void writeString(String string) {
        this.writeStringNoNull(string);
        this.buf[this.pos++] = 0;
    }

    final void writeStringNoNull(String string) {
        int n = string.length();
        this.ensureCapacity(n);
        int n2 = 0;
        while (n2 < n) {
            this.buf[this.pos++] = (byte)string.charAt(n2);
            ++n2;
        }
    }

    final void writeStringNoNull(String string, String string2) throws UnsupportedEncodingException {
        byte[] byArray = string.getBytes(string2);
        int n = byArray.length;
        this.ensureCapacity(n);
        System.arraycopy(byArray, 0, this.buf, this.pos, n);
        this.pos += n;
    }

    final void writeBytesNoNull(byte[] byArray) {
        int n = byArray.length;
        this.ensureCapacity(n);
        System.arraycopy(byArray, 0, this.buf, this.pos, n);
        this.pos += n;
    }

    final void ensureCapacity(int n) {
        if (this.pos + n > this.buf_length) {
            int n2 = (int)((double)this.buf_length * 1.25);
            if (n2 < this.buf_length + n) {
                n2 = this.buf_length + (int)((double)n * 1.25);
            }
            if (this.max_length != -1 && n2 > this.max_length) {
                throw new IllegalArgumentException("Packet is larger than max_allowed_packet from server configuration of " + this.max_length + " bytes");
            }
            byte[] byArray = new byte[n2];
            System.arraycopy(this.buf, 0, byArray, 0, this.buf.length);
            this.buf = byArray;
            this.buf_length = this.buf.length;
        }
    }

    final void dump() {
        int n;
        int n2;
        int n3 = 0;
        int n4 = this.buf_length / 8;
        int n5 = 0;
        while (n5 < n4) {
            n2 = n3;
            n = 0;
            while (n < 8) {
                String string = Integer.toHexString(this.buf[n2]);
                if (string.length() == 1) {
                    string = "0" + string;
                }
                System.out.print(string + " ");
                ++n2;
                ++n;
            }
            System.out.print("    ");
            int n6 = 0;
            while (n6 < 8) {
                if (this.buf[n3] > 32 && this.buf[n3] < 127) {
                    System.out.print((char)this.buf[n3] + " ");
                } else {
                    System.out.print(". ");
                }
                ++n3;
                ++n6;
            }
            System.out.println();
            ++n5;
        }
        n2 = 0;
        n = n3;
        while (n < this.buf_length) {
            String string = Integer.toHexString(this.buf[n]);
            if (string.length() == 1) {
                string = "0" + string;
            }
            System.out.print(string + " ");
            ++n2;
            ++n;
        }
        int n7 = n2;
        while (n7 < 8) {
            System.out.print("   ");
            ++n7;
        }
        System.out.print("    ");
        int n8 = n3;
        while (n8 < this.buf_length) {
            if (this.buf[n8] > 32 && this.buf[n8] < 127) {
                System.out.print((char)this.buf[n8] + " ");
            } else {
                System.out.print(". ");
            }
            ++n8;
        }
        System.out.println();
    }
}

