/*
 * Decompiled with CFR 0.152.
 */
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;

public class ThoJaDBConnect {
    String m_strType = "";
    String m_strUser = "";
    String m_strPassword = "";
    String m_strHost = "";
    String m_strDatabase = "";
    String m_strLastExceptionString = "";
    String m_strLastLocExceptionString = "";
    boolean m_blnParamSet = false;
    Connection m_DBConnection = null;
    ThoJaDBAdapter m_objDatabaseAccess = null;

    public boolean SetDatabase(String strType, String strUser, String strPassword, String strHost, String strDatabase) {
        try {
            this.m_strType = strType.toLowerCase();
            this.m_strUser = strUser;
            this.m_strHost = strHost;
            this.m_strPassword = strPassword;
            this.m_strDatabase = strDatabase;
            this.m_blnParamSet = true;
            return true;
        }
        catch (Exception ex) {
            this.SaveException(ex);
            return false;
        }
    }

    public boolean Connect() {
        boolean blnIsValid = false;
        if (this.m_strType.equals("mysql")) {
            this.m_objDatabaseAccess = new ThoJaMySQL();
            blnIsValid = true;
        }
        if (this.m_strType.equals("mssql")) {
            this.m_objDatabaseAccess = new ThoJaMSSQL();
            blnIsValid = true;
        }
        if (this.m_strType.equals("oracle")) {
            this.m_objDatabaseAccess = new ThoJaOracle();
            blnIsValid = true;
        }
        if (this.m_strType.equals("oracle9i")) {
            this.m_objDatabaseAccess = new ThoJaOracle9i();
            blnIsValid = true;
        }
        if (this.m_strType.equals("postgresql")) {
            this.m_objDatabaseAccess = new ThoJaPostgreSQL();
            blnIsValid = true;
        }
        if (blnIsValid) {
            try {
                this.m_DBConnection = this.m_objDatabaseAccess.createConnection(this.m_strHost, this.m_strDatabase, this.m_strUser, this.m_strPassword);
                if (this.m_DBConnection != null) {
                    return true;
                }
                this.m_strLastExceptionString = this.m_objDatabaseAccess.GetLastExceptionMessage();
                this.m_strLastLocExceptionString = this.m_objDatabaseAccess.GetLastLocExceptionMessage();
            }
            catch (Exception ex) {
                this.SaveException(ex);
                return false;
            }
        } else {
            this.m_strLastLocExceptionString = this.m_strLastExceptionString = "Internal Error: '" + this.m_strType + "' is not a valid database type.";
            return false;
        }
        return false;
    }

    public boolean Disconnect() {
        try {
            this.m_DBConnection.close();
            this.m_objDatabaseAccess = null;
            return true;
        }
        catch (Exception ex) {
            this.SaveException(ex);
            return false;
        }
    }

    public ResultSet ExecuteSQL(String strStatement) {
        try {
            Statement stmt = this.m_DBConnection.createStatement(1004, 1007);
            stmt.execute(strStatement);
            ResultSet rset = stmt.getResultSet();
            return rset;
        }
        catch (Exception ex) {
            this.SaveException(ex);
            return null;
        }
    }

    public String getVersion() {
        try {
            ResultSet rset1 = this.ExecuteSQL(this.m_objDatabaseAccess.getVersion());
            rset1.first();
            return rset1.getString(1);
        }
        catch (Exception ex) {
            this.SaveException(ex);
            return "";
        }
    }

    public ResultSet ListTables() {
        String strCmd = this.m_objDatabaseAccess.listTables();
        return this.ExecuteSQL(strCmd);
    }

    public ResultSet ListTableDesc(String strTable) {
        String strCmd = this.m_objDatabaseAccess.listTableDesc(strTable);
        return this.ExecuteSQL(strCmd);
    }

    private void SaveException(Exception except) {
        this.m_strLastExceptionString = except.getMessage();
        this.m_strLastLocExceptionString = except.getLocalizedMessage();
    }

    public String GetLastExceptionMessage() {
        return this.m_strLastExceptionString;
    }

    public String GetLastLocExceptionMessage() {
        return this.m_strLastLocExceptionString;
    }
}

