/*
 * Decompiled with CFR 0.152.
 */
package com.daffodilwoods.daffodilinstaller.daffodildb2_0;

import com.daffodilwoods.daffodilinstaller.daffodildb2_0.AbstractInstall;
import com.daffodilwoods.daffodilinstaller.daffodildb2_0.Step;
import com.daffodilwoods.daffodilinstaller.daffodildb2_0.WizardInterface;
import com.daffodilwoods.daffodilinstaller.daffodildb2_0.gui.GraphicUI;
import java.awt.Toolkit;

public abstract class StepFactory {
    private static StepFactory UNIQUE_UI = null;
    private AbstractInstall setup_;
    private WizardInterface wizard_;

    private static boolean testGraphicUi() {
        boolean res = true;
        try {
            Toolkit.getDefaultToolkit();
        }
        catch (Error ex) {
            res = false;
        }
        return res;
    }

    public static StepFactory createUI(AbstractInstall setup) {
        if (UNIQUE_UI != null) {
            return UNIQUE_UI;
        }
        if (!StepFactory.testGraphicUi()) {
            System.err.println("No graphic display found. Quiting");
            System.exit(0);
        }
        if ((UNIQUE_UI = new GraphicUI()) != null) {
            StepFactory.UNIQUE_UI.setup_ = setup;
            UNIQUE_UI.initUI();
        }
        return UNIQUE_UI;
    }

    public abstract void initUI();

    public void activateUI() {
        if (this.wizard_ == null) {
            this.showError(new NullPointerException("Null wizard! Please create one or overload StepFactory::activateUI()"));
            this.setup_.cancel();
        }
        this.wizard_.show();
    }

    public void quitUI() {
        if (this.wizard_ != null) {
            this.wizard_.dispose(false);
        }
    }

    public abstract Step createSetupLanguageStep();

    public abstract Step createWelcomeStep();

    public abstract Step createLicenseStep();

    public abstract Step createReadmeStep();

    public abstract Step createLicenseKeyStep();

    public abstract Step createUpgradeStep();

    public abstract Step createComponentStep();

    public abstract Step createDirectoryStep();

    public abstract Step createJVMStep();

    public abstract Step createInstallStep();

    public abstract Step createShortcutStep();

    public abstract Step createEndStep();

    public void setActionEnabled(int actions) {
        if (this.wizard_ == null) {
            this.showError(new NullPointerException("Null wizard! Please create one or overload StepFactory::setActionEnabled()"));
            this.setup_.cancel();
        }
        this.wizard_.setActionEnabled(actions);
    }

    public void showFatalError(Throwable t) {
        t.printStackTrace();
    }

    public void showError(Throwable t) {
        System.err.println(t);
    }

    public void uiSleep(long millis) {
    }

    protected AbstractInstall getInstaller() {
        return this.setup_;
    }

    protected WizardInterface getWizard() {
        return this.wizard_;
    }

    protected void setWizard(WizardInterface w) {
        this.wizard_ = w;
    }
}

