/*
 * Decompiled with CFR 0.152.
 */
package com.daffodilwoods.daffodilinstaller.daffodildb2_0.gui;

import com.daffodilwoods.daffodilinstaller.daffodildb2_0.ComponentsStep;
import com.daffodilwoods.daffodilinstaller.daffodildb2_0.Globals;
import com.daffodilwoods.daffodilinstaller.daffodildb2_0.Setup;
import com.daffodilwoods.daffodilinstaller.daffodildb2_0.gui.ImagePanel;
import com.daffodilwoods.daffodilinstaller.daffodildb2_0.gui.Panel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;

public class ComponentsPanel
extends Panel
implements ComponentsStep {
    JCheckBox embeddedCheckBox;
    JCheckBox serverCheckBox;
    JCheckBox clientCheckBox;
    JCheckBox docsCheckBox;
    JTextArea description;
    Setup setup_;
    boolean isEmbeddedSelected = true;
    boolean isServerSelected = true;
    boolean isClientSelected = true;
    boolean isDocumentaionSelected = true;
    String defaultMessage = "Daffodil DB " + Globals.APP_VERSION + " provides following components.\n" + " 1. Embedded - Embedded component of Daffodil DB " + Globals.APP_VERSION + "\n" + " 2. Server - Server component of Daffodil DB " + Globals.APP_VERSION + "\n" + " 3. Client - Client component of Daffodil DB " + Globals.APP_VERSION + "\n" + " 4. Documentation - complete documentation of Daffodil DB " + Globals.APP_VERSION + ".";
    String embeddedMessgae = "Embedded component of Daffodil DB " + Globals.APP_VERSION + " provides jars necessary" + " to embed it in Application";
    String serverMessage = "Server component of Daffodil DB " + Globals.APP_VERSION + " provides jars necessary to" + " use Daffodil DB in client/server architecture.";
    String clientMessage = "Client component provides necessary jars to connect clients to Daffodil DB " + Globals.APP_VERSION + " server running on same/another machine.";
    String docsMessage = "Documentation contains complete documentation set of Daffodil DB " + Globals.APP_VERSION + ". Documentation is available in two format PDF and HTML.";

    public ComponentsPanel() {
        this.setLayout(new BoxLayout(this, 0));
        JPanel pnMain = new JPanel();
        pnMain.setBorder(new CompoundBorder(new EtchedBorder(), new EmptyBorder(new Insets(5, 5, 5, 5))));
        pnMain.setLayout(new BoxLayout(pnMain, 1));
        JPanel pnHaut = new JPanel();
        pnHaut.setLayout(new BorderLayout());
        JLabel lbTitle = new JLabel(Globals.i18n("UI_Components"));
        lbTitle.setFont(lbTitle.getFont().deriveFont(1, 20.0f));
        lbTitle.setOpaque(true);
        lbTitle.setBorder(new CompoundBorder(new EtchedBorder(), new EmptyBorder(new Insets(5, 0, 5, 0))));
        lbTitle.setBackground(pnMain.getBackground().darker());
        lbTitle.setForeground(Color.white);
        JPanel outerPanel = new JPanel(new BorderLayout());
        JTextArea textArea = new JTextArea(Globals.i18n("UI_ComponentsMessage"));
        textArea.setEditable(false);
        textArea.setHighlighter(null);
        textArea.setBackground(pnMain.getBackground());
        textArea.setWrapStyleWord(true);
        textArea.setLineWrap(true);
        textArea.setBorder(new EmptyBorder(new Insets(5, 0, 5, 0)));
        JPanel optionsPanel = new JPanel();
        optionsPanel.setBorder(new EtchedBorder());
        BoxLayout boxL = new BoxLayout(optionsPanel, 1);
        optionsPanel.setLayout(boxL);
        this.embeddedCheckBox = new JCheckBox("Embedded", true);
        this.serverCheckBox = new JCheckBox("Server", true);
        this.clientCheckBox = new JCheckBox("Client", true);
        this.docsCheckBox = new JCheckBox("Documentation", true);
        optionsPanel.add(this.embeddedCheckBox);
        optionsPanel.add(this.serverCheckBox);
        optionsPanel.add(this.clientCheckBox);
        optionsPanel.add(this.docsCheckBox);
        JButton selectAll = new JButton(Globals.i18n("UI_ComponentsSelectAll"));
        JPanel temp = new JPanel();
        temp.setBorder(null);
        temp.setLayout(new FlowLayout(2));
        temp.add(selectAll);
        selectAll.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ComponentsPanel.this.selectAll_actionPerformed(e);
            }
        });
        outerPanel.add((Component)textArea, "North");
        outerPanel.add((Component)optionsPanel, "Center");
        outerPanel.add((Component)temp, "South");
        pnHaut.add("South", outerPanel);
        pnHaut.add("North", lbTitle);
        JPanel pnBas = new JPanel();
        pnBas.setBorder(new EtchedBorder());
        pnBas.setLayout(new BorderLayout());
        this.description = new JTextArea(this.defaultMessage);
        this.description.setPreferredSize(new Dimension(10, 140));
        this.description.setEditable(false);
        this.description.setHighlighter(null);
        this.description.setBackground(pnMain.getBackground().brighter());
        this.description.setWrapStyleWord(true);
        this.description.setLineWrap(true);
        pnBas.add((Component)this.description, "North");
        pnMain.add(pnHaut);
        pnMain.add(pnBas);
        ImagePanel pnImage = ImagePanel.IMAGE_PANEL;
        this.add(pnImage);
        this.add(pnMain);
        MyMouseListener mouseListener = new MyMouseListener();
        MyItemListener itemListener = new MyItemListener();
        this.embeddedCheckBox.addMouseListener(mouseListener);
        this.serverCheckBox.addMouseListener(mouseListener);
        this.clientCheckBox.addMouseListener(mouseListener);
        this.docsCheckBox.addMouseListener(mouseListener);
        this.embeddedCheckBox.addItemListener(itemListener);
        this.serverCheckBox.addItemListener(itemListener);
        this.clientCheckBox.addItemListener(itemListener);
        this.docsCheckBox.addItemListener(itemListener);
    }

    private void selectAll_actionPerformed(ActionEvent e) {
        this.embeddedCheckBox.setSelected(true);
        this.serverCheckBox.setSelected(true);
        this.clientCheckBox.setSelected(true);
        this.docsCheckBox.setSelected(true);
    }

    public void setSetUp(Setup setup) {
        this.setup_ = setup;
    }

    public void getInstallationComponents() {
        Globals.isEmbeddedSelected = this.isEmbeddedSelected;
        Globals.isServerSelected = this.isServerSelected;
        Globals.isClientSelected = this.isClientSelected;
        Globals.isDocumentaionSelected = this.isDocumentaionSelected;
    }

    public void setInstallationComponents() {
        this.isEmbeddedSelected = Globals.isEmbeddedSelected;
        this.isServerSelected = Globals.isServerSelected;
        this.isClientSelected = Globals.isClientSelected;
        this.isDocumentaionSelected = Globals.isDocumentaionSelected;
        this.embeddedCheckBox.setSelected(this.isEmbeddedSelected);
        this.serverCheckBox.setSelected(this.isServerSelected);
        this.clientCheckBox.setSelected(this.isClientSelected);
        this.docsCheckBox.setSelected(this.isDocumentaionSelected);
    }

    class MyItemListener
    implements ItemListener {
        MyItemListener() {
        }

        public void itemStateChanged(ItemEvent e) {
            boolean isSelected;
            if (ComponentsPanel.this.setup_ != null) {
                if (!(ComponentsPanel.this.embeddedCheckBox.isSelected() || ComponentsPanel.this.serverCheckBox.isSelected() || ComponentsPanel.this.clientCheckBox.isSelected())) {
                    ComponentsPanel.this.setup_.setActionEnabled(3);
                } else {
                    ComponentsPanel.this.setup_.setActionEnabled(7);
                }
            }
            Object item = e.getItem();
            boolean bl = isSelected = e.getStateChange() == 1;
            if (item.equals(ComponentsPanel.this.embeddedCheckBox)) {
                ComponentsPanel.this.isEmbeddedSelected = isSelected;
            } else if (item.equals(ComponentsPanel.this.serverCheckBox)) {
                ComponentsPanel.this.isServerSelected = isSelected;
            } else if (item.equals(ComponentsPanel.this.clientCheckBox)) {
                ComponentsPanel.this.isClientSelected = isSelected;
            } else if (item.equals(ComponentsPanel.this.docsCheckBox)) {
                ComponentsPanel.this.isDocumentaionSelected = isSelected;
            }
        }
    }

    class MyMouseListener
    extends MouseAdapter {
        MyMouseListener() {
        }

        public void mouseExited(MouseEvent e) {
            ComponentsPanel.this.description.setText(ComponentsPanel.this.defaultMessage);
        }

        public void mouseEntered(MouseEvent e) {
            Component com = e.getComponent();
            if (com.equals(ComponentsPanel.this.embeddedCheckBox)) {
                ComponentsPanel.this.description.setText(ComponentsPanel.this.embeddedMessgae);
            } else if (com.equals(ComponentsPanel.this.serverCheckBox)) {
                ComponentsPanel.this.description.setText(ComponentsPanel.this.serverMessage);
            } else if (com.equals(ComponentsPanel.this.clientCheckBox)) {
                ComponentsPanel.this.description.setText(ComponentsPanel.this.clientMessage);
            } else if (com.equals(ComponentsPanel.this.docsCheckBox)) {
                ComponentsPanel.this.description.setText(ComponentsPanel.this.docsMessage);
            }
        }
    }
}

