/* MAIN.C - This file is part of
Resolver for Windows, copyright (C) Fabrizio Gennari, 2000-2003

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
   02111-1307, USA.  */

#include <windows.h>
#include <windowsx.h>
#include <commctrl.h>
#include <winsock2.h>
#include <stdio.h>
#include "resource.h"
#include "resolv.h"
#include "list.h"

HINSTANCE inst;
BOOL idle;

void rev_query(HWND hwnd, char* asked_host, SOCKADDR_IN dns_addr,SOCKADDR_IN host_addr){
	int result,i,line,namesize,query_rep_len;
	char *query,message[256],*name,answer[256], host[256];
	unsigned char errors;
	unsigned short int qdcount,ancount,nscount,arcount,querylen=0;
	struct answer *anstype;
	LV_ITEM linea;
	unsigned char query_rep[65535], *eom, *src;
	struct query *response;

	sprintf(host,"%u.%u.%u.%u.in-addr.arpa",host_addr.sin_addr.S_un.S_un_b.s_b4
	,host_addr.sin_addr.S_un.S_un_b.s_b3
	,host_addr.sin_addr.S_un.S_un_b.s_b2
	,host_addr.sin_addr.S_un.S_un_b.s_b1);
	while(1){
		querylen++;
		query=(char*)malloc(querylen);
		result=res_mkquery(0,host,1,12,0,0,0,query,querylen);
		if (result!=-1) break;
		free(query);
	}
	sprintf(message,"Connecting to %u.%u.%u.%u"
		,dns_addr.sin_addr.S_un.S_un_b.s_b1
		,dns_addr.sin_addr.S_un.S_un_b.s_b2
		,dns_addr.sin_addr.S_un.S_un_b.s_b3
		,dns_addr.sin_addr.S_un.S_un_b.s_b4);
	SetWindowText(GetDlgItem(hwnd,IDC_ANS_STATUS),message);

	query_rep_len=res_nsend((SOCKADDR*)&dns_addr,query,querylen,
		query_rep,sizeof(query_rep));
	free(query);
	switch (query_rep_len){
	case -4:
		sprintf(message,"Socket error, connection failed");
		SetWindowText(GetDlgItem(hwnd,IDC_ANS_STATUS),message);
		return;
	case -3:
		sprintf(message,"Error receiving");
		SetWindowText(GetDlgItem(hwnd,IDC_ANS_STATUS),message);
		return;
	case -2:
		sprintf(message,"Error sending");
		SetWindowText(GetDlgItem(hwnd,IDC_ANS_STATUS),message);
		return;
	case -1:
		sprintf(message,"Internal error");
		SetWindowText(GetDlgItem(hwnd,IDC_ANS_STATUS),message);
		return;
	default:
		;
	}

	if (query_rep_len < sizeof(struct query)){
		sprintf(message,"Error parsing return message");
		SetWindowText(GetDlgItem(hwnd,IDC_ANS_STATUS),message);
		return;
	}

	response = (struct query*)query_rep;

	errors=response->control[1];
	if (process_errors(errors,message,host)){
		SetWindowText(GetDlgItem(hwnd,IDC_ANS_STATUS),message);
		return;
	}
	qdcount=ntohs(response->qdcount);
	ancount=ntohs(response->ancount);
	nscount=ntohs(response->nscount);
	arcount=ntohs(response->arcount);
	if (ancount==0){
		sprintf(message,"%s is a valid domain name, but not a valid hostname",host);
		SetWindowText(GetDlgItem(hwnd,IDC_ANS_STATUS),message);
		return;
	}
	eom=query_rep+query_rep_len;
	src=query_rep+sizeof(*response);
	result=ns_skiprr(src,eom,ns_s_qd,qdcount);
	if (result < 0){
		SetWindowText(GetDlgItem(hwnd,IDC_ANS_STATUS),"Error parsing return message");
		return;
	}
	src+=result;
	line=0;
	for(i=0;i<ancount;i++){
		namesize=256;
		while(1){
			name=(char*)malloc(namesize);
			if (name == NULL){
				SetWindowText(GetDlgItem(hwnd,IDC_ANS_STATUS),"Out of memory");
				return;
			}
			result=dn_expand(query_rep,eom,src,name,namesize);
			if (result==-2){
				SetWindowText(GetDlgItem(hwnd,IDC_ANS_STATUS),"Server gave back a malformed message");
				free(name);
				return;
			}
			if (result>=0){
				break;
			}
			free(name);
			namesize+=256;
		}
		if (src +result+ sizeof(*anstype) >= eom){
			SetWindowText(GetDlgItem(hwnd,IDC_ANS_STATUS),"Server gave back a malformed message");
			free(name);
			return;
		}
		anstype=(struct answer *)(src+result);
		if (ntohs(anstype->type)==12){//reverse lookup: get name from address
			src+=result+sizeof(*anstype);
			if ( (result=dn_expand(query_rep,eom,src,answer,sizeof(answer))) < 0){
				SetWindowText(GetDlgItem(hwnd,IDC_ANS_STATUS),"Server gave back a malformed message");
				free(name);
				return;
			}
			src+=result;
			linea.mask=LVIF_TEXT|LVIF_PARAM;
			linea.lParam=line;
			linea.iItem=line++;
			linea.iSubItem=0;
			linea.pszText=answer;
			ListView_InsertItem(GetDlgItem(hwnd,IDC_LIST4),&linea);
			linea.mask=LVIF_TEXT;
			linea.iSubItem=1;
			linea.pszText=name;
			SendDlgItemMessage(hwnd,IDC_LIST4,LVM_SETITEM,(WPARAM) 0,(LPARAM) &linea);
		}
		else{
			if ( (result=ns_skiprr(src,eom,ns_s_an,1)) < 0){
				SetWindowText(GetDlgItem(hwnd,IDC_ANS_STATUS),"Server gave back a malformed message");
				free(name);
				return;
			}
			src+=result;
		}
		free(name);
	}
	_snprintf(message,sizeof(message),"Hostname of %s",asked_host);
	SetWindowText(GetDlgItem(hwnd,IDC_ANS_STATUS),message);
	/* skip the rest of message */
}

void direct_query(HWND hwnd, char* host, SOCKADDR_IN dns_addr){
	int result,i,line,namesize,query_rep_len;
	char *query,message[256],*name,answer[256];
	unsigned char errors;
	unsigned short int qdcount,ancount,nscount,arcount,querylen=0;
	struct answer *anstype;
	BOOL alias;
	LV_ITEM linea;
	unsigned char query_rep[65536], *eom, *src;
	struct query *response;

	while(1){
		querylen++;
		query=(char*)malloc(querylen);
		result=res_mkquery(0,host,1,1,0,0,0,query,querylen);
		if (result!=-1) break;
		free(query);
	}
	sprintf(message,"Connecting to %u.%u.%u.%u"
		,dns_addr.sin_addr.S_un.S_un_b.s_b1
		,dns_addr.sin_addr.S_un.S_un_b.s_b2
		,dns_addr.sin_addr.S_un.S_un_b.s_b3
		,dns_addr.sin_addr.S_un.S_un_b.s_b4);
	SetWindowText(GetDlgItem(hwnd,IDC_ANS_STATUS),message);

	query_rep_len=res_nsend((SOCKADDR*)&dns_addr,query,querylen,
		query_rep,sizeof(query_rep));
	free(query);
	switch (query_rep_len){
	case -4:
		sprintf(message,"Socket error, connection failed");
		SetWindowText(GetDlgItem(hwnd,IDC_ANS_STATUS),message);
		return;
	case -3:
		sprintf(message,"Error receiving");
		SetWindowText(GetDlgItem(hwnd,IDC_ANS_STATUS),message);
		return;
	case -2:
		sprintf(message,"Error sending");
		SetWindowText(GetDlgItem(hwnd,IDC_ANS_STATUS),message);
		return;
	case -1:
		sprintf(message,"Internal error");
		SetWindowText(GetDlgItem(hwnd,IDC_ANS_STATUS),message);
		return;
	default:
		;
	}

	if (query_rep_len < sizeof(struct query)){
		sprintf(message,"Error parsing return message");
		SetWindowText(GetDlgItem(hwnd,IDC_ANS_STATUS),message);
		return;
	}

	response = (struct query*)query_rep;

	errors=response->control[1];
	if (process_errors(errors,message,host)){
		SetWindowText(GetDlgItem(hwnd,IDC_ANS_STATUS),message);
		return;
	}

	qdcount=ntohs(response->qdcount);
	ancount=ntohs(response->ancount);
	nscount=ntohs(response->nscount);
	arcount=ntohs(response->arcount);
	if (ancount==0){
		sprintf(message,"%s is a valid domain name, but not a valid hostname",host);
		SetWindowText(GetDlgItem(hwnd,IDC_ANS_STATUS),message);
		return;
	}
	eom=query_rep+query_rep_len;
	src=query_rep+sizeof(*response);
	result=ns_skiprr(src,eom,ns_s_qd,qdcount);
	if (result < 0){
		SetWindowText(GetDlgItem(hwnd,IDC_ANS_STATUS),"Error parsing return message");
		return;
	}
	src+=result;

	alias=FALSE;
	line=0;
	for(i=0;i<ancount;i++){
		namesize=256;
		while(1){
			name=(char*)malloc(namesize);
			if (name == NULL){
				SetWindowText(GetDlgItem(hwnd,IDC_ANS_STATUS),"Out of memory");
				return;
			}
			result=dn_expand(query_rep,eom,src,name,namesize);
			if (result==-2){
				SetWindowText(GetDlgItem(hwnd,IDC_ANS_STATUS),"Server gave back a malformed message");
				free(name);
				return;
			}
			if (result>=0){
				break;
			}
			free(name);
			namesize+=256;
		}
		if (src +result+ sizeof(*anstype) >= eom){
			SetWindowText(GetDlgItem(hwnd,IDC_ANS_STATUS),"Server gave back a malformed message");
			free(name);
			return;
		}
		anstype=(struct answer *)(src+result);
		if (ntohs(anstype->type)==5){//alias
			src+=result+sizeof(*anstype);
			if ( (result=dn_expand(query_rep,eom,src,answer,sizeof(answer))) < 0){
				SetWindowText(GetDlgItem(hwnd,IDC_ANS_STATUS),"Server gave back a malformed message");
				free(name);
				return;
			}
			src+=result;
			_snprintf(message,sizeof(message),"%s is an alias for %s",name,answer);
			SetWindowText(GetDlgItem(hwnd,IDC_ANS_STATUS),message);
			alias=TRUE;
		}
		else if(ntohs(anstype->type)==1){//address
			src+=result+sizeof(*anstype);
			if ( (result=GetIPAddress(src,eom,answer,sizeof(answer))) < 0){
				SetWindowText(GetDlgItem(hwnd,IDC_ANS_STATUS),"Server gave back a malformed message");
				free(name);
				return;
			}
			src+=result;
			linea.mask=LVIF_TEXT|LVIF_PARAM;
			linea.lParam=line;
			linea.iItem=line++;
			linea.iSubItem=0;
			linea.pszText=name;
			ListView_InsertItem(GetDlgItem(hwnd,IDC_LIST4),&linea);
			linea.mask=LVIF_TEXT;
			linea.iSubItem=1;
			linea.pszText=answer;
			SendDlgItemMessage(hwnd,IDC_LIST4,LVM_SETITEM,(WPARAM) 0,(LPARAM) &linea);
		}
		else{
			if ( (result=ns_skiprr(src,eom,ns_s_an,1)) < 0){
				SetWindowText(GetDlgItem(hwnd,IDC_ANS_STATUS),"Server gave back a malformed message");
				free(name);
				return;
			}
			src+=result;
		}

		free(name);
	}
	if (!alias){
		_snprintf(message,sizeof(message),"IP address of %s",host);
		SetWindowText(GetDlgItem(hwnd,IDC_ANS_STATUS),message);
	}
}

void mx_query(HWND hwnd, char* host, SOCKADDR_IN dns_addr){
	int result,i,namesize,query_rep_len;
	char *query,message[256],*name,answer[256],comp[256];
	unsigned char errors;
	unsigned short int qdcount,ancount,nscount,arcount,querylen=0,preference;
	struct answer *anstype;
	LV_ITEM linea;
	unsigned char query_rep[65535], *eom, *src;
	struct query *response;
	char pref[6];

	while(1){
		querylen++;
		query=(char*)malloc(querylen);
		result=res_mkquery(0,host,1,15,0,0,0,query,querylen);
		if (result!=-1) break;
		free(query);
	}
	sprintf(message,"Connecting to %u.%u.%u.%u"
		,dns_addr.sin_addr.S_un.S_un_b.s_b1
		,dns_addr.sin_addr.S_un.S_un_b.s_b2
		,dns_addr.sin_addr.S_un.S_un_b.s_b3
		,dns_addr.sin_addr.S_un.S_un_b.s_b4);
	SetWindowText(GetDlgItem(hwnd,IDC_MXT),message);

	query_rep_len=res_nsend((SOCKADDR*)&dns_addr,query,querylen,
		query_rep,sizeof(query_rep));
	free(query);
	switch (query_rep_len){
	case -4:
		sprintf(message,"Socket error, connection failed");
		SetWindowText(GetDlgItem(hwnd,IDC_MXT),message);
		return;
	case -3:
		sprintf(message,"Error receiving");
		SetWindowText(GetDlgItem(hwnd,IDC_MXT),message);
		return;
	case -2:
		sprintf(message,"Error sending");
		SetWindowText(GetDlgItem(hwnd,IDC_MXT),message);
		return;
	case -1:
		sprintf(message,"Internal error");
		SetWindowText(GetDlgItem(hwnd,IDC_MXT),message);
		return;
	default:
		;
	}

	if (query_rep_len < sizeof(struct query)){
		sprintf(message,"Error parsing return message");
		SetWindowText(GetDlgItem(hwnd,IDC_MXT),message);
		return;
	}

	response = (struct query*)query_rep;

	errors=response->control[1];
	if (process_errors(errors,message,host)){
		SetWindowText(GetDlgItem(hwnd,IDC_MXT),message);
		return;
	}

	qdcount=ntohs(response->qdcount);
	ancount=ntohs(response->ancount);
	nscount=ntohs(response->nscount);
	arcount=ntohs(response->arcount);
	if (ancount==0){
		sprintf(message,"%s is a valid domain name, but not a valid mail address",host);
		SetWindowText(GetDlgItem(hwnd,IDC_MXT),message);
		return;
	}
	eom=query_rep+query_rep_len;
	src=query_rep+sizeof(*response);
	result=ns_skiprr(src,eom,ns_s_qd,qdcount);
	if (result < 0){
		SetWindowText(GetDlgItem(hwnd,IDC_MXT),"Error parsing return message");
		return;
	}
	src+=result;

	for(i=0;i<ancount;i++){
		namesize=256;
		while(1){
			name=(char*)malloc(namesize);
			if (name == NULL){
				SetWindowText(GetDlgItem(hwnd,IDC_MXT),"Out of memory");
				return;
			}
			result=dn_expand(query_rep,eom,src,name,namesize);
			if (result==-2){
				SetWindowText(GetDlgItem(hwnd,IDC_MXT),"Server gave back a malformed message");
				free(name);
				return;
			}
			if (result>=0){
				break;
			}
			free(name);
			namesize+=256;
		}
		if (src +result+ sizeof(*anstype) >= eom){
			SetWindowText(GetDlgItem(hwnd,IDC_MXT),"Server gave back a malformed message");
			free(name);
			return;
		}
		anstype=(struct answer *)(src+result);
		if (ntohs(anstype->type) == 15){
			src+=result+sizeof(*anstype);
			if ( (result=GetMailExchanger(query_rep,eom,src,answer,sizeof(answer),&preference)) < 0){
				SetWindowText(GetDlgItem(hwnd,IDC_MXT),"Server gave back a malformed message");
				free(name);
				return;
			}
			src+=result;
			linea.mask=LVIF_TEXT|LVIF_PARAM;
			linea.lParam=i;
			linea.iItem=i;
			linea.iSubItem=0;
			linea.pszText=name;
			ListView_InsertItem(GetDlgItem(hwnd,IDC_MX),&linea);
			linea.mask=LVIF_TEXT;
			linea.iSubItem=2;
			linea.pszText=answer;
			SendDlgItemMessage(hwnd,IDC_MX,LVM_SETITEM,(WPARAM) 0,(LPARAM) &linea);
			linea.iSubItem=1;
			sprintf(pref,"%u",preference);
			linea.pszText=pref;
			SendDlgItemMessage(hwnd,IDC_MX,LVM_SETITEM,(WPARAM) 0,(LPARAM) &linea);
		}
		else{
			if ( (result=ns_skiprr(src,eom,ns_s_an,1)) < 0){
				SetWindowText(GetDlgItem(hwnd,IDC_MXT),"Server gave back a malformed message");
				free(name);
				return;
			}
			src+=result;
		}
		free(name);
	}
	sprintf(message,"Mail exchanger for %s",host);
	SetWindowText(GetDlgItem(hwnd,IDC_MXT),message);
	result=ns_skiprr(src,eom,ns_s_ns,nscount);
	if (result < 0){
		SetWindowText(GetDlgItem(hwnd,IDC_MXT),"Error parsing return message");
		return;
	}
	src+=result;
	for(i=0;i<arcount;i++){
		namesize=256;
		while(1){
			name=(char*)malloc(namesize);
			if (name == NULL){
				SetWindowText(GetDlgItem(hwnd,IDC_MXT),"Out of memory");
				return;
			}
			result=dn_expand(query_rep,eom,src,name,namesize);
			if (result==-2){
				SetWindowText(GetDlgItem(hwnd,IDC_MXT),"Server gave back a malformed message");
				free(name);
				return;
			}
			if (result>=0){
				break;
			}
			free(name);
			namesize+=256;
		}
		if (src +result+ sizeof(*anstype) >= eom){
			SetWindowText(GetDlgItem(hwnd,IDC_MXT),"Server gave back a malformed message");
			free(name);
			return;
		}
		anstype=(struct answer *)(src+result);
		if (ntohs(anstype->type) == 1){
			int j;
			LV_ITEM linea;

			src+=result+sizeof(*anstype);
			if ( (result=GetIPAddress(src,eom,answer,sizeof(answer))) < 0){
				SetWindowText(GetDlgItem(hwnd,IDC_MXT),"Server gave back a malformed message");
				free(name);
				return;
			}
			src+=result;
			for(j=0;j<ancount;j++){
				linea.iItem=j;
				linea.iSubItem=2;
				linea.mask=LVIF_TEXT;
				linea.pszText=comp;
				linea.cchTextMax=256;
				ListView_GetItem(GetDlgItem(hwnd,IDC_MX),&linea);
				if (!strcmp(comp,name)){
					linea.pszText=answer;
					linea.iSubItem=3;
					SendDlgItemMessage(hwnd,IDC_MX,LVM_SETITEM,
						(WPARAM) 0,(LPARAM) &linea);
				}
			}
		}
		else{
			if ( (result=ns_skiprr(src,eom,ns_s_an,1)) < 0){
				SetWindowText(GetDlgItem(hwnd,IDC_MXT),"Server gave back a malformed message");
				free(name);
				return;
			}
			src+=result;
		}
		free(name);
	}
}

void ns_query(HWND hwnd, char* host, SOCKADDR_IN dns_addr){
	int result,i,namesize,query_rep_len;
	char *query,message[256],*name,answer[256],comp[256];
	unsigned char errors;
	unsigned short int qdcount,ancount,nscount,arcount,querylen=0;
	struct answer *anstype;
	LV_ITEM linea;
	unsigned char query_rep[65535], *eom, *src;
	struct query *response;

	while(1){
		querylen++;
		query=(char*)malloc(querylen);
		result=res_mkquery(0,host,1,2,0,0,0,query,querylen);
		if (result!=-1) break;
		free(query);
	}
	sprintf(message,"Connecting to %u.%u.%u.%u"
		,dns_addr.sin_addr.S_un.S_un_b.s_b1
		,dns_addr.sin_addr.S_un.S_un_b.s_b2
		,dns_addr.sin_addr.S_un.S_un_b.s_b3
		,dns_addr.sin_addr.S_un.S_un_b.s_b4);
	SetWindowText(GetDlgItem(hwnd,IDC_NST),message);

	query_rep_len=res_nsend((SOCKADDR*)&dns_addr,query,querylen,
		query_rep,sizeof(query_rep));
	free(query);
	switch (query_rep_len){
	case -4:
		sprintf(message,"Socket error, connection failed");
		SetWindowText(GetDlgItem(hwnd,IDC_NST),message);
		return;
	case -3:
		sprintf(message,"Error receiving");
		SetWindowText(GetDlgItem(hwnd,IDC_NST),message);
		return;
	case -2:
		sprintf(message,"Error sending");
		SetWindowText(GetDlgItem(hwnd,IDC_NST),message);
		return;
	case -1:
		sprintf(message,"Internal error");
		SetWindowText(GetDlgItem(hwnd,IDC_NST),message);
		return;
	default:
		;
	}

	if (query_rep_len < sizeof(struct query)){
		sprintf(message,"Error parsing return message");
		SetWindowText(GetDlgItem(hwnd,IDC_NST),message);
		return;
	}

	response = (struct query*)query_rep;

	errors=response->control[1];

	if (process_errors(errors,message,host)){
		SetWindowText(GetDlgItem(hwnd,IDC_NST),message);
		return;
	}
	qdcount=ntohs(response->qdcount);
	ancount=ntohs(response->ancount);
	nscount=ntohs(response->nscount);
	arcount=ntohs(response->arcount);
	if (ancount==0){
		sprintf(message,"%s is not a domain name. It could be a host name or a mail address",host);
		SetWindowText(GetDlgItem(hwnd,IDC_NST),message);
		return;
	}
	eom=query_rep+query_rep_len;
	src=query_rep+sizeof(*response);
	result=ns_skiprr(src,eom,ns_s_qd,qdcount);
	if (result < 0){
		SetWindowText(GetDlgItem(hwnd,IDC_NST),"Error parsing return message");
		return;
	}
	src+=result;
	for(i=0;i<ancount;i++){
		namesize=256;
		while(1){
			name=(char*)malloc(namesize);
			if (name == NULL){
				SetWindowText(GetDlgItem(hwnd,IDC_NST),"Out of memory");
				return;
			}
			result=dn_expand(query_rep,eom,src,name,namesize);
			if (result==-2){
				SetWindowText(GetDlgItem(hwnd,IDC_NST),"Server gave back a malformed message");
				free(name);
				return;
			}
			if (result>=0){
				break;
			}
			free(name);
			namesize+=256;
		}
		if (src +result+ sizeof(*anstype) >= eom){
			SetWindowText(GetDlgItem(hwnd,IDC_NST),"Server gave back a malformed message");
			free(name);
			return;
		}
		anstype=(struct answer *)(src+result);
		if (ntohs(anstype->type) == 2){
			src+=result+sizeof(*anstype);
			if ( (result=dn_expand(query_rep,eom,src,answer,sizeof(answer))) < 0){
				SetWindowText(GetDlgItem(hwnd,IDC_NST),"Server gave back a malformed message");
				free(name);
				return;
			}
			src+=result;
			linea.mask=LVIF_TEXT|LVIF_PARAM;
			linea.lParam=i;
			linea.iItem=i;
			linea.iSubItem=0;
			linea.pszText=name;
			ListView_InsertItem(GetDlgItem(hwnd,IDC_NS),&linea);
			linea.mask=LVIF_TEXT;
			linea.iSubItem=1;
			linea.pszText=answer;
			SendDlgItemMessage(hwnd,IDC_NS,LVM_SETITEM,(WPARAM) 0,(LPARAM) &linea);
		}
		else{
			if ( (result=ns_skiprr(src,eom,ns_s_an,1)) < 0){
				SetWindowText(GetDlgItem(hwnd,IDC_NST),"Server gave back a malformed message");
				free(name);
				return;
			}
			src+=result;
		}
		free(name);
	}
	sprintf(message,"Name server for %s",host);
	SetWindowText(GetDlgItem(hwnd,IDC_NST),message);
	result=ns_skiprr(src,eom,ns_s_ns,nscount);
	if (result < 0){
		SetWindowText(GetDlgItem(hwnd,IDC_NST),"Error parsing return message");
		return;
	}
	src+=result;
	for(i=0;i<arcount;i++){
		namesize=256;
		while(1){
			name=(char*)malloc(namesize);
			if (name == NULL){
				SetWindowText(GetDlgItem(hwnd,IDC_NST),"Out of memory");
				return;
			}
			result=dn_expand(query_rep,eom,src,name,namesize);
			if (result==-2){
				SetWindowText(GetDlgItem(hwnd,IDC_NST),"Server gave back a malformed message");
				free(name);
				return;
			}
			if (result>=0){
				break;
			}
			free(name);
			namesize+=256;
		}
		if (src + sizeof(*anstype) >= eom){
			SetWindowText(GetDlgItem(hwnd,IDC_NST),"Server gave back a malformed message");
			free(name);
			return;
		}
		anstype=(struct answer *)(src+result);
		if (ntohs(anstype->type) == 1){
			int j;
			LV_ITEM linea;

			src+=result+sizeof(*anstype);
			if ( (result=GetIPAddress(src,eom,answer,sizeof(answer))) < 0){
				SetWindowText(GetDlgItem(hwnd,IDC_NST),"Server gave back a malformed message");
				free(name);
				return;
			}
			src+=result;
			for(j=0;j<ancount;j++){
				linea.iItem=j;
				linea.iSubItem=1;
				linea.mask=LVIF_TEXT;
				linea.pszText=comp;
				linea.cchTextMax=256;
				ListView_GetItem(GetDlgItem(hwnd,IDC_NS),&linea);
				if (!strcmp(comp,name)){
					linea.pszText=answer;
					linea.iSubItem=2;
					SendDlgItemMessage(hwnd,IDC_NS,LVM_SETITEM,
						(WPARAM) 0,(LPARAM) &linea);
				}
			}
		}
		else{
			if ( (result=ns_skiprr(src,eom,ns_s_an,1)) < 0){
				SetWindowText(GetDlgItem(hwnd,IDC_NST),"Server gave back a malformed message");
				free(name);
				return;
			}
			src+=result;
		}
		free(name);
	}
}

void Query(HWND hwnd){
	int length;
	char *host, *dns, message[256];
	SOCKADDR_IN dns_addr,host_addr;
	length=(WORD) SendDlgItemMessage(hwnd,
                        IDC_DNS,
                        EM_LINELENGTH,
                        (WPARAM) 0,
                        (LPARAM) 0);
	if (length==0){
		MessageBox(hwnd,"No DNS specified","Error",MB_OK|MB_ICONERROR);
		return;
	}
	dns=(char*)malloc(length+1);
	*((WORD*)dns)=length;
	SendDlgItemMessage(hwnd,
                        IDC_DNS,
                        EM_GETLINE,
                        (WPARAM) 0,       /* line 0 */
                        (LPARAM) dns);
	dns[length]=0;
	dns_addr.sin_port=htons(53);
	dns_addr.sin_family=AF_INET;
	dns_addr.sin_addr.S_un.S_addr=inet_addr(dns);
	if (dns_addr.sin_addr.S_un.S_addr==INADDR_NONE){
		struct hostent* hostgot=gethostbyname(dns);
		if (hostgot==NULL){
			sprintf(message,"Could not resolve %s",dns);
			MessageBox(hwnd,message,"Error",MB_OK|MB_ICONERROR);
			free(dns);
			return;
		}
		dns_addr.sin_addr.S_un.S_un_b.s_b1=hostgot->h_addr_list[0][0];
		dns_addr.sin_addr.S_un.S_un_b.s_b2=hostgot->h_addr_list[0][1];
		dns_addr.sin_addr.S_un.S_un_b.s_b3=hostgot->h_addr_list[0][2];
		dns_addr.sin_addr.S_un.S_un_b.s_b4=hostgot->h_addr_list[0][3];
	}
	free(dns);
	memset(dns_addr.sin_zero,0,8);
	length=(WORD) SendDlgItemMessage(hwnd,
                        IDC_HOSTNAME,
                        EM_LINELENGTH,
                        (WPARAM) 0,
                        (LPARAM) 0);
	if (length==0){
		MessageBox(hwnd,"No host specified","Error",MB_OK|MB_ICONERROR);
		return;
	}
	host=(char*)malloc(length+1);
	*((WORD*)host)=length;
	SendDlgItemMessage(hwnd,
                        IDC_HOSTNAME,
                        EM_GETLINE,
                        (WPARAM) 0,       /* line 0 */
                        (LPARAM) host);
	host[length]=0;
	host_addr.sin_addr.S_un.S_addr=inet_addr(host);
	if (IsDlgButtonChecked(hwnd,IDC_ADDC)==BST_CHECKED){
		SendDlgItemMessage(hwnd,
                        IDC_LIST4,
                        LVM_DELETEALLITEMS,
                        (WPARAM) 0,
                        (LPARAM) 0);
		if (host_addr.sin_addr.S_un.S_addr==INADDR_NONE)
			direct_query(hwnd,host,dns_addr);
		else
			rev_query(hwnd,host,dns_addr,host_addr);
		UpdateWindow(hwnd);
	}
	if (IsDlgButtonChecked(hwnd,IDC_MXC)==BST_CHECKED){
	SendDlgItemMessage(hwnd,
                        IDC_MX,
                        LVM_DELETEALLITEMS,
                        (WPARAM) 0,
                        (LPARAM) 0);
		mx_query(hwnd,host,dns_addr);
		UpdateWindow(hwnd);
	}
	if (IsDlgButtonChecked(hwnd,IDC_NSC)==BST_CHECKED){
		SendDlgItemMessage(hwnd,
                        IDC_NS,
                        LVM_DELETEALLITEMS,
                        (WPARAM) 0,
                        (LPARAM) 0);
		ns_query(hwnd,host,dns_addr);
		UpdateWindow(hwnd);
	}
	free(host);
}

struct compare_parameter{
	HWND window;
	int subitem;
};

static int CALLBACK Compare(LPARAM lParam1, LPARAM lParam2,
						 LPARAM lParamSort){
	LV_ITEM linea;
	char string1[256],string2[256];
	struct compare_parameter *comp=(struct compare_parameter*)lParamSort;

	linea.iItem=lParam1;
	linea.iSubItem=comp->subitem;
	linea.mask=LVIF_TEXT|LVIF_PARAM;
	linea.pszText=string1;
	linea.cchTextMax=256;
	ListView_GetItem(comp->window,&linea);

	linea.iItem=lParam2;
	linea.iSubItem=comp->subitem;
	linea.mask=LVIF_TEXT|LVIF_PARAM;
	linea.pszText=string2;
	linea.cchTextMax=256;
	ListView_GetItem(comp->window,&linea);

	return strcmp(string1,string2);
};

static BOOL CALLBACK Funzione(HWND hwnd, // handle of window
UINT uMsg, // message identifier
WPARAM wParam, // first message parameter
LPARAM lParam // second message parameter
){
	switch (uMsg)
	{
		case WM_INITDIALOG:
			{
			LV_COLUMN colonna;
			char testo[64]="Hostname";
			HICON icona;

			icona=LoadIcon(inst,MAKEINTRESOURCE(IDI_ICON1));
			SendMessage(hwnd,WM_SETICON,ICON_BIG,(LPARAM)icona);
			colonna.mask=LVCF_TEXT|LVCF_WIDTH;
			colonna.pszText=testo;
			colonna.cx=170;
			ListView_InsertColumn(GetDlgItem(hwnd,IDC_LIST4),0,&colonna);
			colonna.cx=100;
			strcpy(testo,"IP");
			ListView_InsertColumn(GetDlgItem(hwnd,IDC_LIST4),1,&colonna);
			colonna.cx=170;
			strcpy(testo,"Host");
			ListView_InsertColumn(GetDlgItem(hwnd,IDC_NS),0,&colonna);
			strcpy(testo,"Authoritative name server");
			ListView_InsertColumn(GetDlgItem(hwnd,IDC_NS),1,&colonna);
			colonna.cx=100;
			strcpy(testo,"Name server IP");
			ListView_InsertColumn(GetDlgItem(hwnd,IDC_NS),2,&colonna);
			colonna.cx=170;
			strcpy(testo,"Mail address");
			ListView_InsertColumn(GetDlgItem(hwnd,IDC_MX),0,&colonna);
			colonna.cx=25;
			strcpy(testo,"Preference");
			ListView_InsertColumn(GetDlgItem(hwnd,IDC_MX),1,&colonna);
			colonna.cx=170;
			strcpy(testo,"Mail exchanger");
			ListView_InsertColumn(GetDlgItem(hwnd,IDC_MX),2,&colonna);
			colonna.cx=100;
			strcpy(testo,"Mail exchanger IP");
			ListView_InsertColumn(GetDlgItem(hwnd,IDC_MX),3,&colonna);
			CheckDlgButton(hwnd,IDC_ADDC,BST_CHECKED);
			SetWindowText(GetDlgItem(hwnd,IDC_HOSTNAME),"");
			SetWindowText(GetDlgItem(hwnd,IDC_DNS),"");
			return TRUE;
			}
		case WM_COMMAND:
			if(LOWORD(wParam)==IDC_OK)
			{
				Query(hwnd);
				return TRUE;
			}
			if(LOWORD(wParam)==ID_COPYHOSTNAME_COPYHOSTNAME){
				int item;
				if ( (item=ListView_GetNextItem(GetDlgItem(hwnd,IDC_LIST4), -1, LVNI_SELECTED)) != -1){
					LVITEM line;
					HGLOBAL global=GlobalAlloc(GMEM_MOVEABLE,256);

					line.iItem=item;
					line.iSubItem=0;
					line.pszText=GlobalLock(global);
					line.cchTextMax=256;
					line.mask=LVIF_TEXT;
					ListView_GetItem(GetDlgItem(hwnd,IDC_LIST4),&line);
					GlobalUnlock(global);
					OpenClipboard(NULL);
					EmptyClipboard();
					SetClipboardData(CF_TEXT,global);
					CloseClipboard();
					return 1;
				}
			}
			if(LOWORD(wParam)==ID_COPYHOSTNAME_COPYIPADDRESS){
				int item;
				if ( (item=ListView_GetNextItem(GetDlgItem(hwnd,IDC_LIST4), -1, LVNI_SELECTED)) != -1){
					LVITEM line;
					HGLOBAL global=GlobalAlloc(GMEM_MOVEABLE,256);

					line.iItem=item;
					line.iSubItem=1;
					line.pszText=GlobalLock(global);
					line.cchTextMax=256;
					line.mask=LVIF_TEXT;
					ListView_GetItem(GetDlgItem(hwnd,IDC_LIST4),&line);
					GlobalUnlock(global);
					OpenClipboard(NULL);
					EmptyClipboard();
					SetClipboardData(CF_TEXT,global);
					CloseClipboard();
					return 1;
				}
			}
			if(LOWORD(wParam)==ID_MX_COPYHOSTNAME){
				int item;
				if ( (item=ListView_GetNextItem(GetDlgItem(hwnd,IDC_MX), -1, LVNI_SELECTED)) != -1){
					LVITEM line;
					HGLOBAL global=GlobalAlloc(GMEM_MOVEABLE,256);

					line.iItem=item;
					line.iSubItem=0;
					line.pszText=GlobalLock(global);
					line.cchTextMax=256;
					line.mask=LVIF_TEXT;
					ListView_GetItem(GetDlgItem(hwnd,IDC_MX),&line);
					GlobalUnlock(global);
					OpenClipboard(NULL);
					EmptyClipboard();
					SetClipboardData(CF_TEXT,global);
					CloseClipboard();
					return 1;
				}
			}
			if(LOWORD(wParam)==ID_MX_COPYIPADDRESS){
				int item;
				if ( (item=ListView_GetNextItem(GetDlgItem(hwnd,IDC_MX), -1, LVNI_SELECTED)) != -1){
					LVITEM line;
					HGLOBAL global=GlobalAlloc(GMEM_MOVEABLE,256);

					line.iItem=item;
					line.iSubItem=3;
					line.pszText=GlobalLock(global);
					line.cchTextMax=256;
					line.mask=LVIF_TEXT;
					ListView_GetItem(GetDlgItem(hwnd,IDC_MX),&line);
					GlobalUnlock(global);
					OpenClipboard(NULL);
					EmptyClipboard();
					SetClipboardData(CF_TEXT,global);
					CloseClipboard();
					return 1;
				}
			}
			if(LOWORD(wParam)==ID_MX_COPYMAILEXCHANGERNAME){
				int item;
				if ( (item=ListView_GetNextItem(GetDlgItem(hwnd,IDC_MX), -1, LVNI_SELECTED)) != -1){
					LVITEM line;
					HGLOBAL global=GlobalAlloc(GMEM_MOVEABLE,256);

					line.iItem=item;
					line.iSubItem=2;
					line.pszText=GlobalLock(global);
					line.cchTextMax=256;
					line.mask=LVIF_TEXT;
					ListView_GetItem(GetDlgItem(hwnd,IDC_MX),&line);
					GlobalUnlock(global);
					OpenClipboard(NULL);
					EmptyClipboard();
					SetClipboardData(CF_TEXT,global);
					CloseClipboard();
					return 1;
				}
			}
			if(LOWORD(wParam)==ID_MX_COPYPREFERENCE){
				int item;
				if ( (item=ListView_GetNextItem(GetDlgItem(hwnd,IDC_MX), -1, LVNI_SELECTED)) != -1){
					LVITEM line;
					HGLOBAL global=GlobalAlloc(GMEM_MOVEABLE,256);

					line.iItem=item;
					line.iSubItem=1;
					line.pszText=GlobalLock(global);
					line.cchTextMax=256;
					line.mask=LVIF_TEXT;
					ListView_GetItem(GetDlgItem(hwnd,IDC_MX),&line);
					GlobalUnlock(global);
					OpenClipboard(NULL);
					EmptyClipboard();
					SetClipboardData(CF_TEXT,global);
					CloseClipboard();
					return 1;
				}
			}
			if(LOWORD(wParam)==ID_NS_COPYHOSTNAME){
				int item;
				if ( (item=ListView_GetNextItem(GetDlgItem(hwnd,IDC_NS), -1, LVNI_SELECTED)) != -1){
					LVITEM line;
					HGLOBAL global=GlobalAlloc(GMEM_MOVEABLE,256);

					line.iItem=item;
					line.iSubItem=0;
					line.pszText=GlobalLock(global);
					line.cchTextMax=256;
					line.mask=LVIF_TEXT;
					ListView_GetItem(GetDlgItem(hwnd,IDC_NS),&line);
					GlobalUnlock(global);
					OpenClipboard(NULL);
					EmptyClipboard();
					SetClipboardData(CF_TEXT,global);
					CloseClipboard();
					return 1;
				}
			}
			if(LOWORD(wParam)==ID_NS_COPYNAMESERVERNAME){
				int item;
				if ( (item=ListView_GetNextItem(GetDlgItem(hwnd,IDC_NS), -1, LVNI_SELECTED)) != -1){
					LVITEM line;
					HGLOBAL global=GlobalAlloc(GMEM_MOVEABLE,256);

					line.iItem=item;
					line.iSubItem=1;
					line.pszText=GlobalLock(global);
					line.cchTextMax=256;
					line.mask=LVIF_TEXT;
					ListView_GetItem(GetDlgItem(hwnd,IDC_NS),&line);
					GlobalUnlock(global);
					OpenClipboard(NULL);
					EmptyClipboard();
					SetClipboardData(CF_TEXT,global);
					CloseClipboard();
					return 1;
				}
			}
			if(LOWORD(wParam)==ID_NS_COPYNAMESERVERIPADDRESS){
				int item;
				if ( (item=ListView_GetNextItem(GetDlgItem(hwnd,IDC_NS), -1, LVNI_SELECTED)) != -1){
					LVITEM line;
					HGLOBAL global=GlobalAlloc(GMEM_MOVEABLE,256);

					line.iItem=item;
					line.iSubItem=2;
					line.pszText=GlobalLock(global);
					line.cchTextMax=256;
					line.mask=LVIF_TEXT;
					ListView_GetItem(GetDlgItem(hwnd,IDC_NS),&line);
					GlobalUnlock(global);
					OpenClipboard(NULL);
					EmptyClipboard();
					SetClipboardData(CF_TEXT,global);
					CloseClipboard();
					return 1;
				}
			}
			break;
		case WM_NOTIFY:
			if((wParam==IDC_NS)&&(((LPNMHDR)lParam)->code)==NM_DBLCLK){
				if(ListView_GetSelectedCount(GetDlgItem(hwnd,IDC_NS))==1)
					DialogBox(inst,MAKEINTRESOURCE(IDD_LIST),hwnd,list_callback);
				return TRUE;
			}
			if ((((LPNMHDR)lParam)->code)==LVN_COLUMNCLICK){
				LPNMLISTVIEW col=(LPNMLISTVIEW)lParam;
				int subitem=col->iSubItem;
				struct compare_parameter comp;
				int numitems,thisitem;
				LVITEM thisline;

				comp.window=col->hdr.hwndFrom;
				comp.subitem=col->iSubItem;

				ListView_SortItems(col->hdr.hwndFrom,Compare,(LPARAM)&comp);
				numitems=ListView_GetItemCount(col->hdr.hwndFrom);
				for(thisitem=0;thisitem<numitems;thisitem++){
					thisline.iItem=thisitem;
					thisline.lParam=thisitem;
					thisline.mask=LVIF_PARAM;
					ListView_SetItem(col->hdr.hwndFrom,&thisline);
				}
				return TRUE;
			}
			break;
		case WM_CONTEXTMENU:
			if ((HWND)wParam == GetDlgItem(hwnd,IDC_LIST4)){
				if (ListView_GetNextItem((HWND)wParam, -1, LVNI_SELECTED) != -1){
					HMENU menu=LoadMenu(inst,MAKEINTRESOURCE(IDR_MENU1));
					HMENU menu2=GetSubMenu(menu, 0);
					TrackPopupMenu(menu2,0,GET_X_LPARAM(lParam),GET_Y_LPARAM(lParam),0,hwnd,NULL);
					DestroyMenu(menu);
					return 1;
				}
			}
			if ((HWND)wParam == GetDlgItem(hwnd,IDC_MX)){
				if (ListView_GetNextItem((HWND)wParam, -1, LVNI_SELECTED) != -1){
					HMENU menu=LoadMenu(inst,MAKEINTRESOURCE(IDR_MENU1));
					HMENU menu2=GetSubMenu(menu, 1);
					TrackPopupMenu(menu2,0,GET_X_LPARAM(lParam),GET_Y_LPARAM(lParam),0,hwnd,NULL);
					DestroyMenu(menu);
					return 1;
				}
			}
			if ((HWND)wParam == GetDlgItem(hwnd,IDC_NS)){
				if (ListView_GetNextItem((HWND)wParam, -1, LVNI_SELECTED) != -1){
					HMENU menu=LoadMenu(inst,MAKEINTRESOURCE(IDR_MENU1));
					HMENU menu2=GetSubMenu(menu, 2);
					TrackPopupMenu(menu2,0,GET_X_LPARAM(lParam),GET_Y_LPARAM(lParam),0,hwnd,NULL);
					DestroyMenu(menu);
					return 1;
				}
			}
			break;
		case WM_CLOSE:
			EndDialog(hwnd,0);
			return TRUE;
		default:
			return 0;
	}
	return 0;
};

int WINAPI WinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance,
			LPSTR lpCmdLine, int nCmdShow ){
	WSADATA dati;

	inst=hInstance;
	InitCommonControls();
	WSAStartup(MAKEWORD(2,0),&dati);
	DialogBox(hInstance,MAKEINTRESOURCE(IDD_MAINWINDOW),NULL,Funzione);
	WSACleanup();
	return 0;
}
