/*
 * Copyright (c) 1998-2005 Servertec. All Rights Reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * THIS NOTICE MUST NOT BE ALTERED NOR REMOVED.
 *
 * CopyrightVersion 1.0
 */

import java.io.IOException;
import java.io.PrintWriter;

import javax.servlet.ServletException;
import javax.servlet.http.Cookie;

import stec.iws.Utils;

import stec.iws.Request;
import stec.iws.Response;

public class CookieCounterServlet extends BaseServlet
{
	public void service(Request _request, Response _response) throws ServletException, IOException
	{
		int counter;

		Cookie cookies[] = _request.getCookies();
		if(cookies == null)
		{
			counter = 0;
		}
		else
		{
			Cookie cookie = Utils.extractCookie(cookies, "cookiecounter");
			if(cookie == null)
			{
				counter = 0;
			}
			else
			{
				counter = Integer.parseInt(cookie.getValue());
			}
		}

		_response.addCookie(new Cookie("cookiecounter", String.valueOf(counter+1)));

		PrintWriter writer = _response.getWriter();

		writer.println("<html>");
		writer.println("<head><title>Cookie Counter Servlet</title></head>");
		writer.println("<body>");

		if(counter == 0)
		{
			writer.println("cookie counter did not exist");
		}
		else
		{
			writer.println("cookie counter is " + counter);
		}

		writer.println("<p>");
		writer.println("[ <a href=\"./cookiecounter.html\">refresh</a> ]");
		writer.println("</body>");
		writer.println("</html>");
	}
}
