#include <CMovie.h>

CMovie::CMovie()
{
	IGraphBuilder *Graph=NULL;
    IMediaControl *Control=NULL;
    IMediaEvent   *Event=NULL;
	IVideoWindow  *VidWin=NULL;
	IMediaSeeking	*Seeking=NULL;
	error=NULL;
}

CMovie::CMovie(CError *err)
{
	IGraphBuilder *Graph=NULL;
    IMediaControl *Control=NULL;
    IMediaEvent   *Event=NULL;
	IVideoWindow  *VidWin=NULL;
	IMediaSeeking	*Seeking=NULL;
	error=err;
}

int CMovie::Create(WCHAR *name,HWND window)
{
	CoCreateInstance(CLSID_FilterGraph, NULL, CLSCTX_INPROC_SERVER,IID_IGraphBuilder, (void **)&Graph);
	Graph->QueryInterface(IID_IMediaControl, (void **)&Control);
	Graph->QueryInterface(IID_IMediaEvent, (void **)&Event);
	Graph->QueryInterface(IID_IVideoWindow, (void **)&VidWin);
	Graph->QueryInterface(IID_IMediaSeeking, (void **)&Seeking);
	HRESULT hr=Graph->RenderFile(name, NULL);
	if(hr!=S_OK)
		return D_ERROR;
	VidWin->put_Owner((OAHWND)window);
	if(S_OK!=VidWin->SetWindowPosition(-4,-23,GetSystemMetrics(SM_CXSCREEN)+8,GetSystemMetrics(SM_CYSCREEN)+20))
		return D_ERROR;
	VidWin->HideCursor(OATRUE);
	VidWin->put_Visible(OAFALSE);
	return D_FINE;
}

int CMovie::Play()
{
	if(S_OK!=VidWin->SetWindowPosition(-4,-23,GetSystemMetrics(SM_CXSCREEN)+8,GetSystemMetrics(SM_CYSCREEN)+20))
		return D_ERROR;
	VidWin->put_Visible(OATRUE);
	HRESULT hr=Control->Run();
	if(S_OK!=hr&&hr!=S_FALSE)
	{
		if(error!=NULL)
			error->write("Error while playing the movie.\n");
		return D_ERROR;
	}
	long Code;
	while(Event->WaitForCompletion(0, &Code)!=VFW_E_WRONG_STATE)
	{
		if(KEYDOWN2(VK_ESCAPE))
			break;
	}
	VidWin->put_Visible(OAFALSE);
	VidWin->HideCursor(OAFALSE);
	LONGLONG pos = 0;
	Seeking->SetPositions(&pos,AM_SEEKING_AbsolutePositioning,NULL,AM_SEEKING_NoPositioning);
	Control->Stop();
	return D_FINE;
}

int CMovie::Destroy()
{
	if(VidWin!=NULL)
	{
		VidWin->put_Visible(OAFALSE);
		VidWin->put_Owner(NULL);
		VidWin->Release();
		VidWin=NULL;
	}
	if(Control!=NULL)
	{
		Control->Stop();
		Control->Release();
		Control=NULL;
	}
	if(Seeking!=NULL)
	{
		Seeking->Release();
		Seeking=NULL;
	}
	if(Event!=NULL)
	{
		Event->Release();
		Event=NULL;
	}
	if(Graph!=NULL)
	{
		Graph->Release();
		Graph=NULL;
	}
	return D_FINE;
}

CMovie::~CMovie()
{
	this->Destroy();
}
