#ifndef __input__
#define __input__
#include <globals.h>

#include <dinput.h>
#pragma comment(lib,"dinput8.lib")

#ifdef DEBUG_NOVA
#pragma comment(lib,"CInputD.lib")
#endif
#ifndef DEBUG_NOVA
#pragma comment(lib,"CInput.lib")
#endif

class CInput
{
public:
	CInput();
	~CInput();
	int create(HINSTANCE hinstance,HWND main);
	int destroy();
	int get_mouse();
	int get_keyboard();
	bool keydown(int key);
	int xaxis();
	int yaxis();
	int zaxis();
	HRESULT error;
private:
	LPDIRECTINPUT8 input;
	LPDIRECTINPUTDEVICE8 keyboard;
	LPDIRECTINPUTDEVICE8 mouse;
	unsigned long input_buff[256];
	int mouse_x,mouse_y,mouse_z,r_button,l_button,m_button;
	HANDLE MouseEvent[2];
	DIMOUSESTATE mouse_state;
};

#endif