/*
Copyright (C) 2003 Hotsprings Inc.
For conditions of distribution and use, see copyright notice

Location: 
	www.HotspringsInc.com 

History:
	2003Aug21-GiuseppeG: code write
*/

#include "XSP_Core.h"
#include "XSP_File.h"
#include "XSP_GUI.h"
#include "XSP_Codecs.h"

extern "C"
{
	#include "zlib.h"
	#include "png.h"
}

namespace XSP
{

// "image/png"

#if 0
#pragma mark class CodecPNG::_Data
#endif

class CodecPNG::_Data
{
public:
	_Data();
	png_struct* pngs;
	png_info*   pngi;
	OffscreenImage image;
	ptr<LockOffscreenImage> lock;
	bool isComplete;
	bool hasAlpha;
}; // class CodecPNG::_Data

CodecPNG::_Data::_Data()
: pngs(0)
, pngi(0)
, isComplete(false)
, hasAlpha(false)
{}

CodecPNG::CodecPNG()
: data(new _Data())
{
	data->pngs = png_create_read_struct_2( PNG_LIBPNG_VER_STRING
					, (png_voidp)this, ErrorCallback, WarningCallback 
					, (png_voidp)this, MallocCallback, FreeCallback );
	VERIFY(data->pngs != 0);

	data->pngi = png_create_info_struct(data->pngs);
	VERIFY(data->pngi != 0);

    png_set_progressive_read_fn( data->pngs
    						   , (png_voidp)this
    						   , InfoCallback
    						   , RowCallback
    						   , EndCallback );

	png_set_read_user_transform_fn (data->pngs
									,ReadTransformCallback);
	// by default 0 = transparent, 255=opaque
	// if you want them the other way around, just call this
    // png_set_invert_alpha(data->pngs);
}

CodecPNG::~CodecPNG()
{
	if (data != 0)
	{
		// make sure the lock is removed
		data->lock = 0;
		
		if (data->pngs != 0)
		{
	        png_destroy_read_struct( &data->pngs, &data->pngi, (png_info**)0);
	        data->pngi = 0;
	        data->pngs = 0;
		}
		data = 0;
	}
}

void CodecPNG::Decode(void* dataBuf, uint32 dataSize)
{
	Codec::owner t(this); // do not allow callbacks to delete this
	try
	{
		VERIFY(data != 0 && data->pngs != 0 && data->pngi != 0);
		png_process_data(data->pngs, data->pngi, (uint8*)dataBuf, dataSize);
		if (data->isComplete)
		{
			data->lock = 0;
			data->image.data->hasAlpha = data->hasAlpha;
			ReportCompleted(data->image);
			return;
		}
		// this is how we show the data is exhausted but it 
		// looks like we need more => report error
		if (dataSize == 0)
		{
			data->lock = 0;
			Exception err(XSPMSG(0,"Failed to decode image using PNG decoder because not enough data was provided"));
			ReportError(err);
			return;
		}
    }
    catch (const Exception& err)
    {
		data->lock = 0;
		ReportError(err);
    	return;
    }
}

void CodecPNG::EndCallback( png_struct* pngs, png_info* pngi)
{   // complete
	CodecPNG* codec = (CodecPNG*) png_get_progressive_ptr(pngs);
	VERIFY((codec->data->pngs == pngs)&&(codec->data->pngi == pngi));
	codec->data->isComplete = true;
}

void CodecPNG::ErrorCallback( png_struct* pngs, const char* msg)
{
	CodecPNG* codec = (CodecPNG*)png_get_error_ptr(pngs);
	#if DEBUG
		UnitTest::Log("CodecPNG error: %s",msg);
	#endif

	codec->data->lock = 0;
	Exception(XSPMSG(0,"Failed to decode image using PNG decoder because $1;"))
		.Param(String::From_c_str(msg))
		.Raise();
}
void CodecPNG::WarningCallback( png_struct* pngs, const char* /*msg*/)
{
	CodecPNG* codec = (CodecPNG*)png_get_error_ptr(pngs);
}
void*CodecPNG::MallocCallback( png_struct* /*pngs*/, std::size_t z)
{
	return new uint8[z];
}
void CodecPNG::FreeCallback( png_struct* /*pngs*/, void* p)
{
	delete (uint8*) p;
}
void CodecPNG::InfoCallback( png_struct* pngs, png_info* pngi)
{
	CodecPNG* codec = (CodecPNG*) png_get_progressive_ptr(pngs);

	png_color_16* imageBackground;
	if (png_get_bKGD(pngs, pngi, &imageBackground))
	{
		png_set_background(pngs, imageBackground, PNG_BACKGROUND_GAMMA_FILE, 1, 1.0);
		png_read_update_info(pngs, pngi);
	}
	// get info about the image from the header
	Size2D imgZ;
	int cbpp, colorType;
    png_get_IHDR( pngs, pngi
		    	, (uint32*)&imgZ.w, (uint32*)&imgZ.h
		    	, &cbpp     // 1, 2, 4, 8, 16
		    	, &colorType
    			, NULL /* &interlace_type */
    			, NULL /* &compression_type */
    			, NULL /* &filter_type */ );
			// PNG_COLOR_TYPE_GRAY, PNG_COLOR_TYPE_GRAY_ALPHA
			// PNG_COLOR_TYPE_PALETTE, PNG_COLOR_MASK_PALETTE
			// PNG_COLOR_TYPE_RGB, PNG_COLOR_TYPE_RGB_ALPHA
			// PNG_COLOR_MASK_COLOR, PNG_COLOR_MASK_ALPHA
	uint32 channels = png_get_channels(pngs, pngi);
	bool hasAlpha = (channels > 3) || (colorType == PNG_COLOR_TYPE_GRAY_ALPHA);

	// each channel must be exactly 8 bits wide 
	if (cbpp == 16) // too many
        png_set_strip_16(pngs);
	else if (cbpp < 8) // too few
	{
		switch(colorType)
		{
			case PNG_COLOR_TYPE_GRAY:
		    case PNG_COLOR_TYPE_GRAY_ALPHA:
    			png_set_gray_1_2_4_to_8(pngs);
    			break;
			case PNG_COLOR_TYPE_PALETTE:
		    	png_set_palette_to_rgb(pngs);
    			break;
		    default:	
		        png_set_packing(pngs);
    			break;
    	}
    }
    // we need to have at least 3 channels for RGB
    if (channels < 3)
    {
		switch(colorType)
		{
			case PNG_COLOR_TYPE_GRAY:
		    case PNG_COLOR_TYPE_GRAY_ALPHA:
		      	png_set_gray_to_rgb(pngs);
		      	break;
			case PNG_COLOR_TYPE_PALETTE:
		    	png_set_palette_to_rgb(pngs);
		      	break;
		}
	}
	// we need to add alpha channel if missing , fill it with opaque if need be
    if (channels < 4)
    {
	    if (png_get_valid(pngs, pngi, PNG_INFO_tRNS)) 
	    {	// convert colorvalue transparency to alpha channel
	    	png_set_tRNS_to_alpha(pngs);
	    	hasAlpha = true;
	    }	
	    else 
	    {   // convert solid color to alpha opaque = 255
		    #if TARGET_API_Win32 || TARGET_API_Win32_Console	
				png_set_filler(pngs, 255, PNG_FILLER_AFTER);     
			#elif TARGET_API_MAC_OS8 || TARGET_API_MAC_Carbon || TARGET_API_MAC_Mach0
				png_set_filler(pngs, 255, PNG_FILLER_BEFORE);
			#elif TARGET_API_Darwin || TARGET_API_Linux
				png_set_filler(pngs, 255, PNG_FILLER_AFTER);
			#else
				#error "Target not defined"
			#endif
		}
    }

    // byte order specific to each OS =================================
	#if TARGET_API_Win32 || TARGET_API_Win32_Console	
		png_set_bgr(pngs);
	#elif TARGET_API_MAC_OS8 || TARGET_API_MAC_Carbon || TARGET_API_MAC_Mach0
		png_set_swap_alpha(pngs);
	#elif TARGET_API_Darwin || TARGET_API_Linux
		png_set_bgr(pngs);
	#else
		#error "Target not defined"
	#endif
	
	// gamma correction ===============================================
	double gamma;
   	if (!png_get_gAMA(pngs, pngi, &gamma))
   		gamma = 0.45455;
	 #if TARGET_API_Win32 || TARGET_API_Win32_Console	
	   	double gammaScreen = 2.1; //PC
	 #elif TARGET_API_MAC_OS8 || TARGET_API_MAC_Carbon || TARGET_API_MAC_Mach0
	   	double gammaScreen = 2.1; // 1.7; //MAC
	 #elif TARGET_API_Darwin || TARGET_API_Linux
	   	double gammaScreen = 2.1; //PC
	 #else
		#error "Target not defined"
	 #endif
   	png_set_gamma(pngs, gammaScreen, gamma);	 
   	
	// set progressive decoding
    //int numberPasses = png_set_interlace_handling(pngs);
   	
	// update all the settings and reload info with the updated calculations
	png_read_update_info(pngs, pngi);
    			
    png_get_IHDR( pngs, pngi
		    	, (uint32*)&imgZ.w, (uint32*)&imgZ.h
		    	, &cbpp     // 1, 2, 4, 8, 16
		    	, &colorType
    			, NULL /* &interlace_type */
    			, NULL /* &compression_type */
    			, NULL /* &filter_type */ );
    			
	// get the number of bytes in one row of image
	uint32 rowBytes = png_get_rowbytes(pngs, pngi);

	// 1 GRAY,PALETTE    2 GRAY_ALPHA    3 RGB    4 RGB_ALPHA,RGB+filler
	channels = png_get_channels(pngs, pngi);
	VERIFY(channels == 4);

	// create the image (should have an alpha channel)
	codec->data->image = OffscreenImage(imgZ.w, imgZ.h, OffscreenImage::RGBA32);
//		hasAlpha ? OffscreenImage::RGBA32 : OffscreenImage::RGB24);
    codec->data->lock = new LockOffscreenImage(codec->data->image);
	//start filling the image
	png_start_read_image(pngs);
}

void CodecPNG::RowCallback( png_struct* pngs, 
				 uint8* rowBytes, uint32 rowN,
				 int /*pass*/ )
{
	CodecPNG* codec = (CodecPNG*) png_get_progressive_ptr(pngs);
    // When the row is not changed, the new_row variable will be NULL.
	
	LockOffscreenImage& lock = *codec->data->lock;
	uint8* imgRow = lock.memory + lock.rowBytes*rowN;

    // fill the row into the image memory 
	png_progressive_combine_row(pngs, imgRow, rowBytes);
}

void CodecPNG::ReadTransformCallback( png_struct* pngs
				,png_row_info* rowInfo
				,uint8* rowData)
{
	if (0 == (rowInfo->color_type & PNG_COLOR_TYPE_RGB_ALPHA))
		return;
	if ( rowInfo->bit_depth != 8 )
		return;
	if ( rowInfo->channels != 4 )
		return;

	CodecPNG* codec = (CodecPNG*) png_get_progressive_ptr(pngs);

	// normalize pixels = premultiply with the alpha channel	
	ColorRGB clr; 
	uint32* rowB = (uint32*)rowData;
	uint32* rowE = rowB + rowInfo->width;
	bool hasAlpha = false;
	for(; rowB<rowE; ++rowB)
	{
		hasAlpha |= clr.From_uint32(*rowB); // blend with white or black or how the heck they call it
		*rowB = clr.rgba; // store back into the row
	}
	if (hasAlpha)
		codec->data->hasAlpha = true;
}

} // namespace XSP


