

#include "Project.h"













class X11_Server

{

public:

	        //host:display_server_no.screen  => turns into    host:(X_port+displayNo)

    Display*	mDisplay;

    X11_Server(char* displayname);



    ~X11_Server();



    // the values of this atoms are server specific

    Atom	mWM_DELETE_WINDOW;

    Atom	mWM_PROTOCOLS;

	void	CreateICCM_Atoms()

	{

		mWM_DELETE_WINDOW = ::XInternAtom(mDisplay,"WM_DELETE_WINDOW",False);

		mWM_PROTOCOLS     = ::XInternAtom(mDisplay,"WM_PROTOCOLS",False);

	}



	long mAllEventMask;

	void CreateAllEventMask()

	{

    	mAllEventMask = KeyPressMask | KeyReleaseMask			

					| ButtonPressMask |	ButtonReleaseMask | EnterWindowMask | LeaveWindowMask			

//					| PointerMotionMask 

//					| Button1MotionMask | Button2MotionMask | Button3MotionMask 

//					| Button4MotionMask	| Button5MotionMask 

					| ButtonMotionMask		

					| KeymapStateMask			

					| ExposureMask | VisibilityChangeMask | StructureNotifyMask 

//					| ResizeRedirectMask	// this will make the window not resize properly	

					| SubstructureNotifyMask | SubstructureRedirectMask | FocusChangeMask			

					| PropertyChangeMask | ColormapChangeMask | OwnerGrabButtonMask;		

	}





	int 	GetConnectionHandle()

	{

		return ::XConnectionNumber(mDisplay);

	}

	long 	GetConnectionBlockSize()

	{

		return ::XMaxRequestSize(mDisplay);

	}



	int 	GetEventQueueSize()

	{

		return ::XQLength(mDisplay);

	}



    int		mScreen;

	void 	LoadDefaultScreen()

	{

		mScreen = DefaultScreen(mDisplay);

	}



	int mScreenCount;

	void 	LoadScreenCount()

	{

		mScreenCount = ScreenCount(mDisplay);

//		mScreenCount = ::XScreenCount(mDisplay);

	}





	Screen*	mScreenRef;

	void	LoadScreenRef()

	{

		mScreenRef = DefaultScreenOfDisplay(mDisplay);

//		mScreenRef = ::XDefaultScreenOfDisplay(mDisplay);



		mScreenRef = ScreenOfDisplay(mDisplay,mScreen);

//		mScreenRef = ::XScreenOfDisplay(mDisplay,mScreen);

	}



    Window	mRootWindow;

	void 	LoadRootWindow()

	{

	    mRootWindow = DefaultRootWindow(mDisplay);

//	    mRootWindow = ::XDefaultRootWindow(mDisplay);

	}

	void 	LoadRootWindowOfScreen()

	{

	    mRootWindow = RootWindow(mDisplay, mScreen);

//	    mRootWindow = ::XRootWindow(mDisplay, mScreen);

	}



	Visual*		mVisual;

	void	LoadDefaultVisual()

	{

		mVisual = DefaultVisual(mDisplay, mScreen);

//		mVisual = ::XDefaultVisual(mDisplay, mScreen);

	}





	unsigned long	mColorPlanesMask;

	void	LoadColorPlanesMask()

	{

		mColorPlanesMask = ::XAllPlanes();

	}



	unsigned long mBlackColor;

	unsigned long mWhiteColor;

	void 	LoadMonochromePixelColors()

	{

		mBlackColor = BlackPixel(mDisplay,mScreen);

		mWhiteColor = WhitePixel(mDisplay,mScreen);

	}



    int		mScreenDX, mScreenDY;

    int		mScreenBPP;

	void 	LoadScreenSizes()

	{

		mScreenDX = DisplayWidth(mDisplay, mScreen);

		mScreenDY = DisplayHeight(mDisplay, mScreen);

		mScreenBPP = DefaultDepth(mDisplay, mScreen);

//		mScreenBPP = DisplayPlanes(mDisplay, mScreen);

	}

	void 	LoadCurrentScreenSizes() //? are these different

	{

		mScreenDX = ::XDisplayWidth(mDisplay, mScreen);

		mScreenDY = ::XDisplayHeight(mDisplay, mScreen);

		mScreenBPP = ::XDefaultDepth(mDisplay, mScreen);

//		mScreenBPP = ::XDisplayPlanes(mDisplay, mScreen);

	}



	class ScreenSizes

	{

	public:

		int*	mDepths;

		int		mDepthsCount;

		ScreenSizes()

		: mDepths(0)

		{}

		~ScreenSizes()

		{

			if (mDepths != 0)

			{

				::XFree(mDepths);

				mDepths = 0;

				mDepthsCount = 0;

			}

		}

	};

	ScreenSizes mScreenSizes;

	void 	LoadAllAvailableScreenSizes()

	{

		mScreenSizes.mDepths = ::XListDepths(mDisplay, mScreen, &mScreenSizes.mDepthsCount);

	}





	Colormap	mColorMapID;

	int			mColorMapSize;

	void	LoadColorMap()

	{

		mColorMapID = DefaultColormap(mDisplay, mScreen);

		mColorMapSize = DisplayCells(mDisplay, mScreen);

//		mColorMapSize = ::XDisplayCells(mDisplay, mScreen);

	}



	GC		mGraphics;

	void LoadGraphics()

	{

		// this DC should not be freed

		mGraphics = DefaultGC(mDisplay, mScreen);

		//mGraphics = ::XDefaultGC(mDisplay, mScreen);

	}

};





X11_Server::X11_Server(char* displayname)

{

    mDisplay = ::XOpenDisplay(displayname);

    if (mDisplay == 0)

    {

		printf("Cannot open display %s\n", displayname);

		throw 0;

    }

	displayname = DisplayString(mDisplay);

//	displayname = ::XDisplayString(mDisplay);

	printf("Display %s opened\n", displayname);



	CreateAllEventMask();



	CreateICCM_Atoms();

	LoadDefaultScreen();

	LoadRootWindow();



	LoadScreenSizes();

	LoadCurrentScreenSizes();

	printf("Resolution %dx%dx%d\n", mScreenDX, mScreenDY, mScreenBPP);



	LoadColorPlanesMask();

	LoadMonochromePixelColors();



	LoadAllAvailableScreenSizes();

}



X11_Server::~X11_Server()

{

    ::XCloseDisplay(mDisplay);

}















class X11_Window

{

public:

		X11_Window(X11_Server& server);

		~X11_Window();



    X11_Server&	mServer;

    Window	mWindow;

    XSP::uint32 mWidth, mHeight;

};



X11_Window::X11_Window(X11_Server& server)

: mServer(server)

{

    XSetWindowAttributes attributes;

    unsigned long 	 attrmask = 0;



    attributes.event_mask = mServer.mAllEventMask;

    attrmask |= CWEventMask;



    attributes.border_pixel = BlackPixel(mServer.mDisplay, mServer.mScreen);

    attrmask |= CWBorderPixel;



//  flicker free operation requires bg paint during expose

//    attributes.background_pixel = WhitePixel(mServer.mDisplay, mServer.mScreen);

//    attrmask |= CWBackPixel;



//    attributes.override_redirect = True;

//    attrmask |= CWOverrideRedirect;



    mWindow = ::XCreateWindow(

		      mServer.mDisplay	  // connection

		    , mServer.mRootWindow // parent window

		    , 0, 0, mWidth=320, mHeight=280

		    , 4 //border width

		    , CopyFromParent // depth BPP

		    , InputOutput    // window class

		    , CopyFromParent // visual

		    , attrmask, &attributes

		    );

    if (mWindow == 0)

    {

		printf("Cannot create new window\n");

		throw 1;

    }

    printf("Window was created\n");

    

	::XSelectInput(mServer.mDisplay, mWindow, mServer.mAllEventMask); // all events

	printf("Window events unmasked\n");

    

    //if (true)

    { // set the window title

        char* strings[] = {"Title of Hello World"};

		XTextProperty textProperty;

		if (0 != ::XStringListToTextProperty(strings

					    ,sizeof(strings)/sizeof(*strings)

					    ,&textProperty))

    	    ::XSetWMName(mServer.mDisplay, mWindow, &textProperty);

	    printf("A title was added to the window\n");

    }





    // we'll delete the window, not the manager

    ::XChangeProperty( mServer.mDisplay

		     , mWindow

		     , mServer.mWM_PROTOCOLS, XA_ATOM

		     , 32

		     , PropModeAppend

		     , (unsigned char*) &mServer.mWM_DELETE_WINDOW

		     , 1 );



    // ::XMapWindow(mServer.mDisplay, mWindow);

    ::XMapRaised(mServer.mDisplay, mWindow);

    ::XFlush(mServer.mDisplay);

    printf("The window was mapped\n");

}



X11_Window::~X11_Window()

{

    printf("Window destructor\n");

    ::XUnmapWindow(mServer.mDisplay, mWindow);

    ::XDestroyWindow(mServer.mDisplay, mWindow);

    ::XFlush(mServer.mDisplay);

}





class X11_Graphics

{



};



void MainEventLoop()

{

    X11_Server server(":0.0");

    X11_Window window(server);

    

    GC gc = 0;

    {   // create a graphic context

	    XSP::uint32 mask = 0;

	    XGCValues values;



/*	    Colormap cmap = DefaultColormap(server.mDisplay, DefaultScreen(server.mDisplay));

	    XColor bestaprox;

	    

	    bestaprox.red  = 0x0000;

	    bestaprox.green= 0x7F00;

	    bestaprox.blue = 0x0000;

	    ::XAllocColor(server.mDisplay, cmap, &bestaprox);

	    values.foreground = bestaprox.pixel; 

	    mask |= GCForeground;

	    

	    bestaprox.red  = 0x0000;

	    bestaprox.green= 0x0000;

	    bestaprox.blue = 0xCF00;

	    ::XAllocColor(server.mDisplay, cmap, &bestaprox);

	    values.background = bestaprox.pixel; 

	    mask |= GCBackground;

*/	    

	    gc = ::XCreateGC(server.mDisplay, window.mWindow, mask, &values);

    }

    

    for(bool quit=false; !quit; )

    {

		XEvent event;

		if (False == ::XCheckMaskEvent(server.mDisplay, server.mAllEventMask, &event))

		{

			// no events in the queue do something else

			::XNextEvent(server.mDisplay, &event);

		}



		switch (event.type)

		{

		case KeyPress://2

		    printf("Event (2) KeyPress\n");

		    break;

		case KeyRelease://3

		    printf("Event (3) KeyRelease\n");

		    break;

		case ButtonPress://4

		    printf("Event (4) ButtonPress\n");

		    break;

		case ButtonRelease://5

		    printf("Event (5) ButtonRelease\n");

		    break;

		case MotionNotify://6

		    printf("Event (6) MotionNotify\n");

		    break;

		case EnterNotify://7

		    printf("Event (7) EnterNotify\n");

		    break;

		case LeaveNotify://8

		    printf("Event (8) LeaveNotify\n");

		    break;

		case FocusIn://9

		    printf("Event (9) FocusIn\n");

		    break;

		case FocusOut://10

		    printf("Event (10) FocusOut\n");

		    break;

		case KeymapNotify://11

		    printf("Event (11) KeymapNotify\n");

		    break;

		case Expose://12

		    printf("Event (12) Expose %d\n", event.xexpose.count);

	    	//::XClearWindow(server.mDisplay, event.xexpose.window);

	    	//::XClearArea(event.xexpose.display, event.xexpose.window,

	    	//				event.xexpose.x,event.xexpose.y,

	    	//				event.xexpose.width,event.xexpose.height, 

	    	//				False);

	    	::XSetForeground(event.xexpose.display, gc, 0xD0D0DF);

			::XFillRectangle(event.xexpose.display, event.xexpose.window, gc, 

	    					event.xexpose.x,event.xexpose.y,

	    					event.xexpose.width,event.xexpose.height);

		    if (event.xexpose.count == 0)

		    {

		    	::XSetForeground(event.xexpose.display, gc, 0x301F00);

		    	::XDrawString(server.mDisplay, event.xexpose.window, gc, 

		    				32,64, "Hello World!", 12);

		    	::XFlush(server.mDisplay);

		    }

		    break;

		case GraphicsExpose://13

		    printf("Event (13) GraphicsExpose\n");

		    break;

		case NoExpose://14

		    printf("Event (14) NoExpose\n");

		    break;

		case VisibilityNotify://15

		    printf("Event (15) VisibilityNotify\n");

		    break;

		case CreateNotify://16

		    printf("Event (16) CreateNotify\n");

		    break;

		case DestroyNotify://17

		    printf("Event (17) DestroyNotify\n");

		    break;

		case UnmapNotify://18

		    printf("Event (18) UnmapNotify\n");

		    break;

		case MapNotify://19

		    printf("Event (19) MapNotify\n");

		    break;

		case MapRequest://20

		    printf("Event (20) MapRequest\n");

		    break;

		case ReparentNotify://21

		    printf("Event (21) ReparentNotify\n");

		    break;

		case ConfigureNotify://22

		    printf("Event (22) ConfigureNotify %dx%d\n", 

		    		event.xconfigure.width, event.xconfigure.height);

		    break;

		case ConfigureRequest://23

		    printf("Event (23) ConfigureRequest\n");

		    break;

		case GravityNotify://24

		    printf("Event (24) GravityNotify\n");

		    break;

		case ResizeRequest://25

		    // window manager and frameless windows use this somehow ... 

		    // will not send expose events any more !!!

		    printf("Event (25) ResizeRequest %ldx%ld\n", 

		    		event.xresizerequest.width, event.xresizerequest.height);

		    break;

		case CirculateNotify://26

		    printf("Event (26) CirculateNotify\n");

		    break;

		case CirculateRequest://27

		    printf("Event (27) CirculateRequest\n");

		    break;

		case PropertyNotify://28

		    printf("Event (28) PropertyNotify\n");

		    break;

		case SelectionClear://29

		    printf("Event (29) SelectionClear\n");

		    break;

		case SelectionRequest://30

		    printf("Event (30) SelectionRequest\n");

		    break;

		case SelectionNotify://31

		    printf("Event (31) SelectionNotify\n");

		    break;

		case ColormapNotify	://32

		    printf("Event (32) ColormapNotify\n");

		    break;

		case ClientMessage://33

		    printf("Event (33) ClientMessage\n");

		    if (event.xclient.message_type == server.mWM_PROTOCOLS)

		    {

				if (event.xclient.data.l[0] == (long)server.mWM_DELETE_WINDOW)

				    if (event.xclient.window == window.mWindow)

						quit = true;

			}

		    break;

		case MappingNotify://34

		    printf("Event (34) MappingNotify\n");

		    break;

		default:    

		    printf("Event (%d) ?? unknown\n", event.type);

		    break;

		}

    }   // for

    

    ::XFreeGC(server.mDisplay, gc);

}



int main()

{

    printf("Entering event loop\n");

    try

    {

	MainEventLoop();

    }

    catch (...)

    {

        printf("Exception caught\n");

    }

    printf("Exited event loop\n");



    return 0;

}


