/*
Copyright (C) 2003 Hotsprings Inc.
For conditions of distribution and use, see copyright notice

Location: 
	www.HotspringsInc.com 

History:
	2003Aug27-GiuseppeG: code write
*/

namespace XSP
{
#if TARGET_API_Win32 || TARGET_API_Win32_Console
#elif TARGET_API_MAC_OS8 || TARGET_API_MAC_Carbon || TARGET_API_MAC_Mach0
#elif TARGET_API_Darwin || TARGET_API_Linux
#endif

class Point2D;
class Size2D;
class Rect2D;

#if 0
#pragma mark Point2D
#endif

class Point2D
{
public:
	sint32  x,y;
public:
	Point2D() : x(0), y(0) { }
	Point2D(sint32 u, sint32 v) : x(u), y(v) { }
	Point2D(const Point2D& p) : x(p.x), y(p.y) { }
	Point2D& operator= (const Point2D& p) { x=p.x; y=p.y; return *this; }

	bool operator == (const Point2D& p) const { return (x==p.x) && (y==p.y); }
	bool operator != (const Point2D& p) const { return (x!=p.x) || (y!=p.y); }
	
	Point2D  operator- () const;	
	// distance
	Size2D   operator- (const Point2D& p) const;	
	Point2D  operator- (const Size2D& p) const;	
	Point2D  operator+ (const Size2D& p) const;	
	Point2D& operator-= (const Size2D& p);	
	Point2D& operator+= (const Size2D& p);	
	// relative offset
	Point2D  operator+ (const Point2D& p) const;	
	Point2D& operator+= (const Point2D& p);	
}; // class Point2D

#if 0
#pragma mark Size2D
#endif

class Size2D
{
public:
	sint32  w,h;
public:
	Size2D() : w(0), h(0) { }
	Size2D(sint32 u, sint32 v) : w(u), h(v) { }
	Size2D(const Size2D& p) : w(p.w), h(p.h) { }
	Size2D& operator= (const Size2D& p) { w=p.w; h=p.h; return *this; }
	
	bool operator == (const Size2D& p) const { return (w==p.w) && (h==p.h); }
	bool operator != (const Size2D& p) const { return (w!=p.w) || (h!=p.h); }

	Size2D  operator- (const Size2D& p) const;	
	Size2D  operator+ (const Size2D& p) const;	
	Size2D& operator-= (const Size2D& p);	
	Size2D& operator+= (const Size2D& p);	

	void Normalize(); 
}; // class Size2D

#if 0
#pragma mark Rect2D
#endif

class Rect2D
{
public:
	sint32  x,y,w,h;
public:
	Rect2D() : x(0), y(0), w(0), h(0) { }
	explicit Rect2D(const Size2D& s) : x(0), y(0), w(s.w), h(s.h) { }
	Rect2D(const Point2D& p, const Size2D& s) : x(p.x), y(p.y), w(s.w), h(s.h) { }
	Rect2D(const Point2D& nw, const Point2D& se);
	Rect2D(const Rect2D& p) : x(p.x), y(p.y), w(p.w), h(p.h) { }
	Rect2D& operator= (const Rect2D& p) { x=p.x; y=p.y; w=p.w; h=p.h; return *this; }
	
	bool operator == (const Rect2D& p) const;
	bool operator != (const Rect2D& p) const;

	bool isEmpty() const { return (w==0) || (h==0); }
	bool Contains(const Point2D& p) const;
	bool Intersects(const Rect2D& p) const;  
	void ClipTo(const Rect2D& p);

	Rect2D Intersect(const Rect2D& p) const;  
	Rect2D Union(const Rect2D& p) const;  
	
    sint32 GetWest() const { return x; }
    sint32 GetEast() const { return x+w; }
    sint32 GetNorth() const { return y; }
    sint32 GetSouth() const { return y+h; }
    sint32 GetWidth() const { return w; }
    sint32 GetHeight() const { return h; }
    
    Point2D GetNW() const { return Point2D(x,y); }
    Point2D GetNE() const { return Point2D(x+w,y); }
    Point2D GetSW() const { return Point2D(x,y+h); }
    Point2D GetSE() const { return Point2D(x+w,y+h); }
    void AnchorNW_At(const Point2D& p) { x=p.x, y=p.y; }
    void AnchorNE_At(const Point2D& p) { x=p.x-w, y=p.y; }
    void AnchorSW_At(const Point2D& p) { x=p.x, y=p.y-h; }
    void AnchorSE_At(const Point2D& p) { x=p.x-w, y=p.y-h; }
    Size2D GetSize() const { return Size2D(w,h); }
    void SetSize(const Size2D& p) { w = p.w, h=p.h; }
    
	void Normalize(); 
    Point2D GetCenter() const; 

	enum Alignment { C, N, NE, E, SE, S, SW, W, NW };
	// align the input rect inside this rect according to the (a) parameter
	// if the input rect is larger than this rect we use the (o) parameter
	Rect2D Align(const Rect2D& r, Alignment a, Alignment o= NW) const;
    // move the edge or corner by that amount
    void OffsetBy(sint32 u, sint32 v) { x+=u; y+=v; }
	void OffsetBy(sint32 u, sint32 v, Alignment a);
	void EnlargeBy(sint32 u, sint32 v, Alignment a);
	void ShrinkBy(sint32 u, sint32 v, Alignment a) { EnlargeBy(-u,-v,a); }
	// returns the rectangle according to the alignment
	void RemoveBorder(const Rect2D& border, Alignment a = C);
	// Scale the rectangle by the ratio factor/divider, offset accordingly.
	// Used to compute where the change in an image is going to show if the
	// image is stretched.
	// So we've got 4 players : 
	//		this == the rectangle representing the change
	//		factor == the rectangle representing the destination
	//		divider == the rectangle representing the full image
	//		returned rect == where in the destination the change will be drawn
	Rect2D Scale(const Rect2D& factor, const Rect2D& divider) const;

public:
	#if TARGET_API_Win32 || TARGET_API_Win32_Console
		void ConvertToRect(RECT& r) const
		{
			r.bottom = h + (r.top = y); 
			r.right = w + (r.left = x); 
		}
		void ConvertFromRect(const RECT& r) 
		{
			h = r.bottom - (y = r.top); 
			w = r.right - (x = r.left); 
		}
		Rect2D(const RECT& r) 
		{ 
			ConvertFromRect(r);  
		}
	#elif TARGET_API_MAC_OS8 || TARGET_API_MAC_Carbon || TARGET_API_MAC_Mach0
		void ConvertToRect(Rect& r) const
		{
			r.bottom = h + (r.top = y); 
			r.right = w + (r.left = x); 
		}
		void ConvertFromRect(const Rect& r) 
		{
			h = r.bottom - (y = r.top); 
			w = r.right - (x = r.left); 
		}
		Rect2D(const Rect& r) 
		{ 
			ConvertFromRect(r);  
		}
	#elif TARGET_API_Darwin || TARGET_API_Linux

	#endif

}; // class Rect2D

#if 0
#pragma mark ColorRGB
#endif

class ColorRGB
{
public:
	uint32 rgba; // platform specific endian ordering 
public:
    ColorRGB() : rgba(0) {}
    ColorRGB(const ColorRGB& c) : rgba(c.rgba) {}
    ColorRGB& operator=(const ColorRGB& c) { rgba = c.rgba; return *this; }

    bool operator == (const ColorRGB& c) { return rgba == c.rgba; }
    bool operator != (const ColorRGB& c) { return rgba != c.rgba; }

	void Blend(const ColorRGB& a, const ColorRGB& b);
	bool From_uint32(uint32 n); // premultiply, return true if alpha  
public:
	// alpha 255 = opaque
	//       0 = perfectly transparent
	// precondition   0 <= (r,g,b) <= alpha 
    ColorRGB(uint8 r, uint8 g, uint8 b);
    ColorRGB(uint8 r, uint8 g, uint8 b, uint8 a);
    uint8 Red() const;
    uint8 Green() const;
    uint8 Blue() const;
    uint8 Alpha() const;
#if TARGET_API_Win32 || TARGET_API_Win32_Console
    void FromCOLORREF(COLORREF c);
    const COLORREF ToCOLORREF() const;
#elif TARGET_API_MAC_OS8 || TARGET_API_MAC_Carbon || TARGET_API_MAC_Mach0
    inline const RGBColor* ToRGBColor() const { return (RGBColor*)(1+(uint8*)&rgba); }
#elif TARGET_API_Darwin || TARGET_API_Linux
#endif

}; // class ColorRGB

#if 0
#pragma mark OffscreenImage
#endif

class OffscreenImage
{
public:
	class _Data;
	refc<_Data> data;
public:
	OffscreenImage();
	~OffscreenImage();
	OffscreenImage(const OffscreenImage& i);
	OffscreenImage& operator = (const OffscreenImage& i);
	OffscreenImage& operator = (_Data* i);

    bool operator == (const OffscreenImage& i) const;
    bool operator != (const OffscreenImage& i) const;
    bool operator == (const _Data* i) const;
    bool operator != (const _Data* i) const;

	enum PixelStyle { RGB24, RGBA32, TrueColor565, TrueColor555 , Index8 };

    OffscreenImage(sint32 u, sint32 v, PixelStyle style);
    Size2D GetSize() const;
    bool HasAlpha() const;  // true if the image contains at least one non opaque pixel
}; // class OffscreenImage

#if 0
#pragma mark OffscreenImage::_Data
#endif

#if TARGET_API_Win32 || TARGET_API_Win32_Console
	class OffscreenImage::_Data
	{
	private:
		uint32 refcount;
	public:
//		BITMAPINFOHEADER info;
		HBITMAP handle;
		PixelStyle style;
		Size2D z;
		HDC dc; // available while a graphics is open to this image
		bool hasAlpha;
	public:
		_Data();
		~_Data();
		void addref() { ++refcount; }
		void release() { if (--refcount == 0) delete this; }
	}; // class ImageBuffer::Data
#elif TARGET_API_MAC_OS8 || TARGET_API_MAC_Carbon || TARGET_API_MAC_Mach0
	class OffscreenImage::_Data
	{
	private:
		uint32 refcount;
	public:
		PixelStyle style;
		CGrafPtr gWorld;
	public:
		_Data();
		~_Data();
		void addref() { ++refcount; }
		void release() { if (--refcount == 0) delete this; }
	}; // class ImageBuffer::Data
#elif TARGET_API_Darwin || TARGET_API_Linux
	class OffscreenImage::_Data
	{
	private:
		uint32 refcount;
	public:
		_Data();
		~_Data();
		void addref() { ++refcount; }
		void release() { if (--refcount == 0) delete this; }
	}; // class ImageBuffer::Data
#endif

#if 0
#pragma mark Graphics
#endif

class TextFont;

#if TARGET_API_Win32 || TARGET_API_Win32_Console
	
	class Graphics
	{
		PAINTSTRUCT ps;
//		HBITMAP		oldHandle;
		HWND		hwnd;
		int		    mode;
		int         savedDC;
		Point2D		origin;		
	public:
	    Graphics();			// compatible with screen DC
	    Graphics(HDC dc);   // external DC, will not be released
	    Graphics(HWND wnd); // window DC 
	    Graphics(HWND wnd, PAINTSTRUCT*); // during paint
		Graphics(const OffscreenImage& img); // compatible DC to offscreen image
		~Graphics();
	public:	
		bool IsOffScreen() const;
		 
		Rect2D GetClipRect() const;
		void SetClipRect(const Rect2D& r);
		const Point2D& GetOrigin() const;
		void SetOrigin(const Point2D& p);

		void SetFont(const TextFont& f);
		void DrawImage(const OffscreenImage& img, const Rect2D& src, const Rect2D& dst);
		void FillRect(const ColorRGB& c, const Rect2D& dst);
		void DrawLine(const ColorRGB& colr, const Point2D& a, const Point2D& b, uint32 thick=1);
		void DrawText(const String& s, const ColorRGB& c, const TextFont& f, const Point2D& p);
	    uint32 MeasureTextWidth(const String& s, const TextFont& f) const;
		uint32 MeasureTextWidth(const char* b, const char* e, const TextFont& f) const;
		void MeasureEachCharWidth(const char* b, const char* e, const TextFont& f
								 ,std::vector<uint32> & results ) const;

	public: // win32 specific
		OffscreenImage origimg; // if created with an image
		HDC GetDC() const { return ps.hdc; }
		void _GetOrigin();
	}; // class Graphics

#elif TARGET_API_MAC_OS8 || TARGET_API_MAC_Carbon || TARGET_API_MAC_Mach0

	class Graphics
	{
	private:
		CGrafPtr gWorld;   
		GDHandle gDevice;  // for offscreen images it is 0

		CGrafPtr savedGWorld;
		GDHandle savedGDevice;
	public:
		Graphics();    // to whatever graphics port is currently available 
		Graphics(const OffscreenImage& img); // offscreen buffer
		Graphics(CGrafPtr gw, GDHandle dv); 
		~Graphics();
		
		bool IsOffScreen() const;
		void SetFont(const TextFont& f);
		void DrawImage(const OffscreenImage& img, const Rect2D& src, const Rect2D& dst);
		void FillRect(const ColorRGB& c, const Rect2D& dst);
		void DrawLine(const ColorRGB& colr, const Point2D& a, const Point2D& b, uint32 thick=1);
		void DrawText(const String& s, const ColorRGB& c, const TextFont& f, const Point2D& p);
	    uint32 MeasureTextWidth(const String& s, const TextFont& f) const;
	private: // do not allow copying of this object
		Graphics(const Graphics& g); 
		Graphics& operator= (const Graphics& g);
	public:
		CGrafPtr GetGWorld() { return gWorld; }
	}; // class Graphics

#elif TARGET_API_Darwin || TARGET_API_Linux

	class Graphics
	{
	};

#endif

#if 0
#pragma mark LockOffscreenImage
#endif

class LockOffscreenImage
{
public:
	uint8* memory;	 // base memory addr
	uint32 rowBytes; // jump to next row
	uint32 bpp;		 // bits per pixel
	Rect2D bounds;
	
public:
	LockOffscreenImage(const OffscreenImage& img);
	LockOffscreenImage(Graphics& g);
	~LockOffscreenImage();

private:
#if TARGET_API_Win32 || TARGET_API_Win32_Console
	void Init(HANDLE handle);
#elif TARGET_API_MAC_OS8 || TARGET_API_MAC_Carbon || TARGET_API_MAC_Mach0
	PixMapHandle phandle;
	void Init(CGrafPtr gWorld);
#elif TARGET_API_Darwin || TARGET_API_Linux
	// ToDo
#endif

public:
	static void _DrawImage(const LockOffscreenImage& dsti
						  ,const LockOffscreenImage& srci
						  ,const Rect2D& dst
						  ,const Rect2D& src);
	void Fill(ColorRGB clr, Rect2D dst);
}; // class LockOffscreenImage

} // namespace XSP
