/*
Copyright (C) 2003 Hotsprings Inc.
For conditions of distribution and use, see copyright notice

Location: 
	www.HotspringsInc.com 

History:
	2003Aug27-GiuseppeG: code write
*/

namespace XSP
{

#if 0
#pragma mark ScrollView
#endif

class ScrollView : public View
{
	class ScrollListener;
	friend class ScrollListener;
	ViewListener::owner scrollListener; // helps this view react to scroll events
	Rect2D scrollBounds;  // cached value, so we don't have to measure again and again
public:
	ScrollView();
	virtual void SetBounds(const Rect2D& bounds);
	virtual void AddView(const owner& view);
	virtual void RemoveView(const owner& view);
	virtual bool HandleMouseEvent( const UIEvent& ev ); 
	// scroll between 0 and scrollSize
	void ScrollTo(sint32 x, sint32 y);
	Size2D GetScrollSize() const { return scrollBounds.GetSize(); }
	Rect2D GetScrollBounds() const { return scrollBounds; }
	// scroll so this rect becomes visible
	void MakeVisible(const Rect2D& vBounds);
    // attach a view to synch scroll with
    // remember to do the similar call on that view to close the feedback
	void ListenToScrollNotificationsFrom(const View::owner& view);
	void CancelListenToScrollNotifications();
protected:
	~ScrollView();
	bool ComputeScrollRect(); // the origin is at -
}; // ScrollView

#if 0
#pragma mark ScrollBar
#endif

class ScrollBar : public View
{
	class ScrollListener;
	friend class ScrollListener;
	ViewListener::owner scrollListener; // helps this view react to scroll events
	bool vertical;
	sint32 pos;
	sint32 pageZ;
	sint32 totalZ;
/*	enum ScrollBarSkinState
	{
		_PartShift= ButtonView::ButtonMask+1
		// keep 0 unused for normal buttons
	,	PartB1	  = 1 * _PartShift
	,	PartS1	  = 2 * _PartShift
	,	PartThumb = 3 * _PartShift
	,	PartS2	  = 4 * _PartShift
	,	PartB2	  = 5 * _PartShift
	
	,	PartMask  = 7 * _PartShift
	,	FullMask  = PartMask | (PartMask-1)
	};*/
	// the components
	ButtonView* cb1; 
	ButtonView* cs1; 
	ButtonView* cth;
	ButtonView* cs2;
	ButtonView* cb2;
	
public:
	ScrollBar(bool vertical);
	virtual void SetBounds(const Rect2D& bounds);
	virtual void SetSkin(const ViewSkin::owner& skin);
	bool ScrollTo(sint32 x, sint32 pagew, sint32 totalw);
    // attach a view to synch scroll with
    // remember to do the similar call on that view to close the feedback
	void ListenToScrollNotificationsFrom(const View::owner& view);
	void CancelListenToScrollNotifications();
protected:
	~ScrollBar();
	void PositionComponents();
	bool NotifyScroll();
	bool NotifyStep(sint32 amount);
	void ThumbWasDragged();
public:
	void ComponentAction(ButtonView* component);
}; // ScrollBar

#if 0
#pragma mark ScrollPage
#endif

// a page made of some content and 2 scrollbars 
// the whole stuff acts as one compound virtual view
class ScrollPage : public View
{
	View* content;
	ScrollBar* ver;
	ScrollBar* hor;
public:
	ScrollPage();
	void SetContent(const View::owner& view);
	void SetScrollView(const refc<ScrollView>& sview);
	virtual void SetBounds(const Rect2D& bounds);
	virtual void SetSkin(const ViewSkin::owner& skin);
	virtual void SetFont(const TextFont& f);
protected:
	~ScrollPage();
	void PositionComponents();
}; // ScrollPage

} // namespace XSP
