/*
Copyright (C) 2003 Hotsprings Inc.
For conditions of distribution and use, see copyright notice

Location: 
	www.HotspringsInc.com 

History:
	2003Aug27-GiuseppeG: code write
*/

namespace XSP
{

class TabBar : public View
{
	typedef std::list< refc<ButtonView> > Tabs;
	Tabs tabs; 
//	ViewSkin::owner tabSkin; // may be null
    TextFont tabFont;
    ButtonView::ActionListener::owner tabListener;
protected:
	virtual ~TabBar();
public:
	void AddTab(const String& title);
	void RemoveTab(const String& title);
	void GoToTab(const String& title);
	const String& GetCurrentTab();

	virtual void SetBounds(const Rect2D& bounds);  
    // allows you to set the skin for the individual tabs
	virtual void SetSkin(const ViewSkin::owner& skin);
	virtual void SetFont(const TextFont& f);
//	virtual void SetTabFont(const TextFont& font);
	virtual Size2D GetPreferredSize();

	void DoLayout();
private:
	class _TabSelection
	{
	public:
		virtual void TabSelected(const String& title)=0;
	}; // class _TabSelection
public:
	typedef ListenerOf<_TabSelection> TabListener;
	typedef TabListener::Container TabListeners;
private:
	TabListeners tabListeners;
public:
	void NotifyTabSelected(const String& title);
    void AddTabListener(const TabListener::owner& l);

public:
	TabBar();
};

class TabView : public View
{
private:
	refc<MView> contentView; 
	refc<TabBar> tabBar; 
	
	typedef std::vector< std::pair<String, View::owner> > AssocMap;
	AssocMap assocMap;
	
protected:
	virtual ~TabView();
	bool HandleKeyEvent( const UIEvent& ev );
public:
	virtual void SetBounds(const Rect2D& bounds);  
    // allows you to set the skin for the individual tabs
	virtual void SetSkin(const ViewSkin::owner& skin);
	virtual void SetFont(const TextFont& font);

public:
	TabView();
	
	void AddPage(const String& title, const View::owner& page);	
	void RemovePage(const String& title);	
	const String& GetPageTitle(const View::owner& page);	
	void GoToPage(const String& title); 
	const String& GetCurrentPage();	
	void GoToNext();
	void GoToPrev();
	
	// make this view the visible one
//	void GoToView(const owner& view); 
//	void GoToFirstView();
//	View::owner GetCurrentView();

}; // TabView

} // namespace XSP
