/*
Copyright (C) 2003 Hotsprings Inc.
For conditions of distribution and use, see copyright notice

Location: 
	www.HotspringsInc.com 

History:
	2003Aug27-GiuseppeG: code write
*/

namespace XSP
{

/*content is always the full size of the socket
- iff content is null the socket draws it's own skin (the disabled look)
	otherwise the socket forwards the drawing to the child
	exactly one child is allowed, one replaces another
- if the content is null the socket can also provide the tooltip
*/
class ToolSocket : public View
{
	String 	toolName; // will be registered into winmgr's toolNames
protected:
	virtual ~ToolSocket();
	virtual void Draw(Graphics& g, const Rect2D& area);
public:	
	ToolSocket();
	virtual void SetBounds(const Rect2D& bounds);
	virtual Size2D GetPreferredSize();
public:	
	void SetToolName(const String& toolname);
	const String& GetToolName() const { return toolName; }
}; // class ToolSocket

class ToolMgr : public ref_obj
{
	static ToolMgr* _instance;
public:
	static ToolMgr* Instance();
protected:
	ToolMgr();
	~ToolMgr();
public:
	typedef std::list<ToolSocket*> ToolSockets;
	typedef std::map<String, ToolSockets> ToolRepo; 
	ToolRepo toolRepo;
public:	
	void RegisterTool(ToolSocket* ts);
	void UnregisterTool(ToolSocket* ts);
public: // notifications
	class _ToolChange
	{
	public: 
		virtual void ToolAddRemove(ToolSocket* ts, bool added);
	}; // class _ToolChange
	void NotifyChange_ToolAddRemove(ToolSocket* ts, bool added);

	typedef ListenerOf<_ToolChange> ToolListener;
	typedef ToolListener::Container ToolListeners;
	void AddListener(const ToolListener::owner& l);
	bool IsWithinNotify() { return toolListeners.withinNotify; }
private:
	ToolListeners toolListeners;
}; // class ToolMgr


/* the toolbar is just another container
   any view inside the toolbar is registered to the ToolRepo 
   the toolname should contain the type of the view (like Editing/Cut-Button)
*/
class ToolBar : public View
{
	refc<ToolMgr> toolMgr;
	sint32 cellSize;
public:
	ToolBar();
	void AddTool(const String& toolname);
	void RemoveTool(const String& toolname);
	void AddTool(ToolSocket* toolSock);
	void RemoveTool(ToolSocket* toolSock);
    ToolSocket* GetTool(const String& toolname);
	void SetCellSize(uint32 z);
	void DoLayout();
	
	void DemoPopulate();
public:
	virtual void SetBounds(const Rect2D& bounds);
	virtual Size2D GetPreferredSize();
protected:
	virtual ~ToolBar();
}; // class ToolBar

} // namespace XSP
