/*
Copyright (C) 2003 Hotsprings Inc.
For conditions of distribution and use, see copyright notice

Location: 
	www.HotspringsInc.com 

History:
	2003Aug27-GiuseppeG: code write
*/

namespace XSP
{

#if 0
#pragma mark StateSkin
#endif

class StateSkin : public ref_obj
{
public:
	typedef refc<StateSkin> owner;
protected:
	virtual ~StateSkin();
public:
	virtual void Draw(Graphics& g, const Rect2D& bounds, const Rect2D& area)=0;
	virtual Rect2D GetContent(const Rect2D& bounds)=0;
	virtual Rect2D GetContent()=0;
}; // class StateSkin

#if 0
#pragma mark SolidColorSkin
#endif

class SolidColorSkin : public StateSkin
{
public:
	ColorRGB bgColr;
	Rect2D   content;
public:
	SolidColorSkin();
	SolidColorSkin(const ColorRGB& c);
	~SolidColorSkin();
protected:
	virtual void Draw(Graphics& g, const Rect2D& bounds, const Rect2D& area);
	virtual Rect2D GetContent(const Rect2D& bounds);
	virtual Rect2D GetContent();
}; // class SolidColorSkin

#if 0
#pragma mark ImageSkin
#endif

class ImageSkin : public StateSkin
{
protected:
	OffscreenImage image; 
	Rect2D   content;
public:
	ImageSkin();
	ImageSkin(const OffscreenImage& image, const Rect2D& content);
	~ImageSkin();

	void SetImage(const OffscreenImage& image);
	void SetContent(const Rect2D& bounds);
	
protected:
	virtual void Draw(Graphics& g, const Rect2D& bounds, const Rect2D& area);
	virtual Rect2D GetContent(const Rect2D& bounds);
	virtual Rect2D GetContent();
}; // class ImageSkin

#if 0
#pragma mark SolidButtonSkin
#endif

class SolidButtonSkin : public StateSkin
{
	ColorRGB body,light,dark;
	OffscreenImage image; 
	void BuildImage(Size2D b);
public:
	SolidButtonSkin(const ColorRGB& bg, const ColorRGB& light, const ColorRGB& dark);
	~SolidButtonSkin();
protected:
	virtual void Draw(Graphics& g, const Rect2D& bounds, const Rect2D& area);
	virtual Rect2D GetContent(const Rect2D& bounds);
	virtual Rect2D GetContent();
}; // class SolidButtonSkin


#if 0
#pragma mark ViewSkin
#endif

class ViewSkin : public ref_obj
{
public:
	typedef refc<ViewSkin> owner;

public:
	class Element
	{
	public:
		Element();
		~Element();
		Element(const Element& e);
	public:
		uint32 stateMask;
		uint32 stateCode;
		StateSkin::owner stateSkin;
	}; // Element
	typedef std::list<Element> Elements;
	Elements elements;
public:
	typedef std::map<String, owner> Parts;
	Parts parts;
protected:
	virtual ~ViewSkin();
public:
	ViewSkin();
	virtual StateSkin::owner& GetStateSkin(uint32 stateID);
	void AddStateSkin(uint32 m, uint32 c, const StateSkin::owner& s);

	void AddPart(const String& partName, const ViewSkin::owner& partV);
	void JoinPartsFrom(const ViewSkin::owner& skin);
	ViewSkin::owner GetPart(const String& partName);
}; // class ViewSkin

} // namespace XSP
