/*
Copyright (C) 2003 Hotsprings Inc.
For conditions of distribution and use, see copyright notice

Location: 
	www.HotspringsInc.com 

History:
	2003Aug27-GiuseppeG: code write
*/

#include "XSP_Core.h"
#include "XSP_File.h"
#include "XSP_GUI.h"

namespace XSP
{

BackgroundView::BackgroundView()
{
	SetBgStyle(Desktop);
}

#if TARGET_API_Win32 || TARGET_API_Win32_Console

void BackgroundView::SetBgStyle(Style s)
{
	uint32 id = COLOR_BACKGROUND;
	switch (s)
	{
	case Edit: 
		id = COLOR_WINDOW; 
		break;
	case Dialog: 
		id = COLOR_BTNFACE; 
		break;
	case Desktop: 
	default:
		id = COLOR_DESKTOP; // same as COLOR_BACKGROUND
		break;
	};
	bgCol.FromCOLORREF(::GetSysColor(id));
}

#else
#error  "BackgroundView::SetBgStyle undefined for this OS"
#endif

void BackgroundView::SetBounds(const Rect2D& bounds)
{
	if (bounds == GetBounds())
		return;	
		
	View::SetBounds(bounds);
	Rect2D cont = GetSkinContentBounds();

	const Children& children = GetChildren();
	Children::const_iterator b = children.begin();
	Children::const_iterator e = children.end();
	if (b != e)
	{
		if (b == --e) // if we have exactly one child, keep it's size synched
			(*b)->SetBounds(bounds);
		//for(; b!=e; ++b) 
		//	(*b)->SetBounds(bounds);
	}
}


void BackgroundView::Draw(Graphics& g, const Rect2D& area)
{
	// green background
//	g.FillRect(ColorRGB(0x00,0xFF,0x00), area);
	g.FillRect(bgCol, area);
}

/*
	image = OffscreenImage(64, 64, OffscreenImage::RGBA32);
	Size2D rs(image.GetSize());
	if (false)
	{
		Graphics goi(image);
		Rect2D fr(Point2D(0,0), Size2D(1,1));
		for(fr.y=0; fr.y<rs.h; ++fr.y)
		for(fr.x=0; fr.x<rs.w; ++fr.x)	
		{
			ColorRGB clr( 0xB4+(fr.x&0x3F)
						, 0xC0+((fr.x|fr.y)&0x3F)
						, 0xB8+((fr.x&fr.y)&0x3F));
			goi.FillRect(clr, fr);
		}
	}
	else if (true)
	{
		LockOffscreenImage goi(image);
		uint8* row = goi.memory;

		Rect2D fr(Point2D(0,0), Size2D(1,1));
		for(fr.y=0; fr.y<rs.h; ++fr.y)
		{
			uint32* pix = (uint32*) row;
			for(fr.x=0; fr.x<rs.w; ++fr.x)	
			{
				ColorRGB clr( 0xB4+((fr.x|fr.y)&0x3F)
							, 0xC0+(fr.x+fr.y)
							, 0xB8+((fr.x&fr.y)&0x3F));
				*pix++ = clr.rgba;
				
			}
			row += goi.rowBytes;
		}
	}
*/



} // namespace XSP
