/*
Copyright (C) 2003 Hotsprings Inc.
For conditions of distribution and use, see copyright notice

Location: 
	www.HotspringsInc.com 

History:
	2003Aug27-GiuseppeG: code write
*/

#include "XSP_Core.h"
#include "XSP_File.h"
#include "XSP_GUI.h"

namespace XSP
{

WinMgr::~WinMgr()
{
}

WinMgr::WinMgr(const WinMgr& t)
: data(t.data)
{
}

WinMgr& WinMgr::operator = (const WinMgr& t)
{
	data = t.data;
	return *this;
}

WinMgr::WinMgr(_Data* d)
:data(d)
{
}

bool WinMgr::operator == (const WinMgr& t) const
{
	return data == t.data;
}

bool WinMgr::operator != (const WinMgr& t) const
{
	return data != t.data;
}

bool WinMgr::operator == (_Data* const t) const
{
	return data == t;
}

bool WinMgr::operator != (_Data* const t) const
{
	return data != t;
}

void WinMgr::AddListener(const Listener::owner& listener)
{
	VERIFY(data != 0);
	data->winMgrListeners.Add(listener);
}


void  WinMgr::RequestEvents(bool imediate)
{
	XSP::CoreModule::_instance->mainLoop->PostEvent(
		data->processEvents, imediate);
}

WinMgr::EventProcessor::EventProcessor(WinMgr::_Data* d)
: winMgrData(d)
{
}

void WinMgr::EventProcessor::Run()
{
	if (winMgrData != 0)
		WinMgr(winMgrData).ProcessEvents();
}

void WinMgr::EventProcessor::Cancel()
{
	winMgrData = 0;
	Event_Abstract::Cancel();
}

Window::Window()
{
}

Window::~Window()
{
}

Window::Window(const Window& t)
: data(t.data)
{
}

Window::Window(_Data* t)
: data(t)
{
}

Window& Window::operator = (const Window& t)
{
	data = t.data;
	return *this;
}

Window& Window::operator = (const Window* t)
{
	if (t == 0)
		data = 0;
	else
		data = t->data;
	return *this;
}

bool Window::operator == (const Window& t) const
{
	return data == t.data;
}

bool Window::operator != (const Window& t) const
{
	return data != t.data;
}

bool Window::operator == (const Window* t) const
{
	return t==0 ? data==0 : data==t->data;
}

bool Window::operator != (const Window* t) const
{
	return t==0 ? data!=0 : data!=t->data;
}

void Window::AddListener(const WindowListener::owner& l)
{
	VERIFY(data != 0);
	data->listeners.Add(l);
}

void Window::_WindowChange::Closed(Window& )
{}
void Window::_WindowChange::BoundsChanged(Window& )
{}
void Window::_WindowChange::Activated(Window& , bool )
{}

class MainWindowClosesApp : public Window::WindowListener
{
	void Closed(Window&)
	{
		CoreModule::_instance->mainLoop->PostEvent(
			CoreModule::_instance->mainLoop->CreateQuitEvent());
	}
	~MainWindowClosesApp()
	{
		CancelListener();
	}
};

void Window::SetWindowClosesApp()
{
	AddListener(new MainWindowClosesApp());
}

void Window::SetBgStyle(BackgroundView::Style s)
{
	data->SetBgStyle(s);
}

void Window::AddView(const View::owner& view)
{
	data->AddView(view);
}


} // namespace XSP
