library PowerLZW;

uses
  SysUtils,
  Classes,
  Windows,
  PowerAcrModuleInfo,
  CompressLZW in 'CompressLZW.pas';

{$R *.RES}

type
  TReadFunc = function (Data: Pointer; var Buffer; Size: integer): integer; stdcall;
  TWriteFunc = function (Data: Pointer; const Buffer; Size: integer): integer; stdcall;
  TReadStream = class(TStream)
  private
    FData: Pointer;
    FReadFunc: TReadFunc;
  public
    constructor Create(Data: Pointer; ReadFunc: TReadFunc);
    function Read(var Buffer; Count: Longint): Longint; override;
    function Write(const Buffer; Count: Longint): Longint; override;
    function Seek(Offset: Longint; Origin: Word): Longint; override;
  end;
  TWriteStream = class(TStream)
  private
    FData: Pointer;
    FWriteFunc: TWriteFunc;
  public
    constructor Create(Data: Pointer; WriteFunc: TWriteFunc);
    function Read(var Buffer; Count: Longint): Longint; override;
    function Write(const Buffer; Count: Longint): Longint; override;
    function Seek(Offset: Longint; Origin: Word): Longint; override;
  end;
  TMapMemoryStream = class (TCustomMemoryStream)
  public
    constructor Create(Buf: Pointer; Size: integer);
    function Write(const Buffer; Count: integer): integer; override;
  end;

procedure SetOptions(Opt: PChar); stdcall;
begin
  // none
end;

procedure Compress(Data: Pointer; Opt: PChar; ReadFunc: TReadFunc; WriteFunc: TWriteFunc); stdcall;
var ReadStream: TReadStream;
    WriteStream: TWriteStream;
    LZWCompressor: TLZWCompressor;
begin
  LZWCompressor:=TLZWCompressor.Create;
  ReadStream:=TReadStream.Create(Data,ReadFunc);
  LZWCompressor.InStream:=ReadStream;
  WriteStream:=TWriteStream.Create(Data,WriteFunc);
  LZWCompressor.OutStream:=WriteStream;
  try
    LZWCompressor.Compress;
  finally
    ReadStream.Free;
    WriteStream.Free;
    LZWCompressor.Free;
  end;
end;

function Decompress(Data: Pointer; ReadFunc: TReadFunc; WriteFunc: TWriteFunc): Boolean; stdcall;
var ReadStream: TReadStream;
    WriteStream: TWriteStream;
    LZWCompressor: TLZWCompressor;
begin
  Result:=True;
  try
    LZWCompressor:=TLZWCompressor.Create;
    ReadStream:=TReadStream.Create(Data,ReadFunc);
    LZWCompressor.InStream:=ReadStream;
    WriteStream:=TWriteStream.Create(Data,WriteFunc);
    LZWCompressor.OutStream:=WriteStream;
    try
      LZWCompressor.Decompress;
    finally
      ReadStream.Free;
      WriteStream.Free;
      LZWCompressor.Free;
    end;
  except
    Result:=False;
  end;
end;

procedure CompressMem(Data: Pointer; Opt: PChar; Mem: Pointer; MemSize: integer; WriteFunc: TWriteFunc); stdcall;
var ReadStream: TMapMemoryStream;
    WriteStream: TWriteStream;
    LZWCompressor: TLZWCompressor;
begin
  LZWCompressor:=TLZWCompressor.Create;
  ReadStream:=TMapMemoryStream.Create(Mem, MemSize);
  LZWCompressor.InStream:=ReadStream;
  WriteStream:=TWriteStream.Create(Data,WriteFunc);
  LZWCompressor.OutStream:=WriteStream;
  try
    LZWCompressor.Compress;
  finally
    ReadStream.Free;
    WriteStream.Free;
    LZWCompressor.Free;
  end;
end;

{ TReadStream }

constructor TReadStream.Create(Data: Pointer; ReadFunc: TReadFunc);
begin
  FData:=Data; FReadFunc:=ReadFunc;
end;

function TReadStream.Read(var Buffer; Count: Integer): Longint;
begin
  Result:=FReadFunc(FData,Buffer,Count);
end;

function TReadStream.Seek(Offset: Integer; Origin: Word): Longint;
begin
  Result:=-1;
end;

function TReadStream.Write(const Buffer; Count: Integer): Longint;
begin
  Result:=-1;
end;

{ TWriteStream }

constructor TWriteStream.Create(Data: Pointer; WriteFunc: TWriteFunc);
begin
  FData:=Data; FWriteFunc:=WriteFunc;
end;

function TWriteStream.Read(var Buffer; Count: Integer): Longint;
begin
  Result:=-1;
end;

function TWriteStream.Seek(Offset: Integer; Origin: Word): Longint;
begin
  Result:=-1;
end;

function TWriteStream.Write(const Buffer; Count: Integer): Longint;
begin
  Result:=FWriteFunc(FData,Buffer,Count);
end;

constructor TMapMemoryStream.Create(Buf: Pointer; Size: integer);
begin
  inherited Create;
  SetPointer(Buf,Size);
end;

function TMapMemoryStream.Write(const Buffer; Count: integer): integer;
begin
  Result:=-1;
end;

const
  LZWModuleInfo: TPowerArcModuleInfo = (
    Signature:   PowerArcModuleSignature;
    Name:        'LZW';
    Description: 'LZW example compressor';
    Options:     #0#0;
    DefaultBPC:  0;
    MaxBPC:      0;
    ModuleID:    'ALZW0001';
  );

function GetPowerArcModuleInfo: PPowerArcModuleInfo; stdcall;
begin
  Result:=@LZWModuleInfo;
end;

exports
  SetOptions,
  GetPowerArcModuleInfo,
  Compress,
  CompressMem,
  Decompress;

begin
  IsMultiThread:=True;
end.
