/*
 * Decompiled with CFR 0.152.
 */
package stec.pos;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OptionalDataException;
import java.io.UTFDataFormatException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Date;
import stec.pos.Blob;

public final class ByteArray {
    public static final byte NULL = 0;
    public static final byte BYTE = 1;
    public static final byte CHAR = 2;
    public static final byte SHORT = 3;
    public static final byte INT = 4;
    public static final byte LONG = 5;
    public static final byte FLOAT = 6;
    public static final byte DOUBLE = 7;
    public static final byte STRING = 8;
    public static final byte OBJECT = 9;
    public static final byte BOOLEAN = 10;
    public static final byte BLOB = 11;
    public static final byte DATE = 12;
    public static final byte BIGINTEGER = 13;
    public static final byte BIGDECIMAL = 14;
    public static final byte BYTE_ARRAY = 15;
    public static final byte DUPLICATES = -1;

    public static final byte getByte(byte[] byArray, int n) {
        return byArray[n];
    }

    public static final void setByte(byte[] byArray, int n, int n2) {
        byArray[n] = (byte)(n2 & 0xFF);
    }

    public static final char getChar(byte[] byArray, int n) {
        return (char)(((byArray[n] & 0xFF) << 8) + (byArray[n + 1] & 0xFF));
    }

    public static final void setChar(byte[] byArray, int n, int n2) {
        byArray[n] = (byte)(n2 >>> 8 & 0xFF);
        byArray[n + 1] = (byte)(n2 & 0xFF);
    }

    public static final short getShort(byte[] byArray, int n) {
        return (short)(((byArray[n] & 0xFF) << 8) + (byArray[n + 1] & 0xFF));
    }

    public static final void setShort(byte[] byArray, int n, int n2) {
        byArray[n] = (byte)(n2 >>> 8 & 0xFF);
        byArray[n + 1] = (byte)(n2 & 0xFF);
    }

    public static final int getInt(byte[] byArray, int n) {
        return ((byArray[n] & 0xFF) << 24) + ((byArray[n + 1] & 0xFF) << 16) + ((byArray[n + 2] & 0xFF) << 8) + (byArray[n + 3] & 0xFF);
    }

    public static final void setInt(byte[] byArray, int n, int n2) {
        byArray[n] = (byte)(n2 >>> 24 & 0xFF);
        byArray[n + 1] = (byte)(n2 >>> 16 & 0xFF);
        byArray[n + 2] = (byte)(n2 >>> 8 & 0xFF);
        byArray[n + 3] = (byte)(n2 & 0xFF);
    }

    public static final long getLong(byte[] byArray, int n) {
        return ((long)ByteArray.getInt(byArray, n) << 32) + ((long)ByteArray.getInt(byArray, n + 4) & 0xFFFFFFFFL);
    }

    public static final void setLong(byte[] byArray, int n, long l) {
        byArray[n] = (byte)(l >>> 56 & (long)255);
        byArray[n + 1] = (byte)(l >>> 48 & (long)255);
        byArray[n + 2] = (byte)(l >>> 40 & (long)255);
        byArray[n + 3] = (byte)(l >>> 32 & (long)255);
        byArray[n + 4] = (byte)(l >>> 24 & (long)255);
        byArray[n + 5] = (byte)(l >>> 16 & (long)255);
        byArray[n + 6] = (byte)(l >>> 8 & (long)255);
        byArray[n + 7] = (byte)(l & (long)255);
    }

    public static final float getFloat(byte[] byArray, int n) {
        return Float.intBitsToFloat(ByteArray.getInt(byArray, n));
    }

    public static final void setFloat(byte[] byArray, int n, float f) {
        ByteArray.setInt(byArray, n, Float.floatToIntBits(f));
    }

    public static final double getDouble(byte[] byArray, int n) {
        return Double.longBitsToDouble(ByteArray.getLong(byArray, n));
    }

    public static final void setDouble(byte[] byArray, int n, double d) {
        ByteArray.setLong(byArray, n, Double.doubleToLongBits(d));
    }

    public static final boolean getBoolean(byte[] byArray, int n) {
        return byArray[n] == 1;
    }

    public static final void setBoolean(byte[] byArray, int n, boolean bl) {
        byArray[n] = bl ? (byte)1 : 0;
    }

    public static final String getString(byte[] byArray, int n) throws UTFDataFormatException {
        int n2 = byArray.length - n;
        StringBuffer stringBuffer = new StringBuffer(n2);
        byte[] byArray2 = new byte[n2];
        int n3 = 0;
        block5: while (n3 < n2) {
            int n4 = byArray[n + n3] & 0xFF;
            switch (n4 >> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    ++n3;
                    stringBuffer.append((char)n4);
                    continue block5;
                }
                case 12: 
                case 13: {
                    if ((n3 += 2) > n2) {
                        throw new UTFDataFormatException();
                    }
                    byte by = byArray[n + n3 - 1];
                    if ((by & 0xC0) != 128) {
                        throw new UTFDataFormatException();
                    }
                    stringBuffer.append((char)((n4 & 0x1F) << 6 | by & 0x3F));
                    continue block5;
                }
                case 14: {
                    if ((n3 += 3) > n2) {
                        throw new UTFDataFormatException();
                    }
                    byte by = byArray[n + n3 - 2];
                    byte by2 = byArray[n + n3 - 1];
                    if ((by & 0xC0) != 128 || (by2 & 0xC0) != 128) {
                        throw new UTFDataFormatException();
                    }
                    stringBuffer.append((char)((n4 & 0xF) << 12 | (by & 0x3F) << 6 | (by2 & 0x3F) << 0));
                    continue block5;
                }
            }
            throw new UTFDataFormatException();
        }
        return stringBuffer.toString();
    }

    public static final void setString(byte[] byArray, int n, String string) {
        char c;
        int n2;
        int n3 = string.length();
        char[] cArray = new char[n3];
        string.getChars(0, n3, cArray, 0);
        int n4 = 0;
        for (n2 = 0; n2 < n3; ++n2) {
            c = cArray[n2];
            if (c >= '\u0001' && c <= '\u007f') {
                ++n4;
                continue;
            }
            if (c > '\u07ff') {
                n4 += 3;
                continue;
            }
            n4 += 2;
        }
        for (n2 = 0; n2 < n3; ++n2) {
            c = cArray[n2];
            if (c >= '\u0001' && c <= '\u007f') {
                byArray[n++] = (byte)c;
                continue;
            }
            if (c > '\u07ff') {
                byArray[n++] = (byte)(0xE0 | c >> 12 & 0xF);
                byArray[n++] = (byte)(0x80 | c >> 6 & 0x3F);
                byArray[n++] = (byte)(0x80 | c >> 0 & 0x3F);
                continue;
            }
            byArray[n++] = (byte)(0xC0 | c >> 6 & 0x1F);
            byArray[n++] = (byte)(0x80 | c >> 0 & 0x3F);
        }
    }

    public static final String getUtf8String(byte[] byArray, int n) throws UTFDataFormatException {
        int n2 = ByteArray.getInt(byArray, n);
        n += 4;
        StringBuffer stringBuffer = new StringBuffer(n2);
        byte[] byArray2 = new byte[n2];
        int n3 = 0;
        block5: while (n3 < n2) {
            int n4 = byArray[n + n3] & 0xFF;
            switch (n4 >> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    ++n3;
                    stringBuffer.append((char)n4);
                    continue block5;
                }
                case 12: 
                case 13: {
                    if ((n3 += 2) > n2) {
                        throw new UTFDataFormatException();
                    }
                    byte by = byArray[n + n3 - 1];
                    if ((by & 0xC0) != 128) {
                        throw new UTFDataFormatException();
                    }
                    stringBuffer.append((char)((n4 & 0x1F) << 6 | by & 0x3F));
                    continue block5;
                }
                case 14: {
                    if ((n3 += 3) > n2) {
                        throw new UTFDataFormatException();
                    }
                    byte by = byArray[n + n3 - 2];
                    byte by2 = byArray[n + n3 - 1];
                    if ((by & 0xC0) != 128 || (by2 & 0xC0) != 128) {
                        throw new UTFDataFormatException();
                    }
                    stringBuffer.append((char)((n4 & 0xF) << 12 | (by & 0x3F) << 6 | (by2 & 0x3F) << 0));
                    continue block5;
                }
            }
            throw new UTFDataFormatException();
        }
        return stringBuffer.toString();
    }

    public static final void setUtf8String(byte[] byArray, int n, String string) {
        char c;
        int n2;
        int n3 = string.length();
        char[] cArray = new char[n3];
        string.getChars(0, n3, cArray, 0);
        int n4 = 0;
        for (n2 = 0; n2 < n3; ++n2) {
            c = cArray[n2];
            if (c >= '\u0001' && c <= '\u007f') {
                ++n4;
                continue;
            }
            if (c > '\u07ff') {
                n4 += 3;
                continue;
            }
            n4 += 2;
        }
        ByteArray.setInt(byArray, n, n4);
        n += 4;
        for (n2 = 0; n2 < n3; ++n2) {
            c = cArray[n2];
            if (c >= '\u0001' && c <= '\u007f') {
                byArray[n++] = (byte)c;
                continue;
            }
            if (c > '\u07ff') {
                byArray[n++] = (byte)(0xE0 | c >> 12 & 0xF);
                byArray[n++] = (byte)(0x80 | c >> 6 & 0x3F);
                byArray[n++] = (byte)(0x80 | c >> 0 & 0x3F);
                continue;
            }
            byArray[n++] = (byte)(0xC0 | c >> 6 & 0x1F);
            byArray[n++] = (byte)(0x80 | c >> 0 & 0x3F);
        }
    }

    public static final Object getObject(byte[] byArray, int n) throws IOException, OptionalDataException, ClassNotFoundException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray, n, byArray.length - n);
        ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
        return objectInputStream.readObject();
    }

    public static final void setObject(byte[] byArray, int n, Object object) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
        objectOutputStream.writeObject(object);
        objectOutputStream.flush();
        byte[] byArray2 = byteArrayOutputStream.toByteArray();
        System.arraycopy(byArray2, 0, byArray, n, byArray2.length);
    }

    public static final Blob getBlob(byte[] byArray, int n) {
        byte[] byArray2 = new byte[byArray.length - n];
        System.arraycopy(byArray, n, byArray2, 0, byArray2.length);
        return new Blob(byArray2);
    }

    public static final void setBlob(byte[] byArray, int n, Blob blob) {
        byte[] byArray2 = blob.getValue();
        System.arraycopy(byArray2, 0, byArray, n, byArray2.length);
    }

    public static final Date getDate(byte[] byArray, int n) {
        return new Date(ByteArray.getLong(byArray, n));
    }

    public static final void setDate(byte[] byArray, int n, Date date) {
        ByteArray.setLong(byArray, n, date.getTime());
    }

    public static final BigInteger getBigInteger(byte[] byArray, int n) {
        byte[] byArray2 = new byte[byArray.length - n];
        System.arraycopy(byArray, n, byArray2, 0, byArray2.length);
        return new BigInteger(byArray2);
    }

    public static final void setBigInteger(byte[] byArray, int n, BigInteger bigInteger) {
        byte[] byArray2 = bigInteger.toByteArray();
        System.arraycopy(byArray2, 0, byArray, n, byArray2.length);
    }

    public static final BigDecimal getBigDecimal(byte[] byArray, int n) {
        return new BigDecimal(ByteArray.getBigInteger(byArray, n + 4), ByteArray.getInt(byArray, n));
    }

    public static final void setBigDecimal(byte[] byArray, int n, BigDecimal bigDecimal) {
        ByteArray.setInt(byArray, n, bigDecimal.scale());
        ByteArray.setBigInteger(byArray, n + 4, bigDecimal.unscaledValue());
    }

    public static final byte[] getByteArray(byte[] byArray, int n) {
        byte[] byArray2 = new byte[byArray.length - n];
        System.arraycopy(byArray, n, byArray2, 0, byArray2.length);
        return byArray2;
    }

    public static final void setByteArray(byte[] byArray, int n, byte[] byArray2) {
        System.arraycopy(byArray2, 0, byArray, n, byArray2.length);
    }

    public static final Object decodeObject(byte[] byArray, int n) throws IOException, UTFDataFormatException, OptionalDataException, ClassNotFoundException {
        byte by = byArray[n];
        ++n;
        switch (by) {
            case 0: {
                return null;
            }
            case 1: {
                return new Byte(ByteArray.getByte(byArray, n));
            }
            case 2: {
                return new Character(ByteArray.getChar(byArray, n));
            }
            case 3: {
                return new Short(ByteArray.getShort(byArray, n));
            }
            case 4: {
                return new Integer(ByteArray.getInt(byArray, n));
            }
            case 5: {
                return new Long(ByteArray.getLong(byArray, n));
            }
            case 6: {
                return new Float(ByteArray.getFloat(byArray, n));
            }
            case 7: {
                return new Double(ByteArray.getDouble(byArray, n));
            }
            case 8: {
                return ByteArray.getString(byArray, n);
            }
            case 9: {
                return ByteArray.getObject(byArray, n);
            }
            case 10: {
                return new Boolean(ByteArray.getBoolean(byArray, n));
            }
            case 11: {
                return ByteArray.getBlob(byArray, n);
            }
            case 12: {
                return ByteArray.getDate(byArray, n);
            }
            case 13: {
                return ByteArray.getBigInteger(byArray, n);
            }
            case 14: {
                return ByteArray.getBigDecimal(byArray, n);
            }
            case 15: {
                return ByteArray.getByteArray(byArray, n);
            }
        }
        throw new IOException("Invalid Object type: ".concat(String.valueOf(String.valueOf(by))));
    }

    public static final void encodeObject(byte[] byArray, int n, Object object) throws IOException {
        int n2 = n + 1;
        if (object == null) {
            byArray[n] = 0;
            return;
        }
        String string = object.getClass().getName();
        if (string.equals("java.lang.Byte")) {
            byArray[n] = 1;
            ByteArray.setByte(byArray, n2, ((Byte)object).byteValue());
        } else if (string.equals("java.lang.Character")) {
            byArray[n] = 2;
            ByteArray.setChar(byArray, n2, ((Character)object).charValue());
        } else if (string.equals("java.lang.Short")) {
            byArray[n] = 3;
            ByteArray.setShort(byArray, n2, ((Short)object).shortValue());
        } else if (string.equals("java.lang.Integer")) {
            byArray[n] = 4;
            ByteArray.setInt(byArray, n2, (Integer)object);
        } else if (string.equals("java.lang.Long")) {
            byArray[n] = 5;
            ByteArray.setLong(byArray, n2, (Long)object);
        } else if (string.equals("java.lang.Float")) {
            byArray[n] = 6;
            ByteArray.setFloat(byArray, n2, ((Float)object).floatValue());
        } else if (string.equals("java.lang.Double")) {
            byArray[n] = 7;
            ByteArray.setDouble(byArray, n2, (Double)object);
        } else if (string.equals("java.lang.String")) {
            byArray[n] = 8;
            ByteArray.setString(byArray, n2, (String)object);
        } else if (string.equals("java.lang.Boolean")) {
            byArray[n] = 10;
            ByteArray.setBoolean(byArray, n2, (Boolean)object);
        } else if (string.equals("stec.pos.Blob")) {
            byArray[n] = 11;
            ByteArray.setBlob(byArray, n2, (Blob)object);
        } else if (string.equals("java.util.Date")) {
            byArray[n] = 12;
            ByteArray.setDate(byArray, n2, (Date)object);
        } else if (string.equals("java.math.BigInteger")) {
            byArray[n] = 13;
            ByteArray.setBigInteger(byArray, n2, (BigInteger)object);
        } else if (string.equals("java.math.BigDecimal")) {
            byArray[n] = 14;
            ByteArray.setBigDecimal(byArray, n2, (BigDecimal)object);
        } else if (string.equals("[B")) {
            byArray[n] = 15;
            ByteArray.setByteArray(byArray, n2, (byte[])object);
        } else {
            byArray[n] = 9;
            ByteArray.setObject(byArray, n2, object);
        }
    }

    public static final byte[] toByteArray(Object object) throws IOException {
        byte[] byArray;
        if (object == null) {
            return new byte[0];
        }
        String string = object.getClass().getName();
        if (string.equals("java.lang.Byte")) {
            byArray = new byte[1];
            ByteArray.setByte(byArray, 0, ((Byte)object).byteValue());
        } else if (string.equals("java.lang.Character")) {
            byArray = new byte[2];
            ByteArray.setChar(byArray, 0, ((Character)object).charValue());
        } else if (string.equals("java.lang.Short")) {
            byArray = new byte[2];
            ByteArray.setShort(byArray, 0, ((Short)object).shortValue());
        } else if (string.equals("java.lang.Integer")) {
            byArray = new byte[4];
            ByteArray.setInt(byArray, 0, (Integer)object);
        } else if (string.equals("java.lang.Long")) {
            byArray = new byte[8];
            ByteArray.setLong(byArray, 0, (Long)object);
        } else if (string.equals("java.lang.Float")) {
            byArray = new byte[4];
            ByteArray.setFloat(byArray, 0, ((Float)object).floatValue());
        } else if (string.equals("java.lang.Double")) {
            byArray = new byte[8];
            ByteArray.setDouble(byArray, 0, (Double)object);
        } else if (string.equals("java.lang.String")) {
            String string2 = (String)object;
            byArray = new byte[ByteArray.getStringLength(string2)];
            ByteArray.setString(byArray, 0, string2);
        } else if (string.equals("java.lang.Boolean")) {
            byArray = new byte[1];
            ByteArray.setBoolean(byArray, 0, (Boolean)object);
        } else if (string.equals("stec.pos.Blob")) {
            Blob blob = (Blob)object;
            byArray = new byte[blob.length()];
            ByteArray.setBlob(byArray, 0, blob);
        } else if (string.equals("java.util.Date")) {
            byArray = new byte[8];
            ByteArray.setDate(byArray, 0, (Date)object);
        } else if (string.equals("java.math.BigInteger")) {
            byArray = ((BigInteger)object).toByteArray();
        } else if (string.equals("java.math.BigDecimal")) {
            BigDecimal bigDecimal = (BigDecimal)object;
            byte[] byArray2 = bigDecimal.unscaledValue().toByteArray();
            byArray = new byte[4 + byArray2.length];
            ByteArray.setInt(byArray, 0, bigDecimal.scale());
            System.arraycopy(byArray2, 0, byArray, 4, byArray2.length);
        } else if (string.equals("[B")) {
            byte[] byArray3 = (byte[])object;
            byArray = new byte[byArray3.length];
            System.arraycopy(byArray3, 0, byArray, 0, byArray3.length);
        } else {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(object);
            objectOutputStream.flush();
            return byteArrayOutputStream.toByteArray();
        }
        return byArray;
    }

    public static final byte[] toEncodedByteArray(Object object) throws IOException {
        byte[] byArray;
        if (object == null) {
            byte[] byArray2 = new byte[]{0};
            return byArray2;
        }
        String string = object.getClass().getName();
        if (string.equals("java.lang.Byte")) {
            byArray = new byte[2];
            byArray[0] = 1;
            ByteArray.setByte(byArray, 1, ((Byte)object).byteValue());
        } else if (string.equals("java.lang.Character")) {
            byArray = new byte[3];
            byArray[0] = 2;
            ByteArray.setChar(byArray, 1, ((Character)object).charValue());
        } else if (string.equals("java.lang.Short")) {
            byArray = new byte[3];
            byArray[0] = 3;
            ByteArray.setShort(byArray, 1, ((Short)object).shortValue());
        } else if (string.equals("java.lang.Integer")) {
            byArray = new byte[5];
            byArray[0] = 4;
            ByteArray.setInt(byArray, 1, (Integer)object);
        } else if (string.equals("java.lang.Long")) {
            byArray = new byte[9];
            byArray[0] = 5;
            ByteArray.setLong(byArray, 1, (Long)object);
        } else if (string.equals("java.lang.Float")) {
            byArray = new byte[5];
            byArray[0] = 6;
            ByteArray.setFloat(byArray, 1, ((Float)object).floatValue());
        } else if (string.equals("java.lang.Double")) {
            byArray = new byte[9];
            byArray[0] = 7;
            ByteArray.setDouble(byArray, 1, (Double)object);
        } else if (string.equals("java.lang.String")) {
            String string2 = (String)object;
            byArray = new byte[ByteArray.getStringLength(string2) + 1];
            byArray[0] = 8;
            ByteArray.setString(byArray, 1, string2);
        } else if (string.equals("java.lang.Boolean")) {
            byArray = new byte[2];
            byArray[0] = 10;
            ByteArray.setBoolean(byArray, 1, (Boolean)object);
        } else if (string.equals("stec.pos.Blob")) {
            Blob blob = (Blob)object;
            byArray = new byte[blob.length() + 1];
            byArray[0] = 11;
            ByteArray.setBlob(byArray, 1, blob);
        } else if (string.equals("java.util.Date")) {
            byArray = new byte[9];
            byArray[0] = 12;
            ByteArray.setDate(byArray, 1, (Date)object);
        } else if (string.equals("java.math.BigInteger")) {
            BigInteger bigInteger = (BigInteger)object;
            byte[] byArray3 = bigInteger.toByteArray();
            byArray = new byte[byArray3.length + 1];
            byArray[0] = 13;
            System.arraycopy(byArray3, 0, byArray, 1, byArray3.length);
        } else if (string.equals("java.math.BigDecimal")) {
            BigDecimal bigDecimal = (BigDecimal)object;
            byte[] byArray4 = bigDecimal.unscaledValue().toByteArray();
            byArray = new byte[5 + byArray4.length];
            byArray[0] = 14;
            ByteArray.setInt(byArray, 1, bigDecimal.scale());
            System.arraycopy(byArray4, 0, byArray, 5, byArray4.length);
        } else if (string.equals("[B")) {
            byte[] byArray5 = (byte[])object;
            byArray = new byte[byArray5.length + 1];
            byArray[0] = 15;
            System.arraycopy(byArray5, 0, byArray, 1, byArray5.length);
        } else {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(object);
            objectOutputStream.flush();
            byte[] byArray6 = byteArrayOutputStream.toByteArray();
            byArray = new byte[byArray6.length + 1];
            byArray[0] = 9;
            System.arraycopy(byArray6, 0, byArray, 1, byArray6.length);
        }
        return byArray;
    }

    public static final int getEncodedType(Object object) {
        if (object == null) {
            return 0;
        }
        String string = object.getClass().getName();
        if (string.equals("java.lang.Byte")) {
            return 1;
        }
        if (string.equals("java.lang.Character")) {
            return 2;
        }
        if (string.equals("java.lang.Short")) {
            return 3;
        }
        if (string.equals("java.lang.Integer")) {
            return 4;
        }
        if (string.equals("java.lang.Long")) {
            return 5;
        }
        if (string.equals("java.lang.Float")) {
            return 6;
        }
        if (string.equals("java.lang.Double")) {
            return 7;
        }
        if (string.equals("java.lang.String")) {
            return 8;
        }
        if (string.equals("java.lang.Boolean")) {
            return 10;
        }
        if (string.equals("stec.pos.Blob")) {
            return 11;
        }
        if (string.equals("java.util.Date")) {
            return 12;
        }
        if (string.equals("java.math.BigInteger")) {
            return 13;
        }
        if (string.equals("java.math.BigDecimal")) {
            return 14;
        }
        if (string.equals("[B")) {
            return 15;
        }
        return 9;
    }

    public static final int getStringLength(String string) {
        int n = 0;
        int n2 = string.length();
        for (int i = 0; i < n2; ++i) {
            char c = string.charAt(i);
            if (c >= '\u0001' && c <= '\u007f') {
                ++n;
                continue;
            }
            if (c > '\u07ff') {
                n += 3;
                continue;
            }
            n += 2;
        }
        return n;
    }

    public static final int getUtf8StringLength(String string) {
        return ByteArray.getStringLength(string) + 4;
    }

    public static final int getObjectLength(Object object) throws IOException {
        if (object == null) {
            return 0;
        }
        String string = object.getClass().getName();
        if (string.equals("java.lang.Byte")) {
            return 1;
        }
        if (string.equals("java.lang.Character")) {
            return 2;
        }
        if (string.equals("java.lang.Short")) {
            return 2;
        }
        if (string.equals("java.lang.Integer")) {
            return 4;
        }
        if (string.equals("java.lang.Long")) {
            return 8;
        }
        if (string.equals("java.lang.Float")) {
            return 4;
        }
        if (string.equals("java.lang.Double")) {
            return 8;
        }
        if (string.equals("java.lang.String")) {
            return ByteArray.getStringLength((String)object);
        }
        if (string.equals("java.lang.Boolean")) {
            return 1;
        }
        if (string.equals("stec.pos.Blob")) {
            return ((Blob)object).length();
        }
        if (string.equals("java.util.Date")) {
            return 8;
        }
        if (string.equals("java.math.BigInteger")) {
            return ((BigInteger)object).toByteArray().length;
        }
        if (string.equals("java.math.BigDecimal")) {
            return ((BigDecimal)object).unscaledValue().toByteArray().length + 4;
        }
        if (string.equals("[B")) {
            return ((byte[])object).length;
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
        objectOutputStream.writeObject(object);
        objectOutputStream.flush();
        return byteArrayOutputStream.toByteArray().length;
    }

    public static final int getEncodedObjectLength(Object object) throws IOException {
        return ByteArray.getObjectLength(object) + 1;
    }

    static {
        NULL = 0;
        BYTE = 1;
        CHAR = (byte)2;
        SHORT = (byte)3;
        INT = (byte)4;
        LONG = (byte)5;
        FLOAT = (byte)6;
        DOUBLE = (byte)7;
        STRING = (byte)8;
        OBJECT = (byte)9;
        BOOLEAN = (byte)10;
        BLOB = (byte)11;
        DATE = (byte)12;
        BIGINTEGER = (byte)13;
        BIGDECIMAL = (byte)14;
        BYTE_ARRAY = (byte)15;
        DUPLICATES = (byte)-1;
    }
}

