/*
 * Copyright (c) 2001-2005 Servertec. All Rights Reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * THIS NOTICE MUST NOT BE ALTERED NOR REMOVED.
 *
 * CopyrightVersion 1.0
 */

import java.io.IOException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;

import java.util.Vector;
import java.util.Hashtable;
import java.util.Enumeration;

import stec.pos.ByteArray;
import stec.pos.Blob;

import stec.pos.ByteArray;
import stec.pos.ObjectStoreEnumeration;
import stec.pos.ObjectStoreUtils;
import stec.pos.ObjectStore;
import stec.pos.ObjectStoreReference;
import stec.pos.Index;
import stec.pos.IndexReference;
import stec.pos.IndexedObjectStore;
import stec.pos.IndexedObjectStoreReference;
import stec.pos.POSException;
import stec.pos.IndexDescriptor;
import stec.pos.Indexer;

import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletException;
import javax.servlet.ServletConfig;

import stec.lang.DString;

import stec.iws.Utils;
import stec.iws.iws;

public class AddressBookServlet extends HttpServlet
{
	private static final String STORE = "./AddressBook/AddressBook";

	private String select_template;
	private String list_template;
	private String list_entry_template;
	private String entry_template;
	private String remove_template;
	private String search_template;

	private String path;
	private String idpath;

	private String[] indexes =
	{
		"id",
		"name",
		"category",
		"first_name",
		"last_name",
		"company_name",
		"business_city",
		"business_state",
		"business_zipcode",
		"business_country",
		"business_phone_number",
		"business_email_address",
		"home_city",
		"home_state",
		"home_zipcode",
		"home_country",
		"home_phone_number",
		"home_email_address",
	};

	private String[] search_indexes =
	{
		"category",
		"first_name",
		"last_name",
		"company_name",
		"business_city",
		"business_state",
		"business_zipcode",
		"business_country",
		"business_phone_number",
		"business_email_address",
		"home_city",
		"home_state",
		"home_zipcode",
		"home_country",
		"home_phone_number",
		"home_email_address",
	};

	private String getIndexerName(String index_name)
	{
		StringBuffer sb = new StringBuffer();

		char chr;
		boolean convert = true;

		int length = index_name.length();

		for(int i = 0; i < length; i++)
		{
			chr = index_name.charAt(i);

			if(convert)
			{
				convert = false;
				sb.append(Character.toUpperCase(chr));
			}
			else if(chr == '_')
			{
				convert = true;
			}
			else
			{
				sb.append(chr);
			}
		}

		sb.append("Indexer");

		return sb.toString();
	}

	private void init_index(String index_name, String path) throws Exception
	{
		if(Index.exists(path))
		{
			IndexReference reference = Index.open(path, true);

			try
			{
				reference.clear();
			}
			catch(Throwable throwable)
			{
				throw new POSException(throwable);
			}
			finally
			{
				try
				{
					reference.close();
				}
				catch(Throwable throwable)
				{
					throw new ServletException(throwable);
				}
			}
		}
		else
		{
			if(index_name.equals("id"))
			{
				Index.create(path, -1, -1, "java.lang.Long", 10, -1, "java.lang.Long", -1, -1, null, true, true, true, -1, -1, null, true);
			}
			else
			{
				Index.create(path, -1, -1, "java.lang.String", 10, -1, "java.lang.Long", -1, -1, null, true, true, true, -1, -1, null, true);
			}
		}
	}

	public synchronized void init(ServletConfig config) throws ServletException
	{
		super.init(config);

		try
		{
			select_template = Utils.getItem("./AddressBook/select.tf");
			list_template = Utils.getItem("./AddressBook/list.tf");
			list_entry_template = Utils.getItem("./AddressBook/list_entry.tf");
			entry_template = Utils.getItem("./AddressBook/entry.tf");
			remove_template = Utils.getItem("./AddressBook/remove.tf");
			search_template = Utils.getItem("./AddressBook/search.tf");

			path = Utils.concatPaths(iws.getBaseDirectory(), STORE);

			idpath = path + ".ids";

			File file = new File(idpath);
			if(!file.exists())
			{
				DataOutputStream os = new DataOutputStream(new FileOutputStream(file));
				os.writeLong(0L);
			}

			if(!IndexedObjectStore.exists(path))
			{
				ObjectStore.create(path, 256, ObjectStoreUtils.prime(100), -1, -1, true);

				path = Utils.concatPaths(iws.getBaseDirectory(), STORE);

				String filename;
				String index_name;

				int count = indexes.length;

				IndexDescriptor[] index_descriptors = new IndexDescriptor[count];

				for(int i = 0; i < count; i++)
				{
					index_name = indexes[i];
					filename = path + "." + index_name;
					init_index(index_name, filename);
					index_descriptors[i] = new IndexDescriptor(index_name, filename, getIndexerName(index_name));
				}

				IndexedObjectStore.create(path, path, index_descriptors, true);
			}

			if(!IndexedObjectStore.exists(path + ".resultset"))
			{
				Index.create(path + ".resultset", -1, -1, "java.lang.String", 10, -1, "java.lang.Long", -1, -1, null, true, true, true, -1, -1, null, true);
			}
		}
		catch(Throwable ex)
		{
			ex = getRootCause(ex);
			ex.printStackTrace();

			throw new ServletException(ex);
		}
	}

	public void service(HttpServletRequest _request, HttpServletResponse _response) throws ServletException, IOException
	{
		_response.setContentType("text/html");

		ServletOutputStream out = _response.getOutputStream();

		try
		{
			String formname = _request.getParameter("formname");
			if(formname == null)
			{
				select("", out, _request, _response);
			}
			else if(formname.length() == 0)
			{
				select("", out, _request, _response);
			}
			else if(formname.equalsIgnoreCase("select"))
			{
				String action = _request.getParameter("action");

				if(action == null)
				{
					select("", out, _request, _response);
				}
				else
				{
					action = action.trim();

					if(action.length() == 0)
					{
						select("", out, _request, _response);
					}
					else if(action.equalsIgnoreCase("add"))
					{
						IndexedObjectStoreReference reference = IndexedObjectStore.open(path, false);

						try
						{
							AddressBookEntry address_book_entry = new AddressBookEntry();

							address_book_entry.id = new Long(-1);

							output_form(entry_template, "add", address_book_entry, "", out);
						}
						catch(Throwable throwable)
						{
							throw new ServletException(throwable);
						}
						finally
						{
							try
							{
								reference.close();
							}
							catch(Throwable throwable)
							{
								throw new ServletException(throwable);
							}
						}
					}
					else if(action.equalsIgnoreCase("edit"))
					{
						String key = _request.getParameter("id");

						if(key == null)
						{
							select("An entry was not selected.", out, _request, _response);
						}
						else if(key.length() == 0)
						{
							select("An entry was not selected.", out, _request, _response);
						}
						else
						{
							IndexedObjectStoreReference reference = IndexedObjectStore.open(path, false);

							try
							{
								Object obj = reference.get(new Long(key));

								if(obj == null)
								{
									select("The selected entry was not found: " + key, out, _request, _response);
								}
								else if(!(obj instanceof AddressBookEntry))
								{
									select("The selected entry was not found: " + key, out, _request, _response);
								}
								else
								{
									AddressBookEntry address_book_entry = (AddressBookEntry)obj;

									output_form(entry_template, "edit", address_book_entry, "", out);
								}
							}
							catch(Throwable throwable)
							{
								throw new ServletException(throwable);
							}
							finally
							{
								try
								{
									reference.close();
								}
								catch(Throwable throwable)
								{
									throw new ServletException(throwable);
								}
							}
						}
					}
					else if(action.equalsIgnoreCase("remove"))
					{
						String key = _request.getParameter("id");

						if(key == null)
						{
							select("An entry was not selected.", out, _request, _response);
						}
						else if(key.length() == 0)
						{
							select("An entry was not selected.", out, _request, _response);
						}
						else
						{
							IndexedObjectStoreReference reference = IndexedObjectStore.open(path, false);

							try
							{
								Object obj = reference.get(new Long(key));

								if(obj == null)
								{
									select("The selected entry was not found: " + key, out, _request, _response);
								}
								else if(!(obj instanceof AddressBookEntry))
								{
									select("The selected entry was not found: " + key, out, _request, _response);
								}
								else
								{
									AddressBookEntry address_book_entry = (AddressBookEntry)obj;

									output_form(remove_template, "remove", address_book_entry, "", out);
								}
							}
							catch(Throwable throwable)
							{
								throw new ServletException(throwable);
							}
							finally
							{
								try
								{
									reference.close();
								}
								catch(Throwable throwable)
								{
									throw new ServletException(throwable);
								}
							}
						}
					}
					else if(action.equalsIgnoreCase("list"))
					{
						list("", "select", out, _request, _response);
					}
					else if(action.equalsIgnoreCase("search"))
					{
						search("", out, _request, _response);
					}
					else
					{
						select("Invalid action: " + action, out, _request, _response);
					}
				}
			}
			else if(formname.equalsIgnoreCase("add"))
			{
				String action = _request.getParameter("action");

				if(action == null)
				{
					AddressBookEntry address_book_entry = getAddressBookEntry(_request);

					output_form(entry_template, "add", address_book_entry, "", out);
				}
				else
				{
					action = action.trim();

					if(action.length() == 0)
					{
						AddressBookEntry address_book_entry = getAddressBookEntry(_request);

						output_form(entry_template, "add", address_book_entry, "", out);
					}
					else if(action.equalsIgnoreCase("ok"))
					{
						AddressBookEntry address_book_entry = getAddressBookEntry(_request);

						IndexedObjectStoreReference reference = IndexedObjectStore.open(path, false);

						try
						{
							String error_message = check(address_book_entry);
							if(error_message.length() == 0)
							{
								address_book_entry.id = newID();

								reference.put(address_book_entry.id, address_book_entry);

								select("", out, _request, _response);
							}
							else
							{
								output_form(entry_template, "add", address_book_entry, error_message, out);
							}
						}
						catch(Throwable throwable)
						{
							throw new ServletException(throwable);
						}
						finally
						{
							try
							{
								reference.close();
							}
							catch(Throwable throwable)
							{
								throw new ServletException(throwable);
							}
						}
					}
					else if(action.equalsIgnoreCase("cancel"))
					{
						select("", out, _request, _response);
					}
					else
					{
						AddressBookEntry address_book_entry = getAddressBookEntry(_request);

						output_form(entry_template, "add", address_book_entry, "Invalid action: " + action, out);
					}
				}
			}
			else if(formname.equalsIgnoreCase("edit"))
			{
				String action = _request.getParameter("action");

				if(action == null)
				{
					AddressBookEntry address_book_entry = getAddressBookEntry(_request);

					output_form(entry_template, "edit", address_book_entry, "", out);
				}
				else
				{
					action = action.trim();

					if(action.length() == 0)
					{
						AddressBookEntry address_book_entry = getAddressBookEntry(_request);

						output_form(entry_template, "edit", address_book_entry, "", out);
					}
					else if(action.equalsIgnoreCase("ok"))
					{
						AddressBookEntry address_book_entry = getAddressBookEntry(_request);

						IndexedObjectStoreReference reference = IndexedObjectStore.open(path, false);

						try
						{
							String error_message = check(address_book_entry);
							if(error_message.length() == 0)
							{
								reference.put(address_book_entry.id, address_book_entry);

								select("", out, _request, _response);
							}
							else
							{
								output_form(entry_template, "edit", address_book_entry, error_message, out);
							}
						}
						catch(Throwable throwable)
						{
							throw new ServletException(throwable);
						}
						finally
						{
							try
							{
								reference.close();
							}
							catch(Throwable throwable)
							{
								throw new ServletException(throwable);
							}
						}
					}
					else if(action.equalsIgnoreCase("cancel"))
					{
						select("", out, _request, _response);
					}
					else
					{
						AddressBookEntry address_book_entry = getAddressBookEntry(_request);

						output_form(entry_template, "edit", address_book_entry, "Invalid action: " + action, out);
					}
				}
			}
			else if(formname.equalsIgnoreCase("remove"))
			{
				String action = _request.getParameter("action");

				if(action == null)
				{
					AddressBookEntry address_book_entry = getAddressBookEntry(_request);

					output_form(remove_template, "remove", address_book_entry, "", out);
				}
				else
				{
					action = action.trim();

					if(action.length() == 0)
					{
						AddressBookEntry address_book_entry = getAddressBookEntry(_request);

						output_form(remove_template, "remove", address_book_entry, "", out);
					}
					else if(action.equalsIgnoreCase("ok"))
					{
						IndexedObjectStoreReference reference = IndexedObjectStore.open(path, false);

						try
						{
							String sid = (String)_request.getParameter("id");

							reference.remove(Long.valueOf(sid));

							select("", out, _request, _response);
						}
						catch(Throwable throwable)
						{
							throw new ServletException(throwable);
						}
						finally
						{
							try
							{
								reference.close();
							}
							catch(Throwable throwable)
							{
								throw new ServletException(throwable);
							}
						}
					}
					else if(action.equalsIgnoreCase("cancel"))
					{
						select("", out, _request, _response);
					}
					else
					{
						AddressBookEntry address_book_entry = getAddressBookEntry(_request);

						output_form(remove_template, "remove", address_book_entry, "Invalid action: " + action, out);
					}
				}
			}
			else if(formname.equalsIgnoreCase("list"))
			{
				String parent = _request.getParameter("parent");
				if(parent == null)
				{
					parent = "list";
				}
				else if(parent.length() == 0)
				{
					parent = "list";
				}

				String action = _request.getParameter("action");

				if(action == null)
				{
					if(parent.equalsIgnoreCase("search"))
					{
						search("", out, _request, _response);
					}
					else
					{
						select("", out, _request, _response);
					}
				}
				else
				{
					action = action.trim();

					if(action.length() == 0)
					{
						if(parent.equalsIgnoreCase("search"))
						{
							search("", out, _request, _response);
						}
						else
						{
							select("", out, _request, _response);
						}
					}
					else if(action.equalsIgnoreCase("ok"))
					{
						if(parent.equalsIgnoreCase("search"))
						{
							search("", out, _request, _response);
						}
						else
						{
							select("", out, _request, _response);
						}
					}
					else
					{
						list("Invalid action: " + action, parent, out, _request, _response);
					}
				}
			}
			else if(formname.equalsIgnoreCase("search"))
			{
				String action = _request.getParameter("action");

				if(action == null)
				{
					search("", out, _request, _response);
				}
				else
				{
					action = action.trim();

					if(action.length() == 0)
					{
						list("", "search", out, _request, _response);
					}
					else if(action.equalsIgnoreCase("ok"))
					{
						list("", "search", out, _request, _response);
					}
					else if(action.equalsIgnoreCase("cancel"))
					{
						select("", out, _request, _response);
					}
					else
					{
						search("Invalid action: " + action, out, _request, _response);
					}
				}
			}
			else
			{
				select("", out, _request, _response);
			}
		}
		catch(Throwable ex)
		{
			ex = getRootCause(ex);
			ex.printStackTrace();

			throw new ServletException(ex);
		}
	}

	private void check(StringBuffer sb, String field, String value)
	{
		if(value == null)
		{
			sb.append(field);
			sb.append(" is required.<br>");
		}
		else if(value.length() == 0)
		{
			sb.append(field);
			sb.append(" is required.<br>");
		}
	}

	private String check(AddressBookEntry address_book_entry)
	{
		StringBuffer sb = new StringBuffer();

		if((address_book_entry.first_name == null || address_book_entry.first_name == null) && address_book_entry.company_name == null)
		{
			sb.append("First Name and Last Name or Company Name is required.<br>");
		}
		else
		{
			if((address_book_entry.first_name.length() == 0 || address_book_entry.first_name.length() == 0) && address_book_entry.company_name.length() == 0)
			{
				sb.append("First Name and Last Name or Company Name is required.<br>");
			}
		}

		return sb.toString();
	}

	private AddressBookEntry getAddressBookEntry(HttpServletRequest request)
	{
		String sid = (String)request.getParameter("id");

		String category = (String)request.getParameter("category");
		String title = (String)request.getParameter("title");
		String first_name = (String)request.getParameter("first_name");
		String middle_initial = (String)request.getParameter("middle_initial");
		if(middle_initial.length() > 1)
		{
			middle_initial = middle_initial.substring(0, 1);
		}
		String last_name = (String)request.getParameter("last_name");
		String nick_name = (String)request.getParameter("nick_name");

		String company_name = (String)request.getParameter("company_name");
		String business_address_line1 = (String)request.getParameter("business_address_line1");
		String business_address_line2 = (String)request.getParameter("business_address_line2");
		String business_city = (String)request.getParameter("business_city");
		String business_state = (String)request.getParameter("business_state");
		String business_zipcode = (String)request.getParameter("business_zipcode");
		String business_country = (String)request.getParameter("business_country");
		String job_title = (String)request.getParameter("job_title");
		String department = (String)request.getParameter("department");
		String office = (String)request.getParameter("office");
		String business_phone_number = (String)request.getParameter("business_phone_number");
		String business_fax_number = (String)request.getParameter("business_fax_number");
		String business_pager_number = (String)request.getParameter("business_pager_number");
		String business_mobile_number = (String)request.getParameter("business_mobile_number");
		String business_website = (String)request.getParameter("business_website");
		String business_email_address = (String)request.getParameter("business_email_address");
		String business_imessenger_address = (String)request.getParameter("business_imessenger_address");

		String home_address_line1 = (String)request.getParameter("home_address_line1");
		String home_address_line2 = (String)request.getParameter("home_address_line2");
		String home_city = (String)request.getParameter("home_city");
		String home_state = (String)request.getParameter("home_state");
		String home_zipcode = (String)request.getParameter("home_zipcode");
		String home_country = (String)request.getParameter("home_country");
		String home_phone_number = (String)request.getParameter("home_phone_number");
		String home_fax_number = (String)request.getParameter("home_fax_number");
		String home_pager_number = (String)request.getParameter("home_pager_number");
		String home_mobile_number = (String)request.getParameter("home_mobile_number");
		String home_website = (String)request.getParameter("home_website");
		String home_email_address = (String)request.getParameter("home_email_address");
		String home_imessenger_address = (String)request.getParameter("home_imessenger_address");

		String spouse = (String)request.getParameter("spouse");
		String children = (String)request.getParameter("children");
		String birthday = (String)request.getParameter("birthday");
		String anniversary = (String)request.getParameter("anniversary");
		String notes = (String)request.getParameter("notes");

		AddressBookEntry address_book_entry = new AddressBookEntry();

		address_book_entry.id = Long.valueOf(sid);

		address_book_entry.category = category;
		address_book_entry.title = title;
		address_book_entry.first_name = first_name;
		address_book_entry.middle_initial = middle_initial;
		address_book_entry.last_name = last_name;
		address_book_entry.nick_name = nick_name;

		address_book_entry.company_name = company_name;
		address_book_entry.business_address_line1 = business_address_line1;
		address_book_entry.business_address_line2 = business_address_line2;
		address_book_entry.business_city = business_city;
		address_book_entry.business_state = business_state;
		address_book_entry.business_zipcode = business_zipcode;
		address_book_entry.business_country = business_country;
		address_book_entry.job_title = job_title;
		address_book_entry.department = department;
		address_book_entry.office = office;
		address_book_entry.business_phone_number = business_phone_number;
		address_book_entry.business_fax_number = business_fax_number;
		address_book_entry.business_pager_number = business_pager_number;
		address_book_entry.business_mobile_number = business_mobile_number;
		address_book_entry.business_website = business_website;
		address_book_entry.business_email_address = business_email_address;
		address_book_entry.business_imessenger_address = business_imessenger_address;

		address_book_entry.home_address_line1 = home_address_line1;
		address_book_entry.home_address_line2 = home_address_line2;
		address_book_entry.home_city = home_city;
		address_book_entry.home_state = home_state;
		address_book_entry.home_zipcode = home_zipcode;
		address_book_entry.home_country = home_country;
		address_book_entry.home_phone_number = home_phone_number;
		address_book_entry.home_fax_number = home_fax_number;
		address_book_entry.home_pager_number = home_pager_number;
		address_book_entry.home_mobile_number = home_mobile_number;
		address_book_entry.home_website = home_website;
		address_book_entry.home_email_address = home_email_address;
		address_book_entry.home_imessenger_address = home_imessenger_address;

		address_book_entry.spouse = spouse;
		address_book_entry.children = children;
		address_book_entry.birthday = birthday;
		address_book_entry.anniversary = anniversary;
		address_book_entry.notes = notes;

		return address_book_entry;
	}

	private void select(String error_message, ServletOutputStream out, HttpServletRequest _request, HttpServletResponse _response) throws ServletException, IOException
	{
		String template = new String(select_template);
		template = DString.replace(template, "%error_message%", error_message);

		int index = template.indexOf("%list%");
		if(index == -1)
		{
			out.print(template);
			return;
		}

		out.print(template.substring(0, index));

		AddressBookEntry address_book_entry;

		IndexedObjectStoreReference reference = IndexedObjectStore.open(path, false);

		try
		{
			reference.setDefaultIndex("name");

			reference.first();

			while(reference.next())
			{
				address_book_entry = (AddressBookEntry)reference.getCurrentValue();
				out.println("<option value = \"" + address_book_entry.id + "\">" + address_book_entry.toString());
			}
		}
		catch(Throwable throwable)
		{
			throw new ServletException(throwable);
		}
		finally
		{
			try
			{
				reference.close();
			}
			catch(Throwable throwable)
			{
				throw new ServletException(throwable);
			}
			finally
			{
				out.print(template.substring(index + 6));
			}
		}
	}

	private String replace(String template, String field, String value)
	{
		return DString.replace(template, field, (value == null) ? "" : value);
	}

	private final void output_form(String form_template, String action, AddressBookEntry address_book_entry, String error_message, ServletOutputStream out) throws IOException
	{
		String template = new String(form_template);
		template = DString.replace(template, "%error_message%", error_message);

		template = replace(template, "%action%", action);

		template = replace(template, "%id%", address_book_entry.id.toString());

		template = replace(template, "%category%", address_book_entry.category);
		template = replace(template, "%title%", address_book_entry.title);
		template = replace(template, "%first_name%", address_book_entry.first_name);
		template = replace(template, "%middle_initial%", address_book_entry.middle_initial);
		template = replace(template, "%last_name%", address_book_entry.last_name);
		template = replace(template, "%nick_name%", address_book_entry.nick_name);

		template = replace(template, "%company_name%", address_book_entry.company_name);
		template = replace(template, "%business_address_line1%", address_book_entry.business_address_line1);
		template = replace(template, "%business_address_line2%", address_book_entry.business_address_line2);
		template = replace(template, "%business_city%", address_book_entry.business_city);
		template = replace(template, "%business_state%", address_book_entry.business_state);
		template = replace(template, "%business_zipcode%", address_book_entry.business_zipcode);
		template = replace(template, "%business_country%", address_book_entry.business_country);
		template = replace(template, "%job_title%", address_book_entry.job_title);
		template = replace(template, "%department%", address_book_entry.department);
		template = replace(template, "%office%", address_book_entry.office);
		template = replace(template, "%business_phone_number%", address_book_entry.business_phone_number);
		template = replace(template, "%business_fax_number%", address_book_entry.business_fax_number);
		template = replace(template, "%business_pager_number%", address_book_entry.business_pager_number);
		template = replace(template, "%business_mobile_number%", address_book_entry.business_mobile_number);
		template = replace(template, "%business_website%", address_book_entry.business_website);
		template = replace(template, "%business_email_address%", address_book_entry.business_email_address);
		template = replace(template, "%business_imessenger_address%", address_book_entry.business_imessenger_address);

		template = replace(template, "%home_address_line1%", address_book_entry.home_address_line1);
		template = replace(template, "%home_address_line2%", address_book_entry.home_address_line2);
		template = replace(template, "%home_city%", address_book_entry.home_city);
		template = replace(template, "%home_state%", address_book_entry.home_state);
		template = replace(template, "%home_zipcode%", address_book_entry.home_zipcode);
		template = replace(template, "%home_country%", address_book_entry.home_country);
		template = replace(template, "%home_phone_number%", address_book_entry.home_phone_number);
		template = replace(template, "%home_fax_number%", address_book_entry.home_fax_number);
		template = replace(template, "%home_pager_number%", address_book_entry.home_pager_number);
		template = replace(template, "%home_mobile_number%", address_book_entry.home_mobile_number);
		template = replace(template, "%home_website%", address_book_entry.home_website);
		template = replace(template, "%home_email_address%", address_book_entry.home_email_address);
		template = replace(template, "%home_imessenger_address%", address_book_entry.home_imessenger_address);

		template = replace(template, "%spouse%", address_book_entry.spouse);
		template = replace(template, "%children%", address_book_entry.children);
		template = replace(template, "%birthday%", address_book_entry.birthday);
		template = replace(template, "%anniversary%", address_book_entry.anniversary);
		template = replace(template, "%notes%", address_book_entry.notes);

		out.print(template);
	}

	private void listAll(ServletOutputStream out, IndexedObjectStoreReference reference) throws ServletException, IOException
	{
		String template;
		AddressBookEntry address_book_entry;

		reference.setDefaultIndex("name");

		reference.first();

		while(reference.next())
		{
			address_book_entry = (AddressBookEntry)reference.getCurrentValue();

			template = new String(list_entry_template);

			template = DString.replace(template, "%id%", address_book_entry.id.toString());
			template = DString.replace(template, "%category%", address_book_entry.category);
			template = DString.replace(template, "%name%", address_book_entry.toString());
			template = DString.replace(template, "%first_name%", address_book_entry.first_name);
			template = DString.replace(template, "%middle_initial%", address_book_entry.middle_initial);
			template = DString.replace(template, "%last_name%", address_book_entry.last_name);
			template = DString.replace(template, "%business_email_address%", address_book_entry.business_email_address);
			template = DString.replace(template, "%business_phone_number%", address_book_entry.business_phone_number);
			template = DString.replace(template, "%home_email_address%", address_book_entry.home_email_address);
			template = DString.replace(template, "%home_phone_number%", address_book_entry.home_phone_number);

			out.println(template);
		}
	}

	private void list(String error_message, String parent, ServletOutputStream out, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException
	{
		String template = new String(list_template);

		template = DString.replace(template, "%error_message%", error_message);
		template = DString.replace(template, "%parent%", parent);

		int index = template.indexOf("%list%");
		if(index == -1)
		{
			out.print(template);
			return;
		}

		out.print(template.substring(0, index));

		IndexedObjectStoreReference reference = IndexedObjectStore.open(path, false);

		try
		{
			if(parent.equalsIgnoreCase("search"))
			{
				IndexReference resultset_index_reference = Index.open(path + ".resultset", false);

				try
				{
					resultset_index_reference.clear();

					Hashtable fields = new Hashtable();
					String index_name;
					String value;

					int count = search_indexes.length;

					for(int i = 0; i < count; i++)
					{
						index_name = search_indexes[i];
						value = (String)request.getParameter(index_name).trim();
						if(value.length() > 0)
						{
							fields.put(index_name, value);
						}
					}

					int field_count = fields.size();

					if(field_count == 0)
					{
						listAll(out, reference);
						return;
					}

					boolean found;

					Enumeration e = fields.keys();
					e.hasMoreElements();
					index_name = (String)e.nextElement();
					value = (String)fields.get(index_name);
					reference.setDefaultIndex(index_name);
					if(reference.containsKey(value))
					{
						reference.setCurrentKey(value);

						String tindex_name;
						Long id;
						AddressBookEntry address_book_entry;
						int hits;
						String key = value;

						int value_count = reference.valueCount(value);

						for(int i = 0; i < value_count; i++)
						{
							id = (Long)reference.getID();

							hits = 1;

							e = fields.keys();
							// skip the first field
							e.hasMoreElements();
							e.nextElement();
							while(e.hasMoreElements())
							{
								found = true;
								tindex_name = (String)e.nextElement();
								value = (String)fields.get(tindex_name);
								reference.setDefaultIndex(tindex_name);
								if(!reference.containsID(value, id))
								{
									break;
								}

								hits++;
							}

							reference.setDefaultIndex(index_name);

							if(hits == field_count)
							{
								address_book_entry = (AddressBookEntry)reference.get(key, id);
								resultset_index_reference.add(address_book_entry.toString(), id);
							}

							if(!reference.next())
							{
								break;
							}
						}

						String ttemplate;

						reference.setDefaultIndex("id");

						resultset_index_reference.first();

						while(resultset_index_reference.next())
						{
							id = (Long)resultset_index_reference.getCurrentValue();
							address_book_entry = (AddressBookEntry)reference.get(id);

							ttemplate = new String(list_entry_template);

							ttemplate = DString.replace(ttemplate, "%id%", address_book_entry.id.toString());
							ttemplate = DString.replace(ttemplate, "%category%", address_book_entry.category);
							ttemplate = DString.replace(ttemplate, "%name%", address_book_entry.toString());
							ttemplate = DString.replace(ttemplate, "%first_name%", address_book_entry.first_name);
							ttemplate = DString.replace(ttemplate, "%middle_initial%", address_book_entry.middle_initial);
							ttemplate = DString.replace(ttemplate, "%last_name%", address_book_entry.last_name);
							ttemplate = DString.replace(ttemplate, "%business_email_address%", address_book_entry.business_email_address);
							ttemplate = DString.replace(ttemplate, "%business_phone_number%", address_book_entry.business_phone_number);
							ttemplate = DString.replace(ttemplate, "%home_email_address%", address_book_entry.home_email_address);
							ttemplate = DString.replace(ttemplate, "%home_phone_number%", address_book_entry.home_phone_number);

							out.println(ttemplate);
						}

						resultset_index_reference.clear();
					}
				}
				catch(Throwable throwable)
				{
					throw new ServletException(throwable);
				}
				finally
				{
					try
					{
						resultset_index_reference.close();
					}
					catch(Throwable throwable)
					{
						throw new ServletException(throwable);
					}
				}
			}
			else
			{
				listAll(out, reference);
			}
		}
		catch(Throwable throwable)
		{
			throw new ServletException(throwable);
		}
		finally
		{
			try
			{
				reference.close();
			}
			catch(Throwable throwable)
			{
				throw new ServletException(throwable);
			}
			finally
			{
				out.print(template.substring(index + 6));
			}
		}
	}

	private void search(String error_message, ServletOutputStream out, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException
	{
		String template = new String(search_template);
		template = DString.replace(template, "%error_message%", error_message);

		String value = (String)request.getParameter("category");
		template = DString.replace(template, "%category%", (value == null) ? "" : value);
		value = (String)request.getParameter("first_name");
		template = DString.replace(template, "%first_name%", (value == null) ? "" : value);
		value = (String)request.getParameter("middle_initial");
		template = DString.replace(template, "%middle_initial%", (value == null) ? "" : value);
		value = (String)request.getParameter("last_name");
		template = DString.replace(template, "%last_name%", (value == null) ? "" : value);

		value = (String)request.getParameter("company_name");
		template = DString.replace(template, "%company_name%", (value == null) ? "" : value);
		value = (String)request.getParameter("business_city");
		template = DString.replace(template, "%business_city%", (value == null) ? "" : value);
		value = (String)request.getParameter("business_state");
		template = DString.replace(template, "%business_state%", (value == null) ? "" : value);
		value = (String)request.getParameter("business_zipcode");
		template = DString.replace(template, "%business_zipcode%", (value == null) ? "" : value);
		value = (String)request.getParameter("business_country");
		template = DString.replace(template, "%business_country%", (value == null) ? "" : value);
		value = (String)request.getParameter("business_phone_number");
		template = DString.replace(template, "%business_phone_number%", (value == null) ? "" : value);
		value = (String)request.getParameter("business_email_address");
		template = DString.replace(template, "%business_email_address%", (value == null) ? "" : value);

		value = (String)request.getParameter("home_city");
		template = DString.replace(template, "%home_city%", (value == null) ? "" : value);
		value = (String)request.getParameter("home_state");
		template = DString.replace(template, "%home_state%", (value == null) ? "" : value);
		value = (String)request.getParameter("home_zipcode");
		template = DString.replace(template, "%home_zipcode%", (value == null) ? "" : value);
		value = (String)request.getParameter("home_country");
		template = DString.replace(template, "%home_country%", (value == null) ? "" : value);
		value = (String)request.getParameter("home_phone_number");
		template = DString.replace(template, "%home_phone_number%", (value == null) ? "" : value);
		value = (String)request.getParameter("home_email_address");
		template = DString.replace(template, "%home_email_address%", (value == null) ? "" : value);

		out.print(template);
	}

	private static Throwable getRootCause(Throwable throwable)
	{
		while(true)
		{
			if(throwable instanceof ServletException)
			{
				throwable = ((ServletException)throwable).getRootCause();
			}
			else if(throwable instanceof POSException)
			{
				throwable = ((POSException)throwable).getRootCause();
			}
			else
			{
				return throwable;
			}
		}
	}

	private synchronized Long newID() throws Throwable
	{
		DataInputStream is = new DataInputStream(new FileInputStream(idpath));
		long id = is.readLong();
		is.close();

		DataOutputStream os = new DataOutputStream(new FileOutputStream(idpath));
		os.writeLong(id + 1L);
		os.close();

		return new Long(id);
	}
}
