#ifndef _FCTR_CRD_H_
#define _FCTR_CRD_H_

#include <windows.h>

#define BACKINGMAX (7)

#define FCTR_SUIT_SPADES		(1)
#define FCTR_SUIT_CLUBS			(2)
#define FCTR_SUIT_HEARTS		(3)
#define FCTR_SUIT_DIAMONDS	(4)

#define FCTR_VALUE_ACE		 (1)
#define FCTR_VALUE_TWO		 (2)
#define FCTR_VALUE_THREE	 (3)
#define FCTR_VALUE_FOUR		 (4)
#define FCTR_VALUE_FIVE		 (5)
#define FCTR_VALUE_SIX		 (6)
#define FCTR_VALUE_SEVEN	 (7)
#define FCTR_VALUE_EIGHT	 (8)
#define FCTR_VALUE_NINE		 (9)
#define FCTR_VALUE_TEN		(10)
#define FCTR_VALUE_JACK		(11)
#define FCTR_VALUE_QUEEN	(12)
#define FCTR_VALUE_KING		(13)
#define FCTR_VALUE_JOKER	(14)

#define FCTR_ERROR_OK										(0)
#define FCTR_ERROR_OUT_OF_MEMORY			(-14)
#define FCTR_ERROR_INVALID_PARAMETER	(-20)
#define FCTR_ERROR_NULL_POINTER				(-21)
#define FCTR_ERROR_EMPTY							(-33)
#define FCTR_ERROR_UNREGISTERED				(-34)

#define FCTR_CARD_PIXELWIDTH (71)
#define FCTR_CARD_PIXELHEIGHT (96)

#define FCTR_DOMINO_PIXELWIDTH (50)
#define FCTR_DOMINO_PIXELHEIGHT (100)

extern SHORT WINAPI FCTR_AddStandardDeckToShoe(USHORT NumberOfJokersPerDeck);
extern SHORT WINAPI FCTR_CardsDealt();
extern SHORT WINAPI FCTR_CardsRemaining();
extern SHORT WINAPI FCTR_TotalCards();
extern SHORT WINAPI FCTR_TotalDecks();
extern SHORT WINAPI FCTR_DealACard(USHORT* lpValue, LPSTR lpValueName, USHORT* lpSuit, LPSTR lpSuitName);
extern SHORT WINAPI FCTR_Shuffle();
extern SHORT WINAPI FCTR_DrawCardBacking(USHORT BackingIndex, HDC hdcDest, USHORT X, USHORT Y, USHORT Orientation);
extern SHORT WINAPI FCTR_DrawCard(USHORT Value, USHORT Suit, HDC hdcDest, USHORT X, USHORT Y, USHORT Orientation);
extern SHORT WINAPI FCTR_Register(LPCSTR lpszName, LPCSTR lpszRegCode);
extern SHORT WINAPI FCTR_AddDeck(LPVOID lpDeck);
extern SHORT WINAPI FCTR_AddCard(LPVOID lpDeck, USHORT Value, LPCSTR lpValueName, USHORT Suit, LPCSTR lpSuitName);
extern SHORT WINAPI FCTR_AddStandardDominoesToShoe(USHORT MaxNumberOfDots);
extern SHORT WINAPI FCTR_AddChineseDominoesToShoe();
extern SHORT WINAPI FCTR_DrawDominoBacking(HDC hdcDest, USHORT X, USHORT Y, USHORT Orientation);
extern SHORT WINAPI FCTR_DrawDomino(USHORT TopValue, USHORT BottomValue, HDC hdcDest, USHORT X, USHORT Y, USHORT Orientation);
extern SHORT WINAPI FCTR_DrawChineseDomino(USHORT TopValue, USHORT BottomValue, HDC hdcDest, USHORT X, USHORT Y, USHORT Orientation);
extern SHORT WINAPI FCTR_DealADomino(USHORT* lpTopValue, USHORT* lpBottomValue);
extern SHORT WINAPI FCTR_AddDomino(LPVOID lpDeck, USHORT TopValue, USHORT BottomValue);
extern VOID WINAPI FCTR_EmptyShoe();
#endif
