
{******************************************}
{                                          }
{   FastReport CLX v2.4 - DBX components   }
{        Master/detail definition          }
{                                          }
{ Copyright (c) 1998-2001 by Tzyganenko A. }
{                                          }
{******************************************}

unit fr_dbxmd;

interface

{$I fr.inc}

uses
  Types, SysUtils, Classes, QGraphics, QControls, QForms, QDialogs,
  DB, DBXpress, SqlExpr, QExtCtrls, QStdCtrls, fr_const;

type
  TfrDBXFieldsLinkForm = class(TForm)
    DetailL: TListBox;
    MasterL: TListBox;
    Label1: TLabel;
    Label2: TLabel;
    AddB: TButton;
    JoinL: TListBox;
    Label3: TLabel;
    ClearB: TButton;
    Bevel1: TBevel;
    OkB: TButton;
    CancelB: TButton;
    procedure FormShow(Sender: TObject);
    procedure FormHide(Sender: TObject);
    procedure ClearBClick(Sender: TObject);
    procedure DetailLDrawItem(Sender: TObject; Index: Integer;
      Rect: TRect; State: TOwnerDrawState; var Handled: Boolean);
    procedure DetailLClick(Sender: TObject);
    procedure MasterLClick(Sender: TObject);
    procedure AddBClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
  private
    { Private declarations }
    FMasterFields, FCurFields,
    FIndexFieldNames, FCurIndexFieldNames: String;
    lm, ld: TStringList;
    procedure FillLists;
    procedure Localize;
  public
    { Public declarations }
    MasterDS: TDataset;
    DetailDS: TSQLTable;
  end;

implementation

uses fr_class, fr_utils;

{$R *.xfm}


procedure TfrDBXFieldsLinkForm.FillLists;
var
  i, j: Integer;
  sMF, sIFN: String;
begin
  MasterL.Items.Assign(lm);
  DetailL.Items.Assign(ld);
  JoinL.Items.Clear;
  i := 1;
  j := 1;
  while i <= Length(FCurFields) do
  begin
    sMF := ExtractFieldName(FCurFields, i);
    sIFN := ExtractFieldName(FCurIndexFieldNames, j);
    JoinL.Items.Add(sIFN + ' -> ' + sMF);
    DetailL.Items.Delete(DetailL.Items.IndexOf(sIFN));
    MasterL.Items.Delete(MasterL.Items.IndexOf(sMF));
  end;

  AddB.Enabled := False;
end;

procedure TfrDBXFieldsLinkForm.FormShow(Sender: TObject);
var
  MasterWasActive: Boolean;
begin
  Caption := DetailDS.Name + ' -> ' + MasterDS.Name;
  lm := TStringList.Create;
  ld := TStringList.Create;
  FMasterFields := DetailDS.MasterFields;
  FCurFields := FMasterFields;
  FIndexFieldNames := DetailDS.IndexFieldNames;
  FCurIndexFieldNames := FIndexFieldNames;

  MasterDS.GetFieldNames(lm);
  MasterWasActive := MasterDS.Active;
  MasterDS.Active := true;
  DetailDS.GetFieldNames(ld);
  MasterDS.Active := MasterWasActive;
  FillLists;
end;

procedure TfrDBXFieldsLinkForm.FormHide(Sender: TObject);
begin
  if ModalResult = mrOk then
  begin
    DetailDS.MasterFields := FCurFields;
    DetailDS.IndexFieldNames := FCurIndexFieldNames;
  end
  else
  begin
    DetailDS.MasterFields := FMasterFields;
    DetailDS.IndexFieldNames := FIndexFieldNames;
  end;

  ld.Free;
  lm.Free;
end;

procedure TfrDBXFieldsLinkForm.ClearBClick(Sender: TObject);
begin
  FCurFields := '';
  FCurIndexFieldNames := '';
  FillLists;
end;

procedure TfrDBXFieldsLinkForm.DetailLDrawItem(Sender: TObject; //Control: TWinControl;
  Index: Integer; Rect: TRect; State: TOwnerDrawState;
  var Handled: Boolean);
begin
  with DetailL.Canvas do
  begin
    FillRect(Rect);
    TextOut(Rect.Left + 2, Rect.Top, DetailL.Items[Index]);
  end;
  Handled := True;
end;

procedure TfrDBXFieldsLinkForm.DetailLClick(Sender: TObject);
begin
  if MasterL.ItemIndex <> -1 then
    AddB.Enabled := True;
end;

procedure TfrDBXFieldsLinkForm.MasterLClick(Sender: TObject);
begin
  if DetailL.ItemIndex <> -1 then
    AddB.Enabled := True;
end;

procedure TfrDBXFieldsLinkForm.AddBClick(Sender: TObject);
var s: String;
begin
  s := MasterL.Items[MasterL.ItemIndex];
  if FCurFields = '' then
    FCurFields := s else
    FCurFields := FCurFields + ';' + s;

  s := DetailL.Items[DetailL.ItemIndex];
  if FCurIndexFieldNames = '' then
    FCurIndexFieldNames := s else
    FCurIndexFieldNames := FCurIndexFieldNames + ';' + s;

  FillLists;
end;

procedure TfrDBXFieldsLinkForm.Localize;
begin
  Font.Name := frDefaultFont;
  Label1.Caption := S56130;
  Label2.Caption := S56131;
  Label3.Caption := S56132;
  AddB.Caption := S56133;
  ClearB.Caption := S56134;
  OkB.Caption := (SOk);
  CancelB.Caption := (SCancel);
end;

procedure TfrDBXFieldsLinkForm.FormCreate(Sender: TObject);
begin
  Localize;
end;

end.

