
{******************************************}
{                                          }
{           FastReport CLX v2.5            }
{           WinAPI stuff wrapper           }
{                                          }
{Copyright(c) 1998-2003 by FastReports Inc.}
{                                          }
{******************************************}

unit fr_api;

{$I fr.inc}

interface

uses Qt, Types;

type
  frHRGN = QRegionH;
  frHDC = QPainterH;
  frHBrush = QBrushH;

const
  frNULLREGION = 0;
  frRGN_AND = 1;
  frRGN_DIFF = 2;
  frRGN_OR = 3;


function frCreateRectRgn(p1, p2, p3, p4: Integer): frHRGN;
procedure frCombineRgn(var p1, p2, p3: frHRGN);
function frPtInRegion(p1: frHRGN; p2, p3: Integer): Boolean;
function frRectVisible(DC: frHDC; ARect: TRect): Boolean;
procedure frSetTextCharacterExtra(DC: frHDC; p2: Integer);
procedure frDeleteRgn(p1: frHRGN);
procedure frGetClipRgn(DC: frHDC; var p2: frHRGN);
procedure frSetClipRgn(DC: frHDC; p2: frHRGN);
procedure frExcludeClipRect(DC: frHDC; p2, p3, p4, p5: Integer);
procedure frExcludeClipRgn(DC: frHDC; p2: frHRGN);

implementation


function frCreateRectRgn(p1, p2, p3, p4: Integer): frHRGN;
begin
  Result := QRegion_create(p1, p2, p3-p1, p4-p2, QRegionRegionType_Rectangle);
end;

procedure frDeleteRgn(p1: frHRGN);
begin
  QRegion_destroy(p1);
end;

procedure frGetClipRgn(DC: frHDC; var p2: frHRGN);
begin
  p2 := QPainter_clipRegion(DC);
end;

procedure frSetClipRgn(DC: frHDC; p2: frHRGN);
begin
  QPainter_setClipRegion(DC, p2);
end;

procedure frExcludeClipRect(DC: frHDC; p2, p3, p4, p5: Integer);
var
  r1, r2, r3: frHRgn;
begin
  r1 := QRegion_create;
  r2 := frCreateRectRgn(p2, p3, p4, p5);
  r3 := QRegion_create;
  frGetClipRgn(DC, r1);
  QRegion_subtract(r1, r3, r2);
  frSetClipRgn(DC, r3);
  frDeleteRgn(r2);
  frDeleteRgn(r3);
end;

procedure frExcludeClipRgn(DC: frHDC; p2: frHRGN);
var
  r1, r3: frHRgn;
begin
  r1 := QRegion_create;
  r3 := QRegion_create;
  frGetClipRgn(DC, r1);
  QRegion_subtract(r1, r3, p2);
  frSetClipRgn(DC, r3);
  frDeleteRgn(r3);
end;

procedure frCombineRgn(var p1, p2, p3: frHRGN);
begin
  QRegion_unite(p1, p2, p3);
end;

function frPtInRegion(p1: frHRGN; p2, p3: Integer): Boolean;
var
  p: TPoint;
  pp: PPoint;
begin
  p := Point(p2, p3);
  pp := @p;
  Result := QRegion_contains(p1, pp);
end;

function frRectVisible(DC: frHDC; ARect: TRect): Boolean;
var
  r: frHRGN;
  p: PRect;
begin
  p := @ARect;
  r := QRegion_create;
  frGetClipRgn(DC, r);
  Result := QRegion_contains(r, p);
//  frDeleteRgn(r);
end;

procedure frSetTextCharacterExtra(DC: frHDC; p2: Integer);
begin
//  SetTextCharacterExtra(DC, p2);
end;



end.