
{******************************************}
{                                          }
{           FastReport CLX v2.5            }
{            CSV export filter             }
{                                          }
{Copyright(c) 1998-2003 by FastReports Inc.}
{                                          }
{******************************************}

unit fr_e_csv;

interface

{$I fr.inc}

uses
  SysUtils, Types, Classes, QGraphics, QForms, QStdCtrls,
  fr_class, fr_e_txt, QControls;

type
  TfrCSVExport = class(TfrTextExport)
  private
    FDelimiter: WideChar;
  public
    constructor Create(AOwner: TComponent); override;
    function ShowModal: Word; override;
    procedure OnEndPage; override;
  published
    property Delimiter: WideChar read FDelimiter write FDelimiter;
  end;

  TfrCSVExportForm = class(TForm)
    GroupBox1: TGroupBox;
    CB1: TCheckBox;
    CB2: TCheckBox;
    Label1: TLabel;
    E1: TEdit;
    Button1: TButton;
    Button2: TButton;
    Label2: TLabel;
    Label3: TLabel;
    E2: TEdit;
    Label4: TLabel;
    E3: TEdit;
    procedure FormCreate(Sender: TObject);
  private
    { Private declarations }
    procedure Localize;
  public
    { Public declarations }
  end;

implementation

uses fr_const, fr_utils;

{$R *.xfm}


{ TfrCSVExport }

constructor TfrCSVExport.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
  frRegisterExportFilter(Self, (SCSVFile) + ' (*.csv)', '*.csv');
  ShowDialog := True;
  ScaleX := 1;
  ScaleY := 1;
  KillEmptyLines := True;
  ConvertToOEM := False;
  Delimiter := ';';
end;

function TfrCSVExport.ShowModal: Word;
begin
  if not ShowDialog then
    Result := mrOk
  else with TfrCSVExportForm.Create(nil) do
  begin
    CB1.Checked := KillEmptyLines;
    CB2.Checked := ConvertToOEM;
    E1.Text := FloatToStr(ScaleX);
    E2.Text := FloatToStr(ScaleY);
    E3.Text := Delimiter;

    Result := ShowModal;
    try
      ScaleX := frStrToFloat(E1.Text);
    except
      ScaleX := 1;
    end;
    try
      ScaleY := frStrToFloat(E2.Text);
    except
      ScaleY := 1;
    end;
    KillEmptyLines := CB1.Checked;
    ConvertToOEM := CB2.Checked;
    if E3.Text <> '' then
      Delimiter := E3.Text[1];
    Free;
  end;
end;

procedure TfrCSVExport.OnEndPage;
var
  i, j, n, tc1, tc2: Integer;
  p: PfrTextRec;
  s: String;
begin
  n := Lines.Count - 1;
  while n >= 0 do
  begin
    if Lines[n] <> nil then break;
    Dec(n);
  end;

  for i := 0 to n do
  begin
    s := '';
    tc1 := 0;
    p := PfrTextRec(Lines[i]);
    while p <> nil do
    begin
      tc2 := Round(p^.X / (64 / ScaleX));
      for j := 0 to tc2 - tc1 - 1 do
        s := s + Delimiter;
      if Pos(Delimiter, p^.Text) <> 0 then
        s := s + '"' + p^.Text + '"' else
        s := s + p^.Text;
      tc1 := tc2;
      p := p^.Next;
    end;
    if not KillEmptyLines or (s <> '') then
    begin
{      if ConvertToOEM then
        CharToOEMBuff(@s[1], @s[1], Length(s));}
      s := s + #13#10;
      Stream.Write(s[1], Length(s));
    end;
  end;
end;


procedure TfrCSVExportForm.Localize;
begin
  Font.Name := frDefaultFont;
  Caption := S54810;
  CB1.Caption := S54801;
  CB2.Caption := S54802;
  Label1.Caption := S54806;
  Label4.Caption := S54811;
  Button1.Caption := (SOk);
  Button2.Caption := (SCancel);
end;

procedure TfrCSVExportForm.FormCreate(Sender: TObject);
begin
  Localize;
end;


end.
