
{******************************************}
{                                          }
{           FastReport CLX v2.5            }
{          Insert fields dialog            }
{                                          }
{Copyright(c) 1998-2003 by FastReports Inc.}
{                                          }
{******************************************}

unit fr_iflds;

interface

{$I fr.inc}

uses
  SysUtils, Types, Classes, QGraphics, QControls, QForms, QDialogs,
  QStdCtrls, fr_dbrel, QExtCtrls;

type
  TfrInsertFieldsForm = class(TForm)
    FieldsL: TListBox;
    DatasetCB: TComboBox;
    Label1: TLabel;
    GroupBox1: TGroupBox;
    HorzRB: TRadioButton;
    VertRB: TRadioButton;
    Button1: TButton;
    Button2: TButton;
    GroupBox2: TGroupBox;
    HeaderCB: TCheckBox;
    BandCB: TCheckBox;
    Image1: TImage;
    Image2: TImage;
    procedure DatasetCBChange(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure DatasetCBDrawItem(Sender: TObject; Index: Integer;
      ARect: TRect; State: TOwnerDrawState; var Handled: Boolean);
    procedure FieldsLDrawItem(Sender: TObject; Index: Integer; ARect: TRect;
      State: TOwnerDrawState; var Handled: Boolean);
  private
    { Private declarations }
    procedure Localize;
  public
    { Public declarations }
    DataSet: TfrTDataSet;
  end;


implementation

uses fr_class, fr_desgn, fr_const, fr_utils, fr_dbset, fr_ctrls;

{$R *.xfm}

procedure TfrInsertFieldsForm.FormShow(Sender: TObject);
begin
  DataSet := nil;
  CurReport.Dictionary.GetDatasetList(DatasetCB.Items);
  if DatasetCB.Items.Count > 0 then
    DatasetCB.ItemIndex := 0;
  DatasetCBChange(nil);
end;

procedure TfrInsertFieldsForm.DatasetCBChange(Sender: TObject);
var
  DSName: String;
begin
  DSName := DatasetCB.Items[DatasetCB.ItemIndex];
  DataSet := frGetDataSet(CurReport.Dictionary.RealDataSetName[DSName]);
  CurReport.Dictionary.GetFieldList(DSName, FieldsL.Items);
end;

procedure TfrInsertFieldsForm.Localize;
begin
  Font.Name := frDefaultFont;
  Caption := (S53630);
  Label1.Caption := (S53631);
  GroupBox1.Caption := (S53632);
  HorzRB.Caption := (S53633);
  VertRB.Caption := (S53634);
  HeaderCB.Caption := (S53635);
  BandCB.Caption := (S53636);
  Button1.Caption := (SOk);
  Button2.Caption := (SCancel);
end;

procedure TfrInsertFieldsForm.FormCreate(Sender: TObject);
begin
  Localize;
end;

procedure TfrInsertFieldsForm.DatasetCBDrawItem(Sender: TObject;
  Index: Integer; ARect: TRect; State: TOwnerDrawState; var Handled: Boolean);
var
  r: TRect;
begin
  r := ARect;
  r.Right := r.Left + 18;
  r.Bottom := r.Top + 16;
  OffsetRect(r, 2, 0);
  with DatasetCB.Canvas do
  begin
    FillRect(ARect);
    frDrawTransparent(DatasetCB.Canvas, r.Left, r.Top, Image1.Picture.Bitmap);
    TextOut(ARect.Left + 20, ARect.Top + 1, DatasetCB.Items[Index]);
  end;
end;

procedure TfrInsertFieldsForm.FieldsLDrawItem(Sender: TObject;
  Index: Integer; ARect: TRect; State: TOwnerDrawState; var Handled: Boolean);
var
  r: TRect;
begin
  r := ARect;
  r.Right := r.Left + 18;
  r.Bottom := r.Top + 16;
  OffsetRect(r, 2, 0);
  with FieldsL.Canvas do
  begin
    FillRect(ARect);
    frDrawTransparent(FieldsL.Canvas, r.Left, r.Top, Image2.Picture.Bitmap);
    TextOut(ARect.Left + 20, ARect.Top + 1, FieldsL.Items[Index]);
  end;
end;

{$HINTS OFF}
procedure TfrInsertFieldsForm.FormClose(Sender: TObject;
  var Action: TCloseAction);
var
  i, x, y, dx, dy, pdx, adx: Integer;
  HeaderL, DataL: TList;
  t, t1: TfrView;
  b: TfrBandView;
  f: TfrTField;
  fSize: Integer;
  fName: String;
  DSName, FieldName: String;
  dsgn: TfrDesignerForm;
  bmp: TBitmap;

  function FindDataset(DataSet: TfrTDataSet): String;
  var
    i: Integer;
    function EnumComponents(f: TComponent): String;
    var
      i: Integer;
      c: TComponent;
      d: TfrDBDataSet;
    begin
      Result := '';
      for i := 0 to f.ComponentCount - 1 do
      begin
        c := f.Components[i];
        if c is TfrDBDataSet then
        begin
          d := c as TfrDBDataSet;
          if d.GetDataSet = DataSet then
          begin
            if d.Owner = CurReport.Owner then
              Result := d.Name else
              Result := d.Owner.Name + '.' + d.Name;
            break;
          end;
        end;
      end;
    end;
  begin
    Result := '';
    for i := 0 to Screen.FormCount - 1 do
    begin
      Result := EnumComponents(Screen.Forms[i]);
      if Result <> '' then Exit;
    end;
    for i := 0 to Screen.DataModuleCount - 1 do
    begin
      Result := EnumComponents(Screen.DataModules[i]);
      if Result <> '' then Exit;
    end;
  end;

begin
  dsgn := TfrDesignerForm(frDesigner);
  HeaderL := TList.Create;
  DataL := TList.Create;
  bmp := TBitmap.Create;
  bmp.Width := 16; bmp.Height := 16;
  if (ModalResult = mrOk) and (DataSet <> nil) and
    (FieldsL.Items.Count > 0) and (FieldsL.SelCount > 0) then
  begin
    dsgn.BeforeChange;
    DSName := DatasetCB.Items[DatasetCB.ItemIndex];
    x := dsgn.Page.LeftMargin; y := dsgn.Page.TopMargin;
    for i := 0 to FieldsL.Items.Count - 1 do
      if FieldsL.Selected[i] then
      begin
        FieldName := FieldsL.Items[i];
        f := TfrTField(DataSet.FindField(CurReport.Dictionary.RealFieldName[FieldsL.Items[i]]));
        fSize := 0;
        if f <> nil then
        begin
          fSize := f.DisplayWidth;
          fName := f.DisplayName;
        end
        else
          fName := FieldName;
        if (fSize = 0) or (fSize > 255) then
          fSize := 6;

        t := frCreateObject(gtMemo, '');
        t.CreateUniqueName;
        t.x := x;
        t.y := y;
        t.dy := 16;
        if HeaderCB.Checked then
          TfrMemoView(t).Font.Style := [fsBold];
        bmp.Canvas.Font.Assign(TfrMemoView(t).Font);
        t.Selected := True;
        if HeaderCB.Checked then
        begin
          t.Memo.Add(fName);
          t.dx := bmp.Canvas.TextWidth(fName + '   ') div dsgn.GridSizeX * dsgn.GridSizeX;
        end
        else
        begin
          t.Memo.Add('[' + DSName + '."' + FieldName + '"]');
          t.dx := (fSize * bmp.Canvas.TextWidth('=')) div dsgn.GridSizeX * dsgn.GridSizeX;
        end;
        dx := t.dx;
        dsgn.Page.Objects.Add(t);
        if HeaderCB.Checked then
          HeaderL.Add(t) else
          DataL.Add(t);
        if HeaderCB.Checked then
        begin
          t := frCreateObject(gtMemo, '');
          t.CreateUniqueName;
          t.x := x;
          t.y := y;
          t.dy := 16;
          if HorzRB.Checked then
            Inc(t.y, 72) else
            Inc(t.x, dx + dsgn.GridSizeX * 2);
          t.Selected := True;
          t.Memo.Add('[' + DSName + '."' + FieldName + '"]');
          t.dx := (fSize * bmp.Canvas.TextWidth('=')) div dsgn.GridSizeX * dsgn.GridSizeX;
          dsgn.Page.Objects.Add(t);
          DataL.Add(t);
        end;
        if HorzRB.Checked then
          Inc(x, t.dx + dsgn.GridSizeX) else
          Inc(y, t.dy + dsgn.GridSizeY);
      end;

    if HorzRB.Checked then
    begin
      t := DataL[DataL.Count - 1];
      adx := t.x + t.dx;
      pdx := dsgn.Page.RightMargin - dsgn.Page.LeftMargin;
      x := dsgn.Page.LeftMargin;
      if adx > pdx then
      begin
        for i := 0 to DataL.Count - 1 do
        begin
          t := DataL[i];
          t.x := Round((t.x - x) / (adx / pdx)) + x;
          t.dx := Round(t.dx / (adx / pdx));
        end;
        if HeaderCB.Checked then
          for i := 0 to DataL.Count - 1 do
          begin
            t := HeaderL[i];
            t1 := DataL[i];
            t.x := Round((t.x - x) / (adx / pdx)) + x;
            if t.dx > t1.dx then
              t.dx := t1.dx;
          end;
      end;
    end;

    if BandCB.Checked then
    begin
      if HeaderCB.Checked then
        t := HeaderL[DataL.Count - 1] else
        t := DataL[DataL.Count - 1];
      dy := t.y + t.dy - dsgn.Page.TopMargin;
      b := frCreateObject(gtBand, '') as TfrBandView;
      b.CreateUniqueName;
      b.y := dsgn.Page.TopMargin;
      b.dy := dy;
      b.Selected := True;
      if not HeaderCB.Checked or not HorzRB.Checked then
      begin
        dsgn.Page.Objects.Add(b);
        b.BandType := btMasterData;
        b.DataSet := FindDataset(DataSet);
      end
      else
      begin
        if frCheckBand(btPageHeader) then
          b.Free
        else
        begin
          b.BandType := btPageHeader;
          dsgn.Page.Objects.Add(b);
        end;
        b := frCreateObject(gtBand, '') as TfrBandView;
        b.BandType := btMasterData;
        b.DataSet := FindDataset(DataSet);
        b.CreateUniqueName;
        b.y := dsgn.Page.TopMargin + 72;
        b.dy := dy;
        b.Selected := True;
        dsgn.Page.Objects.Add(b);
      end;
    end;
  end;
  HeaderL.Free;
  DataL.Free;
end;
{$HINTS ON}



end.

