/*
 * Decompiled with CFR 0.152.
 */
package com.softaspects.framework.galileo.components.table;

import com.softaspects.framework.galileo.components.base.Interval;

public class Cursor
extends Interval {
    private static int DEFAULT_PAGE_SIZE = 10;
    private int fStep = 0;
    private int fPageSize = DEFAULT_PAGE_SIZE;

    public Cursor(int aRowsCount, int aPageSize) {
        this.setPageSize(aPageSize);
        this.setRowsCount(aRowsCount);
        this.setTop(0);
    }

    public Cursor(int aRowsCount) {
        this(aRowsCount, DEFAULT_PAGE_SIZE);
    }

    public Cursor() {
        this(0);
    }

    public void setRowsCount(int aRowsCount) {
        this.setBottom(aRowsCount - 1);
    }

    public void setPageSize(int aPageSize) {
        if (aPageSize <= 0) {
            throw new IllegalArgumentException("Cursor: Value of segment must be positive.");
        }
        this.fPageSize = aPageSize;
    }

    public int getPageSize() {
        return this.fPageSize;
    }

    public Interval getCurrentInterval() {
        Interval result = new Interval();
        if (!this.isEmpty()) {
            result.setTop(this.fStep * this.fPageSize);
            int bottom = result.getTop() + this.fPageSize - 1;
            if (bottom > this.getBottom()) {
                bottom = this.getBottom();
            }
            result.setBottom(bottom);
        }
        return result;
    }

    public int getCurrentIntervalFirstIndex() {
        return this.getCurrentInterval().getTop();
    }

    public int getCurrentIntervalLastIndex() {
        return this.getCurrentInterval().getBottom();
    }

    public int getCurrentIntervalLength() {
        return this.getCurrentInterval().getLength();
    }

    public Interval goToStart() {
        this.fStep = 0;
        return this.getCurrentInterval();
    }

    public Interval goToEnd() {
        this.fStep = this.getCountSteps() - 1;
        return this.getCurrentInterval();
    }

    public Interval stepForward() {
        if (!this.isLastStep()) {
            ++this.fStep;
        }
        return this.getCurrentInterval();
    }

    public Interval stepBackward() {
        if (!this.isFirstStep()) {
            --this.fStep;
        }
        return this.getCurrentInterval();
    }

    public int getCountSteps() {
        if (!this.isEmpty()) {
            int segment = this.getPageSize();
            int result = this.getLength() / segment;
            if (this.getLength() % segment != 0) {
                ++result;
            }
            return result;
        }
        return 0;
    }

    public boolean isFirstStep() {
        return this.fStep == 0;
    }

    public boolean isLastStep() {
        return this.fStep == this.getCountSteps() - 1;
    }

    public int getCurrentStep() {
        return this.fStep;
    }

    public Interval setStep(int aStep) {
        if (aStep > this.getCountSteps() - 1) {
            return this.goToEnd();
        }
        if (aStep < 0) {
            return this.goToStart();
        }
        this.fStep = aStep;
        return this.getCurrentInterval();
    }
}

