/*
 * Decompiled with CFR 0.152.
 */
package com.softaspects.framework.galileo.renderers.html.button;

import com.softaspects.framework.galileo.components.base.ComponentBase;
import com.softaspects.framework.galileo.components.base.PresentationEvent;
import com.softaspects.framework.galileo.components.base.RendererException;
import com.softaspects.framework.galileo.renderers.html.base.ContextRendererImpl;
import com.softaspects.framework.galileo.renderers.html.base.HtmlProperty;
import com.softaspects.framework.galileo.renderers.html.base.JavaScriptProviderBase;
import com.softaspects.framework.galileo.renderers.html.base.JavaScriptResource;
import com.softaspects.framework.galileo.renderers.html.base.RendererFactory;
import com.softaspects.framework.galileo.renderers.html.button.ButtonRendererUtil;
import com.softaspects.framework.galileo.support.components.button.Button;
import com.softaspects.framework.galileo.support.components.button.Image;
import com.softaspects.framework.galileo.support.components.button.model.Model;
import com.softaspects.galileo.client.jsp.html.base.ColorFactory;
import com.softaspects.galileo.client.jsp.html.base.TagFactory;
import java.io.IOException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspWriter;

public class ButtonRenderer
extends ContextRendererImpl {
    private static final String BUTTON_MODEL_SCRIPT_WAS_LOADED = "BUTTON_MODEL_SCRIPT_WAS_LOADED";
    private static final String BUTTON_JSCRIPT_FUNCTION = "ButtonComponent";

    public String doRender() throws RendererException {
        JspWriter out = this.fPageContext.getOut();
        Button button = (Button)this.getComponent();
        try {
            Model buttonModel;
            String buttonImage;
            String textSize;
            Object flag = this.fPageContext.getAttribute(BUTTON_MODEL_SCRIPT_WAS_LOADED, 2);
            StringBuffer sBuffer = new StringBuffer();
            if (flag == null) {
                JavaScriptResource javaScriptResource = new JavaScriptProviderBase().getJavaScriptResource((HttpServletRequest)this.fPageContext.getRequest());
                sBuffer.append(RendererFactory.createJScriptBeginTag(javaScriptResource.getComponentJavaScriptSource(button.getComponentTypeName()), null));
                sBuffer.append(RendererFactory.createJScriptEndTag());
                sBuffer.append("\n");
                this.fPageContext.setAttribute(BUTTON_MODEL_SCRIPT_WAS_LOADED, (Object)BUTTON_MODEL_SCRIPT_WAS_LOADED, 2);
            }
            if (button.getTextColor() != 0) {
                String color = ColorFactory.convertColorFromIntToHtml(button.getTextColor());
                button.addStyleProperty("COLOR", color);
            }
            if ((textSize = button.getTextSize()) != null) {
                button.addStyleProperty("FONT-SIZE", textSize);
            }
            if ((buttonImage = button.getButtonImage()) != null) {
                String align = TagFactory.getAlignValue(button.getImagePosition());
                button.addStyleProperty("BACKGROUND-POSITION", align);
                String imageString = "url" + RendererFactory.parenthesizeString(buttonImage);
                button.addStyleProperty("BACKGROUND-IMAGE", imageString);
                button.addStyleProperty("BACKGROUND-REPEAT", "no-repeat");
            }
            sBuffer.append("<INPUT");
            String sType = ButtonRendererUtil.getButtonTypeName(button.getType());
            sBuffer.append(' ');
            sBuffer.append(RendererFactory.createHtmlStylePropertyString("TYPE", sType));
            Iterator htmlProperties = RendererFactory.componentHtmlPropertiesIterator(button);
            while (htmlProperties.hasNext()) {
                sBuffer.append(' ');
                HtmlProperty htmlProperty = (HtmlProperty)htmlProperties.next();
                sBuffer.append(RendererFactory.createHtmlStylePropertyString(htmlProperty));
            }
            ArrayList<HtmlProperty> aList = new ArrayList<HtmlProperty>();
            if (button.getValue() != null) {
                aList.add(new HtmlProperty("VALUE", button.getValue()));
            }
            if (button.getType() == 3) {
                Image imageButton = (Image)button;
                if (imageButton.getImageSrc() != null) {
                    aList.add(new HtmlProperty("SRC", imageButton.getImageSrc()));
                }
                if (imageButton.getAltText() != null) {
                    aList.add(new HtmlProperty("ALT", imageButton.getAltText()));
                }
                if (imageButton.getHightLightSrc() != null) {
                    imageButton.addPresentationEvent(5, RendererFactory.createHtmlStylePropertyString("this.src", imageButton.getHightLightSrc()));
                    imageButton.addPresentationEvent(3, RendererFactory.createHtmlStylePropertyString("this.src", imageButton.getImageSrc()));
                }
            }
            if ((buttonModel = button.getButtonModel()).isPressed() && (button.getType() == 4 || button.getType() == 5)) {
                aList.add(new HtmlProperty("CHECKED", null));
            }
            Iterator uniqHtmlProperty = ((AbstractList)aList).iterator();
            while (uniqHtmlProperty.hasNext()) {
                sBuffer.append(' ');
                HtmlProperty htmlProperty = (HtmlProperty)uniqHtmlProperty.next();
                sBuffer.append(RendererFactory.createHtmlStylePropertyString(htmlProperty));
            }
            Iterator presentationEvents = button.getPresentationEvents();
            while (presentationEvents.hasNext()) {
                sBuffer.append(' ');
                PresentationEvent presentationEvent = (PresentationEvent)presentationEvents.next();
                String type = RendererFactory.getPresentationEventName(presentationEvent.getType());
                String value = presentationEvent.getValue();
                sBuffer.append(RendererFactory.createHtmlStylePropertyString(type, value));
            }
            sBuffer.append('>');
            StringBuffer params = new StringBuffer();
            params.append(button.isFocused());
            params.append(',');
            params.append(button.isRequired());
            sBuffer.append(RendererFactory.createHtmlJScriptVariable((ComponentBase)button, BUTTON_JSCRIPT_FUNCTION, params.toString()));
            String result = sBuffer.toString();
            if (button.isPageContextRendering()) {
                out.println(result);
            }
            return result;
        }
        catch (IOException e) {
            throw new RendererException(e.toString());
        }
    }
}

