/*
 * Decompiled with CFR 0.152.
 */
package com.softaspects.framework.galileo.renderers.html.container.layout;

import com.softaspects.framework.galileo.components.base.Component;
import com.softaspects.framework.galileo.components.base.Constraint;
import com.softaspects.framework.galileo.components.base.RendererException;
import com.softaspects.framework.galileo.renderers.html.base.RendererFactory;
import com.softaspects.framework.galileo.renderers.html.container.layout.TableBasedLayoutRenderer;
import com.softaspects.framework.galileo.support.components.container.Container;
import com.softaspects.framework.galileo.support.components.container.constraint.BorderConstraint;
import com.softaspects.framework.galileo.support.components.container.layout.BorderLayoutManager;
import java.io.IOException;
import java.util.Iterator;

public class BodrerLayoutRendererEastWest
extends TableBasedLayoutRenderer {
    private static final int BORDER_NORTH_VALUE = 4;
    private static final int BORDER_SOUTH_VALUE = 2;
    private static final int BORDER_CENTER_VALUE = 0;
    private static final int BORDER_WEST_VALUE = 1;
    private static final int BORDER_EAST_VALUE = 3;

    public String intoTableComponensRender(Container aContainer) throws RendererException {
        StringBuffer sBuffer = new StringBuffer();
        BorderLayoutManager borderLayout = (BorderLayoutManager)aContainer.getLayoutManager();
        int rowCount = borderLayout.getCountRows(aContainer);
        int colCount = borderLayout.getCountColumns(aContainer);
        int defaultAlign = borderLayout.getDefaultAlign();
        int defaultValign = borderLayout.getDefaultValign();
        Component firstComponent = this.findComponentForFirstRow(borderLayout);
        int borderFirstComponent = -1;
        if (firstComponent != null) {
            borderFirstComponent = 0;
            Constraint constraint = firstComponent.getConstraint();
            if (constraint != null && constraint instanceof BorderConstraint) {
                borderFirstComponent = ((BorderConstraint)constraint).getBorder();
            }
        }
        try {
            if (colCount > 0) {
                sBuffer.append(RendererFactory.indentString(1, "<TR>"));
                sBuffer.append(this.renderEastWestComponents(borderLayout.getLayoutComponents(1), rowCount, defaultAlign, defaultValign));
                if (firstComponent != null) {
                    sBuffer.append(this.renderComponentIntoCell(firstComponent, 0, defaultAlign, defaultValign));
                }
                sBuffer.append(this.renderEastWestComponents(borderLayout.getLayoutComponents(3), rowCount, defaultAlign, defaultValign));
                sBuffer.append(RendererFactory.indentString(1, "</TR>"));
            }
            sBuffer.append(this.renderNorthSouthComponents(borderLayout.getLayoutComponents(4), borderFirstComponent == 4, defaultAlign, defaultValign));
            if (borderLayout.getCountLayoutComponents(0) > 0) {
                sBuffer.append(RendererFactory.indentString(1, "<TR>"));
                Iterator centerComponents = borderLayout.getLayoutComponents(0);
                boolean isFirstComponent = true;
                if (borderFirstComponent == 0) {
                    String td = RendererFactory.createHtmlStartTagForTableCell(firstComponent, -1, -1, defaultAlign, defaultValign);
                    sBuffer.append(RendererFactory.indentString(2, td));
                    centerComponents.next();
                    isFirstComponent = false;
                }
                while (centerComponents.hasNext()) {
                    Component component = (Component)centerComponents.next();
                    if (isFirstComponent) {
                        String td = RendererFactory.createHtmlStartTagForTableCell(component, -1, -1, defaultAlign, defaultValign);
                        sBuffer.append(RendererFactory.indentString(2, td));
                        isFirstComponent = false;
                    }
                    sBuffer.append(this.renderComponent(component));
                }
                sBuffer.append(RendererFactory.indentString(2, "</TD>"));
                sBuffer.append(RendererFactory.indentString(1, "</TR>"));
            }
            sBuffer.append(this.renderNorthSouthComponents(borderLayout.getLayoutComponents(2), borderFirstComponent == 2, defaultAlign, defaultValign));
            return sBuffer.toString();
        }
        catch (IOException e) {
            throw new RendererException(e.toString());
        }
    }

    private String renderComponentIntoCell(Component aComponent, int aRowSpan, int aDefaultAlign, int aDefaultValign) throws RendererException, IOException {
        StringBuffer sBuffer = new StringBuffer();
        if (aComponent != null) {
            String td = RendererFactory.createHtmlStartTagForTableCell(aComponent, -1, aRowSpan, aDefaultAlign, aDefaultValign);
            sBuffer.append(RendererFactory.indentString(2, td));
            sBuffer.append(this.renderComponent(aComponent));
            sBuffer.append(RendererFactory.indentString(2, "</TD>"));
        }
        return sBuffer.toString();
    }

    private String renderEastWestComponents(Iterator aComponents, int aRowSpan, int aDefaultAlign, int aDefaultValign) throws RendererException, IOException {
        StringBuffer sBuffer = new StringBuffer();
        while (aComponents.hasNext()) {
            Component component = (Component)aComponents.next();
            sBuffer.append(this.renderComponentIntoCell(component, aRowSpan, aDefaultAlign, aDefaultValign));
        }
        return sBuffer.toString();
    }

    private String renderNorthSouthComponents(Iterator aComponents, boolean aStartFromSecond, int aDefaultAlign, int aDefaultValign) throws RendererException, IOException {
        StringBuffer sBuffer = new StringBuffer();
        if (aComponents.hasNext() && aStartFromSecond) {
            aComponents.next();
        }
        while (aComponents.hasNext()) {
            sBuffer.append(RendererFactory.indentString(1, "<TR>"));
            Component component = (Component)aComponents.next();
            sBuffer.append(this.renderComponentIntoCell(component, 0, aDefaultAlign, aDefaultValign));
            sBuffer.append(RendererFactory.indentString(1, "</TR>"));
        }
        return sBuffer.toString();
    }

    private Component findComponentForFirstRow(BorderLayoutManager aBorderLayout) {
        Iterator components = aBorderLayout.getLayoutComponents(4);
        if (components.hasNext()) {
            return (Component)components.next();
        }
        components = aBorderLayout.getLayoutComponents(0);
        if (components.hasNext()) {
            return (Component)components.next();
        }
        components = aBorderLayout.getLayoutComponents(2);
        if (components.hasNext()) {
            return (Component)components.next();
        }
        return null;
    }
}

