/*
 * Decompiled with CFR 0.152.
 */
package com.softaspects.framework.galileo.renderers.html.table;

import com.softaspects.framework.galileo.components.base.RendererException;
import com.softaspects.framework.galileo.components.table.InterfaceManager;
import com.softaspects.framework.galileo.components.table.Table;
import com.softaspects.framework.galileo.renderers.html.base.RendererFactory;
import com.softaspects.framework.galileo.renderers.html.table.AbstractCellEditor;
import com.softaspects.framework.galileo.renderers.html.table.AbstractTableRenderer;
import com.softaspects.framework.galileo.renderers.html.table.RendererUtils;
import com.softaspects.galileo.client.jsp.html.base.ColorFactory;

public class DefaultCellEditor
extends AbstractCellEditor {
    public Object getValue() {
        Object value = this.getTable().getValueAt(this.getRowIndex(), this.getColumnIndex());
        return value == null ? "" : value.toString();
    }

    protected String getTextValue() {
        return (String)this.getValue();
    }

    public String makeRender() throws RendererException {
        String funcOnChange;
        String funcOnBlur;
        boolean edited;
        boolean focused;
        boolean selected;
        int foreground;
        Table table = this.getTable();
        InterfaceManager interfaceManager = table.getInterfaceManager();
        StringBuffer sBuffer = new StringBuffer();
        int rowIndex = this.getRowIndex();
        int columnIndex = this.getColumnIndex();
        String editId = RendererUtils.getTableCellEditorId(table, rowIndex, columnIndex);
        sBuffer.append("<INPUT");
        sBuffer.append(' ');
        sBuffer.append(RendererFactory.createHtmlStylePropertyString("ID", editId));
        sBuffer.append(' ');
        sBuffer.append(RendererFactory.createHtmlStylePropertyString("TYPE", "TEXT"));
        sBuffer.append(' ');
        sBuffer.append(RendererFactory.createHtmlStylePropertyString("VALUE", this.getTextValue()));
        int maxLength = table.getColumnMaxLength(columnIndex);
        if (maxLength != -1) {
            sBuffer.append(' ');
            sBuffer.append(RendererFactory.createHtmlStylePropertyString("MAXLENGTH", maxLength));
        }
        StringBuffer style = new StringBuffer();
        style.append(RendererFactory.createHtmlStyleString("BACKGROUND", "TRANSPARENT"));
        if (table.getColumnPrefferedWidth(columnIndex) != null || table.getEditorMode() == 1) {
            style.append(RendererFactory.createHtmlStyleString("WIDTH", "100%"));
        }
        if (table.getRowHeight() != null || table.getEditorMode() == 1) {
            style.append(RendererFactory.createHtmlStyleString("HEIGHT", "100%"));
        }
        if ((foreground = interfaceManager.getCellForeground(selected = table.isCellSelected(rowIndex, columnIndex), focused = false, edited = false, rowIndex, columnIndex)) != 0) {
            String color = ColorFactory.convertColorFromIntToHtml(foreground);
            style.append(RendererFactory.createHtmlStyleString("COLOR", color));
        }
        sBuffer.append(' ');
        sBuffer.append(RendererFactory.createHtmlStylePropertyString("STYLE", style.toString()));
        String funcOnFocus = AbstractTableRenderer.createEventFunction(interfaceManager.getJScriptFunctionOnEditFocus(rowIndex, columnIndex), rowIndex, columnIndex);
        if (funcOnFocus == null) {
            funcOnFocus = AbstractTableRenderer.createEventFunction(table, "edit_focus", rowIndex, columnIndex);
        }
        if (funcOnFocus != null) {
            sBuffer.append(' ');
            sBuffer.append(RendererUtils.createHtmlEvent(13, funcOnFocus));
        }
        if ((funcOnBlur = AbstractTableRenderer.createEventFunction(interfaceManager.getJScriptFunctionOnEditBlur(rowIndex, columnIndex), rowIndex, columnIndex)) == null) {
            funcOnBlur = AbstractTableRenderer.createEventFunction(table, "edit_blur", rowIndex, columnIndex);
        }
        if (funcOnBlur != null) {
            sBuffer.append(' ');
            sBuffer.append(RendererUtils.createHtmlEvent(8, funcOnBlur));
        }
        if ((funcOnChange = this.getFunctionOnChange(editId, rowIndex, columnIndex)) != null) {
            sBuffer.append(' ');
            sBuffer.append(RendererFactory.createHtmlStylePropertyString("onChange", funcOnChange));
        }
        sBuffer.append('>');
        return sBuffer.toString();
    }
}

