/*
 * Decompiled with CFR 0.152.
 */
package com.softaspects.framework.galileo.renderers.html.table.additions.bitset;

import com.softaspects.framework.galileo.components.base.RendererException;
import com.softaspects.framework.galileo.renderers.html.table.DefaultCellRenderer;
import com.softaspects.framework.galileo.support.components.label.model.LabelModel;
import com.softaspects.framework.galileo.support.components.listmodel.ListDataModel;
import java.util.BitSet;

public class BitSetTableCellRenderer
extends DefaultCellRenderer {
    private static final char DEFAULT_FALSE_CHAR = ' ';
    protected static final boolean GENERATE_EXCEPTION_NULL_VALUE = false;

    public Object getValue() {
        int rowIndex = this.getRowIndex();
        int columnIndex = this.getColumnIndex();
        Object value = this.getTable().getValueAt(rowIndex, columnIndex);
        if (value == null || value instanceof BitSet) {
            return value;
        }
        return this.generateExceptionIfTypeNotCompartable(rowIndex, columnIndex, value);
    }

    protected String getTextValue() throws RendererException {
        Object value = this.getValue();
        if (value != null) {
            Object object;
            String text;
            int rowIndex = this.getRowIndex();
            int columnIndex = this.getColumnIndex();
            ListDataModel rendererData = this.getTable().getInterfaceManager().getRendererDataModel(rowIndex, columnIndex);
            if (rendererData == null) {
                BitSetTableCellRenderer.rendererException("Can't render without renderer data model.");
            }
            String string = text = (object = rendererData.getValuetAt(0)) instanceof LabelModel ? ((LabelModel)object).getText() : object.toString();
            if (text == null || text.length() == 0) {
                BitSetTableCellRenderer.rendererException("Can't render without text data.");
            }
            char[] bitSetCharMapping = text.toCharArray();
            int length = bitSetCharMapping.length;
            StringBuffer sBuffer = new StringBuffer(length);
            int i = 0;
            while (i < length) {
                sBuffer.append(((BitSet)value).get(i) ? Character.toUpperCase(bitSetCharMapping[i]) : (char)' ');
                ++i;
            }
            String result = sBuffer.toString();
            return result.trim().length() == 0 ? "&nbsp;" : result;
        }
        return "&nbsp;";
    }

    protected static void rendererException(String aText) throws RendererException {
        throw new RendererException("BitSet Renderer: " + aText);
    }
}

