/*
 * Decompiled with CFR 0.152.
 */
package com.softaspects.framework.galileo.support.components.container.layout;

import com.softaspects.framework.galileo.components.base.Component;
import com.softaspects.framework.galileo.renderers.html.container.layout.AbsoluteLayoutRenderer;
import com.softaspects.framework.galileo.support.components.container.Container;
import com.softaspects.framework.galileo.support.components.container.layout.AbsoluteLayoutManager;
import com.softaspects.framework.galileo.support.components.container.layout.LayoutManagerImpl;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;

public class AbsoluteLayoutManagerImpl
extends LayoutManagerImpl
implements AbsoluteLayoutManager {
    private String fWidth = null;
    private String fHeight = null;
    private String fTop = null;
    private String fLeft = null;
    private ArrayList fComponentsList = new ArrayList();

    public AbsoluteLayoutManagerImpl() {
        this.setRenderer(new AbsoluteLayoutRenderer());
    }

    public void setWidth(String aWidth) {
        this.validateValue(aWidth, "Width");
        this.fWidth = aWidth;
    }

    public String getWidth() {
        return this.fWidth;
    }

    public void setHeight(String aHeight) {
        this.validateValue(aHeight, "Height");
        this.fHeight = aHeight;
    }

    public String getHeight() {
        return this.fHeight;
    }

    public void setTop(String aTop) {
        this.validateValue(aTop, "Top");
        this.fTop = aTop;
    }

    public String getTop() {
        return this.fTop;
    }

    public void setLeft(String aLeft) {
        this.validateValue(aLeft, "Left");
        this.fLeft = aLeft;
    }

    public String getLeft() {
        return this.fLeft;
    }

    public void addLayoutComponent(Component aComponent) {
        if (aComponent != null) {
            this.fComponentsList.add(aComponent);
        }
    }

    public void removeLayoutComponent(Component aComponent) {
        ((AbstractCollection)this.fComponentsList).remove(aComponent);
    }

    public void removeAllLayoutComponents() {
        this.fComponentsList.clear();
    }

    public void doLayout(Container aContainer) {
        LayoutManagerImpl.validateContainer(aContainer);
        Object[] containerComponents = aContainer.getComponentsArray();
        if (!Arrays.equals(this.fComponentsList.toArray(), containerComponents)) {
            this.removeAllLayoutComponents();
            int i = 0;
            while (i < containerComponents.length) {
                this.addLayoutComponent((Component)containerComponents[i]);
                ++i;
            }
            aContainer.removeAllComponents();
            aContainer.getComponentsList().addAll(this.fComponentsList);
        }
    }

    private void validateValue(String aValue, String aName) {
        if (aValue == null || aValue.length() == 0) {
            throw new IllegalArgumentException("AbsoluteLayoutManager: " + aName + " value is invalid.");
        }
    }
}

