/*
 * Decompiled with CFR 0.152.
 */
package com.softaspects.framework.galileo.support.components.container.layout;

import com.softaspects.framework.galileo.components.base.Component;
import com.softaspects.framework.galileo.renderers.html.container.layout.GridLayoutRenderer;
import com.softaspects.framework.galileo.support.components.container.Container;
import com.softaspects.framework.galileo.support.components.container.layout.LayoutManagerImpl;
import com.softaspects.framework.galileo.support.components.container.layout.OrientationSupportedLayoutManager;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;

public class BoxLayoutManager
extends OrientationSupportedLayoutManager {
    private ArrayList fComponentsList = new ArrayList();

    public BoxLayoutManager() {
        this.setRenderer(new GridLayoutRenderer());
    }

    public int getCountRows(Container aContainer) {
        if (this.getOrientation()) {
            return 1;
        }
        this.doLayout(aContainer);
        return aContainer.getComponentsCount();
    }

    public int getCountColumns(Container aContainer) {
        if (!this.getOrientation()) {
            return 1;
        }
        this.doLayout(aContainer);
        return aContainer.getComponentsCount();
    }

    public void addLayoutComponent(Component aComponent) {
        if (aComponent != null) {
            this.fComponentsList.add(aComponent);
        }
    }

    public void removeLayoutComponent(Component aComponent) {
        ((AbstractCollection)this.fComponentsList).remove(aComponent);
    }

    public void removeAllLayoutComponents() {
        this.fComponentsList.clear();
    }

    public void doLayout(Container aContainer) {
        LayoutManagerImpl.validateContainer(aContainer);
        Object[] containerComponents = aContainer.getComponentsArray();
        if (!Arrays.equals(this.fComponentsList.toArray(), containerComponents)) {
            this.removeAllLayoutComponents();
            int i = 0;
            while (i < containerComponents.length) {
                this.addLayoutComponent((Component)containerComponents[i]);
                ++i;
            }
            aContainer.getComponentsList().clear();
            aContainer.getComponentsList().addAll(this.fComponentsList);
        }
    }
}

