/*
 * Decompiled with CFR 0.152.
 */
package com.softaspects.framework.galileo.support.components.frame;

import com.softaspects.framework.galileo.support.components.frame.Frame;
import com.softaspects.framework.galileo.support.components.frame.FrameContainer;
import com.softaspects.framework.galileo.support.components.frame.FrameContainerPolicy;
import com.softaspects.framework.galileo.support.components.frame.FrameImpl;
import com.softaspects.framework.galileo.support.components.frame.layout.FrameBorderLayoutManager;
import com.softaspects.framework.galileo.support.components.frame.layout.FrameLayoutManager;
import com.softaspects.framework.galileo.support.components.rawdata.RawData;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class FrameContainerImpl
extends FrameImpl
implements FrameContainer {
    private RawData fRawHtml = null;
    private FrameLayoutManager fFrameLayoutManager = null;
    private boolean fFrameLayoutManagerAlreadyWasSet = true;
    private ArrayList fFrameList = new ArrayList();
    private HashMap fFrameIdMap = new HashMap();

    public FrameContainerImpl() {
        this.setFrameLayoutManager(new FrameBorderLayoutManager());
    }

    public String getComponentTypeName() {
        return "FRAMESET_CONTAINER";
    }

    public int getFramesCount() {
        this.getFrameLayoutManager().doLayout(this);
        return this.fFrameList.size();
    }

    public Frame getFrame(int aIndex) {
        return (Frame)this.fFrameList.get(aIndex);
    }

    public Frame getFrame(String aId) {
        return (Frame)this.fFrameIdMap.get(aId);
    }

    public Iterator getFrames() {
        return ((AbstractList)this.fFrameList).iterator();
    }

    public Frame[] getFramesArray() {
        Frame[] array = new Frame[this.fFrameList.size()];
        return this.fFrameList.toArray(array);
    }

    public List getFramesList() {
        return this.fFrameList;
    }

    public void addFrame(Frame aFrame) {
        this.validateFrameID(aFrame);
        this.fFrameList.add(aFrame);
        this.fFrameIdMap.put(aFrame.getId(), aFrame);
        this.fFrameLayoutManager.addLayoutFrame(aFrame);
        aFrame.setParentComponent(this);
    }

    public void removeFrame(int aIndex) {
        this.removeFrame(this.getFrame(aIndex));
    }

    public void removeFrame(Frame aFrame) {
        if (aFrame != null) {
            ((AbstractCollection)this.fFrameList).remove(aFrame);
            this.fFrameIdMap.remove(aFrame.getId());
            this.fFrameLayoutManager.removeLayoutFrame(aFrame);
            aFrame.setParentComponent(null);
        }
    }

    public void removeFrame(String aId) {
        this.removeFrame(this.getFrame(aId));
    }

    public void removeAllFrames() {
        Iterator components = this.getFrames();
        while (components.hasNext()) {
            Frame component = (Frame)components.next();
            if (component == null) continue;
            component.setParentComponent(null);
        }
        this.fFrameList.clear();
        this.fFrameIdMap.clear();
        this.fFrameLayoutManager.removeAllLayoutFrames();
    }

    public boolean isEmpty() {
        return this.fFrameList.isEmpty();
    }

    public boolean isAncestorOf(Frame aFrame) {
        return this.fFrameList.contains(aFrame);
    }

    public boolean isAncestorOf(String aId) {
        return this.fFrameIdMap.containsKey(aId);
    }

    public FrameLayoutManager getFrameLayoutManager() {
        return this.fFrameLayoutManager;
    }

    public void setFrameLayoutManager(FrameLayoutManager aFrameLayoutManager) {
        if (aFrameLayoutManager == null) {
            throw new IllegalArgumentException("Frame container: Layout manager can't be null.");
        }
        if (!this.fFrameLayoutManagerAlreadyWasSet) {
            this.fFrameLayoutManagerAlreadyWasSet = true;
        } else if (FrameContainerPolicy.generateExceptionIfFrameContainerAlreadyHasLayoutManager()) {
            throw new IllegalStateException("Frame container: container already has Layout manager.");
        }
        this.fFrameLayoutManager = aFrameLayoutManager;
        this.fFrameLayoutManager.delegateRenderer(this);
    }

    public void setRawHtml(RawData aRawHtml) {
        this.fRawHtml = aRawHtml;
    }

    public RawData getRawHtml() {
        return this.fRawHtml;
    }

    private static void validateFrame(Frame aFrame) {
        if (aFrame == null) {
            throw new IllegalArgumentException("Frame container: frame can't be null.");
        }
    }

    private void validateFrameID(Frame aFrame) {
        FrameContainerImpl.validateFrame(aFrame);
        if (this.fFrameIdMap.containsKey(aFrame.getId())) {
            throw new IllegalArgumentException("Frame container: frame's ID duplication.");
        }
    }
}

