/*
 * Decompiled with CFR 0.152.
 */
package com.softaspects.framework.galileo.support.components.listmodel;

import com.softaspects.framework.galileo.support.base.Customizeable;
import com.softaspects.framework.galileo.support.components.listmodel.ListDataModel;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;

public class ListDataModelImpl
implements ListDataModel,
Customizeable {
    protected ArrayList fDataList;

    public ListDataModelImpl() {
        this.fDataList = new ArrayList();
    }

    public ListDataModelImpl(int aInitalCapability) {
        this.fDataList = new ArrayList(aInitalCapability);
    }

    public ListDataModelImpl(Collection aValues) {
        ListDataModelImpl.validateValue(aValues, "Collection");
        this.fDataList = new ArrayList(aValues);
    }

    public int getSize() {
        return this.fDataList.size();
    }

    public void addValue(Object aValue) {
        this.fDataList.add(aValue);
    }

    public void addValues(Collection aValues) {
        ListDataModelImpl.validateValue(aValues, "Collection");
        this.fDataList.addAll(aValues);
    }

    public void addValues(Object[] aValues) {
        this.fDataList.addAll(Arrays.asList(aValues));
    }

    public void removeValue(int aIndex) {
        if (aIndex >= 0 && aIndex < this.getSize()) {
            this.fDataList.remove(aIndex);
        }
    }

    public Object getValuetAt(int aIndex) {
        ListDataModelImpl.validateIndex(aIndex);
        return this.fDataList.get(aIndex);
    }

    public void setValueAt(Object aValue, int aIndex) {
        ListDataModelImpl.validateIndex(aIndex);
        if (this.isValueEditable(aIndex) && aIndex >= 0 && aIndex < this.getSize()) {
            this.fDataList.set(aIndex, aValue);
        }
    }

    public boolean isValueEditable(int aIndex) {
        ListDataModelImpl.validateIndex(aIndex);
        return true;
    }

    public boolean contains(Object aValue) {
        return this.fDataList.contains(aValue);
    }

    public int indexOf(Object aValue) {
        return this.fDataList.indexOf(aValue);
    }

    public int lastIndexOf(Object aValue) {
        return this.fDataList.lastIndexOf(aValue);
    }

    public Object[] toArray() {
        return this.fDataList.toArray();
    }

    public Iterator elements() {
        return ((AbstractList)this.fDataList).iterator();
    }

    public boolean isEmpty() {
        return this.fDataList.isEmpty();
    }

    public void clear() {
        this.fDataList.clear();
    }

    public void customize(Object anObject) {
        if (!(anObject instanceof Collection)) {
            throw new IllegalArgumentException("Collection is expected for customization of ListDataModel");
        }
        Collection object = (Collection)anObject;
        this.fDataList.clear();
        this.fDataList.addAll(object);
    }

    protected static void validateIndex(int aIndex) {
        if (aIndex < 0) {
            throw new IllegalArgumentException("ListDataModel: index can't be negative.");
        }
    }

    protected static void validateValue(Object aValue, String aName) {
        if (aValue == null) {
            throw new IllegalArgumentException("ListDataModel: " + aName + "can't be null.");
        }
    }
}

