/*
 * Decompiled with CFR 0.152.
 */
package com.softaspects.framework.galileo.support.util;

import com.softaspects.framework.galileo.support.util.HashedList;
import com.softaspects.framework.galileo.support.util.HashedListStrategy;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;

public class HashedArrayList
extends ArrayList
implements HashedList {
    protected HashedListStrategy fHashedListStrategy = null;
    public static final HashedList EMPTY_LIST = new HashedArrayList(0){

        protected Object getKeyForObject(Object anObject) {
            return null;
        }
    };
    private HashMap fHashMap = new HashMap();

    public HashedArrayList() {
    }

    public HashedArrayList(HashedListStrategy aHashedListStrategy) {
        this.fHashedListStrategy = aHashedListStrategy;
    }

    public HashedArrayList(int anInitialCapacity) {
        super(anInitialCapacity);
    }

    public HashedArrayList(int anInitialCapacity, HashedListStrategy aHashedListStrategy) {
        super(anInitialCapacity);
        this.fHashedListStrategy = aHashedListStrategy;
    }

    protected Object getKeyForObject(Object anObject) {
        if (this.fHashedListStrategy != null) {
            return this.fHashedListStrategy.getKeyForObject(anObject);
        }
        throw new IllegalStateException("The hashed list strategy should be specified");
    }

    public Object get(Object aKey) {
        if (this.fHashMap.size() != this.size()) {
            this.buildHashMap();
        }
        return this.fHashMap.get(aKey);
    }

    protected void buildHashMap() {
        this.fHashMap.clear();
        Iterator iter = ((AbstractList)this).iterator();
        while (iter.hasNext()) {
            Object value = iter.next();
            this.fHashMap.put(this.getKeyForObject(value), value);
        }
    }

    public void add(int index, Object element) {
        Object value = element;
        super.add(index, value);
        this.fHashMap.put(this.getKeyForObject(value), value);
    }

    public boolean add(Object element) {
        this.add(this.size(), element);
        return true;
    }

    public boolean addAll(Collection c) {
        Iterator iter = c.iterator();
        while (iter.hasNext()) {
            this.add(iter.next());
        }
        return c.size() > 0;
    }

    public boolean addAll(int index, Collection c) {
        Iterator iter = c.iterator();
        while (iter.hasNext()) {
            this.add(index++, iter.next());
        }
        return c.size() > 0;
    }
}

