/*
 * Decompiled with CFR 0.152.
 */
package com.softaspects.galileo.client.jsp.html.base;

import com.softaspects.framework.galileo.support.util.ReverseHashMap;
import com.softaspects.galileo.client.jsp.html.base.Colors;

public class ColorFactory
implements Colors {
    private static ReverseHashMap fColorsMap = new ReverseHashMap();
    public static final int COLOR_NOT_GIVEN = 0;

    static {
        ColorFactory.initColors();
    }

    private static void initColors() {
        fColorsMap.put(new Integer(-984833), "ALICEBLUE");
        fColorsMap.put(new Integer(-332841), "ANTIQUEWHITE");
        fColorsMap.put(new Integer(-16711681), "AQUA");
        fColorsMap.put(new Integer(-8388652), "AQUAMARINE");
        fColorsMap.put(new Integer(-983041), "AZURE");
        fColorsMap.put(new Integer(-657956), "BEIGE");
        fColorsMap.put(new Integer(-6972), "BISQUE");
        fColorsMap.put(new Integer(-16777216), "BLACK");
        fColorsMap.put(new Integer(-5171), "BLANCHEDALMOND");
        fColorsMap.put(new Integer(-16776961), "BLUE");
        fColorsMap.put(new Integer(-7722014), "BLUEVIOLET");
        fColorsMap.put(new Integer(-5952982), "BROWN");
        fColorsMap.put(new Integer(-2180985), "BURLYWOOD");
        fColorsMap.put(new Integer(-10510688), "CADETBLUE");
        fColorsMap.put(new Integer(-2987746), "CHOCOLATE");
        fColorsMap.put(new Integer(-32944), "CORAL");
        fColorsMap.put(new Integer(-10185235), "CORNFLOWERBLUE");
        fColorsMap.put(new Integer(-1828), "CORNSILK");
        fColorsMap.put(new Integer(-2354116), "CRIMSON");
        fColorsMap.put(new Integer(-16711681), "CYAN");
        fColorsMap.put(new Integer(-16777077), "DARKBLUE");
        fColorsMap.put(new Integer(-16741493), "DARKCYAN");
        fColorsMap.put(new Integer(-4684277), "DARKGOLDENROD");
        fColorsMap.put(new Integer(-5658199), "DARKGRAY");
        fColorsMap.put(new Integer(-16751616), "DARKGREEN");
        fColorsMap.put(new Integer(-4343957), "DARKKHAKI");
        fColorsMap.put(new Integer(-7667573), "DARKMAGENTA");
        fColorsMap.put(new Integer(-29696), "DARKORANGE");
        fColorsMap.put(new Integer(-6737204), "DARKORCHID");
        fColorsMap.put(new Integer(-7667712), "DARKRED");
        fColorsMap.put(new Integer(-1468806), "DARKSALMON");
        fColorsMap.put(new Integer(-7357297), "DARKSEAGREEN");
        fColorsMap.put(new Integer(-12042869), "DARKSLATEBLUE");
        fColorsMap.put(new Integer(-13676721), "DARKSLATEGRAY");
        fColorsMap.put(new Integer(-16724271), "DARKTURQUOISE");
        fColorsMap.put(new Integer(-7077677), "DARKVIOLET");
        fColorsMap.put(new Integer(-60269), "DEEPPINK");
        fColorsMap.put(new Integer(-16728129), "DEEPSKYBLUE");
        fColorsMap.put(new Integer(-9868951), "DIMGRAY");
        fColorsMap.put(new Integer(-14774017), "DODGERBLUE");
        fColorsMap.put(new Integer(-1296), "FLORALWHITE");
        fColorsMap.put(new Integer(-14513374), "FORESTGREEN");
        fColorsMap.put(new Integer(-65281), "FUCHSIA");
        fColorsMap.put(new Integer(-2302756), "GAINSBORO");
        fColorsMap.put(new Integer(-460545), "GHOSTWHITE");
        fColorsMap.put(new Integer(-10496), "GOLD");
        fColorsMap.put(new Integer(-2448096), "GOLDENROD");
        fColorsMap.put(new Integer(-8355712), "GRAY");
        fColorsMap.put(new Integer(-16744448), "GREEN");
        fColorsMap.put(new Integer(-5374161), "GREENYELLOW");
        fColorsMap.put(new Integer(-983056), "HONEYDEW");
        fColorsMap.put(new Integer(-38476), "HOTPINK");
        fColorsMap.put(new Integer(-3318692), "INDIANRED");
        fColorsMap.put(new Integer(-16), "IVORY");
        fColorsMap.put(new Integer(-989556), "KHAKI");
        fColorsMap.put(new Integer(-1644806), "LAVENDER");
        fColorsMap.put(new Integer(-3851), "LAVENDERBLUSH");
        fColorsMap.put(new Integer(-8586240), "LAWNGREEN");
        fColorsMap.put(new Integer(-1331), "LEMONCHIFFON");
        fColorsMap.put(new Integer(-5383962), "LIGHTBLUE");
        fColorsMap.put(new Integer(-1015680), "LIGHTCORAL");
        fColorsMap.put(new Integer(-2894893), "LIGHTGREY");
        fColorsMap.put(new Integer(-2031617), "LIGHTCYAN");
        fColorsMap.put(new Integer(-329006), "LIGHTGOLDENRODYELLOW");
        fColorsMap.put(new Integer(-7278960), "LIGHTGREEN");
        fColorsMap.put(new Integer(-18751), "LIGHTPINK");
        fColorsMap.put(new Integer(-14634326), "LIGHTSEAGREEN");
        fColorsMap.put(new Integer(-7876870), "LIGHTSKYBLUE");
        fColorsMap.put(new Integer(-8943463), "LIGHTSLATEGREY");
        fColorsMap.put(new Integer(-5192482), "LIGHTSTEELBLUE");
        fColorsMap.put(new Integer(-32), "LIGHTYELLOW");
        fColorsMap.put(new Integer(-16711936), "LIME");
        fColorsMap.put(new Integer(-13447886), "LIMEGREEN");
        fColorsMap.put(new Integer(-331546), "LINEN");
        fColorsMap.put(new Integer(-65281), "MAGENTA");
        fColorsMap.put(new Integer(-8388608), "MAROON");
        fColorsMap.put(new Integer(-10039894), "MEDIUMAQUAMARINE");
        fColorsMap.put(new Integer(-4565549), "MEDIUMORCHID");
        fColorsMap.put(new Integer(-12799119), "MEDIUMSEAGREEN");
        fColorsMap.put(new Integer(-16777011), "MEDIUMBLUE");
        fColorsMap.put(new Integer(-8689426), "MEDIUMSLATEBLUE");
        fColorsMap.put(new Integer(-16713062), "MEDIUMSPRINGGREE");
        fColorsMap.put(new Integer(-12004916), "MEDIUMTURQUOISE");
        fColorsMap.put(new Integer(-3730043), "MEDIUMVIOLETRED");
        fColorsMap.put(new Integer(-15132304), "MIDNIGHTBLUE");
        fColorsMap.put(new Integer(-6943), "MISTYROSE");
        fColorsMap.put(new Integer(-6987), "MOCCASIN");
        fColorsMap.put(new Integer(-8531), "NAVAJOWHITE");
        fColorsMap.put(new Integer(-16777088), "NAVY");
        fColorsMap.put(new Integer(-133658), "OLDLACE");
        fColorsMap.put(new Integer(-23296), "ORANGE");
        fColorsMap.put(new Integer(-47872), "ORANGERED");
        fColorsMap.put(new Integer(-2461482), "ORCHID");
        fColorsMap.put(new Integer(-1120086), "PALEGOLDENROD");
        fColorsMap.put(new Integer(-6751336), "PALEGREEN");
        fColorsMap.put(new Integer(-5247250), "PALETURQUOISE");
        fColorsMap.put(new Integer(-2396013), "PALEVIOLETRED");
        fColorsMap.put(new Integer(-4139), "PAPAYAWHIP");
        fColorsMap.put(new Integer(-9543), "PEACHPUFF");
        fColorsMap.put(new Integer(-3308225), "PERU");
        fColorsMap.put(new Integer(-16181), "PINK");
        fColorsMap.put(new Integer(-2252579), "PLUM");
        fColorsMap.put(new Integer(-5185306), "POWDERBLUE");
        fColorsMap.put(new Integer(-65536), "RED");
        fColorsMap.put(new Integer(-4419697), "ROSYBROWN");
        fColorsMap.put(new Integer(-12490271), "ROYALBLUE");
        fColorsMap.put(new Integer(-7650029), "SADDLEBROWN");
        fColorsMap.put(new Integer(-360334), "SALMON");
        fColorsMap.put(new Integer(-744352), "SANDYBROWN");
        fColorsMap.put(new Integer(-13726889), "SEAGREEN");
        fColorsMap.put(new Integer(-2578), "SEASHELL");
        fColorsMap.put(new Integer(-6270419), "SIENNA");
        fColorsMap.put(new Integer(-4144960), "SILVER");
        fColorsMap.put(new Integer(-7876885), "SKYBLUE");
        fColorsMap.put(new Integer(-9807155), "SLATEBLUE");
        fColorsMap.put(new Integer(-9404272), "SLATEGRAY");
        fColorsMap.put(new Integer(-16711809), "SPRINGGREEN");
        fColorsMap.put(new Integer(-12156236), "STEELBLUE");
        fColorsMap.put(new Integer(-2968436), "TAN");
        fColorsMap.put(new Integer(-16744320), "TEAL");
        fColorsMap.put(new Integer(-2572328), "THISTLE");
        fColorsMap.put(new Integer(-40121), "TOMATO");
        fColorsMap.put(new Integer(-12525360), "TURQUOISE");
        fColorsMap.put(new Integer(-1146130), "VIOLET");
        fColorsMap.put(new Integer(-663885), "WHEAT");
        fColorsMap.put(new Integer(-1), "WHITE");
        fColorsMap.put(new Integer(-657931), "WHITESMOKE");
        fColorsMap.put(new Integer(-256), "YELLOW");
        fColorsMap.put(new Integer(-6632142), "YELLOWGREEN");
    }

    public static String convertColorFromIntToHtml(int aColor) {
        if (aColor == 0) {
            return null;
        }
        StringBuffer sb = new StringBuffer("#");
        int i = 0;
        while (i < 3) {
            int color_rgb = aColor >> 16 - 8 * i & 0xFF;
            if (color_rgb < 16) {
                sb.append('0');
            }
            sb.append(Integer.toHexString(color_rgb));
            ++i;
        }
        return sb.toString().toUpperCase();
    }

    public static int convertColorFromHtmlToInt(String aColor) {
        if (aColor == null || aColor.length() == 0) {
            throw new IllegalArgumentException("Color value not supported.");
        }
        String color = aColor.trim().toUpperCase();
        if (color.startsWith("#")) {
            try {
                int red = Integer.valueOf(color.substring(1, 3), 16);
                int green = Integer.valueOf(color.substring(3, 5), 16);
                int blue = Integer.valueOf(color.substring(5, 7), 16);
                return 0xFF000000 | red << 16 | green << 8 | blue;
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException(e.toString());
            }
        }
        Object result = fColorsMap.getKey(color);
        if (result != null) {
            return (Integer)result;
        }
        throw new IllegalArgumentException("Can't convert String to color. '" + aColor + "' not supported.");
    }
}

