/*
 * Decompiled with CFR 0.152.
 */
package com.softaspects.galileo.client.jsp.html.listmodel;

import com.softaspects.framework.galileo.components.base.Interval;
import com.softaspects.framework.galileo.support.components.listmodel.ListSelectionModel;
import com.softaspects.galileo.client.jsp.html.listmodel.ListSelectionModelSupported;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.Tag;
import javax.servlet.jsp.tagext.TagSupport;

public abstract class AbstractListSelectionModelWorker
extends TagSupport {
    private int fTop = -1;
    private int fBottom = -1;
    private Class fAncestorClass;

    public AbstractListSelectionModelWorker(Class aAncestorClass) {
        if (aAncestorClass == null) {
            throw new IllegalArgumentException("Ancestor class can't be null.");
        }
        this.fAncestorClass = aAncestorClass;
    }

    public void setTop(String aTop) {
        AbstractListSelectionModelWorker.validateValue(aTop, "Top");
        try {
            this.fTop = Integer.parseInt(aTop);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException(e.toString());
        }
    }

    public String getTop() {
        return String.valueOf(this.fTop);
    }

    public void setBottom(String aBottom) {
        AbstractListSelectionModelWorker.validateValue(aBottom, "Bottom");
        try {
            this.fBottom = Integer.parseInt(aBottom);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException(e.toString());
        }
    }

    public String getBottom() {
        return String.valueOf(this.fBottom);
    }

    protected abstract void operation(ListSelectionModel var1, Interval var2);

    public int doStartTag() throws JspException {
        ListSelectionModelSupported listSelectionModelSupport;
        if (this.fTop == -1) {
            throw new JspException("Must specify 'top' value.");
        }
        if (this.fBottom == -1) {
            this.fBottom = this.fTop;
        }
        if ((listSelectionModelSupport = (ListSelectionModelSupported)TagSupport.findAncestorWithClass((Tag)this, (Class)this.fAncestorClass)) == null) {
            throw new JspException("Can't find ancestor tag " + this.fAncestorClass.getName() + ".");
        }
        Interval interval = this.fBottom != -1 ? new Interval(this.fTop, this.fBottom) : new Interval(this.fTop);
        this.operation(listSelectionModelSupport.getListSelectionModel(), interval);
        return 0;
    }

    public void release() {
        this.fTop = -1;
        this.fBottom = -1;
    }

    protected static void validateValue(String aValue, String aName) {
        if (aValue == null || aValue.length() == 0) {
            throw new IllegalArgumentException("ListSelectionModel: " + aName + "can't be null.");
        }
    }
}

