// Copyright:    Copyright (c) 2002-2003  .
//               All rights reserved.

// Company:      SoftAspects 
//
// @version      1.5

  
  function ListDataModel(aObj)
  {
   this.fObj = aObj;

   this.addValue         = listDataModel_addValue;   
   this.removeValue      = listDataModel_removeValue;
   this.clearValues      = listDataModel_clearValues; 
   this.isEmpty          = listDataModel_isEmpty;
   this.getSize          = listDataModel_getSize;
   this.getValueAt       = listDataModel_getValueAt;
   this.setValueAt       = listDataModel_setValueAt;
   this.contains         = listDataModel_contains;
   this.indexOfValue     = listDataModel_indexOfValue;
   this.lastIndexOfValue = listDataModel_lastIndexOfValue;
   this.toArray          = listDataModel_toArray; 
  }
  
  function listDataModel_addValue(aValue)
  {
    var opt = new Option();
   opt.text  = aValue;
    this.fObj.options[this.fObj.options.length] = opt;
  }

  function listDataModel_removeValue(aIndex)
  {
   this.fObj.remove(aIndex); 
   this.fObj.length;
  }

  function listDataModel_clearValues()
  {
   while ( !this.isEmpty() ) this.removeValue(0);
  }
  
  function listDataModel_isEmpty()
  {
   return (this.getSize() == 0);
  }
  
  function listDataModel_getSize()
  {
   return this.fObj.length; 
  }
  
  function listDataModel_getValueAt(aIndex)
  {
   if (aIndex >= this.getSize()) return null;
   return this.fObj.item(aIndex).text;
  }

  function listDataModel_setValueAt(aValue, aIndex)
  {
   if (aIndex >= this.getSize()) return;
   this.fObj.item(aIndex).text = aValue;
  }

  function listDataModel_contains(aValue)
  {
   var size = this.getSize();
   for (i = 0; i < size; i++ )
   {
    if (this.getValueAt(i) == aValue) return true;
   }
   return false;
  }

  function listDataModel_indexOfValue(aValue)
  {
   var size = this.getSize();
   for (i = 0; i < size; i++ )
   {
    if (this.getValueAt(i) == aValue) return i;
   }
   return -1;
  }

  function listDataModel_lastIndexOfValue(aValue)
  {
   var size = this.getSize();
   for (i = size; i >= 0; i-- )
   {
    if (this.getValueAt(i) == aValue) return i;
   }
   return -1;
  }

  function listDataModel_toArray()
  {
   var size  = this.getSize();
   var array = new Array(size);

   for (i = 0; i < size; i++ )
   {
    array[i] = this.getValueAt(i);
   }
   return array; 
  }

//****************************************************

  function ListSelectionModel(aObj, aListBox)
  {
   this.fObj     = aObj; 
   this.fListBox = aListBox;
   
   this.setSelectionType        = listSelectionModel_setSelectionType;
   this.getSelectionType        = listSelectionModel_getSelectionType;
   this.setSelectionInterval    = listSelectionModel_setSelectionInterval;
   this.addSelectionInterval    = listSelectionModel_addSelectionInterval;
   this.removeSelectionInterval = listSelectionModel_removeSelectionInterval;
   this.getSelectionIntervals   = listSelectionModel_getSelectionIntervals;
   this.isSelected              = listSelectionModel_isSelected;
   this.clearSelection          = listSelectionModel_clearSelection;
   this.isEmpty                 = listSelectionModel_selectionIsEmpty;
  } 

   function listSelectionModel_setSelectionType(aType)
   {
    if ( !this.fListBox ) 
    {
      alert("ComboBox not supported this method");
      return;
    } 
    if (aType.toUpperCase().search("SINGLE") < 0) this.fObj.multiple = true;
      else this.fObj.multiple = false;
   }

   function listSelectionModel_getSelectionType()
   {
    if (this.fObj.multiple == false) return "SINGLE";
    return "MULTIPLE";
   }

   function listSelectionModel_setSelectionInterval( aTop, aBottom )
   {
    if (aTop == null)
    {
      alert("Illegal argument exception");
      return;
    }
    this.clearSelection();
    this.addSelectionInterval(aTop, aBottom);
   }

   function listSelectionModel_addSelectionInterval( aTop, aBottom )
   {
    if (aTop == null)
     {
      alert("Illegal argument exception");
      return;
     }
    if (this.fObj.multiple == false) aBottom = aTop;
    if (aTop > aBottom) 
    {
      s = aBottom;
      aTop = aBottom;
      aBottom = s; 
    }
    
    var size = this.fObj.length;
    if ( aBottom < size ) size = aBottom + 1;
    for (i = aTop; i < size; i++ )
    {
      this.fObj.item(i).selected = true;
    }
   }

   function listSelectionModel_removeSelectionInterval( aTop, aBottom)
   {
    if (aTop == null)
    {
     alert("Illegal argument exception");
     return;
    }
   
    if (aTop > aBottom) 
    {
     s = aBottom;
     aTop = aBottom;
     aBottom = s; 
    }

    var size = this.fObj.length ;
    if (aBottom < size) size = aBottom + 1; 
    for (i = aTop; i < size; i++ )
    {
     this.fObj.item(i).selected = false;
    } 
   }
   
   function listSelectionModel_getSelectionIntervals()
   {
    var size = this.fObj.length;
    var array = new Array();
    for (i = 0; i < size; i++ )
    {
     if (this.isSelected(i)) array[array.length] = i;
    }

    return array; 
  }

   function listSelectionModel_isSelected(aIndex)
   {
    if (aIndex == null)
    {
      alert("Illegal argument exception");
      return;
     }
    if(this.fObj.length == 0) 
   {
    return false; 
   }
   else
   { 
    return this.fObj.item(aIndex).selected;
   } 
   }

   function listSelectionModel_clearSelection()
   {
    var size = this.fObj.length;
    for (i = 0; i < size; i++ )
    {
      obj = this.fObj.item(i);
      if (obj.selected) obj.selected = false;
     }
   }

   function listSelectionModel_selectionIsEmpty()
   {
    var size = this.fObj.length;
    for (i = 0; i < size; i++ )
    {
     if (this.isSelected(i)) return false
    }
    return true;
   }

//****************************************************

  function ListComponent(aId, aListBox, aRequired)
  {
   this.fcomponent   = new Component(aId); 
   this.fObj         = this.fcomponent.getObj();
   this.fListBox     = aListBox;
   this.fRequired    = aRequired; 

   this.getId            = this.fcomponent.getId;
   this.getName          = this.fcomponent.getName;
   this.setName          = this.fcomponent.setName;
   this.getHintText      = this.fcomponent.getHintText;
   this.setHintText      = this.fcomponent.setHintText;
   this.getStyleClass    = this.fcomponent.getStyleClass;
   this.setStyleClass    = this.fcomponent.setStyleClass;
   this.getTabIndex      = this.fcomponent.getTabIndex;
   this.setTabIndex      = this.fcomponent.setTabIndex;
   this.getAccessKey     = this.fcomponent.getAccessKey;
   this.setAccessKey     = this.fcomponent.setAccessKey;
   this.isEnabled        = this.fcomponent.isEnabled;
   this.getWidth         = this.fcomponent.getWidth;
   this.setWidth         = this.fcomponent.setWidth;
   this.getHeight        = this.fcomponent.getHeight;
   this.setHeight        = this.fcomponent.setHeight;
   this.setEnabled       = this.fcomponent.setEnabled;
   this.getStyle         = this.fcomponent.getStyle;
   this.getStyleString   = this.fcomponent.getStyleString;
   this.setStyleString   = this.fcomponent.setStyleString;
   this.setFocused       = this.fcomponent.setFocused;
   this.isFocused        = this.fcomponent.isFocused;

   this.isListBox        = list_isListBox;
   this.getSize          = list_getSize;
   this.setSize          = list_setSize;
   this.hasRequiredValue = list_hasRequiredValue;

   dataModel             = new ListDataModel(this.fObj);
   this.dataModel        = dataModel;
   
   selectionModel        = new ListSelectionModel(this.fObj, aListBox);
   this.selectionModel   = selectionModel;
  }
   
   function list_isListBox()
   {
    return this.fListBox;
   } 
   
   function list_getSize()
   {
    return this.fObj.size;
   }
   
   function list_setSize(aSize)
   {
    if (!this.fListBox)
    {
     alert("ComboBox not supported this method");
     return; 
    }  
    this.fObj.size = aSize;
   }

   function list_hasRequiredValue()
   {
    if (!this.fRequired) return true;
    return !this.selectionModel.isEmpty(); 
   }

//*************************************************** 