// BarComboButton.h: interface for the CBarComboButton class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_BARCOMBOBUTTON_H__3BC1D583_B8E6_11D3_B6B4_000000000000__INCLUDED_)
#define AFX_BARCOMBOBUTTON_H__3BC1D583_B8E6_11D3_B6B4_000000000000__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "BarButton.h"

class CCoreCombo;

class CBarComboButton
{
	DECLARE_SERIAL(CBarComboButton)

public:
	void SetCurSel(short Sel);
	short GetCurSel();
	BSTR GetText();
	void SetText(BSTR bstr);
	virtual void Update();
	virtual void SetFocus();
	long ComboGetItemData(int nIndex);
	void ComboSetItemData(int nIndex, long data);
	BOOL Create( DWORD dwStyle, const RECT& rect, CWnd* pParentWnd, UINT nID );
	void ComboSetReadOnly(BOOL bReadOnly);
	BOOL ComboGetReadOnly();
	int ComboGetListCount();
	void ComboSetListText(long nIndex, BSTR bstr);
	BSTR ComboGetListText(int nIndex);
	void ComboSetStyle(enComboStyle style);
	enComboStyle ComboGetStyle();
	void ComboSetSorted(BOOL bSorted);
	BOOL ComboGetSorted();
	void ComboRemoveString(int nIndex);
	void ComboClear();
	void ComboAddString(LPCSTR str,int nIndex);
	void virtual Serialize(CArchive& ar);
	CBarComboButton();
	virtual ~CBarComboButton();

    CCoreCombo* m_pComboBox; // Service Class
    CStringArray   m_Strings; // Combo strings array for Serialization
    CMap<int,int,long,long>  m_DataMap;
 	enComboStyle m_Style;
    BOOL    m_bSorted;
    BOOL    m_bReadOnly;
    CString m_WndText;
protected:
	BOOL GetComboText(CString& str, int nIndex);
};

#endif // !defined(AFX_BARCOMBOBUTTON_H__3BC1D583_B8E6_11D3_B6B4_000000000000__INCLUDED_)
