////////////////////////////////////////////////////////////////
// Copyright 1999-2001 Dmitri Sviridov, ActiveXStore.com
// 
//
// PropComboDlg.cpp : implementation file
//

#include "stdafx.h"
#include "cutecontrols.h"
#include "PropComboDlg.h"
#include "BarPropPage.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

HBITMAP  _CopyBitmap(HBITMAP hBmpSrc);
int _EditPicture(HWND Parent, HBITMAP hBmp, int cx, int cy, HBITMAP& hNewBmp);

/////////////////////////////////////////////////////////////////////////////
// CPropComboDlg dialog


CPropComboDlg::CPropComboDlg(CWnd* pParent)
	: CDialog(CPropComboDlg::IDD, pParent)
{
    m_pItemProp = NULL;
    m_bLoaded = FALSE;
	//{{AFX_DATA_INIT(CPropComboDlg)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
    Create(IDD_COMBOPROP_DLG, pParent);
}

CPropComboDlg::~CPropComboDlg()
{
	AFX_MANAGE_STATE(AfxGetStaticModuleState())
    DestroyWindow();
}


BEGIN_MESSAGE_MAP(CPropComboDlg, CDialog)
	//{{AFX_MSG_MAP(CPropComboDlg)
	ON_BN_CLICKED(IDC_BTN_PICTURE, OnBtnPicture)
	ON_BN_CLICKED(IDC_BUTTON_COMBO_ADD, OnButtonAdd)
	ON_BN_CLICKED(IDC_BUTTON_COMBO_DEL, OnButtonDel)
	ON_BN_CLICKED(IDC_BUTTON_COMBO_INS, OnButtonIns)
	ON_BN_CLICKED(IDC_CHECK_COMBO_SORT, OnCheckSort)
	ON_NOTIFY(NM_CLICK, IDC_LIST_COMBO_LIST, OnClickListComboList)
	ON_EN_CHANGE(IDC_EDIT_LEFT, OnChange)
	ON_EN_CHANGE(IDC_EDIT_ID, OnChange)
	ON_EN_CHANGE(IDC_EDIT_HEIGHT, OnChange)
	ON_EN_CHANGE(IDC_EDIT_COMBO_TEXT, OnChange)
	ON_BN_CLICKED(IDC_CHECK_VISIBLE, OnChange)
	ON_EN_CHANGE(IDC_EDIT_NAME, OnChange)
	ON_EN_CHANGE(IDC_EDIT_TOP, OnChange)
	ON_EN_CHANGE(IDC_EDIT_WIDTH, OnChange)
	ON_BN_CLICKED(IDC_RADIO_COMBO_STYLE_LIST, OnChange)
	ON_BN_CLICKED(IDC_RADIO_COMBO_STYLE_STD, OnChange)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CPropComboDlg message handlers

BOOL CPropComboDlg::ReadProp(IItem* pItem, COMBO_PROPERTIES* pCProp)
{
	AFX_MANAGE_STATE(AfxGetStaticModuleState())

    CComPtr<IItem> spItem = pItem;

    CComBSTR Name;
    if(FAILED(spItem->get_Name(&Name)))
        return FALSE;
    pCProp->Name = Name;

    long ID = -1;
    if(FAILED(spItem->get_ID(&ID)))
        return FALSE;
    pCProp->Id = ID;

    VARIANT_BOOL bVisible; 
    if(FAILED(spItem->get_Visible(&bVisible)))
        return FALSE;
    pCProp->Visible = bVisible ? TRUE: FALSE;

    //  Width
    long width = 0;
    if(FAILED(spItem->get_ControlWidth(&width)))
        return FALSE;
    pCProp->width = width;

    long top = 0;
    if(FAILED(spItem->get_ControlTop(&top)))
        return FALSE;
    pCProp->top = top;

    long left = 0;
    if(FAILED(spItem->get_ControlLeft(&left)))
        return FALSE;
    pCProp->left = left;

    long height = 0;
    if(FAILED(spItem->get_ControlHeight(&height)))
        return FALSE;
    pCProp->height = height;

    // Get Combo Object interface
    CComPtr<ICombo> spCombo;
    spItem->get_ComboBox(&spCombo);
    if (spCombo == NULL)
        return FALSE;

    //  ReadOnly
#ifdef COMBO_PROP_READONLY
    VARIANT_BOOL bRO = VARIANT_FALSE;
    spCombo->get_ReadOnly(&bRO);
#endif
    //  Sorted
    VARIANT_BOOL bSort = VARIANT_FALSE;
    if(FAILED(spCombo->get_Sorted(&bSort)))
        return FALSE;
    pCProp->bSort = bSort ? TRUE : FALSE;

    //  Stlyle
    enComboStyle Style = ccComboStandard;
    if(FAILED(spCombo->get_Style(&Style)))
        return FALSE;
    BOOL bList = Style == ccComboList;
    pCProp->Style = (int)Style;

    // Set Text
    long count = 0;
    if(FAILED(spCombo->get_ListCount(&count)))
        return FALSE;

    for (int i = 0; i < count; i++)
    {
        CComBSTR bstr;
        spCombo->get_ListText(i,&bstr);
        CString str(bstr);
        pCProp->Strings.Add(str);
    }

    // Set Picture
    CComPtr<IPictureDisp> pPic;
    HBITMAP hBmp = NULL;
    if (SUCCEEDED(spItem->get_Image(&pPic)))
    {
       CComQIPtr<IPicture,&IID_IPicture> spPic(pPic);
        if (spPic)
            spPic->get_Handle((UINT*)&hBmp);
    }
    pCProp->hPic = hBmp;

    return TRUE;
}

BOOL CPropComboDlg::SetProp(IItem* pItem, COMBO_PROPERTIES* pCProp)
{
	AFX_MANAGE_STATE(AfxGetStaticModuleState())
    CComPtr<IItem> spItem = pItem;

     CComBSTR Name = pCProp->Name.AllocSysString();
    if(FAILED(spItem->put_Name(Name)))
        return FALSE;

    long ID = pCProp->Id;
    if(FAILED(spItem->put_ID(ID)))
        return FALSE;

    VARIANT_BOOL bVisible = pCProp->Visible ? VARIANT_TRUE:VARIANT_FALSE;
    if(FAILED(spItem->put_Visible(bVisible)))
        return FALSE;

    enItemType type = (enItemType) pCProp->Type;
    if(FAILED(spItem->put_Type(type)))
        return FALSE;

    long width = pCProp->width;
    if(FAILED(spItem->put_ControlWidth(width)))
        return FALSE;

    long top = pCProp->top;
    if(FAILED(spItem->put_ControlTop(top)))
        return FALSE;

    long left = pCProp->left;
    if(FAILED(spItem->put_ControlLeft(left)))
        return FALSE;

    long height = pCProp->height;
    if(FAILED(spItem->put_ControlHeight(height)))
        return FALSE;

    // Get Combo Object interface
    CComPtr<ICombo> spCombo;
    spItem->get_ComboBox(&spCombo);
    if (spCombo == NULL)
        return FALSE;

    // Set ReadOnly
#ifdef COMBO_PROP_READONLY
    VARIANT_BOOL bRO = VARIANT_FALSE;
    spCombo->get_ReadOnly(&bRO);
    CheckDlgButton(IDC_CHECK_COMBO_RO,           
                  bRO ? BST_CHECKED : BST_UNCHECKED);
#endif
    // Set Sorted
    VARIANT_BOOL bSort = pCProp->bSort ? VARIANT_TRUE : VARIANT_FALSE;
    if(FAILED(spCombo->put_Sorted(bSort)))
        return FALSE;

    // Set Stlyle
    enComboStyle Style = (enComboStyle) pCProp->Style;
    if(FAILED(spCombo->put_Style(Style)))
        return FALSE;

    // Set Text
    if(FAILED(spCombo->Clear()))
        return FALSE;
    int  count = pCProp->Strings.GetSize();

    for (int i = 0; i < count; i++)
    {
        CString str = pCProp->Strings.GetAt(i);
        CComVariant var(i);
        if (FAILED(spCombo->AddString(str.AllocSysString(),&var)))
            return FALSE;
    }

    // Set Picture
    CPictureHolder* pPicHolder = new CPictureHolder;
    pPicHolder->CreateFromBitmap(pCProp->hPic);  
    if (FAILED(spItem->put_Image(pPicHolder->GetPictureDispatch())))
        return FALSE;

    return TRUE;
}

void CPropComboDlg::OnBtnPicture() 
{
    BAR_PROPRETIES*  pBarProp = m_pItemProp->pBar;
    
    int cx = pBarProp->ImageWidth;
    int cy = pBarProp->ImageHeight;

    HBITMAP hBmp = NULL;
    if (_EditPicture(m_hWnd, m_pItemProp->hPic, cx, cy,hBmp) == IDCANCEL)    
        return;

    m_pItemProp->hPic = hBmp;
    OnChange();

    // Set Picture
    CButton PicPreView;
    PicPreView.Attach(::GetDlgItem(m_hWnd, IDC_IMAGE_PREVIEW));
    PicPreView.SetBitmap(NULL);
//    if (m_pItemProp->Pic.hPic)
        PicPreView.SetBitmap(m_pItemProp->hPic);
    PicPreView.Detach();
}

void CPropComboDlg::OnButtonAdd() 
{
    CEdit edit;
    edit.Attach(::GetDlgItem(m_hWnd, IDC_EDIT_COMBO_TEXT));
    CString str;
    edit.GetWindowText(str);
    if (!str.IsEmpty())
    {
        CListCtrl list;
        list.Attach(::GetDlgItem(m_hWnd, IDC_LIST_COMBO_LIST));
        int nItem = list.GetItemCount();
        list.InsertItem(nItem,str);
        list.Detach();
        edit.SetWindowText("");
        OnChange();
    }
    edit.Detach();

}

void CPropComboDlg::OnButtonDel() 
{
   CListCtrl list;
   list.Attach(::GetDlgItem(m_hWnd,IDC_LIST_COMBO_LIST));
   
    POSITION pos = list.GetFirstSelectedItemPosition();
    if (pos != NULL)
    {
        int nItem = list.GetNextSelectedItem(pos);
        list.DeleteItem(nItem);
        OnChange();
    }
    list.Detach();	
}

void CPropComboDlg::OnButtonIns() 
{
    CEdit edit;
    edit.Attach(::GetDlgItem(m_hWnd, IDC_EDIT_COMBO_TEXT));
    CString str;
    edit.GetWindowText(str);
    if (!str.IsEmpty())
    {
        CListCtrl list;
        list.Attach(::GetDlgItem(m_hWnd, IDC_LIST_COMBO_LIST));
        POSITION pos = list.GetFirstSelectedItemPosition();
        if (pos != NULL)
        {
            int nItem = list.GetNextSelectedItem(pos);
            list.InsertItem(nItem,str);
            OnChange();
        }
        list.Detach();
    }
    edit.Detach();	
}

BOOL CPropComboDlg::Update(COMBO_PROPERTIES *pProp)
{
    if (!pProp || !pProp->bDirty) return FALSE;

    int ID = GetDlgItemInt(IDC_EDIT_ID);
   pProp->Id = ID;

   TCHAR buffer[256];
   GetDlgItemText(IDC_EDIT_NAME,buffer,sizeof(buffer));
   pProp->Name = buffer; // CSting copy

   BOOL bChk = IsDlgButtonChecked(IDC_CHECK_VISIBLE ) == BST_CHECKED;
   pProp->Visible = bChk;

   bChk = IsDlgButtonChecked(IDC_CHECK_ENABLED) == BST_CHECKED;
   pProp->Enabled = bChk;

    bChk = IsDlgButtonChecked(IDC_CHECK_COMBO_SORT) == BST_CHECKED;
    pProp->bSort = bChk;
    
    bChk = IsDlgButtonChecked(IDC_CHECK_COMBO_SORT) == BST_CHECKED;
    pProp->bSort = bChk;

    BOOL bChkStd = IsDlgButtonChecked(IDC_RADIO_COMBO_STYLE_STD)
                    == BST_CHECKED;
    enComboStyle Style = bChkStd ? ccComboStandard:ccComboList;
    pProp->Style = Style;

    //======= Common with Combo & Label
     int height = GetDlgItemInt(IDC_EDIT_HEIGHT);
     pProp->height = height;

     int width = GetDlgItemInt(IDC_EDIT_WIDTH);
     pProp->width = width;

     int top = GetDlgItemInt(IDC_EDIT_TOP);
     pProp->top = top;

     int left = GetDlgItemInt(IDC_EDIT_LEFT);
     pProp->left = left;

    CListCtrl list;
    list.Attach(::GetDlgItem(m_hWnd, IDC_LIST_COMBO_LIST));
    int count = list.GetItemCount();
    pProp->Strings.RemoveAll();

    for (int i = 0; i < count; i++)
    {
        CString str;
        str = list.GetItemText( i, 0);
        pProp->Strings.Add(str);
    }

    list.Detach();

    return TRUE;
}

void CPropComboDlg::OnCheckSort() 
{
    BOOL bChk = IsDlgButtonChecked(IDC_CHECK_COMBO_SORT) == BST_CHECKED;
    CComboBox ComboBox;
    ComboBox.Attach(::GetDlgItem(m_hWnd, IDC_LIST_COMBO_LIST));
    ComboBox.ModifyStyle( bChk ? 0 : CBS_SORT, bChk ? CBS_SORT :0 );
    ComboBox.Detach();
    OnChange();
}

void CPropComboDlg::OnClickListComboList(NMHDR* pNMHDR, LRESULT* pResult) 
{
    CListCtrl list;
    LPNMHEADER pHd= (LPNMHEADER)pNMHDR;
    int nItem = pHd->iItem;
    list.Attach(::GetDlgItem(m_hWnd, IDC_LIST_COMBO_LIST));
    CString str = list.GetItemText(nItem,0);
    list.Detach();
    if (!str.IsEmpty())
        SetDlgItemText(IDC_EDIT_COMBO_TEXT,str);
   
	
	*pResult = 0;
}

void CPropComboDlg::OnChange() 
{
   if (m_pItemProp && m_bLoaded)
   {
        m_pItemProp->bDirty = TRUE;		
	    Update(m_pItemProp);
        // Notify Propery page to turn on "Apply" button
       ::PostMessage(::GetParent(m_hWnd),WM_MODIFIED, NULL, NULL); 
   }
}

BOOL CPropComboDlg::OnInitDialog() 
{
	CDialog::OnInitDialog();
	
	// TODO: Add extra initialization here
	
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

BOOL CPropComboDlg::ShowData(COMBO_PROPERTIES *pCProp)
{
	AFX_MANAGE_STATE(AfxGetStaticModuleState())
    m_pItemProp = pCProp;
    m_bLoaded = FALSE;  // Prop page SetDirty update protection

    SetDlgItemText(IDC_EDIT_NAME, pCProp->Name);

    // Set ID
    SetDlgItemInt(IDC_EDIT_ID, pCProp->Id);

    // Set Visible
    CheckDlgButton(IDC_CHECK_VISIBLE,           // Set the check box
                  pCProp->Visible ? BST_CHECKED : BST_UNCHECKED);
    // Set Enabled
    CheckDlgButton(IDC_CHECK_ENABLED,           
                  pCProp->Enabled ? BST_CHECKED : BST_UNCHECKED);

    //  Width
    SetDlgItemInt(IDC_EDIT_WIDTH,pCProp->width,FALSE);

    SetDlgItemInt(IDC_EDIT_TOP,pCProp->top,FALSE);

    SetDlgItemInt(IDC_EDIT_LEFT,pCProp->left,FALSE);

    SetDlgItemInt(IDC_EDIT_HEIGHT,pCProp->height,FALSE);

    //  Sorted
    CheckDlgButton(IDC_CHECK_COMBO_SORT,           
                  pCProp->bSort ? BST_CHECKED : BST_UNCHECKED);

    //  Stlyle
    BOOL bList = pCProp->Style == ccComboList;
    CheckDlgButton(IDC_RADIO_COMBO_STYLE_STD,           
                  !bList ? BST_CHECKED : BST_UNCHECKED);
    CheckDlgButton(IDC_RADIO_COMBO_STYLE_LIST,           
                  bList ? BST_CHECKED : BST_UNCHECKED);

    // Set Text
    long count = pCProp->Strings.GetSize();
    CListCtrl list;
    list.Attach(::GetDlgItem(m_hWnd,IDC_LIST_COMBO_LIST));
    list.DeleteAllItems();

    for (int i = 0; i < count; i++)
        list.InsertItem(i,pCProp->Strings.GetAt(i));
    list.Detach();

    // Set Picture
    CButton PicPreView;
    PicPreView.Attach(::GetDlgItem(m_hWnd, IDC_IMAGE_PREVIEW));
    PicPreView.SetBitmap(NULL);
    if (pCProp->hPic)
        PicPreView.SetBitmap(pCProp->hPic);
    PicPreView.Detach();

    m_bLoaded = TRUE;

    return TRUE;
}
