//	CWINSOCK.CPP
//  Implements the CWinsock class.
//
//  You are free to use and distribute this and all the other 
//  files included in this sample without fee for educational
//  purposes.  This notice must be included with all distributions
//
//  Released July 1996.
//
//  Copyright (c) 1996, by Donald C. Asonye
//  Email address as of now:  donald@uh.edu
//

#include <afx.h>
#include <afxwin.h>
#include <windows.h> 
#include "stdafx.h"
#include "cwinsock.h"

// a reminder of the WSAData structure
/*struct WSAData { 
    WORD            wVersion; 
    WORD            wHighVersion; 
    char            szDescription[WSADESCRIPTION_LEN+1]; 
    char            szSystemStatus[WSASYSSTATUS_LEN+1]; 
    unsigned short  iMaxSockets; 
    unsigned short  iMaxUdpDg; 
    char FAR *      lpVendorInfo; 
}; */

// initialize statics for class...
WSAData CWinsock::WsaData;
unsigned int CWinsock::m_nInstances=0;	// we use this to tell how many instances
										// of this class that we have.
										// this probably does not matter anymore in win32

// define message map for CWinsock
BEGIN_MESSAGE_MAP(CWinsock,CWnd)
    //{{AFX_MSG_MAP(CWinsock)
	ON_MESSAGE(WM_WINSOCK_EVENT, OnWinsockEvent)
		// NOTE - the ClassWizard will add and remove mapping macros here.
		//    DO NOT EDIT what you see in these blocks of generated code!
	//}}AFX_MSG_MAP 
	
END_MESSAGE_MAP()
 
/////////////////////////////////////////////////////////////
CWinsock::CWinsock(CWnd* pParent)
{ 
	RECT Rect={0,0,0,0};
	
	// let us create the window.  it's a child of pParent.
	Create(NULL,NULL,WS_CHILD,Rect,pParent,NULL);

	// if we are the first one, then initialize 
	if (!m_nInstances)
	{
		int ret = WSAStartup(0x0101, &WsaData);
		if( ret != 0 )
		{
			AfxMessageBox("WSAStartup failed");
		}
	}		
	
	m_nInstances++;		// static data: only one instance of winsock
	                    // this does not matter much on nt (win32).

	m_hSocket=INVALID_SOCKET;
}  

/////////////////////////////////////////////////////////////
CWinsock::~CWinsock()
{	
	m_nInstances--;	  // decrement 

	// if we are the last one then clean up (important stuff!)
	if (!m_nInstances)
	{
		if( m_hSocket != INVALID_SOCKET )
		{
			CloseSocket();
		}
		WSACleanup();
	}
}

/////////////////////////////////////////////////////////////
// 		function definitions
/////////////////////////////////////////////////////////////
// use this function to connect to a host on a port
SOCKET CWinsock::ConnectToServer(const char *name, const char *port)
{
	SOCKET s = INVALID_SOCKET;

	struct sockaddr_in far server;
	struct hostent far *hp;
	char msg[100];

	int portnum = atoi(port);

	while( *name != 0 && *name == ' ' )
	{
		name++;
	}

	if( *name == 0 || portnum == 0)
	{
		return INVALID_SOCKET;
	}

	if( (name[0] >= '0') && (name[0] <= '9') ) 
	{
		memset((char *) &server,0,sizeof(server));
		server.sin_family      = AF_INET;
		server.sin_addr.s_addr = Inet_Addr(name);
		server.sin_port        = Htons(portnum);
	}
	else
	{ 
		if ( (hp = (hostent far *) GetHostByName(name)) == NULL)
		{
			sprintf(msg,"Error: Connecting to %s.", name);

			if(AfxMessageBox(msg,MB_OK | MB_ICONSTOP ) == IDOK)
			{
				return INVALID_SOCKET;
			}
		}
		memset((char *) &server,0,sizeof(server));
		memcpy((char *) &server.sin_addr,hp->h_addr,hp->h_length);
		server.sin_family = hp->h_addrtype;
		server.sin_port = Htons(portnum);  
	}// else 

	// create socket 
	if( (s = Socket(AF_INET, SOCK_STREAM, 0)) < 1) 
	{
		sprintf(msg,"Error opening stream socket");
		AfxMessageBox(msg,MB_OK | MB_ICONSTOP);
		return INVALID_SOCKET;
	}
  
	if (Connect((struct sockaddr far *)&server, sizeof(server),s)< 0)
	{
		sprintf(msg,"Cannot connect to %s on port %s",name,port);
		AfxMessageBox(msg,MB_OK | MB_ICONSTOP);
		return INVALID_SOCKET;
	}

	m_hSocket = s;
	SetSockOpt(SOL_SOCKET,SO_LINGER,0,0);	
	SetSockOpt(SOL_SOCKET,SO_REUSEADDR,0,0);
	SetSockOpt(SOL_SOCKET,SO_KEEPALIVE,0,0);
	SetSockOpt(SOL_SOCKET,SO_OOBINLINE,0,0);

	return s;		   
}

/////////////////////////////////////////////////////////////
SOCKET CWinsock::Accept (struct sockaddr FAR *addr, int FAR *addrlen)
{
	// call winsock api 
	if( m_hSocket == INVALID_SOCKET )
	{
		return INVALID_SOCKET;
	}
	return accept (m_hSocket, addr, addrlen);
}

/////////////////////////////////////////////////////////////
int CWinsock::Bind (const struct sockaddr FAR *addr, int namelen)
{
	// call winsock api
	if( m_hSocket == INVALID_SOCKET )
	{
		return FALSE;
	}
	return bind (m_hSocket, addr, namelen);
}

/////////////////////////////////////////////////////////////
int CWinsock::CloseSocket ()
{
	// call winsock api
	int status = closesocket (m_hSocket);
	m_hSocket = INVALID_SOCKET;
	return status; 
} 

/////////////////////////////////////////////////////////////
int CWinsock::CloseSocket( SOCKET& sock)
{
	// call winsock api	   
	int status = closesocket(sock);
	sock = INVALID_SOCKET;	   
	return status;
}

/////////////////////////////////////////////////////////////
int CWinsock::Connect (const struct sockaddr FAR *name, int namelen, SOCKET s)
{
	// call winsock api for a specified socket

	if( s == INVALID_SOCKET )
	{
		return FALSE;
	}
	return connect (s, name, namelen);
}

/////////////////////////////////////////////////////////////
int CWinsock::Connect (const struct sockaddr FAR *name, int namelen)
{
	// call winsock api for member socket
	if( m_hSocket == INVALID_SOCKET )
	{
		return FALSE;
	}
	return connect (m_hSocket, name, namelen);
}

/////////////////////////////////////////////////////////////
u_long CWinsock::Htonl (u_long hostlong)
{
	// call winsock api
	return htonl (hostlong);
}

/////////////////////////////////////////////////////////////
u_short CWinsock::Htons (u_short hostshort)
{
	// call winsock api
	return htons (hostshort);
}

/////////////////////////////////////////////////////////////
u_long CWinsock::Inet_Addr (const char FAR * cp)
{
	// call winsock api
	return inet_addr (cp);
}

/////////////////////////////////////////////////////////////
char FAR * CWinsock::Inet_Ntoa (struct in_addr in)
{
	// call winsock api
	return inet_ntoa (in);
}

/////////////////////////////////////////////////////////////
int CWinsock::Listen (int backlog)
{
	// call winsock api
	if( m_hSocket == INVALID_SOCKET )
	{
		return FALSE;
	}
	return listen (m_hSocket, backlog);  
}

/////////////////////////////////////////////////////////////
u_long CWinsock::Ntohl (u_long netlong)
{
	// call winsock api
	return ntohl (netlong);
}

/////////////////////////////////////////////////////////////
u_short CWinsock::Ntohs (u_short netshort)
{
	// call winsock api
	return ntohs(netshort);
}

/////////////////////////////////////////////////////////////
int CWinsock::Recv (char FAR * buf, int len, int flags)
{
	// call winsock api
	return recv (m_hSocket, buf, len, flags);
}

/////////////////////////////////////////////////////////////
int CWinsock::RecvFrom (char FAR * buf, int len, int flags,
                         struct sockaddr FAR *from, int FAR * fromlen)
{
	// call winsock api
	return recvfrom (m_hSocket, buf, len, flags, from, fromlen);
}

/////////////////////////////////////////////////////////////
int CWinsock::Select (int nfds, fd_set FAR *readfds, fd_set FAR *writefds,
                       fd_set FAR *exceptfds, const struct timeval FAR *timeout)
{
	// call winsock api
	if( m_hSocket == INVALID_SOCKET)
	{
		 return FALSE;
	}
	return select (nfds, readfds, writefds, exceptfds, timeout); 
}

/////////////////////////////////////////////////////////////
int CWinsock::Send (const char FAR * buf, int len, int flags)
{
	// call winsock api
	if( m_hSocket == INVALID_SOCKET)
	{
		 return FALSE;
	}
	return send (m_hSocket, buf, len, flags);
}

/////////////////////////////////////////////////////////////
int CWinsock::SendTo (const char FAR * buf, int len, int flags,
                       const struct sockaddr FAR *to, int tolen)
{
	// call winsock api
	if( m_hSocket == INVALID_SOCKET)
	{
		 return FALSE;
	}
	return sendto (m_hSocket, buf, len, flags, to, tolen);
}

/////////////////////////////////////////////////////////////
int CWinsock::SetSockOpt (int level, int optname,
                           const char FAR * optval, int optlen)
{
	// call winsock api
	if( m_hSocket == INVALID_SOCKET)
	{
		return FALSE;
	}
	return setsockopt (m_hSocket, level, optname, optval, optlen);
}

/////////////////////////////////////////////////////////////
int CWinsock::Shutdown (int how)
{
	// call winsock api
	if( m_hSocket == INVALID_SOCKET)
	{
		return FALSE;
	}
	return shutdown(m_hSocket, how);
}

/////////////////////////////////////////////////////////////
SOCKET CWinsock::Socket (int af, int type, int protocol)
{
	// call winsock api
	return socket (af, type, protocol);
}

/////////////////////////////////////////////////////////////
struct hostent FAR * CWinsock::GetHostByName(const char FAR * name)
{
	// call winsock api
	return gethostbyname(name);
}

/////////////////////////////////////////////////////////////
int CWinsock::GetHostName (char FAR * name, int namelen)
{
	// call winsock api
	return gethostname (name, namelen);
}

/////////////////////////////////////////////////////////////
int CWinsock::AsyncSelect(long lEvent)
{
	// call winsock api
	if( m_hSocket == INVALID_SOCKET)
	{
		 return FALSE;
	}
	return WSAAsyncSelect (m_hSocket,m_hWnd, WM_WINSOCK_EVENT, lEvent);
}

/////////////////////////////////////////////////////////////
// attach a socket to this object
void CWinsock::Attach(SOCKET NewSocket)
{
	if (m_hSocket != INVALID_SOCKET)
	{
		CloseSocket();
	}
	m_hSocket=NewSocket;
}

/////////////////////////////////////////////////////////////
// function to detach the socket handle
SOCKET CWinsock::Detach()
{
	SOCKET TempSocket = m_hSocket;
	m_hSocket =  INVALID_SOCKET;
	return TempSocket;
}

/////////////////////////////////////////////////////////////
// function to send the parent the message taht we juse received
LONG CWinsock::OnWinsockEvent (WPARAM wParam, LPARAM lParam)
{
	// send the message to the parent window.
	// let it do the processing as it wishes.
	GetParent()->SendMessage(WM_WINSOCK_EVENT,wParam,lParam);

	return 0L;
 } 
 
