{ Program : TEST "duongGIF" UNIT - Written by Nguyen Tuan Duong }
{ If you have any problems, please contact me : E_mail: mrTUANDUONG@Yahoo.com }
Uses graph,duongGIF;
type paltype=array [0..255] of record r,g,b:byte;end;
const
  xsid = 0.002;
  ysid = 0.002;
  xadd = -0.196005;
  yadd = 0.669916;
  maxcount = 255;
var
  x,y       : word;
  pw,pix    : word;
  numscr,wm : byte;
  count     : byte;
  xsc,ysc,left,top,zx,zy,xc,yc,tempx,bot,right : single;
  pal:paltype;

procedure init_svga;
var A,MODE:integer;
begin
  A:=InstallUserDriver('SVGA256',nil);
  MODE:=4; { mode 1024 x 768 x 256 }
  InitGraph(A,MODE,'');
end;

procedure loadpal;
var i:byte;
begin
    for i:=0 to 255 do
       begin
          Port[$3C8]:=i;
          Port[$3C9]:=Pal[i].r;
          Port[$3C9]:=Pal[i].g;
          Port[$3C9]:=Pal[i].b;
       end;
end;
procedure Setpal;
var
  a,b : word;
begin
  for a:=1 to 85 do begin
    b := a*63 div 85;
    pal[a].b     := b shl 1;
    pal[85+a].g  := b;
    pal[171-a].b := b;
    pal[256-a].g := b;
  end;
  Loadpal;
end;
procedure Draw_earth;
var XX,YY:array[1..120] of integer;
    D2,Un,Uv,K,S,X,Y,Px,Py,Bx,By,I,Sq:longint;
    Th,Sc,A,M:real;
begin
  A:=0; Un:=12; Uv:=445 div Un; K:=Uv div 2; Sc:=Uv/100; D2:=445 shr 1;
  for I:=1 to 120 do begin
    Th:=90*(0.8+0.2*Sin(72*A))*(0.5+0.5*Sin(5*A));
    XX[I]:=Trunc(Th*Cos(A));
    YY[I]:=Trunc(Th*Sin(A));
    A:=A+Pi/60;
  end;
  for Px:=1 to Un do
    for Py:=1 to Un do begin
      for I:=1 to 120 do begin
	X:=Trunc(XX[I]*Sc)+Px*Uv-D2-K;
	Y:=Trunc(YY[I]*Sc)+Py*Uv-D2-K;
	Sq:=sqr(X)+sqr(Y);
	if Sq<160*160 then begin
	  if X<0 then S:=-1 else S:=1;
	  Th:=ArcTan(Y/(X+0.1));
	  M:=160*Sin(2*ArcTan(Sqrt(Sq)/160));
	  X:=S*Trunc(M*Cos(Th));
	  Y:=S*Trunc(M*Sin(Th));
	end;
	X:=X*23 div 15+520; Y:=Y*23 div 15+380;
	if I=1 then begin MoveTo(X,Y); Bx:=X; By:=Y; end;
	SetColor((120*(Px+Py)+I) div 42+32);
	LineTo(X,Y);
      end;
      LineTo(Bx,By);
    end;
end;


FUNCTION mandelbrot(r,i :  extended):WORD;
LABEL
	fertig;
CONST
	abbruchwert : WORD = 4;
	MaxTiefe : WORD = maxcount;
{$ifopt G-}
VAR
	status : WORD;
{$endif}
BEGIN
	asm

		finit
		fld tbyte ptr [r]
		fld tbyte ptr [i]
		fldz
		fldz
		fldz
		fldz

		mov cx,[MaxTiefe]
		mov bx,[abbruchwert]
		mov dx,0

@repeat:

		fld st(1)
		fmul st(0),st(0)
		fst st(4)

		fld st(1)
		fmul st(0),st(0)
		fst st(4)
		fsub

		fadd st(0),st(6)
		fxch st(2)

		fmul
		fadd st(0),st(0)
		fadd st(0),st(4)

		inc dx

		fld st(3)
		fadd st(0),st(3)

		ficomp [abbruchwert]
		fstsw ax
		sahf
		ja fertig

		loop @repeat

fertig:

		mov @result,dx
	END;
END;

procedure Draw_Julia(dx,dy : extended);
var
  x,y,Tiefe2,Tiefe1 : WORD;

  function zyklodentest(xc,yc:extended) : integer;
  var
    r,s,x,y,x2,y2 : extended;
  begin
    y2 := yc*yc;
    x2 := xc+1.0;
    if (xc>-0.75) then begin
      r:= xc*xc+y2;
      s:= SQRT(r-0.5*xc+0.0625);
      if ((16.0*r*s)>(5.0*s-4.0*xc+1.0)) then
      Zyklodentest:=mandelbrot(xc,yc) else Zyklodentest:=4;
    end else
    if ((x2*x2+y2)>0.0625) then Zyklodentest:=mandelbrot(xc,yc) else
    Zyklodentest:=4;
  end;

begin
  yc := yadd;
  y  := 0;
  repeat
    xc := xadd;
    x  := 0;
    Tiefe1 := Zyklodentest(xc,yc);
    putpixel(x,y,Tiefe1);
    repeat
      xc := xc+dx+dx;
      Inc(x,2);
      Tiefe2:=Zyklodentest(xc,yc);
      putpixel(x,y,Tiefe2);
      if (Tiefe1 <> Tiefe2) then Tiefe1 := Zyklodentest(xc-dx,yc);
      putpixel(x-1,y,Tiefe1);
      Tiefe1 := Tiefe2;
    until (x >= getmaxX);
    xc := xadd;
    for x:=0 to getmaxX do begin
      Tiefe1 := getpixel(x,y);
      Tiefe2 := getpixel(x,y+2);
      if (Tiefe1 = Tiefe2) then putpixel(x,y+1,Tiefe1) else
      putpixel(x,y+1,Zyklodentest(xc,yc+dy));
      xc:=xc+dx;
    end;
    yc:=yc+dy+dy;
    INC(y,2);
  until y >= getmaxy;								{ !!! }
end;


begin
  init_svga;
{-PICTURE 1-}
  draw_earth;
  readln;
  saveAREAasGIF(166,29,878,739,'Earth.gif');
{-PICTURE 2-}
  cleardevice;
  setpal;
  xsc := xsid/getmaxX;
  ysc := ysid/getmaxY;
  Draw_Julia(xsc,ysc);
  readln;
  saveSCRasGIF('Julia.gif');

  closegraph;
end.