VERSION 5.00
Object = "{FBFD55C6-C23C-11D3-B65D-004005E66149}#1.0#0"; "SWIFTPRINT.OCX"
Object = "{F9043C88-F6F2-101A-A3C9-08002B2F49FB}#1.2#0"; "COMDLG32.OCX"
Object = "{BDC217C8-ED16-11CD-956C-0000C04E4C0A}#1.1#0"; "TABCTL32.OCX"
Object = "{86CF1D34-0C5F-11D2-A9FC-0000F8754DA1}#2.0#0"; "MSCOMCT2.OCX"
Begin VB.Form frmSample 
   BorderStyle     =   1  'Fixed Single
   Caption         =   "SwiftPrint SampleApp"
   ClientHeight    =   8085
   ClientLeft      =   45
   ClientTop       =   330
   ClientWidth     =   7500
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   ScaleHeight     =   8085
   ScaleWidth      =   7500
   Begin VB.Frame fProperties 
      Caption         =   "Document Settings"
      Height          =   4455
      Left            =   120
      TabIndex        =   25
      Top             =   3480
      Width           =   7215
      Begin VB.ComboBox cboOrientation 
         Height          =   315
         ItemData        =   "frmSample.frx":0000
         Left            =   1200
         List            =   "frmSample.frx":000A
         Style           =   2  'Dropdown List
         TabIndex        =   48
         Top             =   840
         Width           =   1215
      End
      Begin VB.TextBox txtPaperSize 
         BackColor       =   &H8000000F&
         Height          =   315
         Left            =   1200
         Locked          =   -1  'True
         TabIndex        =   45
         Text            =   "A4"
         Top             =   360
         Width           =   2430
      End
      Begin VB.TextBox txtNumPages 
         BackColor       =   &H8000000F&
         Height          =   315
         Left            =   1200
         Locked          =   -1  'True
         TabIndex        =   16
         Text            =   "0"
         Top             =   3960
         Width           =   1215
      End
      Begin VB.ComboBox cboUnits 
         Height          =   315
         ItemData        =   "frmSample.frx":0023
         Left            =   1200
         List            =   "frmSample.frx":0036
         Style           =   2  'Dropdown List
         TabIndex        =   10
         Top             =   1320
         Width           =   1215
      End
      Begin VB.TextBox txtPage 
         Height          =   315
         Left            =   1200
         TabIndex        =   13
         Text            =   "0"
         Top             =   2760
         Width           =   975
      End
      Begin VB.TextBox txtPageWidth 
         BackColor       =   &H8000000F&
         Height          =   315
         Left            =   1200
         Locked          =   -1  'True
         TabIndex        =   11
         Text            =   "0"
         Top             =   1800
         Width           =   1215
      End
      Begin VB.TextBox txtPageHeight 
         BackColor       =   &H8000000F&
         Height          =   315
         Left            =   1200
         Locked          =   -1  'True
         TabIndex        =   12
         Text            =   "0"
         Top             =   2280
         Width           =   1215
      End
      Begin VB.TextBox txtFirstPage 
         Height          =   315
         Left            =   1200
         TabIndex        =   15
         Text            =   "0"
         Top             =   3480
         Width           =   1215
      End
      Begin MSComCtl2.UpDown UpDown1 
         Height          =   315
         Left            =   2160
         TabIndex        =   14
         TabStop         =   0   'False
         Top             =   2760
         Width           =   240
         _ExtentX        =   423
         _ExtentY        =   556
         _Version        =   393216
         Value           =   1
         BuddyControl    =   "txtPage"
         BuddyDispid     =   196614
         OrigLeft        =   2160
         OrigTop         =   1800
         OrigRight       =   2400
         OrigBottom      =   2115
         Max             =   32766
         Min             =   1
         SyncBuddy       =   -1  'True
         BuddyProperty   =   0
         Enabled         =   -1  'True
      End
      Begin VB.Label Label14 
         AutoSize        =   -1  'True
         Caption         =   "Orientation:"
         Height          =   195
         Left            =   240
         TabIndex        =   50
         Top             =   900
         Width           =   810
      End
      Begin VB.Label Label22 
         AutoSize        =   -1  'True
         Caption         =   "Printing orientation of the paper."
         Height          =   195
         Left            =   2640
         TabIndex        =   49
         Top             =   900
         Width           =   2250
      End
      Begin VB.Label Label28 
         AutoSize        =   -1  'True
         Caption         =   "The current printer paper size. (read-only)"
         Height          =   195
         Left            =   3960
         TabIndex        =   47
         Top             =   420
         Width           =   2895
      End
      Begin VB.Label Label29 
         AutoSize        =   -1  'True
         Caption         =   "PaperSize:"
         Height          =   195
         Left            =   240
         TabIndex        =   46
         Top             =   420
         Width           =   765
      End
      Begin VB.Label Label23 
         AutoSize        =   -1  'True
         Caption         =   "Units in which to measure the page and all coordinates."
         Height          =   195
         Left            =   2640
         TabIndex        =   37
         Top             =   1380
         Width           =   3915
      End
      Begin VB.Label Label21 
         AutoSize        =   -1  'True
         Caption         =   "Total number of pages in this document. (read-only)"
         Height          =   195
         Left            =   2640
         TabIndex        =   36
         Top             =   4020
         Width           =   3615
      End
      Begin VB.Label Label20 
         AutoSize        =   -1  'True
         Caption         =   "NumPages:"
         Height          =   195
         Left            =   240
         TabIndex        =   35
         Top             =   4020
         Width           =   825
      End
      Begin VB.Label Label19 
         Caption         =   "First page number of the document.  Pages are numbered starting at this page number and must be specified as such."
         Height          =   375
         Left            =   2640
         TabIndex        =   34
         Top             =   3450
         Width           =   4335
      End
      Begin VB.Label Label18 
         Caption         =   $"frmSample.frx":0068
         Height          =   615
         Left            =   2640
         TabIndex        =   33
         Top             =   2730
         Width           =   4215
      End
      Begin VB.Label Label17 
         AutoSize        =   -1  'True
         Caption         =   "Height of the page in the current units. (read-only)"
         Height          =   195
         Left            =   2640
         TabIndex        =   32
         Top             =   2340
         Width           =   3495
      End
      Begin VB.Label Label16 
         AutoSize        =   -1  'True
         Caption         =   "Width of the page in the current units. (read-only)"
         Height          =   195
         Left            =   2640
         TabIndex        =   31
         Top             =   1860
         Width           =   3450
      End
      Begin VB.Label Label15 
         AutoSize        =   -1  'True
         Caption         =   "Units:"
         Height          =   195
         Left            =   240
         TabIndex        =   30
         Top             =   1380
         Width           =   405
      End
      Begin VB.Label Label1 
         AutoSize        =   -1  'True
         Caption         =   "Page:"
         Height          =   195
         Left            =   240
         TabIndex        =   29
         Top             =   2820
         Width           =   420
      End
      Begin VB.Label Label2 
         AutoSize        =   -1  'True
         Caption         =   "PageWidth:"
         Height          =   195
         Left            =   240
         TabIndex        =   28
         Top             =   1860
         Width           =   840
      End
      Begin VB.Label Label3 
         AutoSize        =   -1  'True
         Caption         =   "PageHeight:"
         Height          =   195
         Left            =   240
         TabIndex        =   27
         Top             =   2340
         Width           =   885
      End
      Begin VB.Label Label4 
         AutoSize        =   -1  'True
         Caption         =   "FirstPage:"
         Height          =   195
         Left            =   240
         TabIndex        =   26
         Top             =   3540
         Width           =   705
      End
   End
   Begin TabDlg.SSTab tabPrint 
      Height          =   3135
      Left            =   120
      TabIndex        =   0
      Top             =   120
      Width           =   7215
      _ExtentX        =   12726
      _ExtentY        =   5530
      _Version        =   393216
      Style           =   1
      Tabs            =   4
      Tab             =   2
      TabsPerRow      =   4
      TabHeight       =   520
      TabCaption(0)   =   "Introduction"
      TabPicture(0)   =   "frmSample.frx":0109
      Tab(0).ControlEnabled=   0   'False
      Tab(0).Control(0)=   "Label5"
      Tab(0).Control(1)=   "Label6"
      Tab(0).Control(2)=   "Label27"
      Tab(0).Control(3)=   "btnAutoTest"
      Tab(0).ControlCount=   4
      TabCaption(1)   =   "Step 1: Create"
      TabPicture(1)   =   "frmSample.frx":0125
      Tab(1).ControlEnabled=   0   'False
      Tab(1).Control(0)=   "Label7"
      Tab(1).Control(1)=   "Label24"
      Tab(1).Control(2)=   "btnNewDoc"
      Tab(1).Control(3)=   "btnPrintSetup"
      Tab(1).ControlCount=   4
      TabCaption(2)   =   "Step 2: Draw"
      TabPicture(2)   =   "frmSample.frx":0141
      Tab(2).ControlEnabled=   -1  'True
      Tab(2).Control(0)=   "Label8"
      Tab(2).Control(0).Enabled=   0   'False
      Tab(2).Control(1)=   "Label9"
      Tab(2).Control(1).Enabled=   0   'False
      Tab(2).Control(2)=   "Label25"
      Tab(2).Control(2).Enabled=   0   'False
      Tab(2).Control(3)=   "Label26"
      Tab(2).Control(3).Enabled=   0   'False
      Tab(2).Control(4)=   "Label10"
      Tab(2).Control(4).Enabled=   0   'False
      Tab(2).Control(5)=   "btnDrawLines"
      Tab(2).Control(5).Enabled=   0   'False
      Tab(2).Control(6)=   "btnDrawImages"
      Tab(2).Control(6).Enabled=   0   'False
      Tab(2).Control(7)=   "btnNextPage"
      Tab(2).Control(7).Enabled=   0   'False
      Tab(2).Control(8)=   "btnClearPage"
      Tab(2).Control(8).Enabled=   0   'False
      Tab(2).Control(9)=   "btnDrawDemo"
      Tab(2).Control(9).Enabled=   0   'False
      Tab(2).ControlCount=   10
      TabCaption(3)   =   "Step 3: Print"
      TabPicture(3)   =   "frmSample.frx":015D
      Tab(3).ControlEnabled=   0   'False
      Tab(3).Control(0)=   "Label11"
      Tab(3).Control(1)=   "Label12"
      Tab(3).Control(2)=   "Label13"
      Tab(3).Control(3)=   "btnPrint"
      Tab(3).Control(4)=   "btnPrintDirect"
      Tab(3).Control(5)=   "btnPrintPreview"
      Tab(3).ControlCount=   6
      Begin VB.CommandButton btnDrawDemo 
         Caption         =   "Draw Text"
         Height          =   375
         Left            =   240
         TabIndex        =   43
         Top             =   480
         Width           =   1455
      End
      Begin VB.CommandButton btnAutoTest 
         Caption         =   "SwiftPrint Demonstration"
         Height          =   495
         Left            =   -70440
         TabIndex        =   41
         Top             =   2280
         Width           =   2175
      End
      Begin VB.CommandButton btnClearPage 
         Caption         =   "Clear Page"
         Height          =   375
         Left            =   3600
         TabIndex        =   6
         Top             =   2520
         Width           =   1455
      End
      Begin VB.CommandButton btnNextPage 
         Caption         =   "Next Page"
         Height          =   375
         Left            =   240
         TabIndex        =   5
         Top             =   2520
         Width           =   1455
      End
      Begin VB.CommandButton btnPrintSetup 
         Caption         =   "Printer Setup"
         Height          =   375
         Left            =   -74760
         TabIndex        =   2
         Top             =   1440
         Width           =   1455
      End
      Begin VB.CommandButton btnPrintPreview 
         Caption         =   "Print Preview"
         Height          =   375
         Left            =   -74760
         TabIndex        =   7
         Top             =   600
         Width           =   1455
      End
      Begin VB.CommandButton btnPrintDirect 
         Caption         =   "Print Direct"
         Height          =   375
         Left            =   -74760
         TabIndex        =   9
         Top             =   1920
         Width           =   1455
      End
      Begin VB.CommandButton btnPrint 
         Caption         =   "Print"
         Height          =   375
         Left            =   -74760
         TabIndex        =   8
         Top             =   1200
         Width           =   1455
      End
      Begin VB.CommandButton btnDrawImages 
         Caption         =   "Draw Images"
         Height          =   375
         Left            =   240
         TabIndex        =   4
         Top             =   1680
         Width           =   1455
      End
      Begin VB.CommandButton btnDrawLines 
         Caption         =   "Draw Lines"
         Height          =   375
         Left            =   240
         TabIndex        =   3
         Top             =   1080
         Width           =   1455
      End
      Begin VB.CommandButton btnNewDoc 
         Caption         =   "New Document"
         Height          =   375
         Left            =   -74760
         TabIndex        =   1
         Top             =   600
         Width           =   1455
      End
      Begin VB.Label Label10 
         Caption         =   $"frmSample.frx":0179
         Height          =   495
         Left            =   1920
         TabIndex        =   44
         Top             =   480
         Width           =   5175
      End
      Begin VB.Label Label27 
         Caption         =   "For a demonstration of all of the capabilities of SwiftPrint however the button on the right will automate this process."
         Height          =   615
         Left            =   -74760
         TabIndex        =   42
         Top             =   2160
         Width           =   3855
      End
      Begin VB.Label Label26 
         Caption         =   "Clear the current page."
         Height          =   495
         Left            =   5280
         TabIndex        =   40
         Top             =   2520
         Width           =   1455
      End
      Begin VB.Label Label25 
         Caption         =   "Move to the next page."
         Height          =   495
         Left            =   1920
         TabIndex        =   39
         Top             =   2520
         Width           =   1215
      End
      Begin VB.Label Label24 
         Caption         =   $"frmSample.frx":020F
         Height          =   615
         Left            =   -73080
         TabIndex        =   38
         Top             =   1440
         Width           =   4935
      End
      Begin VB.Label Label13 
         Caption         =   "Print the document directly to the printer without displaying either the print dialog or the preview window."
         Height          =   495
         Left            =   -73080
         TabIndex        =   24
         Top             =   1920
         Width           =   5055
      End
      Begin VB.Label Label12 
         Caption         =   $"frmSample.frx":02DA
         Height          =   615
         Left            =   -73080
         TabIndex        =   23
         Top             =   1200
         Width           =   4935
      End
      Begin VB.Label Label11 
         Caption         =   $"frmSample.frx":0388
         Height          =   495
         Left            =   -73080
         TabIndex        =   22
         Top             =   600
         Width           =   4935
      End
      Begin VB.Label Label9 
         Caption         =   $"frmSample.frx":0419
         Height          =   615
         Left            =   1920
         TabIndex        =   21
         Top             =   1680
         Width           =   5175
      End
      Begin VB.Label Label8 
         Caption         =   "Demonstration of the line drawing and various graphics primitives available to you through the SwiftPrint API."
         Height          =   495
         Left            =   1920
         TabIndex        =   20
         Top             =   1080
         Width           =   5175
      End
      Begin VB.Label Label7 
         Caption         =   $"frmSample.frx":04B8
         Height          =   615
         Left            =   -73080
         TabIndex        =   19
         Top             =   600
         Width           =   5055
      End
      Begin VB.Label Label6 
         Caption         =   $"frmSample.frx":056D
         Height          =   495
         Left            =   -74760
         TabIndex        =   18
         Top             =   1560
         Width           =   6495
      End
      Begin VB.Label Label5 
         Caption         =   $"frmSample.frx":0620
         Height          =   975
         Left            =   -74760
         TabIndex        =   17
         Top             =   600
         Width           =   6615
      End
   End
   Begin MSComDlg.CommonDialog comdlg 
      Left            =   4680
      Top             =   3240
      _ExtentX        =   847
      _ExtentY        =   847
      _Version        =   393216
      InitDir         =   "e:\testpics"
   End
   Begin SwiftPrintLib.SwiftPrint spDoc 
      Left            =   5880
      Top             =   3240
      _Version        =   65536
      _ExtentX        =   2355
      _ExtentY        =   661
      _StockProps     =   0
   End
End
Attribute VB_Name = "frmSample"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit

Dim m_lInitialHeight As Long
Dim m_lCompressedHeight As Long

Private Sub btnAutoTest_Click()
    'new document and ensure the orientation is portrait
    'we hope that the current page is set for the right size
    btnNewDoc_Click
    spDoc.PageOrientation = SPOR_PORTRAIT
    Me.Refresh
    Screen.MousePointer = vbHourglass
    
    'page 1: demo page layout
    btnDrawDemo_Click
    
    'page 2: lines
    btnNextPage_Click
    btnDrawLines_Click
    
    'page 3: pictures
    DemoDrawPictures
    
    'ensure the settings we show are correct
    UpdateUI
    
    'show the preview
    Screen.MousePointer = vbDefault
    btnPrintPreview_Click
End Sub

Private Sub spDoc_StateChange(ByVal NewState As Long)
    Select Case NewState
    Case SP_IDLE
        Me.Enabled = True
        Me.Visible = True
        Me.ZOrder
        Me.SetFocus
    Case SP_PRINTPREVIEW
        Me.Enabled = False
        Me.Visible = False
    Case SP_PRINTSETUP, SP_PRINT, SP_PRINTING
        Me.Enabled = False
        Me.Visible = True
    End Select
End Sub

Private Sub Form_Load()
    'determine the correct heights for the form
    m_lInitialHeight = Me.Height
    m_lCompressedHeight = Me.Height - fProperties.Height - 200
    
    'set up ready to go
    tabPrint.Tab = 0
    EnableObjects False
    
    'setup the units combo box so that the index of the units is
    'the same as the units in spDoc, only 0 based instead
    cboUnits.Clear
    cboUnits.AddItem "Pixels", SPUN_PIXELS - SPUN_PIXELS
    cboUnits.AddItem "0.1 mm", SPUN_LOMETRIC - SPUN_PIXELS
    cboUnits.AddItem "0.01 mm", SPUN_HIMETRIC - SPUN_PIXELS
    cboUnits.AddItem "0.1 inch", SPUN_LOENGLISH - SPUN_PIXELS
    cboUnits.AddItem "0.01 inch", SPUN_HIENGLISH - SPUN_PIXELS
    cboUnits.AddItem "Twips", SPUN_TWIPS - SPUN_PIXELS
    
    'setup the page orientation so that the index is the same as
    'the orientation within spDoc, only 0 based instead
    cboOrientation.Clear
    cboOrientation.AddItem "Portrait", SPOR_PORTRAIT - SPOR_PORTRAIT
    cboOrientation.AddItem "Landscape", SPOR_LANDSCAPE - SPOR_PORTRAIT
    
    'set form location, we want to center the form for when the
    'whole form is displayed, not just the tab area
    Me.left = (Screen.Width - Me.Width) / 2
    Me.top = (Screen.Height - m_lInitialHeight) / 2
End Sub

Private Sub EnableObjects(bEnable As Boolean)
    'enable objects as required
    cboUnits.Enabled = bEnable
    txtPaperSize.Enabled = bEnable
    txtPageWidth.Enabled = bEnable
    txtPageHeight.Enabled = bEnable
    txtPage.Enabled = bEnable
    txtFirstPage.Enabled = bEnable
    txtNumPages.Enabled = bEnable
    cboOrientation.Enabled = bEnable
    btnDrawLines.Enabled = bEnable
    btnDrawImages.Enabled = bEnable
    btnDrawDemo.Enabled = bEnable
    btnNextPage.Enabled = bEnable
    btnClearPage.Enabled = bEnable
    btnPrintSetup.Enabled = bEnable
    btnPrintPreview.Enabled = bEnable
    btnPrint.Enabled = bEnable
    btnPrintDirect.Enabled = bEnable
    
    'show or hide the document properties as required
    If bEnable Then
        Me.Height = m_lInitialHeight
    Else
        Me.Height = m_lCompressedHeight
    End If
End Sub

Private Sub btnNewDoc_Click()
    On Error GoTo errHandler

    'start a new document
    spDoc.DocBegin
    spDoc.RegistryPath = "HKLM\Software\Swift\SwiftPrint\Sample"
    spDoc.WindowTitle = "Demonstration - " & Me.Caption
    spDoc.WindowOwner = Me.hWnd
    
    EnableObjects True
    UpdateUI
    
    'we have designed this demo to work with either A4 or Letter,
    'just give a warning if it isn't one of these
    If spDoc.PaperSize <> SPPA_A4 And spDoc.PaperSize <> SPPA_LETTER Then
        MsgBox "This demo was designed to use either A4 or Letter size paper. " & vbCrLf & _
            "For best results it is recommended to set the paper to one of these sizes.", _
            vbOKOnly, Me.Caption
    End If
    
    Exit Sub
errHandler:
    MsgBox "(" & Err.Number & ") " & Err.Description
    End
End Sub

Private Sub UpdateUI()
    On Error GoTo errHandler
    
    cboUnits.ListIndex = spDoc.Units - SPUN_PIXELS
    txtPaperSize = GetPaperSizeText(spDoc.PaperSize)
    txtPageWidth = CStr(spDoc.PageWidth)
    txtPageHeight = CStr(spDoc.PageHeight)
    txtPage = CStr(spDoc.Page)
    txtFirstPage = CStr(spDoc.FirstPage)
    txtNumPages = CStr(spDoc.NumPages)
    cboOrientation.ListIndex = spDoc.PageOrientation - SPOR_PORTRAIT
    
    Exit Sub
errHandler:
    MsgBox "(" & Err.Number & ") " & Err.Description
    Resume Next
End Sub

Private Function GetPaperSizeText(ByVal lPaperSize As Long) As String
    'convert the PaperSize number into readable text
    Select Case lPaperSize
    Case SPPA_CUSTOM
        GetPaperSizeText = "Custom"
    Case SPPA_LETTER
        GetPaperSizeText = "Letter 8 1/2 x 11 in"
    Case SPPA_LETTERSMALL
        GetPaperSizeText = "Letter Small 8 1/2 x 11 in"
    Case SPPA_TABLOID
        GetPaperSizeText = "Tabloid 11 x 17 in"
    Case SPPA_LEDGER
        GetPaperSizeText = "Ledger 17 x 11 in"
    Case SPPA_LEGAL
        GetPaperSizeText = "Legal 8 1/2 x 14 in"
    Case SPPA_STATEMENT
        GetPaperSizeText = "Statement 5 1/2 x 8 1/2 in"
    Case SPPA_EXECUTIVE
        GetPaperSizeText = "Executive 7 1/4 x 10 1/2 in"
    Case SPPA_A3
        GetPaperSizeText = "A3 297 x 420 mm"
    Case SPPA_A4
        GetPaperSizeText = "A4 210 x 297 mm"
    Case SPPA_A4SMALL
        GetPaperSizeText = "A4 Small 210 x 297 mm"
    Case SPPA_A5
        GetPaperSizeText = "A5 148 x 210 mm"
    Case SPPA_B4
        GetPaperSizeText = "B4 (JIS) 250 x 354 mm"
    Case SPPA_B5
        GetPaperSizeText = "B5 (JIS) 182 x 257 mm"
    Case SPPA_FOLIO
        GetPaperSizeText = "Folio 8 1/2 x 13 in"
    Case SPPA_QUARTO
        GetPaperSizeText = "Quarto 215 x 275 mm"
    Case SPPA_10X14
        GetPaperSizeText = "10x14 in"
    Case SPPA_11X17
        GetPaperSizeText = "11x17 in"
    Case SPPA_NOTE
        GetPaperSizeText = "Note 8 1/2 x 11 in"
    Case SPPA_ENV_9
        GetPaperSizeText = "Envelope #9 3 7/8 x 8 7/8"
    Case SPPA_ENV_10
        GetPaperSizeText = "Envelope #10 4 1/8 x 9 1/2"
    Case SPPA_ENV_11
        GetPaperSizeText = "Envelope #11 4 1/2 x 10 3/8"
    Case SPPA_ENV_12
        GetPaperSizeText = "Envelope #12 4 \276 x 11"
    Case SPPA_ENV_14
        GetPaperSizeText = "Envelope #14 5 x 11 1/2"
    Case SPPA_CSHEET
        GetPaperSizeText = "C size sheet"
    Case SPPA_DSHEET
        GetPaperSizeText = "D size sheet"
    Case SPPA_ESHEET
        GetPaperSizeText = "E size sheet"
    Case SPPA_ENV_DL
        GetPaperSizeText = "Envelope DL 110 x 220mm"
    Case SPPA_ENV_C5
        GetPaperSizeText = "Envelope C5 162 x 229 mm"
    Case SPPA_ENV_C3
        GetPaperSizeText = "Envelope C3 324 x 458 mm"
    Case SPPA_ENV_C4
        GetPaperSizeText = "Envelope C4 229 x 324 mm"
    Case SPPA_ENV_C6
        GetPaperSizeText = "Envelope C6 114 x 162 mm"
    Case SPPA_ENV_C65
        GetPaperSizeText = "Envelope C65 114 x 229 mm"
    Case SPPA_ENV_B4
        GetPaperSizeText = "Envelope B4 250 x 353 mm"
    Case SPPA_ENV_B5
        GetPaperSizeText = "Envelope B5 176 x 250 mm"
    Case SPPA_ENV_B6
        GetPaperSizeText = "Envelope B6 176 x 125 mm"
    Case SPPA_ENV_ITALY
        GetPaperSizeText = "Envelope 110 x 230 mm"
    Case SPPA_ENV_MONARCH
        GetPaperSizeText = "Envelope Monarch 3.875 x 7.5 in"
    Case SPPA_ENV_PERSONAL
        GetPaperSizeText = "6 3/4 Envelope 3 5/8 x 6 1/2 in"
    Case SPPA_FANFOLD_US
        GetPaperSizeText = "US Std Fanfold 14 7/8 x 11 in"
    Case SPPA_FANFOLD_STD_GERMAN
        GetPaperSizeText = "German Std Fanfold 8 1/2 x 12 in"
    Case SPPA_FANFOLD_LGL_GERMAN
        GetPaperSizeText = "German Legal Fanfold 8 1/2 x 13 in"
    Case SPPA_ISO_B4
        GetPaperSizeText = "B4 (ISO) 250 x 353 mm"
    Case SPPA_JAPANESE_POSTCARD
        GetPaperSizeText = "Japanese Postcard 100 x 148 mm"
    Case SPPA_9X11
        GetPaperSizeText = "9 x 11 in"
    Case SPPA_10X11
        GetPaperSizeText = "10 x 11 in"
    Case SPPA_15X11
        GetPaperSizeText = "15 x 11 in"
    Case SPPA_ENV_INVITE
        GetPaperSizeText = "Envelope Invite 220 x 220 mm"
    Case SPPA_LETTER_EXTRA
        GetPaperSizeText = "Letter Extra 9 \275 x 12 in"
    Case SPPA_LEGAL_EXTRA
        GetPaperSizeText = "Legal Extra 9 \275 x 15 in"
    Case SPPA_TABLOID_EXTRA
        GetPaperSizeText = "Tabloid Extra 11.69 x 18 in"
    Case SPPA_A4_EXTRA
        GetPaperSizeText = "A4 Extra 9.27 x 12.69 in"
    Case SPPA_LETTER_TRANSVERSE
        GetPaperSizeText = "Letter Transverse 8 \275 x 11 in"
    Case SPPA_A4_TRANSVERSE
        GetPaperSizeText = "A4 Transverse 210 x 297 mm"
    Case SPPA_LETTER_EXTRA_TRANSVERSE
        GetPaperSizeText = "Letter Extra Transverse 9\275 x 12 in"
    Case SPPA_A_PLUS
        GetPaperSizeText = "SuperA/SuperA/A4 227 x 356 mm"
    Case SPPA_B_PLUS
        GetPaperSizeText = "SuperB/SuperB/A3 305 x 487 mm"
    Case SPPA_LETTER_PLUS
        GetPaperSizeText = "Letter Plus 8.5 x 12.69 in"
    Case SPPA_A4_PLUS
        GetPaperSizeText = "A4 Plus 210 x 330 mm"
    Case SPPA_A5_TRANSVERSE
        GetPaperSizeText = "A5 Transverse 148 x 210 mm"
    Case SPPA_B5_TRANSVERSE
        GetPaperSizeText = "B5 (JIS) Transverse 182 x 257 mm"
    Case SPPA_A3_EXTRA
        GetPaperSizeText = "A3 Extra 322 x 445 mm"
    Case SPPA_A5_EXTRA
        GetPaperSizeText = "A5 Extra 174 x 235 mm"
    Case SPPA_B5_EXTRA
        GetPaperSizeText = "B5 (ISO) Extra 201 x 276 mm"
    Case SPPA_A2
        GetPaperSizeText = "A2 420 x 594 mm"
    Case SPPA_A3_TRANSVERSE
        GetPaperSizeText = "A3 Transverse 297 x 420 mm"
    Case SPPA_A3_EXTRA_TRANSVERSE
        GetPaperSizeText = "A3 Extra Transverse 322 x 445 mm"
    Case Else
        GetPaperSizeText = "Unknown"
    End Select
End Function

Private Sub cboUnits_Click()
    On Error GoTo errHandler
    
    spDoc.Units = cboUnits.ListIndex + SPUN_PIXELS
    UpdateUI
    
    Exit Sub
errHandler:
    MsgBox "(" & Err.Number & ") " & Err.Description
    Resume Next
End Sub

Private Sub cboOrientation_Click()
    On Error GoTo errHandler
    
    spDoc.PageOrientation = cboOrientation.ListIndex + SPOR_PORTRAIT
    UpdateUI
    
    Exit Sub
errHandler:
    MsgBox "(" & Err.Number & ") " & Err.Description
    Resume Next
End Sub

Private Sub txtPage_Change()
    On Error GoTo errHandler
    
    'change the page number in the document
    If Len(txtPage) > 0 Then
        spDoc.Page = CLng(txtPage)
        UpdateUI
    End If
    
    Exit Sub
errHandler:
    MsgBox "(" & Err.Number & ") " & Err.Description
    Resume Next
End Sub

Private Sub txtFirstPage_Change()
    On Error GoTo errHandler
    
    'change the page number in the document
    If Len(txtFirstPage) > 0 Then
        spDoc.FirstPage = CLng(txtFirstPage)
        UpdateUI
    End If
    
    Exit Sub
errHandler:
    MsgBox "(" & Err.Number & ") " & Err.Description
    Resume Next
End Sub

Private Sub btnPrintSetup_Click()
    On Error GoTo errHandler
    
    spDoc.DoPrintSetup
    UpdateUI
    
    Exit Sub
errHandler:
    MsgBox "(" & Err.Number & ") " & Err.Description
    Resume Next
End Sub

Private Sub btnPrintPreview_Click()
    On Error GoTo errHandler
    
    'show the stuff we've done
    spDoc.DoPrintPreview
    
    Exit Sub
errHandler:
    MsgBox "(" & Err.Number & ") " & Err.Description
    Resume Next
End Sub

Private Sub btnPrint_Click()
    On Error GoTo errHandler
    
    spDoc.DoPrint
    
    Exit Sub
errHandler:
    MsgBox "(" & Err.Number & ") " & Err.Description
    Resume Next
End Sub

Private Sub btnPrintDirect_Click()
    On Error GoTo errHandler
    
    spDoc.DoPrintDirect
    
    Exit Sub
errHandler:
    MsgBox "(" & Err.Number & ") " & Err.Description
    Resume Next
End Sub

Private Sub btnNextPage_Click()
    On Error GoTo errHandler
    
    spDoc.Page = spDoc.Page + 1
    UpdateUI
    
    Exit Sub
errHandler:
    MsgBox "(" & Err.Number & ") " & Err.Description
    Resume Next
End Sub

Private Sub btnClearPage_Click()
    On Error GoTo errHandler
    
    spDoc.DocClearPage
    UpdateUI
    
    Exit Sub
errHandler:
    MsgBox "(" & Err.Number & ") " & Err.Description
    Resume Next
End Sub

Private Sub DrawTitle(left As Long, top As Long, right As Long, bottom As Long, bDrawBg As Boolean)
    On Error GoTo errHandler
    
    Dim x As Long, y As Long, nIdx As Long
    Dim center As Long
    
    'get the printable space on the page
    spDoc.Units = SPUN_LOMETRIC
    center = ((right - left) / 2)
    
    '----------------------------------------------------------------
    'fill page with blue
    '----------------------------------------------------------------
    If bDrawBg Then
        spDoc.FillSolidRect left, top, right, bottom, RGB(248, 248, 255)
    End If
    
    '----------------------------------------------------------------
    'draw the SwiftPrint title
    '----------------------------------------------------------------
    y = 300
    spDoc.SetFont "Arial", y, SPFO_BOLD + SPFS_UNITS, 0
    spDoc.ForeColor = RGB(0, 0, 0)
    spDoc.BackMode = SPBM_TRANSPARENT
    spDoc.TextAlign = SPTA_TOP + SPTA_CENTER + SPTA_NOUPDATECP
    spDoc.TextOut center, top, "SwiftPrint"
    spDoc.InvertRect left, top + y / 2, right, top + y
    
    '----------------------------------------------------------------
    'draw page number at top of page
    '----------------------------------------------------------------
    spDoc.SetFont "Arial", 50, SPFO_BOLD + SPFS_UNITS, 0
    spDoc.ForeColor = RGB(0, 0, 0)
    spDoc.BackMode = SPBM_TRANSPARENT
    spDoc.TextAlign = SPTA_TOP + SPTA_RIGHT + SPTA_NOUPDATECP
    spDoc.TextOut right - 10, top + 10, "Page: " & spDoc.Page
    
    Exit Sub
errHandler:
    MsgBox "(" & Err.Number & ") " & Err.Description
    Resume Next
End Sub

Private Sub btnDrawLines_Click()
    On Error GoTo errHandler
    
    Dim left As Long, top As Long, right As Long, bottom As Long
    Dim x As Long, y As Long, nIdx As Long
    Dim center As Long
    Dim rgPoints() As Long
    
    'set up the page in preparation
    spDoc.Units = SPUN_LOMETRIC
    
    'get the printable space on the page, then set the margins to 10mm or
    'the printable area whichever is greatest
    spDoc.GetPrintableArea left, top, right, bottom
    left = Max(left, 60)
    top = Max(top, 60)
    right = Min(right - 30, spDoc.PageWidth - 60)
    bottom = Min(bottom, spDoc.PageHeight - 60)
    center = left + ((right - left) / 2)
    
    'draw the standard page title
    DrawTitle left, top, right, bottom, True
    
    '----------------------------------------------------------------
    'draw black rectangles onto page
    '----------------------------------------------------------------
    y = 350
    spDoc.SetBrush SPBR_SOLID, RGB(0, 0, 0)
    spDoc.SetPen SPPN_SOLID, 0, RGB(0, 0, 0)
    spDoc.Rectangle center, y, right, y + 350
    spDoc.Rectangle left, y + 350, center, bottom
    
    '----------------------------------------------------------------
    'draw rear vision mirror (or whatever the hell it is)
    '----------------------------------------------------------------
    x = center - 250
    y = y + 175
    spDoc.SetBrush SPBR_SOLID, RGB(255, 255, 255)
    spDoc.RoundRect center - 510, y - 140, center + 510, y + 140, 200, 200
    spDoc.SetBrush SPBR_SOLID, RGB(255, 236, 236)
    spDoc.RoundRect center - 500, y - 130, center + 500, y + 130, 200, 200
    
    '----------------------------------------------------------------
    'draw face into the mirror
    '----------------------------------------------------------------
    For nIdx = 0 To 1
        ReDim rgPoints(SPPOINT, 6) As Long
        
        spDoc.SetPen SPPN_SOLID, 2, RGB(0, 0, 0)
        'draw the first eye outline
        rgPoints(SPX, 0) = x - 210: rgPoints(SPY, 0) = y
        rgPoints(SPX, 1) = x - 100: rgPoints(SPY, 1) = y + 110
        rgPoints(SPX, 2) = x + 100: rgPoints(SPY, 2) = y + 110
        rgPoints(SPX, 3) = x + 210: rgPoints(SPY, 3) = y
        rgPoints(SPX, 4) = x + 100: rgPoints(SPY, 4) = y - 110
        rgPoints(SPX, 5) = x - 100: rgPoints(SPY, 5) = y - 110
        rgPoints(SPX, 6) = x - 210: rgPoints(SPY, 6) = y
        spDoc.PolyBezier rgPoints, 7
        
        'floodfill it with white
        spDoc.SetBrush SPBR_SOLID, RGB(255, 236, 236)
        spDoc.FloodFill x, y, RGB(0, 0, 0), SPFF_BORDER
        
        'draw the eye outline
        rgPoints(SPX, 0) = x - 200: rgPoints(SPY, 0) = y
        rgPoints(SPX, 1) = x - 100: rgPoints(SPY, 1) = y + 100
        rgPoints(SPX, 2) = x + 100: rgPoints(SPY, 2) = y + 100
        rgPoints(SPX, 3) = x + 200: rgPoints(SPY, 3) = y
        rgPoints(SPX, 4) = x + 100: rgPoints(SPY, 4) = y - 100
        rgPoints(SPX, 5) = x - 100: rgPoints(SPY, 5) = y - 100
        rgPoints(SPX, 6) = x - 200: rgPoints(SPY, 6) = y
        spDoc.PolyBezier rgPoints, 7
        
        'floodfill it with white
        spDoc.SetBrush SPBR_SOLID, RGB(255, 255, 255)
        spDoc.FloodFill x, y, RGB(0, 0, 0), SPFF_BORDER
        
        'draw the pupil
        spDoc.SetBrush SPBR_SOLID, RGB(0, 255, 64)
        spDoc.Ellipse x - 74, y - 74, x + 77, y + 77
        spDoc.SetBrush SPBR_SOLID, RGB(0, 32, 0)
        spDoc.Ellipse x - 32, y - 32, x + 32, y + 32
        
        'draw a light reflection
        spDoc.SetPen SPPN_DOT, 0, RGB(255, 255, 255)
        spDoc.LineEx x - 22, y - 22, x - 13, y - 13
        spDoc.LineEx x - 25, y - 12, x - 12, y - 25
        
        'draw the small arcs on the inside of the eye
        spDoc.SetPen SPPN_SOLID, 0, RGB(0, 0, 0)
        spDoc.SetBrush SPBR_SOLID, RGB(255, 216, 216)
        If nIdx = 0 Then
            spDoc.Pie x + 175, y - 20, x + 225, y + 17, x + 175, y - 20, x + 175, y + 17
        Else
            spDoc.Pie x - 175, y - 20, x - 225, y + 17, x - 175, y + 17, x - 175, y - 20
        End If
        
        'move location
        x = x + 500
    Next
    
    'draw the beginning of the nose
    x = x - 750 'middle
    spDoc.SetPen SPPN_SOLID, 5, RGB(255, 220, 220)
    spDoc.LineEx x - 30, y + 10, x - 80, y + 125
    spDoc.LineEx x + 30, y + 10, x + 80, y + 125
    
    '----------------------------------------------------------------
    'draw the different line types
    '----------------------------------------------------------------
    Dim rgLines(1, 4) As Variant
    Dim lWidth As Long, lHeight As Long
    spDoc.TextAlign = SPTA_TOP + SPTA_LEFT + SPTA_NOUPDATECP
    spDoc.ForeColor = RGB(255, 255, 255)
    spDoc.BackMode = SPBM_TRANSPARENT
    y = 760
    x = left + 10
    spDoc.SetFont "Arial", 120, SPFO_BOLD + SPFS_POINTS, 0
    spDoc.GetTextExtent "Line Types", lWidth, lHeight
    spDoc.TextOut x, y, "Line Types"
    y = y + lHeight + 10
    
    spDoc.SetFont "Arial", 100, SPFS_POINTS, 0
    rgLines(0, 0) = SPPN_SOLID:      rgLines(1, 0) = "Solid"
    rgLines(0, 1) = SPPN_DASH:       rgLines(1, 1) = "Dash"
    rgLines(0, 2) = SPPN_DOT:        rgLines(1, 2) = "Dot"
    rgLines(0, 3) = SPPN_DASHDOT:    rgLines(1, 3) = "DashDot"
    rgLines(0, 4) = SPPN_DASHDOTDOT: rgLines(1, 4) = "DashDotDot"
    
    spDoc.GetTextExtent "DashDotDot", lWidth, lHeight
    For nIdx = 0 To 4
        spDoc.TextOut x, y, CStr(rgLines(1, nIdx))
        spDoc.SetPen CLng(rgLines(0, nIdx)), 0, RGB(255, 255, 255)
        spDoc.LineEx x + lWidth + 50, y + lHeight / 2, center - 50, y + lHeight / 2
        y = y + (1.2 * lHeight)
    Next
    
    '----------------------------------------------------------------
    'draw the different line widths
    '----------------------------------------------------------------
    y = y + 40
    spDoc.SetFont "Arial", 120, SPFO_BOLD + SPFS_POINTS, 0
    spDoc.GetTextExtent "Line Widths", lWidth, lHeight
    spDoc.TextOut left + 10, y, "Line Widths"
    y = y + lHeight + 10
    
    spDoc.SetFont "Arial", 100, SPFS_POINTS, 0
    spDoc.GetTextExtent "DashDotDot", lWidth, lHeight
    For nIdx = 0 To 10
        spDoc.TextOut x, y, "Width = " & nIdx
        spDoc.SetPen SPPN_SOLID, nIdx, RGB(255, 255, 255)
        spDoc.LineEx x + lWidth + 50, y + lHeight / 2, center - 50, y + lHeight / 2
        y = y + (1.2 * lHeight)
    Next
            
    '----------------------------------------------------------------
    'draw a color swatchs
    '
    'note: this is very slow due to the approx. 740 filled rectangles
    '      that are drawn.  this is just an example of colors, not
    '      of how to draw an efficient color swatch.
    '----------------------------------------------------------------
    y = y + 40
    spDoc.SetFont "Arial", 120, SPFO_BOLD + SPFS_POINTS, 0
    spDoc.GetTextExtent "Color Swatch", lWidth, lHeight
    spDoc.TextOut left + 10, y, "Color Swatch"
    y = y + lHeight + 10
    
    Dim red As Integer, green As Integer, blue As Integer
    Dim rstep As Integer, gstep As Integer, bstep As Integer
    Dim ybase As Long, xbase As Long
    Dim nSteps As Integer, nBlock As Integer, nCols As Integer
    nSteps = 9
    nBlock = 34
    nCols = 3
    
    xbase = left + 20
    ybase = y
    For bstep = 0 To nSteps - 1
        blue = Min(Int(bstep * (255# / nSteps)), 255)
        y = ybase + Int(bstep / nCols) * nSteps * nBlock
        x = xbase + (bstep Mod nCols) * nSteps * nBlock
        For rstep = 0 To nSteps - 1
            red = Min(Int(rstep * (255# / nSteps)), 255)
            For gstep = 0 To nSteps - 1
                green = Min(Int(gstep * (255# / nSteps)), 255)
                spDoc.FillSolidRect x, y, x + nBlock, y + nBlock, RGB(red, green, blue)
                x = x + nBlock
            Next
            x = x - (nSteps * nBlock)
            y = y + nBlock
        Next
    Next
    
    'reset back to the top right side of the page
    y = 760
    x = center + 30
    
    '----------------------------------------------------------------
    'draw some arcs and chords
    '----------------------------------------------------------------
    spDoc.ForeColor = RGB(0, 0, 0)
    spDoc.TextAlign = SPTA_RIGHT + SPTA_TOP + SPTA_NOUPDATECP
    spDoc.SetFont "Arial", 120, SPFO_BOLD + SPFS_POINTS, 0
    spDoc.GetTextExtent "Arcs and Chords", lWidth, lHeight
    spDoc.TextOut right - 10, y, "Arcs and Chords"
    y = y + lHeight + 20
    
    spDoc.SetPen SPPN_SOLID, 3, RGB(0, 0, 0)
    
    'arcs
    Dim nArcBox As Integer
    nArcBox = (right - 30 - x) / 3
    spDoc.Arc x, y - 50, x + nArcBox, y - 50 + nArcBox, 0, 0, right, bottom, SPAR_NOUPDATECP
    x = x + nArcBox / 8
    spDoc.Arc x, y + 50, x + nArcBox, y + 50 + nArcBox, right, bottom, 0, 0, SPAR_NOUPDATECP
    x = x + (2 * nArcBox) / 3
    spDoc.ArcAngle x - nArcBox / 3, y + 3 * nArcBox / 4, 2 * nArcBox, 20#, 50#, SPAR_NOUPDATECP
    x = x + nArcBox - 50
    
    'chords
    spDoc.SetBrush SPBR_SOLID, RGB(228, 0, 0)
    spDoc.Chord x, y - 60, x + nArcBox, y + nArcBox - 60, 0, 0, center, bottom
    x = x + nArcBox / 2
    spDoc.SetBrush SPBR_SOLID, RGB(0, 228, 0)
    spDoc.Chord x, y, right - 20, y + nArcBox, right, y + nArcBox - 50, x, y + nArcBox + 60
    y = y + nArcBox + 60
    
    '----------------------------------------------------------------
    'draw some pies
    '----------------------------------------------------------------
    spDoc.GetTextExtent "Pies", lWidth, lHeight
    spDoc.TextOut right - 10, y, "Pies"
    y = y + lHeight + 20
    x = center + 20
    spDoc.SetPen SPPN_SOLID, 3, RGB(0, 0, 0)
    nArcBox = (right - 60 - x) / 3
    
    'pacman
    spDoc.SetBrush SPBR_SOLID, RGB(255, 196, 0)
    spDoc.Pie x, y, x + nArcBox, y + nArcBox, right, y - nArcBox, right, y + 2 * nArcBox
    spDoc.SetBrush SPBR_SOLID, RGB(255, 255, 255)
    spDoc.Pie x + nArcBox / 2, y + 30, x + nArcBox / 2 + 40, y + 70, left, bottom, left, top
    
    'ghosts
    x = x - 10
    For nIdx = 1 To 2
        x = x + nArcBox - 30
        spDoc.SetBrush SPBR_SOLID, RGB(0, 0, 196)
        For x = x To x + 4 * nArcBox / 5 Step nArcBox / 5
            spDoc.Pie x, y + 2 * nArcBox / 3, x + nArcBox / 2, y + 3 * nArcBox / 2, x + nArcBox / 2, y, x, y
        Next
        x = x - 15 - 4 * nArcBox / 5
        spDoc.Pie x, y, x + nArcBox, y + 3 * nArcBox / 2, x + nArcBox, y + nArcBox, x, y + nArcBox
        spDoc.SetBrush SPBR_SOLID, RGB(255, 255, 255)
        spDoc.Pie x + nArcBox / 3, y + 80, x + nArcBox / 3 + 40, y + 120, right, y + 180, left, y + 180
        spDoc.Pie x + 2 * nArcBox / 3, y + 80, x + 2 * nArcBox / 3 + 40, y + 120, right, y + 180, left, y + 180
    Next
    
    y = y + nArcBox + 100
    
    '----------------------------------------------------------------
    'draw some polygons
    '----------------------------------------------------------------
    spDoc.ForeColor = RGB(0, 0, 0)
    spDoc.TextAlign = SPTA_RIGHT + SPTA_TOP + SPTA_NOUPDATECP
    spDoc.SetFont "Arial", 120, SPFO_BOLD + SPFS_POINTS, 0
    spDoc.GetTextExtent "Polygons", lWidth, lHeight
    spDoc.TextOut right - 10, y, "Polygons"
    y = y + lHeight + 20
    
    spDoc.SetBrush SPBR_SOLID, RGB(196, 0, 0)
    spDoc.SetPen SPPN_SOLID, 3, RGB(0, 0, 0)
    
    Dim nRadius As Integer, nSides As Integer
    nRadius = 110
    x = center + 10 + nRadius
    y = y + nRadius
    For nSides = 3 To 6
        'squares look better drawn horiz/vert
        spDoc.SetBrush SPBR_SOLID, RGB(36 * (7 - (nSides - 3)), 127 * nSides Mod 3, 36 * (nSides - 3))
        spDoc.PolygonEx x, y, nRadius, nSides, SPPA_TOPHORIZ + (nSides Mod 4)
        x = x + nRadius * 2 + 10
    Next
    x = center + 20 + nRadius
    y = y + 2 * nRadius + 30
    For nSides = 7 To 10
        'squares look better drawn horiz/vert
        spDoc.SetBrush SPBR_SOLID, RGB(36 * (7 - (nSides - 3)), 127 * nSides Mod 3, 36 * (nSides - 3))
        spDoc.PolygonEx x, y, nRadius, nSides, SPPA_TOPHORIZ + (nSides Mod 4)
        x = x + nRadius * 2 + 10
    Next
    y = y + nRadius + 60
    
    '----------------------------------------------------------------
    'draw some beziers
    '----------------------------------------------------------------
    spDoc.ForeColor = RGB(0, 0, 0)
    spDoc.TextAlign = SPTA_RIGHT + SPTA_TOP + SPTA_NOUPDATECP
    spDoc.SetFont "Arial", 120, SPFO_BOLD + SPFS_POINTS, 0
    spDoc.GetTextExtent "Beziers", lWidth, lHeight
    spDoc.TextOut right - 10, y, "Beziers"
    y = y + lHeight + 20
    
    spDoc.SetBrush SPBR_SOLID, RGB(196, 0, 0)
    spDoc.SetPen SPPN_SOLID, 3, RGB(0, 0, 0)
    
    Dim nStepWidth As Integer, nJump As Integer
    ReDim rgPoints(SPPOINT, 13) As Long
    y = y + 70
    
    spDoc.SetPen SPPN_SOLID, 0, RGB(0, 196, 128)
    nStepWidth = (right - center - 40) / 6
    For nIdx = 0 To 6
        nJump = IIf(nIdx >= 2 And nIdx <= 4, 100, 0)
        rgPoints(SPX, nIdx) = center + 20 + nIdx * nStepWidth
        rgPoints(SPY, nIdx) = y + nJump
    Next
    For nIdx = 5 To 0 Step -1
        nJump = IIf(nIdx >= 2 And nIdx <= 4, 100, 0)
        rgPoints(SPX, 7 + (5 - nIdx)) = center + 20 + nIdx * nStepWidth
        rgPoints(SPY, 7 + (5 - nIdx)) = y - nJump
    Next
    spDoc.PolyBezier rgPoints, 13
    
    spDoc.SetPen SPPN_DOT, 0, RGB(255, 0, 0)
    nStepWidth = (right - center - 400) / 6
    For nIdx = 0 To 6
        nJump = IIf(nIdx >= 2 And nIdx <= 4, 70, 0)
        rgPoints(SPX, nIdx) = center + 200 + nIdx * nStepWidth
        rgPoints(SPY, nIdx) = y + nJump
    Next
    For nIdx = 5 To 0 Step -1
        nJump = IIf(nIdx >= 2 And nIdx <= 4, 70, 0)
        rgPoints(SPX, 7 + (5 - nIdx)) = center + 200 + nIdx * nStepWidth
        rgPoints(SPY, 7 + (5 - nIdx)) = y - nJump
    Next
    spDoc.PolyBezier rgPoints, 13
    y = y + 180
    
    '----------------------------------------------------------------
    'draw the footer and copyright statement
    '----------------------------------------------------------------
    Dim strText As String, CharsDrawn As Long
    Dim TextBottom As Long, TextRight As Long, TextHeight As Long
    
    'draw the footer listing functions used in the face
    strText = _
        "The image of eyes in a mirror was drawn using the " & _
        "graphical functions: Bezier, FloodFill, Ellipse, Pie, LineEx."
    spDoc.SetFont "Arial", 100, SPFS_POINTS, 0
    spDoc.TextOutEx strText, center + 30, y, right - 30, bottom, SPTO_RIGHT + SPTO_WORDBREAK, 1, CharsDrawn
    
    'draw the vertical copyright statement
    strText = "SwiftPrint, copyright (C) 1999 - 2000, Brodie Thiesfield"
    spDoc.SetFont "Arial", 65, SPFS_POINTS, 900
    spDoc.ForeColor = RGB(0, 0, 0)
    spDoc.BackMode = SPBM_TRANSPARENT
    spDoc.TextAlign = SPTA_BOTTOM + SPTA_RIGHT + SPTA_NOUPDATECP
    spDoc.TextOut right, bottom, strText
    
    '----------------------------------------------------------------
    'draw border around the page
    '----------------------------------------------------------------
    'draw a red border at the edge of the printable space again here
    'as the first border will have been erased by some of the drawing
    spDoc.SetPen SPPN_SOLID, 0, RGB(255, 0, 0)
    spDoc.SetBrush SPBR_NULL, RGB(0, 0, 0)
    spDoc.Rectangle left, top, right, bottom
    
    Exit Sub
errHandler:
    MsgBox "(" & Err.Number & ") " & Err.Description
    Resume Next
End Sub

Private Function GetImagePath() As String
    On Error GoTo errHandler
    
    Dim sPath As String
    Dim lReturn As Long
    Dim lLen As Long
    
    'return nothing on error
    GetImagePath = ""
    
    '----------------------------------------------------------------
    'get the path of this executable
    '----------------------------------------------------------------
    lReturn = GetComandLine()
    If lReturn Then
        lLen = lstrlenA(lReturn)
        If (lLen > 0) Then
            sPath = String$(lLen, 0)
            Call CopyMemory(ByVal sPath, ByVal lReturn, lLen)
            lReturn = InStrRev(sPath, "\")
            sPath = Mid(sPath, 2, lReturn - 2)
            If Dir(sPath & "\Images", vbDirectory + vbNormal) <> "" Then
                sPath = sPath & "\Images"
            End If
        End If
    End If
    If sPath = "" Then
        sPath = CurDir
        If Dir(sPath & "\Images", vbDirectory + vbNormal) <> "" Then
            sPath = sPath & "\Images"
        End If
    End If
    
    'return the path
    GetImagePath = sPath

    Exit Function
errHandler:
    MsgBox "(" & Err.Number & ") " & Err.Description
    Resume Next
End Function

Private Sub btnDrawImages_Click()
    On Error GoTo errHandler
    
    '----------------------------------------------------------------
    'get the image directory path
    '----------------------------------------------------------------
    Dim sPath As String
    sPath = GetImagePath()
    If sPath = "" Then
        Err.Raise cdlCancel
    End If
    
    '----------------------------------------------------------------
    'get the name of the image file to display
    '----------------------------------------------------------------
    comdlg.CancelError = True
    comdlg.Flags = cdlOFNFileMustExist + cdlOFNLongNames
    comdlg.Filter = _
        "All Image Files (*.bmp;*.jpg;*.gif;*.png;*.wmf;*.emf)|*.bmp;*.jpg;*.jpeg;*.gif;*.png;*.wmf;*.emf" & _
        "|Raster Files (*.bmp;*.jpg;*.gif;*.png)|*.bmp;*.jpg;*.gif;*.png" & _
        "|Vector Files (*.wmf;*.emf)|*.wmf;*.emf" & _
        "|Bitmap Files (*.bmp)|*.bmp" & _
        "|JPEG Files (*.jpg;*.jpeg)|*.jpg;*.jpeg" & _
        "|GIF Files (*.bmp)|*.bmp" & _
        "|PNG Files (*.png)|*.png" & _
        "|Windows Metafiles (*.wmf)|*.wmf" & _
        "|Enhanced Metafiles (*.emf)|*.emf"
    comdlg.FilterIndex = 1
    comdlg.InitDir = sPath
    comdlg.ShowOpen
    
    '----------------------------------------------------------------
    'get the image position on the page
    '----------------------------------------------------------------
    Load frmImagePos
    frmImagePos.Show vbModal, Me
    If frmImagePos.m_lAlignment = -1 Then
        Err.Raise cdlCancel
    End If
    
    'draw the picture
    DrawPicture comdlg.FileName, frmImagePos.m_lAlignment
    
    Exit Sub
errHandler:
    If Err.Number = cdlCancel Then
        Exit Sub
    Else
        MsgBox "(" & Err.Number & ") " & Err.Description
        Resume Next
    End If
End Sub

Private Sub DrawPicture(strFile As String, lAlign As swiftprintlib.SPImageAlign)
    On Error GoTo errHandler
    
    Dim id As Long
    Dim imgWidth As Long, imgHeight As Long
    Dim imgType As Long
    Dim left As Long, top As Long, right As Long, bottom As Long
    Dim center As Long
    Dim x As Long, y As Long, nIdx As Long
    
    '----------------------------------------------------------------
    'prepare the page for output
    '----------------------------------------------------------------
    
    'set up the page in preparation
    spDoc.Units = SPUN_LOMETRIC
    
    'get the printable space on the page, then set the margins to 10mm or
    'the printable area whichever is greatest
    spDoc.GetPrintableArea left, top, right, bottom
    left = Max(left, 60)
    top = Max(top, 60)
    right = Min(right - 30, spDoc.PageWidth - 60)
    bottom = Min(bottom, spDoc.PageHeight - 60)
    center = left + ((right - left) / 2)
    
    'draw the standard page title
    DrawTitle left, top, right, bottom, True
    y = 370
    
    '----------------------------------------------------------------
    'draw the vertical copyright statement
    '----------------------------------------------------------------
    Dim strText As String
    strText = "SwiftPrint, copyright (C) 1999 - 2000, Brodie Thiesfield"
    spDoc.SetFont "Arial", 65, SPFS_POINTS, 900
    spDoc.ForeColor = RGB(0, 0, 0)
    spDoc.BackMode = SPBM_TRANSPARENT
    spDoc.TextAlign = SPTA_BOTTOM + SPTA_RIGHT + SPTA_NOUPDATECP
    spDoc.TextOut right, bottom, strText
    
    '----------------------------------------------------------------
    'draw the image title onto the page
    '----------------------------------------------------------------
    Dim TextRight As Long, TextBottom As Long, CharsDrawn As Long
    Dim TextHeight As Long
    spDoc.SetFont "Arial", 80, SPFS_POINTS, 0
    spDoc.TextAlign = SPTA_TOP + SPTA_LEFT + SPTA_NOUPDATECP
    strText = _
        "SwiftPrint Image Output Demo.  Image may be copyright (c) by original owner." & vbCrLf & _
        "File = " & strFile
    TextRight = right - 20
    TextBottom = bottom
    spDoc.TextOutExCalc strText, left + 20, y, TextRight, TextBottom, SPTO_CENTER + SPTO_WORDBREAK, 1, CharsDrawn
    TextHeight = TextBottom - y
    spDoc.TextOutEx strText, left + 20, bottom - TextHeight - 20, right - 20, bottom, SPTO_CENTER + SPTO_WORDBREAK, 1, CharsDrawn
    
    '----------------------------------------------------------------
    'draw image onto the page
    '----------------------------------------------------------------
    spDoc.LoadImage strFile, id
    spDoc.GetImageDetails id, imgType, imgWidth, imgHeight
    spDoc.PlaceImage id, left + 20, y, right - 20, bottom - TextHeight - 40, lAlign
    
    '----------------------------------------------------------------
    'draw border around the page
    '----------------------------------------------------------------
    'draw a red border at the edge of the printable space again here
    'as the first border will have been erased by some of the drawing
    spDoc.SetPen SPPN_SOLID, 0, RGB(255, 0, 0)
    spDoc.SetBrush SPBR_NULL, RGB(0, 0, 0)
    spDoc.Rectangle left, top, right, bottom
    
    Exit Sub
errHandler:
    If Err.Number = cdlCancel Then
        Exit Sub
    Else
        MsgBox "(" & Err.Number & ") " & Err.Description
        Resume Next
    End If
End Sub

Private Function Max(ByVal l1 As Long, ByVal l2 As Long) As Long
    Max = IIf(l1 > l2, l1, l2)
End Function

Private Function Min(ByVal l1 As Long, ByVal l2 As Long) As Long
    Min = IIf(l1 < l2, l1, l2)
End Function

Private Sub btnDrawDemo_Click()
    On Error GoTo errHandler
    
    Dim left As Long, top As Long, right As Long, bottom As Long
    Dim x As Long, y As Long, nIdx As Long
    Dim center As Long, lMaxY As Long
    Dim strText As String, CharsDrawn As Long
    Dim TextHeight As Long, TextWidth As Long
    
    'set up the page in preparation
    spDoc.Units = SPUN_LOMETRIC
    
    'get the printable space on the page, then set the margins to 10mm or
    'the printable area whichever is greatest
    spDoc.GetPrintableArea left, top, right, bottom
    left = Max(left, 60)
    top = Max(top, 60)
    right = Min(right - 30, spDoc.PageWidth - 60)
    bottom = Min(bottom, spDoc.PageHeight - 60)
    center = left + ((right - left) / 2)
    
    '----------------------------------------------------------------
    'draw the SwiftPrint title
    '----------------------------------------------------------------
    y = 300
    spDoc.SetPen SPPN_NULL, 0, 0
    spDoc.SetBrush SPBR_SOLID, RGB(232, 232, 255)
    spDoc.Rectangle left, top, right, top + y / 2
    
    'draw the standard page title
    DrawTitle left, top, right, bottom, False
    
    '----------------------------------------------------------------
    'draw page number at top of page
    '----------------------------------------------------------------
    spDoc.SetFont "Arial", 50, SPFO_BOLD + SPFS_UNITS, 0
    spDoc.ForeColor = RGB(0, 0, 0)
    spDoc.BackMode = SPBM_TRANSPARENT
    spDoc.TextAlign = SPTA_TOP + SPTA_RIGHT + SPTA_NOUPDATECP
    spDoc.TextOut right - 10, top + 10, "Page: " & spDoc.Page
    
    spDoc.SetPen SPPN_SOLID, 0, RGB(0, 0, 0)
    spDoc.SetBrush SPBR_NULL, 0
    spDoc.Rectangle left, top, right, top + y
    
    'draw the all around rectangle
    spDoc.SetPen SPPN_SOLID, 0, RGB(0, 0, 0)
    spDoc.SetBrush SPBR_NULL, 0
    spDoc.Rectangle left, top, right, bottom
    
    'draw the vertical copyright statement
    strText = "SwiftPrint, copyright (C) 1999 - 2000, Brodie Thiesfield"
    spDoc.SetFont "Arial", 65, SPFS_POINTS, 900
    spDoc.ForeColor = RGB(0, 0, 0)
    spDoc.BackMode = SPBM_TRANSPARENT
    spDoc.TextAlign = SPTA_BOTTOM + SPTA_RIGHT + SPTA_NOUPDATECP
    spDoc.TextOut right, bottom, strText
    
    'reset the y and top values
    y = top + 300
    top = y
    
    'adjust the margins now
    top = top + 20
    left = left + 20
    right = right - 20
    bottom = bottom - 20
    
    '----------------------------------------------------------------
    'draw the page footer
    '----------------------------------------------------------------
    Dim nFooterTop As Integer
    nFooterTop = bottom - 380
    
    'draw the purple rectangle
    spDoc.SetPen SPPN_SOLID, 0, RGB(0, 0, 0)
    spDoc.SetBrush SPBR_SOLID, RGB(232, 232, 255)
    spDoc.RoundRect left, nFooterTop + 50, right, bottom, 75, 75
    
    'draw the black rectangle
    spDoc.SetBrush SPBR_SOLID, RGB(0, 0, 0)
    spDoc.RoundRect left, nFooterTop, right, nFooterTop + 100, 75, 75
    spDoc.Rectangle left, nFooterTop + 50, right, nFooterTop + 100
    
    'draw the title
    spDoc.SetFont "Arial", 80, SPFO_BOLD + SPFS_UNITS, 0
    spDoc.ForeColor = RGB(255, 255, 255)
    spDoc.BackMode = SPBM_TRANSPARENT
    spDoc.TextAlign = SPTA_TOP + SPTA_CENTER + SPTA_NOUPDATECP
    spDoc.TextOut center, nFooterTop + 10, "Contact Details"
    
    spDoc.SetFont "Arial", 80, SPFS_POINTS, 0
    spDoc.ForeColor = RGB(0, 0, 0)
    spDoc.TextAlign = SPTA_TOP + SPTA_LEFT + SPTA_NOUPDATECP
    
    strText = "Please feel free to contact me at the addresses below.  I will be creating a " & _
        "mailing list for anyone who wishes to be notified when a new release of SwiftPrint is " & _
        "made, send me an email if you wish to be added to that list.  Other reasons you may wish " & _
        "to contact me is to licence SwiftPrint for use outside the freeware licence agreement, " & _
        "reporting bugs, or to request a new feature." & vbCrLf
    TextHeight = bottom - 40
    TextWidth = right - 40
    spDoc.TextOutExCalc strText, left + 40, nFooterTop + 120, TextWidth, TextHeight, _
        SPTO_LEFT + SPTO_VCENTER + SPTO_WORDBREAK, 8, CharsDrawn
    spDoc.TextOutEx strText, left + 40, nFooterTop + 120, TextWidth, TextHeight, _
        SPTO_LEFT + SPTO_VCENTER + SPTO_WORDBREAK, 8, CharsDrawn
    
    strText = "Name: " & vbTab & "Brodie Thiesfield" & vbCrLf & _
        "Email:" & vbTab & "brodie@iname.com" & vbCrLf & _
        "Web:" & vbTab & "http://www.ecn.net.au/~brodie/SwiftPrint"
    spDoc.TextOutEx strText, left + 160, TextHeight, center, bottom - 20, _
        SPTO_LEFT + SPTO_VCENTER + SPTO_WORDBREAK, 8, CharsDrawn
    
    strText = "Mail:" & vbTab & "Brodie Thiesfield" & vbCrLf & _
        vbTab & "c/- SwiftPrint" & vbCrLf & _
        vbTab & "PO Box 206, Geebung, Qld, 4034, Australia"
    spDoc.TextOutEx strText, center + 120, TextHeight, right - 20, bottom - 20, _
        SPTO_LEFT + SPTO_VCENTER + SPTO_WORDBREAK, 8, CharsDrawn
        
    'adjust the margins now
    top = top + 20
    left = left + 20
    right = right - 20
    bottom = bottom - 20
    
    '----------------------------------------------------------------
    'draw the beginning of the blurb
    '----------------------------------------------------------------
    'adjust the top to be the top of the document body
    spDoc.GetTextExtent "a", TextWidth, TextHeight
    
    'set the font attributes for the blurb leadin
    spDoc.ForeColor = RGB(0, 0, 0)
    spDoc.BackMode = SPBM_TRANSPARENT
    
    'set the text
    strText = vbCrLf & _
        "The ability to print and print preview documents using complex text wrapping, " & _
        "lines, and images has now arrived for applications written in Visual Basic " & _
        "or any other environment which supports ActiveX controls. "
    DrawParagraph strText, left, y, center - 30, -1, SPFO_BOLD
        
    strText = vbCrLf & _
        "The printing revolution was started by PreviewPrint which supplied the first " & _
        "basic ability to preview simple clipped text and lines.  Now with a total rewrite, " & _
        "it has been radically improved and renamed, reappearing in it's new form as SwiftPrint. " & _
        vbCrLf & vbCrLf & _
        "SwiftPrint is a comprehensive printing service with integrated print preview " & _
        "capable of supplimenting or replacing the normal printer functionality in " & _
        "Visual Basic and any other ActiveX-capable programming environment. " & _
        "SwiftPrint has a large selection of graphics, text and image primitives, " & _
        "making the creation of complex page layouts a simpler task.  " & _
        vbCrLf & vbCrLf & _
        "The astounding array of functionality provided by SwiftPrint includes:"
    DrawParagraph strText, left, y, center - 30, -1, 0

    strText = vbCrLf & "Graphics Primitives"
    DrawParagraph strText, left, y, center - 30, -1, SPFO_UNDERLINE
    
    strText = vbTab & "- line, arc, chord, bezier" & vbCrLf & _
        vbTab & "- polygon, ellipse, pie, rectangles" & vbCrLf & _
        vbTab & "- color inversion, flood filling"
    DrawParagraph strText, left, y, center - 30, -1, 0
    
    strText = vbCrLf & "Text Primitives"
    DrawParagraph strText, left, y, center - 30, -1, SPFO_UNDERLINE
    
    strText = vbTab & "- horizontal text alignment: left, center, right" & vbCrLf & _
        vbTab & "- vertical text alignment: top, baseline, center, bottom" & vbCrLf & _
        vbTab & "- supports bold, italic, underline and strikeout attributes" & vbCrLf & _
        vbTab & "- text rotation to any angle" & vbCrLf & _
        vbTab & "- text output can be clipped or word wrapped to a rectangle"
    DrawParagraph strText, left, y, center - 30, -1, 0
    
    strText = vbCrLf & "Image Primitives"
    DrawParagraph strText, left, y, center - 30, -1, SPFO_UNDERLINE
    
    strText = vbTab & "- place image files onto the printed page" & vbCrLf & _
        vbTab & "- supports BMP, JPG, GIF, PNG, WMF, and EMF formats"
    DrawParagraph strText, left, y, center - 30, -1, 0

    strText = vbCrLf & "Printer and Printing Support"
    DrawParagraph strText, left, y, center - 30, -1, SPFO_UNDERLINE
    
    strText = vbTab & "- printer setup dialog" & vbCrLf & _
        vbTab & "- print with print preview and print dialog" & vbCrLf & _
        vbTab & "- print with print dialog only" & vbCrLf & _
        vbTab & "- print directly with no dialog"
    DrawParagraph strText, left, y, center - 30, -1, 0

    strText = vbCrLf & "Print Preview"
    DrawParagraph strText, left, y, center - 30, -1, SPFO_UNDERLINE
    
    strText = vbTab & "- easy navigation through the document when previewing" & vbCrLf & _
        vbTab & "- display pages singly or as double page spread" & vbCrLf & _
        vbTab & "- display odd or even page on the left in two page mode" & vbCrLf & _
        vbTab & "- zoom between 3 levels of magnification"
    DrawParagraph strText, left, y, center - 30, -1, 0
    lMaxY = y

    '----------------------------------------------------------------
    'draw the screen shot
    '----------------------------------------------------------------
    y = top
    Dim sPath As String, ImageHeight As Long
    sPath = GetImagePath()
    sPath = sPath & "\SwiftPrintScreenshot.gif"
    ImageHeight = right - center - 30 + 200
    If LCase(Dir(sPath)) = "swiftprintscreenshot.gif" Then
        Dim spImageId As Long
        spDoc.LoadImage sPath, spImageId
        spDoc.PlaceImage spImageId, center + 30, y, right, y + ImageHeight, SPIA_BESTFIT
    Else
        spDoc.SetPen SPPN_SOLID, 5, RGB(0, 0, 0)
        spDoc.SetBrush SPBR_SOLID, RGB(255, 232, 232)
        spDoc.Rectangle center + 30, y, right, y + ImageHeight
        spDoc.SetPen SPPN_SOLID, 2, RGB(255, 0, 0)
        spDoc.LineEx center + 30, y, right, y + ImageHeight
        spDoc.LineEx center + 30, y + ImageHeight, right, y
        spDoc.SetFont "Arial", 100, SPFS_POINTS, 0
        spDoc.BackColor = RGB(255, 232, 232)
        spDoc.BackMode = SPBM_OPAQUE
        spDoc.TextOutEx "Image not found.", center + 30, y, right, y + ImageHeight, _
            SPTO_CENTER + SPTO_VCENTER + SPTO_SINGLELINE, 5, CharsDrawn
        spDoc.BackMode = SPBM_TRANSPARENT
    End If
    
    '----------------------------------------------------------------
    'subtitle the screen shot
    '----------------------------------------------------------------
    strText = "Figure 1: SwiftPrint demonstration page screenshot"
    spDoc.TextAlign = SPTA_TOP + SPTA_CENTER + SPTA_NOUPDATECP
    spDoc.SetFont "Arial", 80, SPFO_BOLD + SPFO_ITALIC + SPFS_POINTS, 0
    spDoc.TextOut (right + center + 30) / 2, y + ImageHeight + 10, strText
    spDoc.GetTextExtent strText, TextWidth, TextHeight
    y = y + ImageHeight + 10 + TextHeight
    
    '----------------------------------------------------------------
    'Licencing
    '----------------------------------------------------------------
    strText = vbCrLf & "Licencing"
    DrawParagraph strText, center + 30, y, right, -1, SPFO_UNDERLINE
    y = y + TextHeight / 2
    
    strText = _
        "This new version of SwiftPrint has taken many weeks of time and effort to create." & _
        "As this product has now become one of the most feature rich print preview controls " & _
        "available as freeware/shareware I have decided to revise the pricing structure." & _
        vbCrLf & vbCrLf & _
        "SwiftPrint will continue to be licenced as freeware only if you " & _
        "will receive no remuneration whatsoever for developing or distributing the " & _
        "application it is being used in.  This means that SwiftPrint is licenced without " & _
        "fee for applications developed solely for your own personal use, or for applications " & _
        "which will be distributed solely as freeware." & _
        vbCrLf & vbCrLf & _
        "Licencing fees will apply for any other use, for example, use in shareware " & _
        "or commercial applications.  See the documentation for full details of the new " & _
        "licencing conditions."
    DrawParagraph strText, center + 30, y, right, -1, 0
    
    Exit Sub
errHandler:
    MsgBox "(" & Err.Number & ") " & Err.Description
    Resume Next
End Sub


Sub DrawParagraph(ByVal strText As String, ByVal left As Long, ByRef top As Long, ByVal right As Long, ByVal bottom As Long, ByVal FontMod As Long)
    Dim TextWidth As Long, TextHeight As Long, CharsDrawn As Long
    
    TextWidth = right
    TextHeight = IIf(bottom < 0, top + 1, bottom)
    spDoc.SetFont "Times New Roman", 100, SPFS_POINTS + FontMod, 0
    spDoc.TextOutExCalc strText, left, top, TextWidth, TextHeight, _
        SPTO_LEFT + SPTO_TOP + SPTO_WORDBREAK, 4, CharsDrawn
    spDoc.TextOutEx strText, left, top, TextWidth, TextHeight, _
        SPTO_LEFT + SPTO_TOP + SPTO_WORDBREAK, 4, CharsDrawn
    top = TextHeight
End Sub

Sub DemoDrawPictures()
    Dim strPath As String
    
    strPath = GetImagePath()
    If Dir(strPath & "\balloon32.emf", vbNormal) <> "" Then
        btnNextPage_Click
        DrawPicture strPath & "\balloon32.emf", SPIA_STRETCH
    End If
    If Dir(strPath & "\bird.wmf", vbNormal) <> "" Then
        btnNextPage_Click
        DrawPicture strPath & "\bird.wmf", SPIA_STRETCH
    End If
    If Dir(strPath & "\test.gif", vbNormal) <> "" Then
        btnNextPage_Click
        DrawPicture strPath & "\test.gif", SPIA_STRETCH
    End If
End Sub
