/*
 * Decompiled with CFR 0.152.
 */
package com.iproject.wbmpcreator;

import com.iproject.wbmpcreator.ChartDrawException;
import com.iproject.wbmpcreator.SimpleImageFile;
import com.iproject.wbmpcreator.WBMPDimension;
import com.iproject.wbmpcreator.WBMPFilter;
import com.iproject.wbmpcreator.WBMPfile;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.util.Vector;

public class WBMPChart
extends WBMPfile {
    public static final int HISTOGRAM_TYPE_1 = 101;
    public static final int HISTOGRAM_TYPE_2 = 102;
    public static final int HISTOGRAM_TYPE_3 = 103;
    public static final int HISTOGRAM_TYPE_4 = 104;
    public static final int LINEAR_TYPE_1 = 201;
    public static final int LINEAR_TYPE_2 = 202;
    public static final int LINEAR_TYPE_3 = 203;
    public static final int LINEAR_TYPE_4 = 204;
    public static final int CHART_PLAIN = 1001;
    public static final int CHART_POINT = 1002;
    public static final int CHART_PLAIN_FILLED = 1003;
    public static final int CHART_POINT_FILLED = 1004;
    public static final int PROGRESS_BAR_HORIZONTAL = 1005;
    public static final int PROGRESS_BAR_VERTICAL = 1006;
    public static final int APPLEPIE_TYPE_1 = 301;
    public static final int APPLEPIE_TYPE_2 = 302;
    public static final int STOCK_TYPE_1 = 401;
    public static final int STOCK_TYPE_2 = 402;

    public WBMPChart(int n, int n2) {
        this.setWBMPLength(n);
        this.setWBMPWidth(n2);
        this.createWBMPFile();
    }

    public WBMPChart(WBMPDimension wBMPDimension) {
        this.setWBMPLength(wBMPDimension.getDimensionLength());
        this.setWBMPWidth(wBMPDimension.getDimensionWidth());
        this.createWBMPFile();
    }

    public WBMPChart(WBMPfile wBMPfile) {
        this.WBMPpic = wBMPfile.getWBMPpic();
        this.WBMPLength = wBMPfile.getWBMPLength();
        this.WBMPWidth = wBMPfile.getWBMPWidth();
    }

    public WBMPfile drawAdvancedChart(String[] stringArray, String[] stringArray2, Vector vector, int n, int n2, int n3, boolean bl) throws Exception, ChartDrawException {
        WBMPfile wBMPfile;
        if (stringArray2 != null && stringArray2.length != 2) {
            throw new ChartDrawException("Axis parameter should consist of either null or of 2 elements");
        }
        BufferedImage bufferedImage = new BufferedImage(n2, n3, 1);
        Graphics graphics = bufferedImage.getGraphics();
        int n4 = 1;
        int n5 = 1;
        int n6 = 1;
        int n7 = 1;
        if (stringArray2 != null) {
            n4 = 6;
            n7 = 6;
        }
        if (stringArray != null) {
            n5 = 22;
        }
        int n8 = n4;
        int n9 = bufferedImage.getWidth() - n4 - n5;
        int n10 = n6;
        int n11 = bufferedImage.getHeight() - n6 - n7;
        if (bl) {
            graphics.drawLine(n4, n6, n4, n11);
            graphics.drawLine(n4, n11, n9, n11);
        }
        if (stringArray != null) {
            int n12 = stringArray.length;
            switch (n12) {
                case 4: {
                    graphics.setColor(this.ltHtl(3));
                    graphics.fillRect(bufferedImage.getWidth() - n5, n6 + 21, 6, 6);
                    graphics.setColor(Color.black);
                }
                case 3: {
                    graphics.setColor(this.ltHtl(2));
                    graphics.fillRect(bufferedImage.getWidth() - n5, n6 + 14, 6, 6);
                    graphics.setColor(Color.black);
                }
                case 2: {
                    graphics.setColor(this.ltHtl(1));
                    graphics.fillRect(bufferedImage.getWidth() - n5, n6 + 7, 6, 6);
                    graphics.setColor(Color.black);
                }
                case 1: {
                    graphics.setColor(Color.white);
                    graphics.fillRect(bufferedImage.getWidth() - n5, n6 + 0, 6, 6);
                    break;
                }
                default: {
                    throw new ChartDrawException("Too many parameters for output");
                }
            }
        }
        switch (n) {
            case 101: {
                this.lthtl(vector, graphics, n8, n9, n10, n11);
                break;
            }
            case 102: {
                this.Lthtl(vector, graphics, n8, n9, n10, n11);
                break;
            }
            case 103: {
                this.lThtl(vector, graphics, n8, n9, n10, n11);
                break;
            }
            case 104: {
                this.LThtl(vector, graphics, n8, n9, n10, n11);
                break;
            }
            case 201: {
                this.LtHtl(vector, graphics, n8, n9, n10, n11);
                break;
            }
            case 202: {
                this.lTHtl(vector, graphics, n8, n9, n10, n11);
                break;
            }
            case 203: {
                this.LTHtl(vector, graphics, n8, n9, n10, n11);
                break;
            }
            case 204: {
                this.lthTl(vector, graphics, n8, n9, n10, n11);
                break;
            }
            case 301: {
                this.LthTl(vector, graphics, n8, n9, n10, n11);
                break;
            }
            case 302: {
                this.lThTl(vector, graphics, n8, n9, n10, n11);
                break;
            }
            case 401: {
                this.LThTl(vector, graphics, n8, n9, n10, n11);
                break;
            }
            case 402: {
                this.ltHTl(vector, graphics, n8, n9, n10, n11);
                break;
            }
            case 1001: {
                this.LtHTl(vector, graphics, n8, n9, n10, n11);
                break;
            }
            case 1002: {
                this.lTHTl(vector, graphics, n8, n9, n10, n11);
                break;
            }
            case 1003: {
                this.LTHTl(vector, graphics, n8, n9, n10, n11);
                break;
            }
            case 1004: {
                this.lthtL(vector, graphics, n8, n9, n10, n11);
                break;
            }
            case 1005: {
                this.LthtL(vector, graphics, n8, n9, n10, n11, 0);
                break;
            }
            case 1006: {
                this.LthtL(vector, graphics, n8, n9, n10, n11, 1);
            }
        }
        SimpleImageFile simpleImageFile = new SimpleImageFile();
        simpleImageFile.setInnerImg(bufferedImage);
        WBMPFilter wBMPFilter = new WBMPFilter();
        try {
            wBMPfile = wBMPFilter.complexImageFilter(simpleImageFile.getPointArray(), simpleImageFile.getLength(), simpleImageFile.getWidth(), 100);
        }
        catch (Exception exception) {
            wBMPfile = new WBMPfile(simpleImageFile.getLength(), simpleImageFile.getWidth());
        }
        wBMPfile.invertWBMPImage();
        if (stringArray2 != null) {
            try {
                wBMPfile.drawCustomString(stringArray2[0], n4, bufferedImage.getHeight() - 6, "STANDARD", 0);
                wBMPfile.drawCustomString(stringArray2[1], 1, n6, "STANDARD", 0);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        if (stringArray != null) {
            int n13 = stringArray.length;
            switch (n13) {
                case 4: {
                    wBMPfile.drawCustomString(stringArray[3], bufferedImage.getWidth() - n5 + 7, n6 + 21, "STANDARD", 0);
                }
                case 3: {
                    wBMPfile.drawCustomString(stringArray[2], bufferedImage.getWidth() - n5 + 7, n6 + 14, "STANDARD", 0);
                }
                case 2: {
                    wBMPfile.drawCustomString(stringArray[1], bufferedImage.getWidth() - n5 + 7, n6 + 7, "STANDARD", 0);
                }
                case 1: {
                    wBMPfile.drawCustomString(stringArray[0], bufferedImage.getWidth() - n5 + 7, n6 + 0, "STANDARD", 0);
                    break;
                }
                default: {
                    throw new ChartDrawException("Too many parameters for output");
                }
            }
        }
        return wBMPfile;
    }

    private void lthtl(Vector vector, Graphics graphics, int n, int n2, int n3, int n4) {
        int n5 = 0;
        double d = 0.0;
        double d2 = ((double[])vector.get(0))[0];
        for (int i = 0; i < vector.size(); ++i) {
            double[] dArray = (double[])vector.get(i);
            n5 = dArray.length;
            for (int j = 0; j < dArray.length; ++j) {
                if (!(dArray[j] > d2)) continue;
                d2 = dArray[j];
            }
        }
        double d3 = Math.abs(d - d2);
        double d4 = (double)(n4 - n3) / d3;
        double[] dArray = (double[])vector.get(0);
        int n6 = (n2 - n) / dArray.length;
        for (int i = 0; i < dArray.length; ++i) {
            graphics.setColor(this.ltHtl(i));
            int n7 = (int)((dArray[i] - d) * d4);
            graphics.fillRect(n + n6 * i, n4 - n7, n6 - 1, n7);
        }
    }

    private void Lthtl(Vector vector, Graphics graphics, int n, int n2, int n3, int n4) {
        int n5;
        int n6;
        int n7 = 0;
        double d = 0.0;
        double d2 = ((double[])vector.get(0))[0];
        for (int i = 0; i < vector.size(); ++i) {
            double[] dArray = (double[])vector.get(i);
            n7 = dArray.length;
            for (int j = 0; j < dArray.length; ++j) {
                if (!(dArray[j] > d2)) continue;
                d2 = dArray[j];
            }
        }
        double d3 = Math.abs(d - d2);
        double d4 = (double)(n4 - n3) / d3;
        double[] dArray = (double[])vector.get(0);
        int n8 = Math.min((n2 - n) / dArray.length, 20);
        double[] dArray2 = new double[dArray.length];
        int[] nArray = new int[dArray2.length];
        for (n6 = 0; n6 < nArray.length; ++n6) {
            nArray[n6] = n6;
        }
        System.arraycopy(dArray, 0, dArray2, 0, dArray.length);
        for (n6 = 0; n6 < dArray2.length; ++n6) {
            for (n5 = 0; n5 < n6; ++n5) {
                if (!(dArray2[n6] > dArray2[n5])) continue;
                double d5 = dArray2[n5];
                dArray2[n5] = dArray2[n6];
                dArray2[n6] = d5;
                int n9 = nArray[n5];
                nArray[n5] = nArray[n6];
                nArray[n6] = n9;
            }
        }
        for (n6 = 0; n6 < dArray2.length; ++n6) {
            graphics.setColor(this.ltHtl(nArray[n6]));
            n5 = (int)((dArray2[n6] - d) * d4);
            graphics.fillRect(n + (n2 - n - n8) / 2, n4 - n5, n8, n5);
            graphics.setColor(Color.black);
            graphics.drawRect(n + (n2 - n - n8) / 2, n4 - n5, n8, n5);
        }
    }

    private void lThtl(Vector vector, Graphics graphics, int n, int n2, int n3, int n4) {
        int n5 = 0;
        double d = 0.0;
        double d2 = ((double[])vector.get(0))[0];
        for (int i = 0; i < vector.size(); ++i) {
            double[] dArray = (double[])vector.get(i);
            n5 = dArray.length;
            for (int j = 0; j < dArray.length; ++j) {
                if (!(dArray[j] > d2)) continue;
                d2 = dArray[j];
            }
        }
        double d3 = Math.abs(d - d2);
        double d4 = (double)(n4 - n3) / d3;
        double[] dArray = (double[])vector.get(0);
        int n6 = (n2 - n) / dArray.length - 5;
        for (int i = 0; i < dArray.length; ++i) {
            graphics.setColor(this.ltHtl(i));
            int n7 = (int)((dArray[i] - d) * d4);
            graphics.fillRect(n + (n6 + 5) * i, n4 - n7, n6, n7);
            int[] nArray = new int[]{n + (n6 + 5) * i, n + (n6 + 5) * i + 3, n + (n6 + 5) * i + 3 + n6 - 1, n + (n6 + 5) * i + 3 + n6 - 1, n + (n6 + 5) * i + n6 - 1, n + (n6 + 5) * i + n6 - 1, n + (n6 + 5) * i};
            int[] nArray2 = new int[]{n4 - n7, n4 - n7 - 3, n4 - n7 - 3, n4 - 3, n4, n4 - n7, n4 - n7};
            graphics.fillPolygon(nArray, nArray2, 7);
            graphics.setColor(Color.black);
            graphics.drawLine(n + (n6 + 5) * i, n4 - n7, n + (n6 + 5) * i + n6 - 1, n4 - n7);
            graphics.drawLine(n + (n6 + 5) * i + n6 - 1, n4 - n7, n + (n6 + 5) * i + n6 - 1, n4);
            graphics.drawLine(n + (n6 + 5) * i + n6 - 1, n4 - n7, n + (n6 + 5) * i + n6 - 1 + 3, n4 - n7 - 3);
        }
    }

    private void LThtl(Vector vector, Graphics graphics, int n, int n2, int n3, int n4) {
        int n5;
        int n6;
        int n7 = 0;
        double d = 0.0;
        double d2 = ((double[])vector.get(0))[0];
        for (int i = 0; i < vector.size(); ++i) {
            double[] dArray = (double[])vector.get(i);
            n7 = dArray.length;
            for (int j = 0; j < dArray.length; ++j) {
                if (!(dArray[j] > d2)) continue;
                d2 = dArray[j];
            }
        }
        double d3 = Math.abs(d - d2);
        double d4 = (double)(n4 - n3 - 4) / d3;
        double[] dArray = (double[])vector.get(0);
        int n8 = Math.min((n2 - n) / dArray.length, 20);
        double[] dArray2 = new double[dArray.length];
        int[] nArray = new int[dArray2.length];
        for (n6 = 0; n6 < nArray.length; ++n6) {
            nArray[n6] = n6;
        }
        System.arraycopy(dArray, 0, dArray2, 0, dArray.length);
        for (n6 = 0; n6 < dArray2.length; ++n6) {
            for (n5 = 0; n5 < n6; ++n5) {
                if (!(dArray2[n6] > dArray2[n5])) continue;
                double d5 = dArray2[n5];
                dArray2[n5] = dArray2[n6];
                dArray2[n6] = d5;
                int n9 = nArray[n5];
                nArray[n5] = nArray[n6];
                nArray[n6] = n9;
            }
        }
        for (n6 = 0; n6 < dArray2.length; ++n6) {
            graphics.setColor(this.ltHtl(nArray[n6]));
            n5 = (int)((dArray2[n6] - d) * d4);
            graphics.fillRect(n + (n2 - n - n8) / 2, n4 - n5, n8, n5);
            graphics.setColor(Color.black);
            graphics.drawRect(n + (n2 - n - n8) / 2, n4 - n5, n8, n5);
            graphics.setColor(this.ltHtl(nArray[n6]));
            int[] nArray2 = new int[]{n + (n2 - n - n8) / 2 + n8, n + (n2 - n - n8) / 2 + n8 + 5, n + (n2 - n - n8) / 2 + n8 + 5, n + (n2 - n - n8) / 2 + n8, n + (n2 - n - n8) / 2 + n8};
            int[] nArray3 = new int[]{n4 - n5, n4 - n5 - 3, n4 - 3, n4, n4 - n5};
            graphics.fillPolygon(nArray2, nArray3, 5);
            if (n6 == 0) {
                nArray3[0] = n4 - n5;
                nArray3[1] = n4 - n5 - 3;
                nArray3[2] = n4 - n5 - 3;
                nArray3[3] = n4 - n5;
                nArray3[4] = n4 - n5;
                nArray2[0] = n + (n2 - n - n8) / 2;
                nArray2[1] = n + (n2 - n + n8) / 2 + 5;
                nArray2[2] = n + (n2 - n + n8) / 2 + 5;
                nArray2[3] = n + (n2 - n + n8) / 2;
                nArray2[4] = n + (n2 - n - n8) / 2;
                graphics.fillPolygon(nArray2, nArray3, 5);
            }
            graphics.setColor(Color.black);
            graphics.drawLine(n + (n2 - n - n8) / 2 + n8, n4 - n5, n + (n2 - n - n8) / 2 + n8 + 5, n4 - n5 - 3);
            graphics.drawLine(n + (n2 - n - n8) / 2 + n8, n4, n + (n2 - n - n8) / 2 + n8, n4 - n5);
            graphics.drawLine(n + (n2 - n - n8) / 2 + n8, n4 - n5, n + (n2 - n - n8) / 2, n4 - n5);
        }
    }

    private Color ltHtl(int n) {
        switch (n) {
            case 0: {
                return Color.white;
            }
            case 1: {
                return new Color(64, 64, 64);
            }
            case 2: {
                return new Color(128, 128, 128);
            }
            case 3: {
                return new Color(192, 192, 192);
            }
        }
        return Color.black;
    }

    private void LtHtl(Vector vector, Graphics graphics, int n, int n2, int n3, int n4) {
        int n5 = 0;
        double d = 0.0;
        double d2 = ((double[])vector.get(0))[0];
        for (int i = 0; i < vector.size(); ++i) {
            double[] dArray = (double[])vector.get(i);
            n5 = dArray.length;
            for (int j = 0; j < dArray.length; ++j) {
                if (!(dArray[j] > d2)) continue;
                d2 = dArray[j];
            }
        }
        double d3 = Math.abs(d - d2);
        double d4 = (double)(n2 - n) / d3;
        double[] dArray = (double[])vector.get(0);
        int n6 = (n4 - n3) / dArray.length;
        for (int i = 0; i < dArray.length; ++i) {
            graphics.setColor(this.ltHtl(i));
            int n7 = (int)((dArray[i] - d) * d4);
            graphics.fillRect(n + 1, n3 + n6 * i, n7 - 1, n6);
        }
    }

    private void lTHtl(Vector vector, Graphics graphics, int n, int n2, int n3, int n4) {
        int n5;
        int n6;
        int n7 = 0;
        double d = 0.0;
        double d2 = ((double[])vector.get(0))[0];
        for (int i = 0; i < vector.size(); ++i) {
            double[] dArray = (double[])vector.get(i);
            n7 = dArray.length;
            for (int j = 0; j < dArray.length; ++j) {
                if (!(dArray[j] > d2)) continue;
                d2 = dArray[j];
            }
        }
        double d3 = Math.abs(d - d2);
        double d4 = (double)(n2 - n) / d3;
        double[] dArray = (double[])vector.get(0);
        int n8 = Math.min((n4 - n3) / dArray.length, 20);
        double[] dArray2 = new double[dArray.length];
        int[] nArray = new int[dArray2.length];
        for (n6 = 0; n6 < nArray.length; ++n6) {
            nArray[n6] = n6;
        }
        System.arraycopy(dArray, 0, dArray2, 0, dArray.length);
        for (n6 = 0; n6 < dArray2.length; ++n6) {
            for (n5 = 0; n5 < n6; ++n5) {
                if (!(dArray2[n6] > dArray2[n5])) continue;
                double d5 = dArray2[n5];
                dArray2[n5] = dArray2[n6];
                dArray2[n6] = d5;
                int n9 = nArray[n5];
                nArray[n5] = nArray[n6];
                nArray[n6] = n9;
            }
        }
        for (n6 = 0; n6 < dArray2.length; ++n6) {
            graphics.setColor(this.ltHtl(nArray[n6]));
            n5 = (int)((dArray2[n6] - d) * d4);
            graphics.fillRect(n, n3 + (n4 - n3 - n8) / 2, n5, n8);
            graphics.setColor(Color.black);
            graphics.drawRect(n, n3 + (n4 - n3 - n8) / 2, n5, n8);
        }
    }

    private void LTHtl(Vector vector, Graphics graphics, int n, int n2, int n3, int n4) {
        int n5 = 0;
        double d = 0.0;
        double d2 = ((double[])vector.get(0))[0];
        for (int i = 0; i < vector.size(); ++i) {
            double[] dArray = (double[])vector.get(i);
            n5 = dArray.length;
            for (int j = 0; j < dArray.length; ++j) {
                if (!(dArray[j] > d2)) continue;
                d2 = dArray[j];
            }
        }
        double d3 = Math.abs(d - d2);
        double d4 = (double)(n2 - n - 3) / d3;
        double[] dArray = (double[])vector.get(0);
        int n6 = (n4 - n3 - 5 * (dArray.length - 1)) / dArray.length;
        for (int i = 0; i < dArray.length; ++i) {
            graphics.setColor(this.ltHtl(i));
            int n7 = (int)((dArray[i] - d) * d4);
            graphics.fillRect(n + 1, n3 + (n6 + 5) * i, n7 - 1, n6);
            int[] nArray = new int[]{n3 + (n6 + 5) * i, n3 + (n6 + 5) * i + 3, n3 + (n6 + 5) * i + 3 + n6 - 1, n3 + (n6 + 5) * i + 3 + n6 - 1, n3 + (n6 + 5) * i + n6 - 1, n3 + (n6 + 5) * i + n6 - 1, n3 + (n6 + 5) * i};
            int[] nArray2 = new int[]{n + n7, n + n7 + 3, n + n7 + 3, n + 3, n, n + n7, n + n7};
            graphics.fillPolygon(nArray2, nArray, 7);
            graphics.setColor(Color.black);
            graphics.drawLine(n + n7, n3 + (n6 + 5) * i, n + n7, n3 + (n6 + 5) * i + n6 - 1);
            graphics.drawLine(n + n7, n3 + (n6 + 5) * i + n6 - 1, n, n3 + (n6 + 5) * i + n6 - 1);
            graphics.drawLine(n + n7, n3 + (n6 + 5) * i + n6 - 1, n + n7 + 3, n3 + (n6 + 5) * i + n6 - 1 + 3);
        }
    }

    private void lthTl(Vector vector, Graphics graphics, int n, int n2, int n3, int n4) {
        int n5;
        int n6;
        int n7 = 0;
        double d = 0.0;
        double d2 = ((double[])vector.get(0))[0];
        for (int i = 0; i < vector.size(); ++i) {
            double[] dArray = (double[])vector.get(i);
            n7 = dArray.length;
            for (int j = 0; j < dArray.length; ++j) {
                if (!(dArray[j] > d2)) continue;
                d2 = dArray[j];
            }
        }
        double d3 = Math.abs(d - d2);
        double d4 = (double)(n2 - n - 4) / d3;
        double[] dArray = (double[])vector.get(0);
        int n8 = Math.min((n4 - n3) / dArray.length, 20);
        double[] dArray2 = new double[dArray.length];
        int[] nArray = new int[dArray2.length];
        for (n6 = 0; n6 < nArray.length; ++n6) {
            nArray[n6] = n6;
        }
        System.arraycopy(dArray, 0, dArray2, 0, dArray.length);
        for (n6 = 0; n6 < dArray2.length; ++n6) {
            for (n5 = 0; n5 < n6; ++n5) {
                if (!(dArray2[n6] > dArray2[n5])) continue;
                double d5 = dArray2[n5];
                dArray2[n5] = dArray2[n6];
                dArray2[n6] = d5;
                int n9 = nArray[n5];
                nArray[n5] = nArray[n6];
                nArray[n6] = n9;
            }
        }
        for (n6 = 0; n6 < dArray2.length; ++n6) {
            graphics.setColor(this.ltHtl(nArray[n6]));
            n5 = (int)((dArray2[n6] - d) * d4);
            graphics.fillRect(n, n3 + (n4 - n3 - n8) / 2, n5, n8);
            graphics.setColor(Color.black);
            graphics.drawRect(n, n3 + (n4 - n3 - n8) / 2, n5, n8);
            graphics.setColor(this.ltHtl(nArray[n6]));
            int[] nArray2 = new int[]{n + n5, n + n5 + 3, n + 3, n, n + n5};
            int[] nArray3 = new int[]{n3 + (n4 - n3 + n8) / 2, n3 + (n4 - n3 + n8) / 2 + 5, n3 + (n4 - n3 + n8) / 2 + 5, n3 + (n4 - n3 + n8) / 2, n3 + (n4 - n3 + n8) / 2};
            graphics.fillPolygon(nArray2, nArray3, 5);
            if (n6 == 0) {
                nArray2[0] = n + n5;
                nArray2[1] = n + n5 + 3;
                nArray2[2] = n + 3;
                nArray2[3] = n;
                nArray2[4] = n + n5;
                nArray3[0] = n3 + (n4 - n3 - n8) / 2;
                nArray3[1] = n3 + (n4 - n3 + n8) / 2 + 5;
                nArray3[2] = n3 + (n4 - n3 + n8) / 2 + 5;
                nArray3[3] = n3 + (n4 - n3 + n8) / 2;
                nArray3[4] = n3 + (n4 - n3 - n8) / 2;
                graphics.fillPolygon(nArray2, nArray3, 5);
            }
            graphics.setColor(Color.black);
            graphics.drawLine(n, n3 + (n4 - n3 - n8) / 2 + n8, n + 3, n3 + (n4 - n3 - n8) / 2 + n8 + 5);
            graphics.drawLine(n, n3 + (n4 - n3 - n8) / 2 + n8, n + n5, n3 + (n4 - n3 - n8) / 2 + n8);
            graphics.drawLine(n + n5, n3 + (n4 - n3 - n8) / 2 + n8, n + n5, n3 + (n4 - n3 - n8) / 2);
        }
    }

    private void LthTl(Vector vector, Graphics graphics, int n, int n2, int n3, int n4) {
        int n5 = Math.min(n2 - n, n4 - n3);
        int n6 = n + (n2 - n) / 2;
        int n7 = n3 + (n4 - n3) / 2;
        graphics.setColor(Color.white);
        graphics.drawOval(n6 - n5 / 2, n7 - n5 / 2, n5, n5);
        double[] dArray = (double[])vector.get(0);
        int n8 = dArray.length;
        double d = 0.0;
        for (int i = 0; i < n8; ++i) {
            d += dArray[i];
        }
        double d2 = 0.0;
        for (int i = 0; i < n8; ++i) {
            double d3 = d2;
            int n9 = (int)((double)n6 + (double)(n5 / 2) * Math.cos(Math.PI * 2 * (d2 += dArray[i] / d)));
            int n10 = (int)((double)n7 - (double)(n5 / 2) * Math.sin(Math.PI * 2 * d2));
            graphics.drawLine(n6, n7, n9, n10);
            graphics.setColor(this.ltHtl(i));
            graphics.fillArc(n6 - n5 / 2, n7 - n5 / 2, n5, n5, (int)((double)360 * d3), (int)((double)360 * (d2 - d3)));
        }
    }

    private void lThTl(Vector vector, Graphics graphics, int n, int n2, int n3, int n4) {
        int n5 = n2 - n;
        int n6 = n4 - n3 - 4;
        int n7 = n + (n2 - n) / 2;
        int n8 = n3 + (n4 - n3) / 2 - 4;
        graphics.setColor(Color.white);
        graphics.drawOval(n7 - n5 / 2, n8 - n6 / 2, n5, n6);
        double[] dArray = (double[])vector.get(0);
        int n9 = dArray.length;
        double d = 0.0;
        for (int i = 0; i < n9; ++i) {
            d += dArray[i];
        }
        double d2 = 0.0;
        for (int i = 0; i < n9; ++i) {
            double d3 = d2;
            graphics.setColor(this.ltHtl(i));
            graphics.fillArc(n7 - n5 / 2, n8 - n6 / 2, n5, n6, (int)((double)360 * d3), (int)((double)360 * ((d2 += dArray[i] / d) - d3)));
        }
        graphics.setColor(Color.white);
        graphics.drawLine(n, n8, n, n8 + 4);
        graphics.drawLine(n2, n8, n2, n8 + 4);
        graphics.drawArc(n, n3, n5, n6, 180, 180);
    }

    private void LThTl(Vector vector, Graphics graphics, int n, int n2, int n3, int n4) throws ChartDrawException {
        double d = 0.0;
        double d2 = 0.0;
        for (int i = 0; i < vector.size(); ++i) {
            if (d == 0.0) {
                try {
                    d = ((double[])vector.get(i))[0];
                    d2 = ((double[])vector.get(i))[1];
                }
                catch (NullPointerException nullPointerException) {}
                continue;
            }
            try {
                d = Math.min(d, ((double[])vector.get(i))[0]);
                d2 = Math.max(d2, ((double[])vector.get(i))[1]);
                continue;
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        double d3 = (n2 - n) / vector.size();
        double d4 = (double)(n4 - n3) / (d2 - d);
        int n5 = (n2 - n) / vector.size();
        if (n5 < 3) {
            throw new ChartDrawException("Insufficient place for output");
        }
        int n6 = Math.min(n5, 2);
        for (int i = 0; i < vector.size(); ++i) {
            try {
                int n7 = (int)((double)n4 - (((double[])vector.get(i))[0] - d) * d4);
                int n8 = (int)((double)n4 - (((double[])vector.get(i))[1] - d) * d4);
                int n9 = (int)((double)n4 - (((double[])vector.get(i))[2] - d) * d4);
                graphics.setColor(Color.white);
                graphics.drawLine(n + i * n5, n7, n + i * n5, n8);
                graphics.drawLine(n + i * n5, n9, n + i * n5 + n6, n9);
                continue;
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
    }

    private void ltHTl(Vector vector, Graphics graphics, int n, int n2, int n3, int n4) throws ChartDrawException {
        double d = 0.0;
        double d2 = 0.0;
        for (int i = 0; i < vector.size(); ++i) {
            if (d == 0.0) {
                try {
                    d = ((double[])vector.get(i))[0];
                    d2 = ((double[])vector.get(i))[1];
                }
                catch (NullPointerException nullPointerException) {}
                continue;
            }
            try {
                d = Math.min(d, ((double[])vector.get(i))[0]);
                d2 = Math.max(d2, ((double[])vector.get(i))[1]);
                continue;
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        double d3 = (n2 - n) / vector.size();
        double d4 = (double)(n4 - n3) / (d2 - d);
        int n5 = (n2 - n) / vector.size();
        if (n5 < 5) {
            throw new ChartDrawException("Insufficient place for output");
        }
        int n6 = Math.min(n5, 6);
        for (int i = 0; i < vector.size(); ++i) {
            try {
                int n7 = (int)((double)n4 - (((double[])vector.get(i))[0] - d) * d4);
                int n8 = (int)((double)n4 - (((double[])vector.get(i))[1] - d) * d4);
                int n9 = (int)((double)n4 - (((double[])vector.get(i))[2] - d) * d4);
                int n10 = (int)((double)n4 - (((double[])vector.get(i))[3] - d) * d4);
                graphics.setColor(Color.white);
                graphics.drawLine(n + i * n5 + n5 / 2, n7, n + i * n5 + n5 / 2, Math.max(n9, n10));
                graphics.drawLine(n + i * n5 + n5 / 2, n8, n + i * n5 + n5 / 2, Math.min(n9, n10));
                if (n10 < n9) {
                    graphics.drawRect(n + i * n5 + 1, n10, n5 - 2, n9 - n10);
                    continue;
                }
                graphics.fillRect(n + i * n5 + 1, n9, n5 - 2, n10 - n9);
                continue;
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
    }

    private void LtHTl(Vector vector, Graphics graphics, int n, int n2, int n3, int n4) {
        int n5 = n2 - n;
        int n6 = Math.abs(n4 - n3);
        double d = ((double[])vector.get(0))[0];
        double d2 = ((double[])vector.get(0))[0];
        for (int i = 0; i < vector.size(); ++i) {
            d = Math.min(((double[])vector.get(i))[0], d);
            d2 = Math.max(((double[])vector.get(i))[0], d2);
        }
        double d3 = (double)n5 / (double)(vector.size() - 1);
        double d4 = (double)n6 / Math.abs(d2 - d);
        int n7 = 0;
        int n8 = 0;
        for (int i = 0; i < vector.size(); ++i) {
            int n9 = n + (int)((double)i * d3);
            double d5 = ((double[])vector.get(i))[0];
            int n10 = n4 - (int)(d4 * (d5 - d));
            graphics.drawLine(n9, n10, n9, n10);
            if (i > 0) {
                graphics.drawLine(n7, n8, n9, n10);
            }
            n7 = n9;
            n8 = n10;
        }
    }

    private void lTHTl(Vector vector, Graphics graphics, int n, int n2, int n3, int n4) {
        int n5 = n2 - n;
        int n6 = Math.abs(n4 - n3);
        double d = ((double[])vector.get(0))[0];
        double d2 = ((double[])vector.get(0))[0];
        for (int i = 0; i < vector.size(); ++i) {
            d = Math.min(((double[])vector.get(i))[0], d);
            d2 = Math.max(((double[])vector.get(i))[0], d2);
        }
        double d3 = (double)n5 / (double)(vector.size() - 1);
        double d4 = (double)n6 / Math.abs(d2 - d);
        for (int i = 0; i < vector.size(); ++i) {
            int n7 = n + (int)((double)i * d3);
            int n8 = n4 - (int)(d4 * ((double[])vector.get(i))[0] - d);
            graphics.drawLine(n7, n8, n7, n8);
            graphics.drawLine(n7 - 1, n8, n7, n8);
            graphics.drawLine(n7 + 1, n8, n7, n8);
            graphics.drawLine(n7, n8 - 1, n7, n8);
            graphics.drawLine(n7, n8 + 1, n7, n8);
        }
    }

    private void LTHTl(Vector vector, Graphics graphics, int n, int n2, int n3, int n4) {
        int n5 = n2 - n;
        int n6 = Math.abs(n4 - n3);
        double d = ((double[])vector.get(0))[0];
        double d2 = ((double[])vector.get(0))[0];
        for (int i = 0; i < vector.size(); ++i) {
            d = Math.min(((double[])vector.get(i))[0], d);
            d2 = Math.max(((double[])vector.get(i))[0], d2);
        }
        double d3 = (double)n5 / (double)(vector.size() - 1);
        double d4 = (double)n6 / Math.abs(d2 - d);
        int[] nArray = new int[vector.size() + 2];
        int[] nArray2 = new int[vector.size() + 2];
        for (int i = 0; i < vector.size(); ++i) {
            nArray[i] = n + (int)((double)i * d3);
            nArray2[i] = n4 - (int)(d4 * ((double[])vector.get(i))[0] - d);
        }
        nArray[vector.size()] = nArray[vector.size() - 1];
        nArray2[vector.size()] = n4;
        nArray[vector.size() + 1] = nArray[0];
        nArray2[vector.size() + 1] = nArray2[0];
        graphics.fillPolygon(nArray, nArray2, vector.size() + 2);
    }

    private void lthtL(Vector vector, Graphics graphics, int n, int n2, int n3, int n4) {
        int n5 = n2 - n;
        int n6 = Math.abs(n4 - n3);
        double d = ((double[])vector.get(0))[0];
        double d2 = ((double[])vector.get(0))[0];
        for (int i = 0; i < vector.size(); ++i) {
            d = Math.min(((double[])vector.get(i))[0], d);
            d2 = Math.max(((double[])vector.get(i))[0], d2);
        }
        double d3 = (double)n5 / (double)(vector.size() - 1);
        double d4 = (double)n6 / Math.abs(d2 - d);
        for (int i = 0; i < vector.size(); ++i) {
            int n7 = n + (int)((double)i * d3);
            int n8 = n4 - (int)(d4 * ((double[])vector.get(i))[0] - d);
            graphics.drawLine(n7, n8, n7, n8);
            graphics.drawLine(n7, n4, n7, n8);
        }
    }

    private void LthtL(Vector vector, Graphics graphics, int n, int n2, int n3, int n4, int n5) throws ChartDrawException {
        int n6 = Math.min(n, n2);
        int n7 = Math.min(n3, n4);
        int n8 = Math.abs(n2 - n);
        int n9 = Math.abs(n4 - n3);
        graphics.drawRect(n6, n7, n8, n9);
        try {
            int[] nArray = (int[])vector.get(0);
            if (n5 == 0) {
                int n10 = (int)((double)nArray[0] / 100.0 * (double)n8);
                graphics.fillRect(n6, n7, n10, n9);
            } else {
                int n11 = (int)((double)nArray[0] / 100.0 * (double)n9);
                graphics.fillRect(n6, n7 + n9 - n11, n8, n7 + n9);
            }
        }
        catch (Exception exception) {
            throw new ChartDrawException("Value must be represented as a int[] array with 1 value at 0 index");
        }
    }
}

