/*
 * Decompiled with CFR 0.152.
 */
package com.iproject.wbmpcreator;

import com.iproject.wbmpcreator.BadSequenceLineException;
import com.iproject.wbmpcreator.SimpleImageFile;
import com.iproject.wbmpcreator.WBMPCustomFont;
import com.iproject.wbmpcreator.WBMPDimension;
import com.iproject.wbmpcreator.WBMPFilter;
import com.others.ImageEncoder;
import com.others.WBMP2BMP;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.awt.image.Raster;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URL;
import java.net.URLConnection;
import java.util.StringTokenizer;

public class WBMPfile
implements Serializable {
    public static final int MIX_MODE_XOR = 1;
    public static final int MIX_MODE_AND = 2;
    public static final int MIX_MODE_OR = 3;
    public static final int MIX_MODE_NOT = 4;
    public static final int ALIGN_HORIZONTAL_LEFT = 10;
    public static final int ALIGN_HORIZONTAL_RIGHT = 11;
    public static final int ALIGN_HORIZONTAL_CENTER = 12;
    public static final int ALIGN_VERTICAL_TOP = 13;
    public static final int ALIGN_VERTICAL_BOTTOM = 14;
    public static final int ALIGN_VERTICAL_CENTER = 15;
    public static final int ALIGN_CENTER = 16;
    public static final int APPEND_MODE_DIVISION = 1;
    public static final int APPEND_MODE_CONTINUOUS = 2;
    protected int WBMPLength;
    protected int WBMPWidth;
    protected int[][] WBMPpic;
    protected Raster r;
    protected BufferedImage img;
    protected Graphics g;
    protected WBMPfile outFile;
    private String licenseExpires = "31.12.2099";
    private String licenseNumber = "LICENSE_FOR_VERSION_2_00";
    private String licenseOwner = "Trial shareware license";
    private boolean isInstantiated = false;
    public static final int LINE_POINT1 = 1;
    public static final int LINE_POINT2 = 2;
    public static final int LINE_POINT3 = 3;
    public static final int LINE_INT2_1 = 21;
    public static final int LINE_INT2_2 = 22;
    public static final int LINE_INT3_2 = 32;
    public static final int LINE_CHAIN3_1 = 131;
    public static final int LINE_CHAIN3_2 = 132;

    public WBMPfile() {
    }

    public WBMPfile(String string) throws IOException {
        this.openWBMPFile(string);
    }

    public WBMPfile(int n, int n2) {
        this.WBMPLength = n;
        this.WBMPWidth = n2;
        this.createWBMPFile();
    }

    public WBMPfile(int n, int n2, int[][] nArray) {
        this.setWBMPLength(n);
        this.setWBMPWidth(n2);
        this.createWBMPFile();
        this.WBMPpic = nArray;
    }

    public void setWBMPLength(int n) {
        this.WBMPLength = n;
    }

    public int getWBMPLength() {
        return this.WBMPLength;
    }

    public void setWBMPWidth(int n) {
        this.WBMPWidth = n;
    }

    public int getWBMPWidth() {
        return this.WBMPWidth;
    }

    public void createWBMPFile() {
        this.WBMPpic = null;
        this.WBMPpic = new int[this.getExcNum(this.WBMPLength)][this.WBMPWidth];
        for (int i = 0; i < this.getExcNum(this.WBMPLength); ++i) {
            for (int j = 0; j < this.WBMPWidth; ++j) {
                this.WBMPpic[i][j] = 1;
            }
        }
    }

    public void destroyWBMPFile() {
        this.WBMPpic = null;
    }

    public void setElementAt(int n, int n2, int n3) {
        try {
            this.WBMPpic[n][n2] = n3;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void ltht(int[][] nArray) {
        for (int i = 0; i < this.WBMPLength; ++i) {
            for (int j = 0; j < this.WBMPWidth; ++j) {
                this.WBMPpic[i][j] = nArray[i][j] > 0 ? 0 : 1;
            }
        }
    }

    public int getElementAt(int n, int n2) {
        try {
            int n3 = this.WBMPpic[n][n2];
            return n3;
        }
        catch (Exception exception) {
            int n4 = 0;
            return n4;
        }
    }

    private void Ltht(String string) {
        WBMPfile wBMPfile = this;
        File file = new File(string);
        if (file.exists()) {
            file.delete();
        }
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            fileOutputStream.write(0);
            fileOutputStream.write(0);
            fileOutputStream.write(this.WBMPLength);
            fileOutputStream.write(this.WBMPWidth);
            int n = this.getExcNum(this.WBMPLength);
            int n2 = this.WBMPWidth;
            int n3 = 0;
            int n4 = n / 8;
            for (int i = 0; i < n2; ++i) {
                for (int j = 0; j < n4; ++j) {
                    n3 = 0;
                    for (int k = 7; k >= 0; --k) {
                        if (wBMPfile.WBMPpic[8 * j + 7 - k][i] == 0) continue;
                        n3 = (byte)(n3 + WBMPfile.power2(k));
                    }
                    fileOutputStream.write(n3);
                }
            }
            fileOutputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected int getExcNum(int n) {
        int n2 = n / 8;
        if (n2 * 8 == n) {
            return n;
        }
        return (n2 + 1) * 8;
    }

    protected static int power2(int n) {
        return 1 << n;
    }

    public void printWBMPImage() {
        WBMPfile wBMPfile = this;
        if (!this.isInstantiated) {
            this.KTdBb(wBMPfile);
        }
        for (int i = 0; i < this.getWBMPWidth(); ++i) {
            for (int j = 0; j < this.getWBMPLength(); ++j) {
                System.out.print(wBMPfile.WBMPpic[j][i]);
            }
            System.out.println("\n");
        }
    }

    public void invertWBMPImage() {
        int n = 0;
        int n2 = 0;
        try {
            for (n = 0; n < this.getExcNum(this.WBMPLength); ++n) {
                for (n2 = 0; n2 < this.WBMPWidth; ++n2) {
                    this.WBMPpic[n][n2] = this.WBMPpic[n][n2] == 0 ? 1 : 0;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void convertBytes2Points(int[] nArray, int n, int n2) {
        for (int i = 0; i < n; ++i) {
            int n3 = nArray[i];
            if (n3 < 0) {
                n3 += 256;
            }
            for (int j = 7; j >= 0; --j) {
                this.WBMPpic[7 - j + 8 * i][n2] = n3 / WBMPfile.power2(j);
                if (n3 < WBMPfile.power2(j)) continue;
                n3 -= WBMPfile.power2(j);
            }
        }
    }

    public WBMPfile mix(WBMPfile wBMPfile, int n) {
        return this.mix(wBMPfile, n, 0, 0);
    }

    protected int xor(int n, int n2) {
        if (n == n2) {
            return 1;
        }
        return 0;
    }

    protected int and(int n, int n2) {
        if (n == 0 && n2 == 0) {
            return 0;
        }
        return 1;
    }

    protected int or(int n, int n2) {
        if (n != 0 && n2 != 0) {
            return 1;
        }
        return 0;
    }

    protected int not(int n, int n2) {
        int n3 = n == 0 ? 1 : 0;
        return this.and(n3, n2);
    }

    public WBMPfile mix(WBMPfile wBMPfile, int n, int n2, int n3) {
        WBMPfile wBMPfile2 = this;
        for (int i = 0; i < wBMPfile.getWBMPLength(); ++i) {
            block7: for (int j = 0; j < wBMPfile.getWBMPWidth(); ++j) {
                switch (n) {
                    case 1: {
                        wBMPfile2.setElementAt(i + n2, j + n3, this.xor(wBMPfile.getElementAt(i, j), this.getElementAt(i + n2, j + n3)));
                        continue block7;
                    }
                    case 2: {
                        wBMPfile2.setElementAt(i + n2, j + n3, this.and(wBMPfile.getElementAt(i, j), this.getElementAt(i + n2, j + n3)));
                        continue block7;
                    }
                    case 3: {
                        wBMPfile2.setElementAt(i + n2, j + n3, this.or(wBMPfile.getElementAt(i, j), this.getElementAt(i + n2, j + n3)));
                        continue block7;
                    }
                    case 4: {
                        wBMPfile2.setElementAt(i + n2, j + n3, this.not(wBMPfile.getElementAt(i, j), this.getElementAt(i + n2, j + n3)));
                    }
                }
            }
        }
        return wBMPfile2;
    }

    protected WBMPfile text2WBMP(String string, Font font, int n, int n2, int n3, int n4) {
        this.prepareRaster(n, n2);
        this.g.setFont(font);
        this.g.drawString(string, n3, n4);
        this.copyDataToOutLayer();
        this.clearRaster();
        return this.outFile;
    }

    public void drawString(String string, int n, int n2, Font font) {
        this.mix(this.text2WBMP(string, font, this.WBMPLength, this.WBMPWidth, n, n2), 3);
    }

    public void drawCustomString(String string, int n, int n2, String string2, int n3) throws FileNotFoundException {
        if (string2.trim().equals("STANDARD")) {
            this.mix(WBMPCustomFont.getWBMPImage(string, 1, n3), 3, n, n2);
        } else {
            try {
                WBMPCustomFont wBMPCustomFont = new WBMPCustomFont(string2);
                this.mix(WBMPCustomFont.getWBMPImage(string, 0, 0), 3, n, n2);
                wBMPCustomFont.unloadCustomFont();
                wBMPCustomFont = null;
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw new FileNotFoundException("The font name specified is not correct");
            }
        }
    }

    public void drawLine(int n, int n2, int n3, int n4) {
        this.ltHt(n, n2, n3, n4, 0);
    }

    public void drawOval(int n, int n2, int n3, int n4, boolean bl) {
        this.LTHt(n, n2, n3, n4, 0, bl);
    }

    public void drawPoint(int n, int n2, int n3) {
        this.setElementAt(n, n2, n3);
    }

    public void drawRect(int n, int n2, int n3, int n4, boolean bl) {
        this.LTht(n, n2, n3, n4, 0, bl);
    }

    public void draw3DRect(int n, int n2, int n3, int n4, boolean bl, boolean bl2) {
        this.lTHt(n, n2, n3, n4, 0, bl, bl2);
    }

    public void drawArc(int n, int n2, int n3, int n4, int n5, int n6) {
        this.lthT(n, n2, n3, n4, n5, n6, 0);
    }

    protected void prepareRaster(int n, int n2) {
        this.outFile = new WBMPfile(n, n2);
        this.img = new BufferedImage(n, n2, 11);
        this.g = this.img.getGraphics();
    }

    protected void copyDataToOutLayer() {
        this.r = this.img.getData();
        int[] nArray = new int[1];
        for (int i = 0; i < this.WBMPLength; ++i) {
            for (int j = 0; j < this.WBMPWidth; ++j) {
                int[] nArray2 = this.r.getPixel(i, j, nArray);
                try {
                    if (nArray2[0] != 0) {
                        this.outFile.setElementAt(i, j, 0);
                        continue;
                    }
                    this.outFile.setElementAt(i, j, 1);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    protected void clearRaster() {
        this.r = null;
        this.g = null;
        this.img = null;
    }

    public String getString() {
        WBMPfile wBMPfile = this;
        if (!this.isInstantiated) {
            this.KTdBb(wBMPfile);
        }
        String string = "";
        string = String.valueOf(string).concat(String.valueOf('\u0000'));
        string = String.valueOf(string).concat(String.valueOf('\u0000'));
        int n = Integer.parseInt(String.valueOf(this.WBMPLength));
        string = String.valueOf(string).concat(String.valueOf((char)n));
        n = Integer.parseInt(String.valueOf(this.WBMPWidth));
        string = String.valueOf(string).concat(String.valueOf((char)n));
        int n2 = this.getExcNum(this.WBMPLength) / 8;
        for (int i = 0; i < this.WBMPWidth; ++i) {
            for (int j = 0; j < n2; ++j) {
                n = 0;
                for (int k = 7; k >= 0; --k) {
                    if (wBMPfile.WBMPpic[8 * j + 7 - k][i] == 0) continue;
                    n += WBMPfile.power2(k);
                }
                string = String.valueOf(string).concat(String.valueOf((char)n));
            }
        }
        return string;
    }

    public WBMPfile rotate(int n) {
        if (n / 4 * 4 == n) {
            return this;
        }
        if (n / 2 * 2 == n) {
            this.outFile = new WBMPfile(this.WBMPLength, this.WBMPWidth);
            for (int i = 0; i < this.WBMPLength; ++i) {
                for (int j = 0; j < this.WBMPWidth; ++j) {
                    this.outFile.setElementAt(this.WBMPLength - 1 - i, this.WBMPWidth - 1 - j, this.getElementAt(i, j));
                }
            }
        } else {
            this.outFile = new WBMPfile(this.WBMPWidth, this.WBMPLength);
            if (n / 4 * 4 + 1 == n) {
                for (int i = 0; i < this.WBMPWidth; ++i) {
                    for (int j = 0; j < this.WBMPLength; ++j) {
                        this.outFile.setElementAt(i, this.WBMPLength - 1 - j, this.getElementAt(j, i));
                    }
                }
            } else {
                for (int i = 0; i < this.WBMPWidth; ++i) {
                    for (int j = 0; j < this.WBMPLength; ++j) {
                        this.outFile.setElementAt(this.WBMPWidth - 1 - i, j, this.getElementAt(j, i));
                    }
                }
            }
        }
        return this.outFile;
    }

    public WBMPfile getRectArea(WBMPDimension wBMPDimension) {
        int n = this.getWBMPLength() - wBMPDimension.getX();
        int n2 = this.getWBMPWidth() - wBMPDimension.getY();
        if (n > wBMPDimension.getDimensionLength()) {
            n = wBMPDimension.getDimensionLength() - 1;
        }
        if (n2 > wBMPDimension.getDimensionWidth()) {
            n2 = wBMPDimension.getDimensionWidth() - 1;
        }
        this.outFile = new WBMPfile(n, n2);
        try {
            int n3 = wBMPDimension.getX();
            int n4 = wBMPDimension.getY();
            for (int i = 0; i < n; ++i) {
                for (int j = 0; j < n2; ++j) {
                    this.outFile.setElementAt(i, j, this.getElementAt(i + n3, j + n4));
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        return this.outFile;
    }

    public int[][] getWBMPpic() {
        WBMPfile wBMPfile = this;
        if (!this.isInstantiated) {
            this.KTdBb(wBMPfile);
        }
        return wBMPfile.WBMPpic;
    }

    private boolean lTht(OutputStream outputStream) {
        WBMPfile wBMPfile = this;
        try {
            outputStream.write(0);
            outputStream.write(0);
            int n = Integer.parseInt(String.valueOf(this.WBMPLength));
            outputStream.write(n);
            n = Integer.parseInt(String.valueOf(this.WBMPWidth));
            outputStream.write(n);
            int n2 = this.getExcNum(this.WBMPLength) / 8;
            for (int i = 0; i < this.WBMPWidth; ++i) {
                for (int j = 0; j < n2; ++j) {
                    n = 0;
                    for (int k = 7; k >= 0; --k) {
                        if (wBMPfile.WBMPpic[8 * j + 7 - k][i] == 0) continue;
                        n += WBMPfile.power2(k);
                    }
                    outputStream.write(n);
                }
            }
        }
        catch (Exception exception) {
            boolean bl = false;
            return bl;
        }
        return true;
    }

    WBMPfile KTdBb(WBMPfile wBMPfile) {
        WBMPfile wBMPfile2 = wBMPfile;
        int n = wBMPfile.getWBMPLength();
        int n2 = wBMPfile.getWBMPWidth();
        if (n < 35 || n2 < 7) {
            return wBMPfile2;
        }
        wBMPfile2.mix(WBMPCustomFont.getWBMPImage("(c) Max", 1, 0), 1, n - 35, n2 - 7);
        return wBMPfile2;
    }

    private void LTht(int n, int n2, int n3, int n4, int n5, boolean bl) {
        if (bl) {
            for (int i = 0; i < n3; ++i) {
                this.ltHt(n + i, n2, n + i, n2 + n4, n5);
            }
        } else {
            this.ltHt(n, n2, n + n3, n2, n5);
            this.ltHt(n, n2, n, n2 + n4, n5);
            this.ltHt(n + n3, n2, n + n3, n2 + n4, n5);
            this.ltHt(n, n2 + n4, n + n3, n2 + n4, n5);
        }
    }

    private void ltHt(int n, int n2, int n3, int n4, int n5) {
        int n6;
        int n7 = Math.abs(n3 - n);
        int n8 = Math.abs(n4 - n2);
        int n9 = n3 >= n ? 1 : -1;
        int n10 = n6 = n4 >= n2 ? 1 : -1;
        if (n8 <= n7) {
            int n11 = (n8 << 1) - n7;
            int n12 = n8 << 1;
            int n13 = n8 - n7 << 1;
            this.drawPoint(n, n2, n5);
            int n14 = n + n9;
            int n15 = n2;
            int n16 = 1;
            while (n16 <= n7) {
                if (n11 > 0) {
                    n11 += n13;
                    n15 += n6;
                } else {
                    n11 += n12;
                }
                this.drawPoint(n14, n15, n5);
                ++n16;
                n14 += n9;
            }
        } else {
            int n17 = (n7 << 1) - n7;
            int n18 = n7 << 1;
            int n19 = n7 - n8 << 1;
            this.drawPoint(n, n2, n5);
            int n20 = n;
            int n21 = n2 + n6;
            int n22 = 1;
            while (n22 <= n8) {
                if (n17 > 0) {
                    n17 += n19;
                    n20 += n9;
                } else {
                    n17 += n18;
                }
                this.drawPoint(n20, n21, n5);
                ++n22;
                n21 += n6;
            }
        }
    }

    private void LtHt(int n, int n2, int n3) {
        try {
            this.WBMPpic[n][n2] = n3;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void lTHt(int n, int n2, int n3, int n4, int n5, boolean bl, boolean bl2) {
        this.LTht(n, n2, n3, n4, n5, bl);
        if (bl2) {
            this.ltHt(n + n3 + 1, n2 + 1, n + n3 + 1, n2 + n4 + 1, n5);
            this.ltHt(n + 1, n2 + n4 + 1, n + n3 + 1, n2 + n4 + 1, n5);
        }
    }

    public void drawCircle(int n, int n2, int n3, int n4, boolean bl) {
        if (bl) {
            for (int i = 0; i < 180; ++i) {
                int n5 = (int)((double)n + (double)n3 * Math.cos(i));
                this.ltHt(n5, (int)((double)n2 + (double)n3 * Math.sin(i)), n5, (int)((double)n2 - (double)n3 * Math.sin(i)), n4);
            }
        } else {
            for (int i = 0; i < 360; ++i) {
                this.LtHt((int)((double)n + (double)n3 * Math.cos(i)), (int)((double)n2 + (double)n3 * Math.sin(i)), n4);
            }
        }
    }

    private void LTHt(int n, int n2, int n3, int n4, int n5, boolean bl) {
        int n6 = n + n3 / 2;
        int n7 = n2 + n4 / 2;
        if (bl) {
            for (int i = 0; i < 360; ++i) {
                int n8 = n6 - (int)((double)n3 / (double)2 * Math.cos(i / 2));
                this.ltHt(n8, n7 + (int)((double)n4 / (double)2 * Math.sin(i / 2)), n8, n7 - (int)((double)n4 / (double)2 * Math.sin(i / 2)), n5);
            }
        } else {
            for (int i = 0; i < 360; ++i) {
                this.LtHt(n6 + (int)((double)n3 / (double)2 * Math.cos(i)), n7 - (int)((double)n4 / (double)2 * Math.sin(i)), n5);
            }
        }
    }

    private void lthT(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        int n8 = n + n3 / 2;
        int n9 = n2 + n4 / 2;
        for (int i = n5; i < n6 + 1; ++i) {
            this.LtHt(n8 + (int)((double)(n3 / 2) * Math.cos(i)), n9 - (int)((double)(n4 / 2) * Math.sin(i)), n7);
        }
    }

    public void drawSpecialLine(int n, int n2, int n3, int n4, int n5, int n6) {
        double d = 0.0;
        int n7 = n3 - n;
        int n8 = n4 - n2;
        d = Math.sqrt(n7 * n7 + n8 * n8);
        double d2 = (double)n7 / d;
        double d3 = (double)n8 / d;
        switch (n5) {
            case 1: {
                int n9 = 1;
                while ((long)n9 <= Math.round(d)) {
                    if (n9 / 2 * 2 == n9) {
                        this.drawPoint((int)((long)n + Math.round((double)n9 * d2)), (int)((long)n2 + Math.round((double)n9 * d3)), n6);
                    }
                    ++n9;
                }
                break;
            }
            case 2: {
                int n10 = 1;
                while ((long)n10 <= Math.round(d)) {
                    if (n10 / 3 * 3 == n10) {
                        this.drawPoint((int)((long)n + Math.round((double)n10 * d2)), (int)((long)n2 + Math.round((double)n10 * d3)), n6);
                    }
                    ++n10;
                }
                break;
            }
            case 3: {
                int n11 = 1;
                while ((long)n11 <= Math.round(d)) {
                    if (n11 / 3 * 3 == n11) {
                        this.drawPoint((int)((long)n + Math.round((double)n11 * d2)), (int)((long)n2 + Math.round((double)n11 * d3)), n6);
                    }
                    ++n11;
                }
                break;
            }
            case 21: {
                int n12 = 1;
                while ((long)n12 <= Math.round(d)) {
                    if (n12 / 3 * 3 != n12) {
                        this.drawPoint((int)((long)n + Math.round((double)n12 * d2)), (int)((long)n2 + Math.round((double)n12 * d3)), n6);
                    }
                    ++n12;
                }
                break;
            }
            case 22: {
                int n13 = 1;
                while ((long)n13 <= Math.round(d)) {
                    if (n13 / 4 * 4 == n13 || n13 / 4 * 4 == n13 + 1) {
                        this.drawPoint((int)((long)n + Math.round((double)n13 * d2)), (int)((long)n2 + Math.round((double)n13 * d3)), n6);
                    }
                    ++n13;
                }
                break;
            }
            case 32: {
                int n14 = 1;
                while ((long)n14 <= Math.round(d)) {
                    if (n14 - n14 / 5 * 5 < 3) {
                        this.drawPoint((int)((long)n + Math.round((double)n14 * d2)), (int)((long)n2 + Math.round((double)n14 * d3)), n6);
                    }
                    ++n14;
                }
                break;
            }
            case 131: {
                int n15 = 1;
                while ((long)n15 <= Math.round(d)) {
                    int n16 = n15 - n15 / 6 * 6;
                    if (n16 < 3 || n16 == 5) {
                        this.drawPoint((int)((long)n + Math.round((double)n15 * d2)), (int)((long)n2 + Math.round((double)n15 * d3)), n6);
                    }
                    ++n15;
                }
                break;
            }
            case 132: {
                int n17 = 1;
                while ((long)n17 <= Math.round(d)) {
                    int n18 = n17 - n17 / 8 * 8;
                    if (n18 < 3 || n18 == 5 || n18 == 6) {
                        this.drawPoint((int)((long)n + Math.round((double)n17 * d2)), (int)((long)n2 + Math.round((double)n17 * d3)), n6);
                    }
                    ++n17;
                }
                break;
            }
        }
    }

    public WBMPfile(String string, int n) {
        try {
            String string2 = string.substring(0, string.indexOf("://"));
            String string3 = string.substring(string.indexOf("://") + 3);
            String string4 = string3.substring(string3.indexOf("/"));
            string3 = string3.substring(0, string3.indexOf("/"));
            URL uRL = new URL(string2, string3, n, string4);
            URLConnection uRLConnection = uRL.openConnection();
            InputStream inputStream = uRLConnection.getInputStream();
            int n2 = inputStream.available();
            byte[] byArray = new byte[n2];
            int n3 = inputStream.read(byArray);
            inputStream.close();
            n3 = byArray[2];
            if (n3 < 0) {
                n3 += 256;
            }
            this.setWBMPLength(n3);
            n3 = byArray[3];
            if (n3 < 0) {
                n3 += 256;
            }
            this.setWBMPWidth(n3);
            this.createWBMPFile();
            int n4 = 3;
            int n5 = this.getExcNum(this.WBMPLength) / 8;
            int[] nArray = new int[n5];
            int n6 = 0;
            for (n6 = 0; n6 < this.WBMPWidth; ++n6) {
                for (int i = 0; i < n5; ++i) {
                    nArray[i] = byArray[++n4];
                }
                this.convertBytes2Points(nArray, n5, n6);
            }
        }
        catch (Exception exception) {
            this.WBMPLength = 96;
            this.WBMPWidth = 44;
            this.createWBMPFile();
        }
    }

    public WBMPfile openEWBMPFile(String string) throws IOException {
        int n = 0;
        int n2 = 0;
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(string));
        byte[] byArray = new byte[bufferedInputStream.available()];
        bufferedInputStream.read(byArray);
        this.WBMPLength = this.LthT(byArray[2]) * 256 + this.LthT(byArray[3]);
        this.WBMPWidth = this.LthT(byArray[4]) * 256 + this.LthT(byArray[5]);
        this.createWBMPFile();
        n = this.getExcNum(this.WBMPLength) / 8;
        int[] nArray = new int[n];
        for (n2 = 0; n2 < this.WBMPWidth; ++n2) {
            for (int i = 0; i < n; ++i) {
                nArray[i] = this.LthT(byArray[6 + n2 * n + i]);
            }
            this.convertBytes2Points(nArray, n, n2);
        }
        bufferedInputStream.close();
        return this;
    }

    public void saveEWBMP2File(String string) {
        WBMPfile wBMPfile = this;
        int n = this.getExcNum(this.WBMPLength);
        int n2 = this.WBMPWidth;
        int n3 = 0;
        int n4 = n / 8;
        File file = new File(string);
        if (file.exists()) {
            file.delete();
        }
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            fileOutputStream.write(0);
            fileOutputStream.write(0);
            fileOutputStream.write(this.WBMPLength >> 8);
            fileOutputStream.write(this.WBMPLength);
            fileOutputStream.write(this.WBMPWidth >> 8);
            fileOutputStream.write(this.WBMPWidth);
            for (int i = 0; i < n2; ++i) {
                for (int j = 0; j < n4; ++j) {
                    n3 = 0;
                    for (int k = 7; k >= 0; --k) {
                        if (wBMPfile.WBMPpic[8 * j + 7 - k][i] == 0) continue;
                        n3 = (byte)(n3 + WBMPfile.power2(k));
                    }
                    fileOutputStream.write(n3);
                }
            }
            fileOutputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static synchronized WBMPfile executeSequence(String string) throws BadSequenceLineException, FileNotFoundException {
        WBMPfile wBMPfile = new WBMPfile(96, 45);
        try {
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(new FileInputStream(String.valueOf(string).concat(String.valueOf(".wbmpseq")))));
            String string2 = " ";
            int n = 0;
            if (string2.indexOf("##") == -1 && string2.indexOf("#") != -1) {
                string2 = string2.substring(0, string2.indexOf("#"));
            }
            while (n <= string2.length()) {
                if (string2.substring(n).indexOf("#") == string2.substring(n).indexOf("##")) {
                    if (string2.substring(n).indexOf("#") == -1) break;
                    string2 = String.valueOf(string2.substring(0, string2.substring(n).indexOf("#"))).concat(String.valueOf(string2.substring(string2.substring(n).indexOf("#") + 1)));
                    ++n;
                    continue;
                }
                if (string2.substring(n).indexOf("##") > string2.substring(n).indexOf("##")) {
                    string2 = string2.substring(string2.indexOf("#"));
                }
                ++n;
            }
            String string3 = "";
            while (!string2.equals(null)) {
                string2 = bufferedReader.readLine();
                try {
                    if (string2 == null) {
                    }
                }
                catch (NullPointerException nullPointerException) {}
                break;
                StringTokenizer stringTokenizer = new StringTokenizer(string2);
                string3 = stringTokenizer.nextToken().trim();
                if (string3.equals("SIZE")) {
                    wBMPfile.setWBMPLength(Integer.parseInt(stringTokenizer.nextToken()));
                    wBMPfile.setWBMPWidth(Integer.parseInt(stringTokenizer.nextToken()));
                    wBMPfile.createWBMPFile();
                }
                if (string3.equals("DRAWARC")) {
                    wBMPfile.drawArc(Integer.parseInt(stringTokenizer.nextToken()), Integer.parseInt(stringTokenizer.nextToken()), Integer.parseInt(stringTokenizer.nextToken()), Integer.parseInt(stringTokenizer.nextToken()), Integer.parseInt(stringTokenizer.nextToken()), Integer.parseInt(stringTokenizer.nextToken()));
                }
                if (string3.equals("DRAWCIRCLE")) {
                    wBMPfile.drawCircle(Integer.parseInt(stringTokenizer.nextToken()), Integer.parseInt(stringTokenizer.nextToken()), Integer.parseInt(stringTokenizer.nextToken()), Integer.parseInt(stringTokenizer.nextToken()), stringTokenizer.nextToken().equals("true"));
                }
                if (string3.equals("DRAWLINE")) {
                    wBMPfile.drawLine(Integer.parseInt(stringTokenizer.nextToken()), Integer.parseInt(stringTokenizer.nextToken()), Integer.parseInt(stringTokenizer.nextToken()), Integer.parseInt(stringTokenizer.nextToken()));
                }
                if (string3.equals("DRAWOVAL")) {
                    wBMPfile.drawOval(Integer.parseInt(stringTokenizer.nextToken()), Integer.parseInt(stringTokenizer.nextToken()), Integer.parseInt(stringTokenizer.nextToken()), Integer.parseInt(stringTokenizer.nextToken()), stringTokenizer.nextToken().equals("true"));
                }
                if (string3.equals("DRAWPOINT")) {
                    wBMPfile.drawPoint(Integer.parseInt(stringTokenizer.nextToken()), Integer.parseInt(stringTokenizer.nextToken()), Integer.parseInt(stringTokenizer.nextToken()));
                }
                if (string3.equals("DRAWRECT")) {
                    wBMPfile.drawRect(Integer.parseInt(stringTokenizer.nextToken()), Integer.parseInt(stringTokenizer.nextToken()), Integer.parseInt(stringTokenizer.nextToken()), Integer.parseInt(stringTokenizer.nextToken()), stringTokenizer.nextToken().equals("true"));
                }
                if (string3.equals("DRAW3DRECT")) {
                    wBMPfile.draw3DRect(Integer.parseInt(stringTokenizer.nextToken()), Integer.parseInt(stringTokenizer.nextToken()), Integer.parseInt(stringTokenizer.nextToken()), Integer.parseInt(stringTokenizer.nextToken()), stringTokenizer.nextToken().equals("true"), stringTokenizer.nextToken().equals("true"));
                }
                if (string3.equals("DRAWSPECIALLINE")) {
                    wBMPfile.drawSpecialLine(Integer.parseInt(stringTokenizer.nextToken()), Integer.parseInt(stringTokenizer.nextToken()), Integer.parseInt(stringTokenizer.nextToken()), Integer.parseInt(stringTokenizer.nextToken()), Integer.parseInt(stringTokenizer.nextToken()), Integer.parseInt(stringTokenizer.nextToken()));
                }
                if (string3.equals("DRAWCUSTOMSTRING")) {
                    String string4 = stringTokenizer.nextToken();
                    while (string4.lastIndexOf("\"") != string4.length() - 2) {
                        string4 = String.valueOf(string4).concat(String.valueOf(String.valueOf(stringTokenizer.nextToken()).concat(String.valueOf(" "))));
                    }
                    string4.trim();
                    string4 = string4.substring(1, string4.length() - 2);
                    int n2 = Integer.parseInt(stringTokenizer.nextToken());
                    int n3 = Integer.parseInt(stringTokenizer.nextToken());
                    String string5 = stringTokenizer.nextToken();
                    wBMPfile.drawCustomString(string4, n2, n3, string5, 0);
                }
                string2 = "";
            }
            bufferedReader.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new FileNotFoundException("The sequence name specified is not correct");
        }
        catch (IOException iOException) {
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return wBMPfile;
    }

    public WBMPfile openWBMPFile(String string) throws IOException {
        int n = 0;
        int n2 = 0;
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(string));
        byte[] byArray = new byte[bufferedInputStream.available()];
        bufferedInputStream.read(byArray);
        boolean bl = false;
        if (string.toUpperCase().indexOf(".OTB") == string.length() - 4) {
            bl = true;
        }
        if (bl) {
            this.WBMPLength = this.LthT(byArray[1]);
            this.WBMPWidth = this.LthT(byArray[2]);
        } else {
            this.WBMPLength = this.LthT(byArray[2]);
            this.WBMPWidth = this.LthT(byArray[3]);
        }
        this.createWBMPFile();
        n = this.getExcNum(this.WBMPLength) / 8;
        int[] nArray = new int[n];
        for (n2 = 0; n2 < this.WBMPWidth; ++n2) {
            for (int i = 0; i < n; ++i) {
                nArray[i] = this.LthT(byArray[4 + n2 * n + i]);
            }
            this.convertBytes2Points(nArray, n, n2);
        }
        bufferedInputStream.close();
        return this;
    }

    public WBMPfile(byte[] byArray) {
        int n = 0;
        int n2 = 0;
        this.WBMPLength = this.LthT(byArray[2]);
        this.WBMPWidth = this.LthT(byArray[3]);
        this.createWBMPFile();
        n = this.getExcNum(this.WBMPLength) / 8;
        int[] nArray = new int[n];
        for (n2 = 0; n2 < this.WBMPWidth; ++n2) {
            for (int i = 0; i < n; ++i) {
                nArray[i] = this.LthT(byArray[4 + n2 * n + i]);
            }
            this.convertBytes2Points(nArray, n, n2);
        }
    }

    private int LthT(byte n) {
        int n2 = n;
        if (n2 < 0) {
            n2 += 256;
        }
        return n2;
    }

    public void convert2WBMPfile(String string) {
        SimpleImageFile simpleImageFile = new SimpleImageFile(string);
    }

    public void convert2WBMPfile(URL uRL) {
        SimpleImageFile simpleImageFile = new SimpleImageFile(uRL);
    }

    public WBMPfile(SimpleImageFile simpleImageFile, int n, int n2, int n3) {
        this.setWBMPLength(simpleImageFile.getLength());
        this.setWBMPWidth(simpleImageFile.getWidth());
        this.createWBMPFile();
        try {
            boolean bl;
            WBMPFilter wBMPFilter = new WBMPFilter();
            boolean bl2 = bl = n < 0 || n2 < 0 || n3 < 0;
            if (!bl) {
                wBMPFilter.setRedThreshold(n);
                wBMPFilter.setGreenThreshold(n2);
                wBMPFilter.setBlueThreshold(n3);
                this.ltht(wBMPFilter.simpleImageFilter(simpleImageFile.getPointArray(), simpleImageFile.getLength(), simpleImageFile.getWidth(), 1));
            } else {
                int n4 = 0;
                if (n < 0) {
                    ++n4;
                }
                if (n2 < 0) {
                    n4 += 2;
                }
                if (n3 < 0) {
                    n4 += 4;
                }
                this.ltht(wBMPFilter.simpleImageFilter(simpleImageFile.getPointArray(), simpleImageFile.getLength(), simpleImageFile.getWidth(), 1, n4));
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private int[] lThT() {
        int[] nArray = new int[this.WBMPLength * this.WBMPWidth];
        for (int i = 0; i < this.WBMPLength; ++i) {
            for (int j = 0; j < this.WBMPWidth; ++j) {
                nArray[j * this.WBMPLength + i] = this.WBMPpic[i][j];
            }
        }
        return nArray;
    }

    public WBMPfile(String string, int n, boolean bl) throws InterruptedException {
        SimpleImageFile simpleImageFile = new SimpleImageFile(string);
        WBMPFilter wBMPFilter = new WBMPFilter();
        this.WBMPLength = simpleImageFile.getLength();
        this.WBMPWidth = simpleImageFile.getWidth();
        this.WBMPpic = wBMPFilter.complexImageFilter(simpleImageFile.getPointArray(), simpleImageFile.getLength(), simpleImageFile.getWidth(), n).getWBMPpic();
        if (bl) {
            this.invertWBMPImage();
        }
    }

    public void saveWBMPFile(String string, String string2) {
        int n;
        WBMPfile wBMPfile = this;
        if (!this.isInstantiated) {
            this.KTdBb(wBMPfile);
        }
        BufferedImage bufferedImage = new BufferedImage(this.WBMPLength, this.WBMPWidth, 12);
        Graphics graphics = bufferedImage.getGraphics();
        graphics.setColor(Color.white);
        graphics.fillRect(0, 0, this.WBMPLength, this.WBMPWidth);
        graphics.setColor(Color.black);
        for (n = 0; n < this.WBMPLength; ++n) {
            for (int i = 0; i < this.WBMPWidth; ++i) {
                if (wBMPfile.WBMPpic[n][i] != 0) continue;
                graphics.fillRect(n, i, 1, 1);
            }
        }
        try {
            n = 0;
            if (string.toUpperCase().equals("BMP")) {
                n = 1;
            } else if (string.toUpperCase().equals("PNG")) {
                n = 2;
            } else if (string.toUpperCase().equals("JPG")) {
                n = 4;
            } else if (string.toUpperCase().equals("TIFF")) {
                n = 8;
            } else if (string.toUpperCase().equals("WBMP")) {
                n = 16;
            } else if (string.toUpperCase().equals("OTA")) {
                n = 32;
            }
            WBMP2BMP wBMP2BMP = new WBMP2BMP();
            FileOutputStream fileOutputStream = null;
            if (n < 16) {
                fileOutputStream = new FileOutputStream(string2);
            }
            switch (n) {
                case 1: {
                    ImageEncoder imageEncoder = wBMP2BMP.getImageEncoder(fileOutputStream);
                    imageEncoder.encode(bufferedImage);
                    break;
                }
                case 2: {
                    ImageEncoder imageEncoder = wBMP2BMP.getPNGImageEncoder(fileOutputStream);
                    imageEncoder.encode(bufferedImage);
                    break;
                }
                case 4: {
                    ImageEncoder imageEncoder = wBMP2BMP.getJPEGImageEncoder(fileOutputStream);
                    imageEncoder.encode(bufferedImage);
                    break;
                }
                case 8: {
                    ImageEncoder imageEncoder = wBMP2BMP.getTIFFImageEncoder(fileOutputStream);
                    imageEncoder.encode(bufferedImage);
                    break;
                }
                case 16: {
                    wBMPfile.Ltht(string2);
                    break;
                }
                case 32: {
                    wBMPfile.LThT(string2);
                }
            }
            if (n < 16) {
                fileOutputStream.flush();
                fileOutputStream.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void writeWBMPFile(String string, OutputStream outputStream) {
        int n;
        WBMPfile wBMPfile = this;
        if (!this.isInstantiated) {
            this.KTdBb(wBMPfile);
        }
        BufferedImage bufferedImage = new BufferedImage(this.WBMPLength, this.WBMPWidth, 12);
        Graphics graphics = bufferedImage.getGraphics();
        graphics.setColor(Color.white);
        graphics.fillRect(0, 0, this.WBMPLength, this.WBMPWidth);
        graphics.setColor(Color.black);
        for (n = 0; n < this.WBMPLength; ++n) {
            for (int i = 0; i < this.WBMPWidth; ++i) {
                if (wBMPfile.WBMPpic[n][i] != 0) continue;
                graphics.fillRect(n, i, 1, 1);
            }
        }
        try {
            n = 0;
            if (string.toUpperCase().equals("BMP")) {
                n = 1;
            } else if (string.toUpperCase().equals("PNG")) {
                n = 2;
            } else if (string.toUpperCase().equals("JPG")) {
                n = 4;
            } else if (string.toUpperCase().equals("TIFF")) {
                n = 8;
            } else if (string.toUpperCase().equals("WBMP")) {
                n = 16;
            } else if (string.toUpperCase().equals("OTA")) {
                n = 32;
            }
            WBMP2BMP wBMP2BMP = new WBMP2BMP();
            switch (n) {
                case 1: {
                    ImageEncoder imageEncoder = wBMP2BMP.getImageEncoder(outputStream);
                    imageEncoder.encode(bufferedImage);
                    break;
                }
                case 2: {
                    ImageEncoder imageEncoder = wBMP2BMP.getPNGImageEncoder(outputStream);
                    imageEncoder.encode(bufferedImage);
                    break;
                }
                case 4: {
                    ImageEncoder imageEncoder = wBMP2BMP.getJPEGImageEncoder(outputStream);
                    imageEncoder.encode(bufferedImage);
                    break;
                }
                case 8: {
                    ImageEncoder imageEncoder = wBMP2BMP.getTIFFImageEncoder(outputStream);
                    imageEncoder.encode(bufferedImage);
                    break;
                }
                case 16: {
                    wBMPfile.lTht(outputStream);
                    break;
                }
                case 32: {
                    wBMPfile.ltHT(outputStream);
                }
            }
            if (n < 16) {
                outputStream.flush();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void LThT(String string) {
        WBMPfile wBMPfile = this;
        File file = new File(string);
        if (file.exists()) {
            file.delete();
        }
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            fileOutputStream.write(0);
            fileOutputStream.write((byte)this.WBMPLength);
            fileOutputStream.write((byte)this.WBMPWidth);
            fileOutputStream.write(1);
            int n = this.getExcNum(this.WBMPLength);
            int n2 = this.WBMPWidth;
            int n3 = 0;
            int n4 = n / 8;
            for (int i = 0; i < n2; ++i) {
                for (int j = 0; j < n4; ++j) {
                    n3 = 0;
                    for (int k = 7; k >= 0; --k) {
                        if (wBMPfile.WBMPpic[8 * j + 7 - k][i] == 0) continue;
                        n3 = (byte)(n3 + WBMPfile.power2(k));
                    }
                    fileOutputStream.write(n3);
                }
            }
            fileOutputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void ltHT(OutputStream outputStream) {
        WBMPfile wBMPfile = this;
        try {
            outputStream.write(0);
            outputStream.write((byte)this.WBMPLength);
            outputStream.write((byte)this.WBMPWidth);
            outputStream.write(1);
            int n = this.getExcNum(this.WBMPLength);
            int n2 = this.WBMPWidth;
            int n3 = 0;
            int n4 = n / 8;
            for (int i = 0; i < n2; ++i) {
                for (int j = 0; j < n4; ++j) {
                    n3 = 0;
                    for (int k = 7; k >= 0; --k) {
                        if (wBMPfile.WBMPpic[8 * j + 7 - k][i] == 0) continue;
                        n3 = (byte)(n3 + WBMPfile.power2(k));
                    }
                    outputStream.write(n3);
                }
            }
            outputStream.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public byte[] getByteArray(String string) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] byArray = new byte[4];
        if (string.equalsIgnoreCase("WBMP")) {
            byArray[0] = 0;
            byArray[1] = 0;
            byArray[2] = (byte)this.WBMPLength;
            byArray[3] = (byte)this.WBMPWidth;
        } else if (string.equalsIgnoreCase("OTA")) {
            byArray[0] = 0;
            byArray[1] = (byte)this.WBMPLength;
            byArray[2] = (byte)this.WBMPWidth;
            byArray[3] = 1;
        }
        try {
            byteArrayOutputStream.write(byArray);
        }
        catch (Exception exception) {
            // empty catch block
        }
        int n = this.getExcNum(this.WBMPLength);
        int n2 = this.WBMPWidth;
        int n3 = 0;
        int n4 = n / 8;
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n4; ++j) {
                n3 = 0;
                for (int k = 7; k >= 0; --k) {
                    if (this.WBMPpic[8 * j + 7 - k][i] == 0) continue;
                    n3 = (byte)(n3 + WBMPfile.power2(k));
                }
                byteArrayOutputStream.write(n3);
            }
        }
        return byteArrayOutputStream.toByteArray();
    }

    public WBMPfile align(WBMPfile wBMPfile, WBMPfile wBMPfile2, int n, int n2) {
        WBMPfile wBMPfile3 = new WBMPfile(wBMPfile.getByteArray("WBMP"));
        int n3 = 0;
        int n4 = 0;
        switch (n) {
            case 10: {
                break;
            }
            case 11: {
                n3 = wBMPfile.getWBMPLength() - wBMPfile2.getWBMPLength();
                break;
            }
            case 12: {
                n3 = (wBMPfile.getWBMPLength() - wBMPfile2.getWBMPLength()) / 2;
                break;
            }
            case 13: {
                break;
            }
            case 14: {
                n4 = wBMPfile.getWBMPWidth() - wBMPfile2.getWBMPWidth();
                break;
            }
            case 15: {
                n4 = (wBMPfile.getWBMPWidth() - wBMPfile2.getWBMPWidth()) / 2;
                break;
            }
            case 16: {
                n4 = (wBMPfile.getWBMPWidth() - wBMPfile2.getWBMPWidth()) / 2;
                n3 = (wBMPfile.getWBMPLength() - wBMPfile2.getWBMPLength()) / 2;
            }
        }
        wBMPfile3.mix(wBMPfile2, n2, n3, n4);
        return wBMPfile3;
    }

    public WBMPfile drawTTFString(String string, Font font) {
        BufferedImage bufferedImage = new BufferedImage(10, 10, 10);
        Graphics graphics = bufferedImage.getGraphics();
        int n = graphics.getFontMetrics().getHeight();
        graphics.setFont(font);
        int n2 = graphics.getFontMetrics().stringWidth(string);
        graphics = null;
        bufferedImage = null;
        WBMPfile wBMPfile = new WBMPfile(n2, n);
        wBMPfile.drawString(string, 0, n - 1, font);
        return wBMPfile.reduce(1);
    }

    public WBMPfile reduce(int n) {
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7 = 0;
        for (n6 = 0; n6 < this.WBMPWidth; ++n6) {
            n5 = 0;
            for (n4 = 0; n4 < this.WBMPLength; ++n4) {
                if (this.WBMPpic[n4][n6] != n) continue;
                ++n5;
            }
            if (n5 != this.WBMPLength) break;
            n7 = n6 + 1;
        }
        n6 = this.WBMPWidth - 1;
        n5 = this.WBMPWidth - 1;
        while (n5 >= 0) {
            n4 = 0;
            for (n3 = this.WBMPLength; n3 >= 0; --n3) {
                if (this.WBMPpic[n3][n5] != n) continue;
                ++n4;
            }
            if (n4 != this.WBMPLength) break;
            n6 = n5--;
        }
        if (n6 == 0) {
            n6 = this.WBMPWidth - 1;
        }
        n5 = 0;
        for (n4 = 0; n4 < this.WBMPLength; ++n4) {
            n3 = 0;
            for (n2 = 0; n2 < this.WBMPWidth; ++n2) {
                if (this.WBMPpic[n4][n2] != n) continue;
                ++n3;
            }
            if (n3 != this.WBMPWidth) break;
            n5 = n4 + 1;
        }
        n4 = this.WBMPLength - 1;
        n3 = this.WBMPLength - 1;
        while (n3 >= 0) {
            n2 = 0;
            for (int i = 0; i < this.WBMPWidth; ++i) {
                if (this.WBMPpic[n3][i] != n) continue;
                ++n2;
            }
            if (n2 != this.WBMPWidth) break;
            n4 = n3--;
        }
        return this.getRectArea(new WBMPDimension(n5, n7, n4 - n5 + 1, n6 - n7 + 1));
    }
}

