/*
 * Decompiled with CFR 0.152.
 */
package com.others;

import com.others.SeekableStream;
import java.io.IOException;

public class ByteArraySeekableStream
extends SeekableStream {
    private byte[] lth;
    private int Lth;
    private int lTh;
    private int LTh;

    public ByteArraySeekableStream(byte[] byArray, int n, int n2) throws IOException {
        this.lth = byArray;
        this.Lth = n;
        this.lTh = n2;
    }

    public ByteArraySeekableStream(byte[] byArray) throws IOException {
        this(byArray, 0, byArray.length);
    }

    public boolean canSeekBackwards() {
        return true;
    }

    public long getFilePointer() {
        return this.LTh;
    }

    public void seek(long l) {
        this.LTh = (int)l;
    }

    public int read() {
        if (this.LTh < this.lTh + this.Lth) {
            return this.lth[this.LTh++ + this.Lth] & 0xFF;
        }
        return -1;
    }

    public int read(byte[] byArray, int n, int n2) {
        if (byArray == null) {
            throw new NullPointerException();
        }
        if (n < 0 || n2 < 0 || n + n2 > byArray.length) {
            throw new IndexOutOfBoundsException();
        }
        if (n2 == 0) {
            return 0;
        }
        int n3 = this.LTh;
        this.LTh = Math.min(this.LTh + n2, this.lTh + this.Lth);
        if (this.LTh == n3) {
            return -1;
        }
        System.arraycopy(this.lth, n3, byArray, n, this.LTh - n3);
        return this.LTh - n3;
    }

    public int skipBytes(int n) {
        int n2 = this.LTh;
        this.LTh = Math.min(this.LTh + n, this.lTh + this.Lth);
        return this.LTh - n2;
    }

    public void close() {
    }

    public long length() {
        return this.lTh;
    }
}

