/*
 * Decompiled with CFR 0.152.
 */
package com.others;

import com.others.BMPCodec;
import com.others.FPXCodec;
import com.others.FileSeekableStream;
import com.others.GIFCodec;
import com.others.ImageDecodeParam;
import com.others.ImageDecoder;
import com.others.ImageEncodeParam;
import com.others.ImageEncoder;
import com.others.JPEGCodec;
import com.others.PNGCodec;
import com.others.SeekableStream;
import com.others.TIFFCodec;
import com.others.dlKhlHz;
import java.awt.color.ColorSpace;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public abstract class ImageCodec {
    private static Hashtable Lthtl = new Hashtable();
    private static final byte[][] lThtl;
    private static final int[] LThtl;
    private static final ComponentColorModel ltHtl;
    private static final int[] LtHtl;
    private static final ComponentColorModel lTHtl;
    private static final int[] LTHtl;
    private static final ComponentColorModel lthTl;
    private static final int[] LthTl;
    private static final ComponentColorModel lThTl;
    private static final int[] LThTl;
    private static final ComponentColorModel ltHTl;
    private static final int[] LtHTl;
    private static final ComponentColorModel lTHTl;
    private static final int[] LTHTl;
    private static final ComponentColorModel lthtL;
    private static final int[] LthtL;
    private static final ComponentColorModel lThtL;
    private static final int[] LThtL;
    private static final ComponentColorModel ltHtL;
    private static final int[] LtHtL;
    private static final ComponentColorModel lTHtL;
    private static final int[] LTHtL;
    private static final ComponentColorModel lthTL;
    private static final int[] LthTL;
    private static final ComponentColorModel lThTL;

    protected ImageCodec() {
    }

    public static ImageCodec getCodec(String string) {
        return (ImageCodec)Lthtl.get(string.toLowerCase());
    }

    public static void registerCodec(ImageCodec imageCodec) {
        Lthtl.put(imageCodec.getFormatName().toLowerCase(), imageCodec);
    }

    public static void unregisterCodec(String string) {
        Lthtl.remove(string.toLowerCase());
    }

    public static Enumeration getCodecs() {
        return Lthtl.elements();
    }

    public static ImageEncoder createImageEncoder(String string, OutputStream outputStream, ImageEncodeParam imageEncodeParam) {
        ImageCodec imageCodec = ImageCodec.getCodec(string);
        if (imageCodec == null) {
            return null;
        }
        return imageCodec.createImageEncoder(outputStream, imageEncodeParam);
    }

    public static ImageDecoder createImageDecoder(String string, InputStream inputStream, ImageDecodeParam imageDecodeParam) {
        ImageCodec imageCodec = ImageCodec.getCodec(string);
        if (imageCodec == null) {
            return null;
        }
        return imageCodec.createImageDecoder(inputStream, imageDecodeParam);
    }

    public static ImageDecoder createImageDecoder(String string, File file, ImageDecodeParam imageDecodeParam) throws IOException {
        ImageCodec imageCodec = ImageCodec.getCodec(string);
        if (imageCodec == null) {
            return null;
        }
        return imageCodec.createImageDecoder(file, imageDecodeParam);
    }

    public static ImageDecoder createImageDecoder(String string, SeekableStream seekableStream, ImageDecodeParam imageDecodeParam) {
        ImageCodec imageCodec = ImageCodec.getCodec(string);
        if (imageCodec == null) {
            return null;
        }
        return imageCodec.createImageDecoder(seekableStream, imageDecodeParam);
    }

    private static String[] lthtl(Vector vector) {
        int n = vector.size();
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = (String)vector.elementAt(i);
        }
        return stringArray;
    }

    public static String[] getDecoderNames(SeekableStream seekableStream) {
        if (!seekableStream.canSeekBackwards() && !seekableStream.markSupported()) {
            throw new IllegalArgumentException(dlKhlHz.getString("ImageCodec2"));
        }
        Enumeration enumeration = Lthtl.elements();
        Vector<String> vector = new Vector<String>();
        Object var3_3 = null;
        while (enumeration.hasMoreElements()) {
            ImageCodec imageCodec = (ImageCodec)enumeration.nextElement();
            int n = imageCodec.getNumHeaderBytes();
            if (n == 0 && !seekableStream.canSeekBackwards()) continue;
            try {
                if (n > 0) {
                    seekableStream.mark(n);
                    byte[] byArray = new byte[n];
                    seekableStream.readFully(byArray);
                    seekableStream.reset();
                    if (!imageCodec.isFormatRecognized(byArray)) continue;
                    vector.add(imageCodec.getFormatName());
                    continue;
                }
                long l = seekableStream.getFilePointer();
                seekableStream.seek(0L);
                if (imageCodec.isFormatRecognized(seekableStream)) {
                    vector.add(imageCodec.getFormatName());
                }
                seekableStream.seek(l);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        return ImageCodec.lthtl(vector);
    }

    public static String[] getEncoderNames(RenderedImage renderedImage, ImageEncodeParam imageEncodeParam) {
        Enumeration enumeration = Lthtl.elements();
        Vector<String> vector = new Vector<String>();
        Object var4_4 = null;
        while (enumeration.hasMoreElements()) {
            ImageCodec imageCodec = (ImageCodec)enumeration.nextElement();
            if (!imageCodec.canEncodeImage(renderedImage, imageEncodeParam)) continue;
            vector.add(imageCodec.getFormatName());
        }
        return ImageCodec.lthtl(vector);
    }

    public abstract String getFormatName();

    public int getNumHeaderBytes() {
        return 0;
    }

    public boolean isFormatRecognized(byte[] byArray) {
        throw new RuntimeException(dlKhlHz.getString("ImageCodec0"));
    }

    public boolean isFormatRecognized(SeekableStream seekableStream) throws IOException {
        throw new RuntimeException(dlKhlHz.getString("ImageCodec1"));
    }

    protected abstract Class getEncodeParamClass();

    protected abstract Class getDecodeParamClass();

    protected abstract ImageEncoder createImageEncoder(OutputStream var1, ImageEncodeParam var2);

    public abstract boolean canEncodeImage(RenderedImage var1, ImageEncodeParam var2);

    protected ImageDecoder createImageDecoder(InputStream inputStream, ImageDecodeParam imageDecodeParam) {
        SeekableStream seekableStream = SeekableStream.wrapInputStream(inputStream, true);
        return this.createImageDecoder(seekableStream, imageDecodeParam);
    }

    protected ImageDecoder createImageDecoder(File file, ImageDecodeParam imageDecodeParam) throws IOException {
        return this.createImageDecoder(new FileSeekableStream(file), imageDecodeParam);
    }

    protected abstract ImageDecoder createImageDecoder(SeekableStream var1, ImageDecodeParam var2);

    public static ColorModel createGrayIndexColorModel(SampleModel sampleModel, boolean bl) {
        byte[] byArray;
        int n;
        block7: {
            block6: {
                if (sampleModel.getNumBands() != 1) {
                    throw new IllegalArgumentException();
                }
                n = sampleModel.getSampleSize(0);
                byArray = null;
                if (n >= 8) break block6;
                byArray = lThtl[n];
                if (bl) break block7;
                int n2 = byArray.length;
                byte[] byArray2 = new byte[n2];
                for (int i = 0; i < n2; ++i) {
                    byArray2[i] = byArray[n2 - i - 1];
                }
                byArray = byArray2;
                break block7;
            }
            byArray = new byte[256];
            if (!bl) {
                for (int i = 0; i < 256; ++i) {
                    byArray[i] = (byte)i;
                }
            } else {
                for (int i = 0; i < 256; ++i) {
                    byArray[i] = (byte)(255 - i);
                }
            }
        }
        return new IndexColorModel(n, byArray.length, byArray, byArray, byArray);
    }

    public static ColorModel createComponentColorModel(SampleModel sampleModel) {
        int n = sampleModel.getDataType();
        int n2 = sampleModel.getNumBands();
        ComponentColorModel componentColorModel = null;
        if (n == 0) {
            switch (n2) {
                case 1: {
                    componentColorModel = ltHtl;
                    break;
                }
                case 2: {
                    componentColorModel = lTHtl;
                    break;
                }
                case 3: {
                    componentColorModel = lthtL;
                    break;
                }
                case 4: {
                    componentColorModel = lThtL;
                }
            }
        } else if (n == 1) {
            switch (n2) {
                case 1: {
                    componentColorModel = lthTl;
                    break;
                }
                case 2: {
                    componentColorModel = lThTl;
                    break;
                }
                case 3: {
                    componentColorModel = ltHtL;
                    break;
                }
                case 4: {
                    componentColorModel = lTHtL;
                }
            }
        } else if (n == 3) {
            switch (n2) {
                case 1: {
                    componentColorModel = ltHTl;
                    break;
                }
                case 2: {
                    componentColorModel = lTHTl;
                    break;
                }
                case 3: {
                    componentColorModel = lthTL;
                    break;
                }
                case 4: {
                    componentColorModel = lThTL;
                }
            }
        }
        return componentColorModel;
    }

    static {
        ImageCodec.registerCodec(new BMPCodec());
        ImageCodec.registerCodec(new GIFCodec());
        ImageCodec.registerCodec(new FPXCodec());
        ImageCodec.registerCodec(new JPEGCodec());
        ImageCodec.registerCodec(new PNGCodec());
        ImageCodec.registerCodec(new TIFFCodec());
        lThtl = new byte[][]{null, {0, -1}, {0, 85, -86, -1}, null, {0, 17, 34, 51, 68, 85, 102, 119, -120, -103, -86, -69, -52, -35, -18, -1}};
        LThtl = new int[]{8};
        ltHtl = new ComponentColorModel(ColorSpace.getInstance(1003), LThtl, false, false, 1, 0);
        LtHtl = new int[]{8, 8};
        lTHtl = new ComponentColorModel(ColorSpace.getInstance(1003), LtHtl, true, false, 3, 0);
        LTHtl = new int[]{16};
        lthTl = new ComponentColorModel(ColorSpace.getInstance(1003), LTHtl, false, false, 1, 1);
        LthTl = new int[]{16, 16};
        lThTl = new ComponentColorModel(ColorSpace.getInstance(1003), LthTl, true, false, 3, 1);
        LThTl = new int[]{32};
        ltHTl = new ComponentColorModel(ColorSpace.getInstance(1003), LThTl, false, false, 1, 3);
        LtHTl = new int[]{32, 32};
        lTHTl = new ComponentColorModel(ColorSpace.getInstance(1003), LtHTl, true, false, 3, 3);
        LTHTl = new int[]{8, 8, 8};
        lthtL = new ComponentColorModel(ColorSpace.getInstance(1000), LTHTl, false, false, 1, 0);
        LthtL = new int[]{8, 8, 8, 8};
        lThtL = new ComponentColorModel(ColorSpace.getInstance(1000), LthtL, true, false, 3, 0);
        LThtL = new int[]{16, 16, 16};
        ltHtL = new ComponentColorModel(ColorSpace.getInstance(1000), LThtL, false, false, 1, 1);
        LtHtL = new int[]{16, 16, 16, 16};
        lTHtL = new ComponentColorModel(ColorSpace.getInstance(1000), LtHtL, true, false, 3, 1);
        LTHtL = new int[]{32, 32, 32};
        lthTL = new ComponentColorModel(ColorSpace.getInstance(1000), LTHtL, false, false, 1, 3);
        LthTL = new int[]{32, 32, 32, 32};
        lThTL = new ComponentColorModel(ColorSpace.getInstance(1000), LthTL, true, false, 3, 3);
    }
}

