/*
This is a simple cross-browser API (for IE, NN4, and NN6+).  Including it on the page gives access to the object X, an object that is just a container for several "static" methods (and some fields describing the web client).  There is no need to instantiate this object.

*** booleans:
X.systemIsWindows
X.systemIsMac
X.browserIsIE
X.browserIsNN4
X.browserIsNN6Plus

*** ints:
X.browserVersion (major version only, e.g. 6, not 6.02)

*** methods:
X.getDiv(d): get a reference to the div named d
X.getImage(d,i): get a reference to the img named i in the div named d
X.getForm(d,f): get a reference to the form named f in the div named d
X.writeToDiv(d,s): write the string s to div d (erasing existing contents if any)
X.appendToDiv(d,s): append the string s to the end of the current contents of div d (NB: the API will give you a JS alert if you try this in NN4)
X.setDivStyle(d,n,v): set the style n of div d to value v
X._writeOrAppendToDiv(x,y,z): private method; do not use.

*/

function _X()
{
	this.systemIsWindows=(navigator.appVersion.toLowerCase().indexOf("windows")>-1)
	this.systemIsMac=(navigator.appVersion.toLowerCase().indexOf("mac")>-1)

	this.browserIsIE=(navigator.appName.toLowerCase().indexOf("microsoft")>-1)
	this.browserIsNN4=false
	this.browserIsNN6Plus=false

	if (!this.browserIsIE)
	{
		if (navigator.appVersion.charAt(0)=="4")
		{
			this.browserIsNN4=true
		}
		else
		{
			this.browserIsNN6Plus=true
		}
	}

	this.browserVersion=0
	if (this.browserIsNN4 || this.browserIsNN6Plus)
	{
		this.browserVersion=parseInt(navigator.appVersion.charAt(0))
	}
	if (this.browserIsIE)
	{
		var tempSplit=navigator.appVersion.split("MSIE ")
		this.browserVersion=parseInt(tempSplit[1].charAt(0))
	}

	this.getDiv=_getDiv;
	this.getImage=_getImage;
	this.getForm=_getForm;
	this._writeOrAppendToDiv=__writeOrAppendToDiv;
	this.writeToDiv=_writeToDiv;
	this.appendToDiv=_appendToDiv;
	this.setDivStyle=_setDivStyle;
}


function _getDiv(divName)
{
	var targetDiv
	if (this.browserIsIE)
	{
		targetDiv=document.all[divName]
	}
	else if (this.browserIsNN6Plus)
	{
		targetDiv=document.getElementById(divName)
	}
	else if (this.browserIsNN4)
	{
		targetDiv=document.layers[divName]
		if (!targetDiv)
		{
			var docLayers=document.layers
			for (var i=0; i<docLayers.length; i++)
			{
				targetDiv=docLayers[i].document.layers[divName]
				if (!targetDiv)
				{
					continue
				}
				else
				{
					break
				}
			}
		}
	}
	//alert("returning "+targetDiv)
	return targetDiv

}

function _getImage(divName,imgName)
{
	var ret
	if (this.browserIsIE)
	{
		ret=document.images[imgName]
	}
	else if (this.browserIsNN6Plus)
	{
		ret=document.getElementById(imgName)

	}
	else if (this.browserIsNN4)
	{
		ret=document.layers[divName].document.images[imgName]
	}
	return ret
	
}

function _getForm(divName,formName)
{
	var ret
	if (this.browserIsIE)
	{
		ret=document.forms[formName]
	}
	else if (this.browserIsNN6Plus)
	{
		ret=document.getElementById(formName)
	}
	else if (this.browserIsNN4)
	{
		ret=document.layers[divName].document.forms[formName]
	}
	return ret
	
}

function __writeOrAppendToDiv(divName,divContents,appendText)
{
	var targetDiv=this.getDiv(divName)
	if (!this.browserIsNN4)
	{
		if (!appendText)
		{
			targetDiv.innerHTML=divContents+" " // spchar for ie/mac bug
		}
		else
		{
			targetDiv.insertAdjacentHTML("beforeEnd",divContents+" ") // spchar for ie/mac bug
		}
	}
	else
	{
		if (appendText)
		{
			alert("Cannot append text to the end of a div in NN4.")
		}
		targetDiv.document.open()
		targetDiv.document.write(divContents)
		targetDiv.document.close()
	}
}


function _writeToDiv(divName,divContents)
{
	this._writeOrAppendToDiv(divName,divContents,false)
}

function _appendToDiv(divName,divContents)
{
	this._writeOrAppendToDiv(divName,divContents,true)
}

function _setDivStyle(divName,styleName,styleValue)
{
	if (!this.browserIsNN4)
	{
		this.getDiv(divName).style[styleName]=styleValue
	}
	else
	{
		styleValue=""+styleValue
		if (styleName=="visibility")
		{
			if (styleValue=="visible")
			{
				styleValue="show"
			}
			else if (styleValue=="hidden")
			{
				styleValue="hide"
			}
		}
		if (styleValue.indexOf("px")>-1)
		{
			styleValue=styleValue.substring(0,styleValue.indexOf("px"));
		}
		this.getDiv(divName)[styleName]=styleValue
	}
}

var X=new _X()


