

<% /*
Copyright (c) Steve Schneider 2002-2003.
All rights reserved.
*/ %>
       

<% PageUtils.jspStart(request); %>
    
<%@ page import="java.util.*" %>   
<%@ page import="java.text.*" %>   

<%@ page import="com.workroll.app.filesystem.*" %>
<%@ page import="com.workroll.app.entity.*" %>
<%@ page import="com.workroll.app.db.*" %>
<%@ page import="com.workroll.app.util.*" %>

<% PageUtils.setRequiredLoginStatus("user",request); %>
<% PageUtils.setPathToAppRoot("../",request); %>
<% PageUtils.setSection(WorkRollConstants.SECTION_ISSUES_POPUP,request); %>
 
<%@ include file="../global/topInclude.jsp" %>
<%!
   
%>        

<%
com.theavocadopapers.client.Client client=controller.getClient();
boolean isBasicInterface=!(client.isExp() && client.isWin());

InstallationConfig installationConfig=controller.getCurrentInstallationConfig();
boolean doNotifications=installationConfig.isDoNotifications();

String mode=controller.getParam("mode"); // "add" or "edit"
int editingIssueId=controller.getParamAsInt("issueId");

Calendar now=Calendar.getInstance();
int nowYear=now.get(Calendar.YEAR);
int nowMonth=now.get(Calendar.MONTH);
int nowDate=now.get(Calendar.DATE);

User thisUser=controller.getSessionInfo().getUser();

// default these as if we're adding:
int issueId=0;
int projectId=0;
int instanceId=0;
int assignedByUserId=thisUser.getId();
int assignedToUserId=0;
int status=AbstractIssue.STATUS_OPEN;
int priority=AbstractIssue.PRIORITY_NORMAL;
int hour=-1;
int minute=-1;
int date=nowDate;
int month=nowMonth;
int year=nowYear;
String description="";
String issueUrl="";

int menuFirstYear=nowYear;
int menuLastYear=nowYear+10;

AbstractIssue issue=null;

if (mode.equals("edit"))
{
	issue=Manager.selectNonClosedIssueById(editingIssueId);
	issueId=issue.getId();
	projectId=issue.getProjectId();
	instanceId=issue.getInstanceId();
	assignedByUserId=issue.getAssignedByUserId();
	assignedToUserId=issue.getAssignedToUserId();
	status=issue.getStatus();
	priority=issue.getPriority();
	description=issue.getDescriptionText();
	issueUrl=issue.getUrl();
	Calendar dueDateCal=Calendar.getInstance();
	dueDateCal.setTime(issue.getDueDate());
	hour=dueDateCal.get(Calendar.HOUR);
	minute=dueDateCal.get(Calendar.MINUTE);
	
	
	if (dueDateCal.get(Calendar.AM_PM)==Calendar.PM)
	{
		hour+=12;
	}
	date=dueDateCal.get(Calendar.DATE);
	month=dueDateCal.get(Calendar.MONTH);
	year=dueDateCal.get(Calendar.YEAR);
	
	// normally, we allow user a choice of years starting now and going 10 yrs out; however,
	// if the existing due date of this issue is before now or after 10 yrs, we need to display
	// different years:
	if (year<menuFirstYear)
	{
		menuFirstYear=year;
	}
	else if (year>menuLastYear)
	{
		menuLastYear=year;
	}
	
}


%>

<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 3.2 Final//EN">
<html>
<head>


<% // Re following js include: "Calendar" replicates java.util.Calendar to some extent; it is not a set of scripts specific to this popup calendar module: %>
<SCRIPT src=../global/Calendar.js></script>

<SCRIPT src=../global/HashMap.js></script>

<%@ include file="../global/headInclude.jsp" %>
<%@ include file="../global/popupHeadInclude.jsp" %>
<%@ include file="../global/objectsJs.jsp" %>
<%@ include file="../global/validationJs.jsp" %>
<% // @ include file="js/issuesJs.jsp" %>
<%@ include file="../global/cookieJs.jsp" %>






<script language="JavaScript">

top.focus()

top.setModalReturnValue(null)

var isBasicInterface=<%=""+isBasicInterface%>

var formSubmitted=false;

var adminEmail="<%=installationConfig.getAdminEmail()%>"

var HOUR_MS=<%=WorkRollConstants.HOUR_MS%>

var resetReminderSentFlags=false;

var doNotifications=<%=""+doNotifications%>

var START_OF_WORK_MS=<%=WorkRollConstants.START_OF_WORK_MS%>
var END_OF_WORK_MS=<%=WorkRollConstants.END_OF_WORK_MS%>
var MIDNIGHT_MS=0
var ANYTIME_MS=<%=WorkRollConstants.ANYTIME_MS%>



var openDateMs=<%=""+(issue!=null && issue.getOpenDate()!=null?""+issue.getOpenDate().getTime():""+new Date().getTime())%>

var commentsEmailAddress="<%=WorkRollConstants.COMMENTS_EMAIL_ADDRESS%>"

var mode="<%=mode%>"
var issueId=<%=issueId%>

var users=new HashMap()
var sendEmailcheckboxClickedByUser=false

var currentByUserId=<%=assignedByUserId%>
var currentToUserId=<%=assignedToUserId%>
var defaultNotificationPref=<%=thisUser.getDefaultNotificationPref()%>
var initiallyCheckSendEmailCheckbox

<%
ArrayList objs;

objs=Manager.selectAllUsers();
if (objs==null)
{
	objs=new ArrayList();
}
for (int i=0; i<objs.size(); i++)
{
	User obj=(User)objs.get(i);
	if (obj!=null)
	{
		%>
		users.put(<%=obj.getId()%>, new User(<%=JsUtils.formatAsJsArray(obj)%>))<%
	}

}
%>

var now=new Date(<%=now.getTime().getTime()%>)

function testURL()
{
	var els=document.forms["mainForm"]
	var urlStr=trim(els["url"].value)
	//alert("'"+urlStr+"'")
	if (urlStr=="")
	{
		errorAlert("You have not entered a URL to test; please enter one and press \"test URL\" again.",els["url"])
		return false		
	}
	window.open(document.forms["mainForm"].elements["url"].value)
}

function launchCalendar(formObj)
{
	var els=formObj.elements
	
	var hour=els["dueDateHour"].options[els["dueDateHour"].selectedIndex].value
	var date=els["dueDateDate"].options[els["dueDateDate"].selectedIndex].value
	var month=els["dueDateMonth"].options[els["dueDateMonth"].selectedIndex].value
	var year=els["dueDateYear"].options[els["dueDateYear"].selectedIndex].value

	if (hour=="") {hour=0}
	else {hour=parseInt(hour)}
	
	if (date=="") {date=1}
	else {date=parseInt(date)}
	
	if (month=="") {month=0}
	else {month=parseInt(month)}
	
	if (year=="") {year=new Date(window.now).getFullYear()}
	else {year=parseInt(year)}
	
	// have to make sure date of month is valid for month:
	var dateTestCal=new Calendar()
	dateTestCal.set(dateTestCal.DATE,1)
	dateTestCal.set(dateTestCal.MONTH,month)
	dateTestCal.set(dateTestCal.YEAR,year)
	dateTestCal.set(dateTestCal.HOUR,0)
	date=Math.min(date,dateTestCal.getDaysInMonth())
	
	var url="issues/calendar.jsp?date="+date+"&month="+month+"&year="+year+"&hour="+hour+"&showTime=true"
	callbackValuesHolder.els=els
	openDialogWithCallback(url, "calendarWin", 406, 258, false, true,"launchCalendarCALLBACK")
}

function launchCalendarCALLBACK(newDateArray)
{
	// if user didn't choose a date, then newDateArray will equal []; otherwise it will be
	// a four-el array of nums: year, month, date, hour (using array instead of object or
	// custom object b/c have had trouble in the past with objects returned by modal
	// dialogs; also passing values as vars, not array, to setNewDate(), for same reason):
	if (newDateArray!=null && newDateArray.length==4)
	{
		setNewDate(callbackValuesHolder.els,newDateArray[0],newDateArray[1],newDateArray[2],newDateArray[3])
	}

}

function setNewDate(els,year,month,date,hour)
{
	setSelect(els["dueDateYear"],""+year)
	setSelect(els["dueDateMonth"],""+month)
	setSelect(els["dueDateDate"],""+date)
	setSelect(els["dueDateHour"],""+hour)
}

function setSelect(selectObj,s)
{
	for (var i=0; i<selectObj.options.length; i++)
	{
		var thisOption=selectObj.options[i]
		if (thisOption.value==s)
		{
			thisOption.selected=true
		}
		else
		{
			thisOption.selected=false
		}
	}
}

function isValidForm(formObj)
{
	// don't allow submit more than once:
	if (window.formSubmitted)
	{
		return false;
	}
	var els=formObj.elements
	
	if (selectValue(els["assignedByUserId"])=="")
	{
		errorAlert("You have not selected an assigning user; please select one and try again.",els["assignedByUserId"])
		return false
	}
	if (selectValue(els["assignedToUserId"])=="")
	{
		errorAlert("You have not selected a user to assign this issue to; please select one and try again.",els["assignedToUserId"])
		return false
	}
	if (selectValue(els["status"])=="")
	{
		errorAlert("You have not selected a status; please select one and try again.",els["status"])
		return false
	}
	if (selectValue(els["priority"])=="")
	{
		errorAlert("You have not selected a priority; please select one and try again.",els["priority"])
		return false
	}

	if (selectValue(els["dueDateMonth"])=="")
	{
		errorAlert("You have not selected a month; please select one and try again.",els["dueDateMonth"])
		return false
	}
	if (selectValue(els["dueDateDate"])=="")
	{
		errorAlert("You have not selected a date; please select one and try again.",els["dueDateDate"])
		return false
	}
	if (selectValue(els["dueDateYear"])=="")
	{
		errorAlert("You have not selected a year; please select one and try again.",els["dueDateYear"])
		return false
	}
	
	var chosenMonth=parseInt(selectValue(els["dueDateMonth"]))
	var chosenDate=parseInt(selectValue(els["dueDateDate"]))
	var chosenYear=parseInt(selectValue(els["dueDateYear"]))
	var chosenHour=parseInt(selectValue(els["dueDateHour"]))
	var testCal=new Calendar(new Date(chosenYear,chosenMonth,1,0,0,0,0).getTime())
	if (chosenDate>testCal.getDaysInMonth())
	{
		errorAlert("This is not a valid date: this month has less than "+chosenDate+" days. Please fix and try again.",els["dueDateDate"])
		return false
	}
		
	if (trim(els["descriptionText"].value).length==0)
	{
		errorAlert("You have not entered a description. Please enter one and try again.",els["descriptionText"])
		return false
	}
	if (trim(els["url"].value).length>0 && !isValidURL(trim(els["url"].value)))
	{
		errorAlert("A URL is not required, but the URL you have entered is not valid. URLs entered here must begin with \"http://\", \"https://\", \"ftp://\", \"file://\", or \"mailto:\".  Please fix and try again.",els["url"])
		return false
	}

	
	
	if (okToShowDialog("inputsameuser") && selectValue(els["assignedByUserId"])==selectValue(els["assignedToUserId"]))
	{
		var user=users.get(parseInt(selectValue(els["assignedByUserId"])))
		if (!isBasicInterface)
		{
			var okToProceed=generalConfirm("The assigning user and the assigned-to user are the same ("+user.fullname+"); OK to proceed?"+dontShowHTML("inputsameuser",true))
			if (!okToProceed)
			{
				return false
			}
		}
	}
	
	if (window.mode=="add")
	{
		// only do these tests if we''re adding, not editing:
		testCal=new Calendar(new Date(chosenYear,chosenMonth,chosenDate,Math.floor(chosenHour/HOUR_MS),0,0,0).getTime())
		var nowCal=new Calendar(now.getTime())
		if (testCal.compareTo(nowCal)<0)
		{
			if (okToShowDialog("inputpastdate"))
			{
				if (!isBasicInterface)
				{
					var okToProceed=generalConfirm("The due date you have assigned is in the past; OK to proceed?"+dontShowHTML("inputpastdate",true))
					if (!okToProceed)
					{
						return false
					}
				}
			}
		}
		else if (testCal.equalsIgnoreTime(nowCal))
		{
			if (okToShowDialog("inputtodaysdate"))
			{
				if (!isBasicInterface)
				{

					var okToProceed=generalConfirm("You have assigned this issue to be due today; OK to proceed?"+dontShowHTML("inputtodaysdate",true))
					if (!okToProceed)
					{
						return false
					}
				}
			}
		}
	}
	if (window.mode=="add")
	{
		els["resetReminderSentFlags"].value="true"
	}
	else
	{
		els["resetReminderSentFlags"].value=(window.resetReminderSentFlags?"true":"false")
	}
	window.formSubmitted=true
	hidePageAndShowPleaseWait()
	return true
}


  
 
function storeIssueSuccess(isSuccess,issueId, mailExceptionText)
{
	if (isSuccess)
	{
		mailExceptionText=unescape(mailExceptionText);
		if (okToShowDialog("inputchangesmade") || mailExceptionText.length>0)
		{
			if (mailExceptionText.length==0)
			{
				if (!isBasicInterface)
				{
					generalAlert((window.mode=="add"?"The issue has been added.":"Your changes have been saved.")+dontShowHTML("inputchangesmade",false))
				}
			}
			else
			{
				generalAlert((window.mode=="add"?"The issue has been added.":"Your changes have been saved.")+" However, there was an error in sending the notification to the assigned-to user; please notify <a href='mailto:"+adminEmail+"'>"+adminEmail+"</a> of the error: "+mailExceptionText+"", 450)
			}
		}

		var els=document.forms["mainForm"].elements
		var due=new Calendar()
		
		due.set(due.YEAR,parseInt(selectValue(els["dueDateYear"])))
		due.set(due.MONTH,parseInt(selectValue(els["dueDateMonth"])))
		due.set(due.DATE,parseInt(selectValue(els["dueDateDate"])))
		
		var hrs
		var mins
		if (parseInt(selectValue(els["dueDateHour"]))==MIDNIGHT_MS)
		{
			hrs=0
			mins=0
		}

		else if (parseInt(selectValue(els["dueDateHour"]))==START_OF_WORK_MS)
		{
			hrs=9
			mins=30
		}
		else if (parseInt(selectValue(els["dueDateHour"]))==END_OF_WORK_MS)
		{
			hrs=17
			mins=30
		}
		else if (parseInt(selectValue(els["dueDateHour"]))==ANYTIME_MS)
		{
			hrs=23
			mins=59
		}
		else
		{
			hrs=Math.floor(selectValue(els["dueDateHour"])/HOUR_MS)
			mins=0
			//alert(hrs)
		}
		
		due.set(due.HOUR,hrs)
		due.set(due.MINUTE,mins)
		due.set(due.SECOND,0)
		due.set(due.MILLISECOND,0)

		var issueAsArray=
		[
			issueId,
			escape(els["descriptionText"].value.replace(/ /g,"+")),
			parseInt(selectValue(els["assignedByUserId"])),
			parseInt(selectValue(els["assignedToUserId"])),
			parseInt(selectValue(els["status"])),
			parseInt(selectValue(els["priority"])),
			window.openDateMs,
			due.getTimeInMillis(),
			els["url"].value,
			parseInt(selectValue(els["projectId"])),
			parseInt(selectValue(els["instanceId"]))
		]
		top.setModalReturnValue([issueAsArray,els["mode"].value]) // the issue as an array, and "add" or "edit"
		top.doModalClose()
	}
	else
	{
		errorAlert("There was a problem; the issue may not have been added/updated.  You may wish to tell your administrator, or send e-mail to "+window.commentsEmailAddress+".")
	}
} 


function userMenuChange(selectObj,isAssignedToUser)
{
	var newValue=selectObj.options[selectObj.selectedIndex].value
	if (isAssignedToUser)
	{
		window.currentToUserId=newValue
	}
	else
	{
		window.currentByUserId=newValue
	}
	setSendEmailCheckboxCheckedValue()
}

function setSendEmailCheckboxCheckedValue()
{
	//alert("toid="+currentToUserId+" byid="+currentByUserId+" dnp="+defaultNotificationPref+" doNotifications="+doNotifications+" sendEmailcheckboxClickedByUser="+sendEmailcheckboxClickedByUser)
	if (doNotifications && !sendEmailcheckboxClickedByUser)
	{
		var isChecked
		if (defaultNotificationPref==0) // ALWAYS
		{
			isChecked=true
		}
		else if (defaultNotificationPref==1) // NEVER
		{
			isChecked=false
		}
		else // EXCEPT_TO_SELF
		{
			isChecked=(currentByUserId!=currentToUserId)
		}
		document.forms["mainForm"].elements["sendNotification"].checked=isChecked
	}
}

function init()
{
	document.getElementById("popupMainDiv").style.visibility="visible"
	var byMenu=document.forms["mainForm"].elements["assignedByUserId"]
	var toMenu=document.forms["mainForm"].elements["assignedToUserId"]
	window.currentByUserId=byMenu.options[byMenu.selectedIndex].value
	window.currentToUserId=toMenu.options[toMenu.selectedIndex].value
	setSendEmailCheckboxCheckedValue()
	if (document.getElementById("submitButton").focus)
	{
		document.getElementById("submitButton").focus()
	}
}
</script> 

<style type="text/css">
.inputClass {padding:2px; height:20px; border: 1px solid #7F7F5E; font-size:11px; font-family:arial,helvetica; width:294px; } 
.textareaClass {padding:4px; height:120px; width:294px; border: 1px solid #7F7F5E; font-size:11px; font-family:arial,helvetica; } 
.selectClass {padding:2px; width:294px; border: 1px solid #7F7F5E; font-size:11px; font-family:arial,helvetica; }
.testUrlButton {background-color:#A2A27A; border:1px solid #444434; width:55px; height:18px; font-family:arial,helvetica; font-size:11px; color:#444434;">}

</style>

 
  
 
</head>

<%@ include file="../global/bodyOpen.jsp" %>  

<div id=popupMainDiv style="visibility:hidden; ">
<form action=processIssueInput.jsp target=hiddensubmitter method=post onsubmit="return isValidForm(this)" name=mainForm id=mainForm>
<input type=hidden name=mode id=mode value="<%=mode%>">
<input type=hidden name=resetReminderSentFlags id=resetReminderSentFlags value="false">
<input type=hidden name=issueId id=issueId value="<%=issueId%>">
<input type=hidden name=issueIsNonClosed id=issueIsNonClosed value="true"> <!-- Any issues being edited will always be non-closed; can't edit closed issues w/out opening them first. -->

<font class=bodyFont>

<span class=firstSentenceFont><%
if (mode.equals("add"))
{
	%>
	Add an issue<%=HelpManager.helpLink("addEditDialog","F2F2E1",request)%> by 
	<%
}
else
{
	%>
	Edit this issue<%=HelpManager.helpLink("addEditDialog","F2F2E1",request)%> by 
	<%
}

%></span> 


<%
if (mode.equals("add"))
{
	%>
	completing all fields below
	<%
}
else
{
	%>
	making changes to the fields below
	<%
}

%> and pressing the "<%=mode.equals("add")?"add":"submit"%>" button.<BR><BR>


<table border=0 width=290 cellspacing=0 cellpadding=0>
<tr>
<td>
<span class=boldishFont>Project<%=HelpManager.helpLink("project","F2F2E1",request)%></span><BR>
<select name=projectId id=projectId class=selectText style="width:140px; ">
<option value="0">All projects</option>
<%
ArrayList projects=Manager.selectAllProjects();
if (projects==null)
{
	projects=new ArrayList();
}
for (int i=0; i<projects.size(); i++)
{
	Project project=(Project)projects.get(i);
	%>
	<option value="<%=project.getId()%>" <%=projectId==project.getId()?" selected":""%>><%=project.getName()%></option>
	<%
}
%>
</select><%=HtmlUtils.doubleLB(request)%>
</td>
<td nowrap width=10><BR></td>
<td>
<span class=boldishFont>Instance<%=HelpManager.helpLink("instance","F2F2E1",request)%></span><BR>
<select name=instanceId id=instanceId class=selectText style="width:140px; ">
<option value="0">All instances</option>
<%
ArrayList instances=Manager.selectAllInstances();
if (instances==null)
{
	instances=new ArrayList();
}
for (int i=0; i<instances.size(); i++)
{
	Instance instance=(Instance)instances.get(i);
	%>
	<option value="<%=instance.getId()%>" <%=instanceId==instance.getId()?" selected":""%>><%=instance.getName()%></option>
	<%
}
%>

</select><%=HtmlUtils.doubleLB(request)%>
</td></tr>
</table>




<table border=0 width=290 cellspacing=0 cellpadding=0>
<tr>
<td>
<span class=boldishFont>Assigned by<%=HelpManager.helpLink("assignedByUser","F2F2E1",request)%></span><BR>
<select name=assignedByUserId id=assignedByUserId class=selectText style="width:140px; " onChange="userMenuChange(this,false)">
<%
ArrayList users=Manager.selectAllUsers();
if (users==null)
{
	users=new ArrayList();
}
for (int i=0; i<users.size(); i++)
{
	User user=(User)users.get(i);
	boolean showUser=(user.isActive() || assignedByUserId==user.getId());
	String optionColor=(user.isActive()?"000000":"999999");
	if (showUser)
	{
		%>
		<option style="color:#<%=optionColor%>; " value="<%=user.getId()%>"<%=assignedByUserId==user.getId()?" selected":""%>><%=user.getFullname()%><%=(user.isActive()?"":" [inactive]")%></option>
		<%
	}
}
%>
</select><%=HtmlUtils.doubleLB(request)%>
</td>
<td nowrap width=10><BR></td>
<td>
<span class=boldishFont>Assigned to<%=HelpManager.helpLink("assignedToUser","F2F2E1",request)%></span><BR>
<select name=assignedToUserId id=assignedToUserId class=selectText style="width:140px; " onChange="userMenuChange(this,true)">
<%
for (int i=0; i<users.size(); i++)
{
	User user=(User)users.get(i);
	boolean showUser=(user.isActive() || assignedToUserId==user.getId());
	String optionColor=(user.isActive()?"000000":"999999");
	if (showUser)
	{
		%>
		<option style="color:#<%=optionColor%>; " value="<%=user.getId()%>"<%=assignedToUserId==user.getId()?" selected":""%>><%=user.getFullname()%><%=(user.isActive()?"":" [inactive]")%></option>
		<%
	}
}
%>
</select><%=HtmlUtils.doubleLB(request)%>
</td></tr>
</table>

<table border=0 width=290 cellspacing=0 cellpadding=0>
<tr>
<td>
<span class=boldishFont>Status<%=HelpManager.helpLink("status","F2F2E1",request)%></span><BR>
<select name=status id=status class=selectText style="width:140px; ">
<%
int[] codes=AbstractIssue.STATUS_CODES;
String[] labels=AbstractIssue.STATUS_LABELS;
for (int i=0; i<codes.length; i++)
{
	// don't show "closed":
	if (codes[i]!=AbstractIssue.STATUS_CLOSED)
	{
		%>
		<option value="<%=codes[i]%>" <%=status==codes[i]?" selected":""%>><%=labels[i]%></option>
		<%
	}
}
%>
</select><%=HtmlUtils.doubleLB(request)%>
</td>
<td nowrap width=10><BR></td>
<td>
<span class=boldishFont>Priority<%=HelpManager.helpLink("priority","F2F2E1",request)%></span><BR>
<select name=priority id=priority class=selectText style="width:140px; ">
<%
codes=AbstractIssue.PRIORITY_CODES;
labels=AbstractIssue.PRIORITY_LABELS;
for (int i=0; i<codes.length; i++)
{
	%>
	<option value="<%=codes[i]%>" <%=priority==codes[i]?" selected":""%>><%=labels[i]%></option>
	<%
}
%>

</select><%=HtmlUtils.doubleLB(request)%>
 </td></tr>
</table>

<span class=boldishFont>Due date/time<%=HelpManager.helpLink("dueDate","F2F2E1",request)%></span><BR>
<table border=0 cellspacing=0 cellpadding=0 width=288>
<tr>
<td>
<select name=dueDateHour id=dueDateHour class=selectText style="width:112px; " onchange="window.resetReminderSentFlags=true">
<option value="<%=WorkRollConstants.ANYTIME_MS%>"<%=(hour*WorkRollConstants.HOUR_MS+minute*WorkRollConstants.MINUTE_MS==WorkRollConstants.ANYTIME_MS?" selected":"")%>><%=HtmlUtils.capitalizeFirst(WorkRollConstants.ANYTIME_LABEL)%></option>
<option value="<%=WorkRollConstants.START_OF_WORK_MS%>"<%=(hour*WorkRollConstants.HOUR_MS+minute*WorkRollConstants.MINUTE_MS==WorkRollConstants.START_OF_WORK_MS?" selected":"")%>><%=HtmlUtils.capitalizeFirst(WorkRollConstants.START_OF_WORK_LABEL)%></option>
<option value="<%=WorkRollConstants.END_OF_WORK_MS%>"<%=(hour*WorkRollConstants.HOUR_MS+minute*WorkRollConstants.MINUTE_MS==WorkRollConstants.END_OF_WORK_MS?" selected":"")%>><%=HtmlUtils.capitalizeFirst(WorkRollConstants.END_OF_WORK_LABEL)%></option>

<%
boolean isAM=true;
for (int i=0; i<24; i++)
{
	if (i>11) 
	{
		isAM=false;
	}
	String label;
	if (i==0)
	{
		label="Midnight, morn. of";
	}
	else if (i==12)
	{
		label="Noon on";
	}
	else
	{
		int h=i;
		if (!isAM)
		{
			h-=12;
		}
		label=""+h+":00 "+(isAM?"AM":"PM")+" on";
	}
	%>
	<option value="<%=i*WorkRollConstants.HOUR_MS%>" <%=(hour==i && minute==0?" selected":"")%>><%=label%></option>
	<%
} 
%>
</select><%=HtmlUtils.spacer(2, 2, request)%><select name=dueDateMonth id=dueDateMonth class=selectText style="width:46px; " onchange="window.resetReminderSentFlags=true">
<%
for (int i=0; i<MONTHS_ABBREV.length; i++)
{
	%>
	<option value="<%=i%>" <%=month==i?" selected":""%>><%=MONTHS_ABBREV[i]%></option>
	<%
}
%>
</select><%=HtmlUtils.spacer(2, 2, request)%><select name=dueDateDate id=dueDateDate class=selectText style="width:42px; " onchange="window.resetReminderSentFlags=true">
<%
for (int i=1; i<=31; i++)
{
	%>
	<option value="<%=i%>" <%=date==i?" selected":""%>><%=i%>,</option>
	<%
}
%>
</select><%=HtmlUtils.spacer(2, 2, request)%><select name=dueDateYear id=dueDateYear class=selectText style="width:51px; " onchange="window.resetReminderSentFlags=true">
<%
for (int i=menuFirstYear; i<=menuLastYear; i++)
{
	%>
	<option value="<%=i%>" <%=year==i?" selected":""%>><%=i%></option>
	<%
}
%>
</select><br>
</td>
<td align=right><a hidefocus=true href="#" onclick="launchCalendar(document.forms['mainForm']); return false;"><img src=../images/calendarIcon.gif height=17 width=19 border=0></a><BR></td>
</tr>
</table>
<%=HtmlUtils.spacer(9, 2, request)%><BR>

 
 
<span class=boldishFont>Description<%=HelpManager.helpLink("description","F2F2E1",request)%></span><BR>
<textarea rows=4 cols=20 name="descriptionText" id="descriptionText" class="textareaText" style="width:290px; height:90px; overflow-x:visible; overflow-y:scroll; " wrap="soft"><%=description%></textarea>
<%=HtmlUtils.doubleLB(request)%>



<span class=boldishFont>URL (optional)<%=HelpManager.helpLink("url","F2F2E1",request)%></span><BR>
<input type=text class=inputText name=url id=url style="width:230px; " value="<%=issueUrl%>"> <input type=button onclick="testURL()" value="test URL"  class=testUrlButton><%=HtmlUtils.doubleLB(request)%>

<%
if (doNotifications)
{
	%>
	<input onclick="window.sendEmailcheckboxClickedByUser=true" type=checkbox name=sendNotification value=true id=sendNotificationTrue><label onclick="window.sendEmailcheckboxClickedByUser=true" for="sendNotificationTrue"><span class=boldishFont>Send e-mail notification to assigned-to user<%=HelpManager.helpLink("notificationsAndReminders","F2F2E1",request)%></span></label>
	<%
}
%><%=HtmlUtils.doubleLB(request)%><BR><BR>

<input id="submitButton" class=formButton type=submit value="<%=mode.equals("add")?"add":"submit"%>"> <input  class=formButton type=button value=cancel onclick="top.doModalClose()"><BR>

<BR>
</font>

</form>	

</div>

<%@ include file="../global/popupBodyClose.jsp" %>

</html>


<%@ include file="../global/bottomInclude.jsp" %>


<%
if (pageException!=null)
{
	%>
	<%@ include file="../global/jspErrorDialogLaunch.jsp" %>
	<%
}
%>




<% PageUtils.jspEnd(request); %>


