<% /*
Copyright (c) Steve Schneider 2002-2003.
All rights reserved.
*/ %>


<% PageUtils.jspStart(request); %>
<% PageUtils.forceNoCache(response); %>

<%@ page import="java.util.*" %>
<%@ page import="java.net.*" %>

<%@ page import="com.workroll.app.filesystem.*" %>
<%@ page import="com.workroll.app.entity.*" %>
<%@ page import="com.workroll.app.db.*" %>
<%@ page import="com.workroll.app.session.*" %>

<% PageUtils.setSkipTrialPeriodExpireCheck(true,request); %>
<% PageUtils.setSkipMaxUsersExceededCheck(true,request); %>

<% PageUtils.setRequiredLoginStatus("user",request); %>
<% PageUtils.setPathToAppRoot("../",request); %>
<% PageUtils.setRequiredRequestMethod("POST",request); %>
<% PageUtils.setSection(WorkRollConstants.SECTION_ADMIN,request); %>

<%@ include file="../global/topInclude.jsp" %>

<%!

%>

<%
boolean isPopup=(controller.getParamAsBoolean("isPopup"));

InstallationConfig installationConfig=controller.getCurrentInstallationConfig();
SessionInfo sessionInfo=controller.getSessionInfo();
int secretQuestion=controller.getParamAsInt("secretQuestion");
String secretAnswer=controller.getParam("secretAnswer");

User user=sessionInfo.getUser();
user.setSecretQuestion(secretQuestion);
user.setSecretAnswer(secretAnswer);
sessionInfo.setUser(user);
Manager.updateUser(user);



String redirectUrl=PageUtils.nonNull(sessionInfo.getPostLoginDestinationUrl());
if (redirectUrl.length()==0)
{
	// ...then user hit the login page directly rather than being redirected to
	// it from a login-required page, so just send them to a "you're logged in"
	// page:
	redirectUrl="loginConfirm.jsp?isPopup="+(isPopup?"true":"false");
}
controller.redirect(redirectUrl);


%>



<%@ include file="../global/bottomInclude.jsp" %>


<%
if (pageException!=null)
{
	%>
	<%@ include file="../global/jspErrorDialogLaunch.jsp" %>
	<%
}
%>




<% PageUtils.jspEnd(request); %>

